/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.QueryUtils;
import com.sas.query.datasources.Function;
import com.sas.query.datasources.FunctionConstants;
import com.sas.query.models.CompoundExpression;
import com.sas.query.models.ConstantExpression;
import com.sas.query.models.Expression;
import com.sas.query.models.ExpressionConstants;
import com.sas.query.visuals.ButtonBar;
import com.sas.query.visuals.ExpressionEditTabPanel;
import com.sas.query.visuals.FlatSplitPane;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.SqlTextHelper;
import com.sas.query.visuals.SqlTextHelperConstants;
import com.sas.query.visuals.SqlTextPanel;
import com.sas.query.visuals.SqlTextPanelPlus;
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;

public class ExpressionEditPanel
extends FlatSplitPane
implements PropertyChangeListener,
ExpressionConstants,
FunctionConstants,
SqlTextHelperConstants {
    protected SqlTextPanel expressionBeingBuilt;
    protected ButtonBar toolBarPanel1;
    protected JButton bPlus;
    protected JButton bMinus;
    protected JButton bTimes;
    protected JButton bDivide;
    protected JButton bConcat;
    protected JButton bParenIt;
    protected JButton bQuoteIt;
    protected JButton bFunction;
    protected JButton bColumn;
    protected Expression m_expBeforeEdit;
    protected Query m_query;
    protected ExpressionEditTabPanel tabber;
    protected JPanel topPanel;
    protected JPanel bottomPanel;
    protected boolean m_firstTime = true;
    protected SymAction m_aList;
    protected ExpBuildKey m_aKeyListener;
    protected ExpBuildMouse m_aMouseListener;
    protected ExpBuildFocus m_aFocusListener;
    protected static QueryResource bundle = new QueryResource(ExpressionEditPanel.class);
    public static final int TAB_SPLITTER_INITIAL_LOCATION = 160;

    public ExpressionEditPanel(SqlTextHelper m_callingHelper) {
        this(m_callingHelper.getExpression(), m_callingHelper.getQuery());
        if (m_callingHelper.hasBehavior(1024)) {
            this.expressionBeingBuilt.setBehavior(1024);
        }
        this.expressionBeingBuilt.recomputeDisplay();
    }

    public ExpressionEditPanel(Expression initialExpression, Query query) {
        super(2, -8, -8);
        this.m_expBeforeEdit = initialExpression;
        this.m_query = query;
        this.topPanel = new JPanel();
        GridBagLayout topGridBagLayout = new GridBagLayout();
        this.topPanel.setLayout(topGridBagLayout);
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BorderLayout(0, 0));
        this.getSplitter().setTopComponent(this.topPanel);
        this.getSplitter().setBottomComponent(this.bottomPanel);
        this.getSplitter().setDividerLocation(99);
        this.expressionBeingBuilt = new SqlTextPanelPlus(2);
        this.expressionBeingBuilt.setBehavior(512);
        this.expressionBeingBuilt.clearBehavior(16);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.insets = new Insets(8, 8, 0, 8);
        topGridBagLayout.setConstraints(this.expressionBeingBuilt, gbc);
        this.topPanel.add(this.expressionBeingBuilt);
        Vector<Serializable> operatorButtons = new Vector<Serializable>();
        this.bPlus = new JButton("+");
        this.bPlus.setMargin(new Insets(0, 2, 0, 2));
        operatorButtons.addElement(this.bPlus);
        this.bMinus = new JButton("-");
        this.bMinus.setMargin(new Insets(0, 2, 0, 2));
        operatorButtons.addElement(this.bMinus);
        this.bTimes = new JButton("*");
        this.bTimes.setMargin(new Insets(0, 2, 0, 2));
        operatorButtons.addElement(this.bTimes);
        this.bDivide = new JButton("/");
        this.bDivide.setMargin(new Insets(0, 2, 0, 2));
        operatorButtons.addElement(this.bDivide);
        operatorButtons.addElement(new Integer(5));
        this.bConcat = new JButton(" || ");
        this.bConcat.setMargin(new Insets(0, 2, 0, 2));
        operatorButtons.addElement(this.bConcat);
        operatorButtons.addElement(new Integer(5));
        this.bParenIt = new JButton("(x)");
        this.bParenIt.setMargin(new Insets(0, 2, 0, 2));
        this.bParenIt.setFont(new Font("Dialog", 2, 12));
        operatorButtons.addElement(this.bParenIt);
        this.bQuoteIt = new JButton("'x'");
        this.bQuoteIt.setMargin(new Insets(0, 2, 0, 2));
        this.bQuoteIt.setFont(new Font("Dialog", 2, 12));
        operatorButtons.addElement(this.bQuoteIt);
        this.toolBarPanel1 = new ButtonBar(2, operatorButtons, new Insets(0, 0, 0, 5), true);
        this.toolBarPanel1.setOutline(true);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(8, 8, 8, 8);
        topGridBagLayout.setConstraints(this.toolBarPanel1, gbc);
        this.topPanel.add(this.toolBarPanel1);
        try {
            this.expressionBeingBuilt.setExpression(this.m_query, (Expression)this.m_expBeforeEdit.clone());
        }
        catch (Throwable t) {
            this.expressionBeingBuilt.setExpression(this.m_query, null);
        }
        this.tabber = new ExpressionEditTabPanel(this.expressionBeingBuilt.getHelper());
        this.tabber.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.bottomPanel.add("Center", this.tabber);
        this.addAllListeners();
    }

    @Override
    public void addAllListeners() {
        super.addAllListeners();
        this.m_aList = new SymAction();
        this.bPlus.addActionListener(this.m_aList);
        this.bMinus.addActionListener(this.m_aList);
        this.bDivide.addActionListener(this.m_aList);
        this.bTimes.addActionListener(this.m_aList);
        this.bConcat.addActionListener(this.m_aList);
        this.bParenIt.addActionListener(this.m_aList);
        this.bQuoteIt.addActionListener(this.m_aList);
        this.m_aKeyListener = new ExpBuildKey();
        this.expressionBeingBuilt.addKeyListener(this.m_aKeyListener);
        this.m_aMouseListener = new ExpBuildMouse();
        this.expressionBeingBuilt.addMouseListener(this.m_aMouseListener);
        this.m_aFocusListener = new ExpBuildFocus();
        this.addFocusListener(this.m_aFocusListener);
        this.expressionBeingBuilt.addPropertyChangeListener(this);
    }

    @Override
    public void removeAllListeners() {
        super.removeAllListeners();
        if (this.m_aList != null) {
            this.bPlus.removeActionListener(this.m_aList);
            this.bMinus.removeActionListener(this.m_aList);
            this.bDivide.removeActionListener(this.m_aList);
            this.bTimes.removeActionListener(this.m_aList);
            this.bConcat.removeActionListener(this.m_aList);
            this.bParenIt.removeActionListener(this.m_aList);
            this.bQuoteIt.removeActionListener(this.m_aList);
            this.m_aList = null;
        }
        if (this.m_aKeyListener != null) {
            this.expressionBeingBuilt.removeKeyListener(this.m_aKeyListener);
            this.m_aKeyListener = null;
        }
        if (this.m_aMouseListener != null) {
            this.expressionBeingBuilt.removeMouseListener(this.m_aMouseListener);
            this.m_aMouseListener = null;
        }
        if (this.m_aFocusListener != null) {
            this.removeFocusListener(this.m_aFocusListener);
            this.m_aFocusListener = null;
        }
        this.expressionBeingBuilt.removePropertyChangeListener(this);
        if (this.tabber != null) {
            this.tabber.removeAllListeners();
            this.tabber = null;
        }
        if (this.expressionBeingBuilt != null) {
            this.expressionBeingBuilt.removeAll();
            this.expressionBeingBuilt = null;
        }
        if (this.toolBarPanel1 != null) {
            this.toolBarPanel1.removeAllListeners();
            this.toolBarPanel1 = null;
        }
        this.bPlus = null;
        this.bMinus = null;
        this.bTimes = null;
        this.bDivide = null;
        this.bConcat = null;
        this.bParenIt = null;
        this.bQuoteIt = null;
        this.bFunction = null;
        this.bColumn = null;
        this.m_query = null;
        if (this.topPanel != null) {
            this.topPanel.removeAll();
            this.topPanel = null;
        }
        if (this.bottomPanel != null) {
            this.bottomPanel.removeAll();
            this.bottomPanel = null;
        }
        this.removeAll();
    }

    @Override
    public void propertyChange(PropertyChangeEvent p) {
        if (p.getPropertyName().equals("NewCurrentToken")) {
            // empty if block
        }
    }

    private void showEditStuff(boolean val) {
    }

    public Expression getExpression() {
        return this.expressionBeingBuilt.getExpression();
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }

    public SqlTextPanel getSqlTextPanel() {
        return this.expressionBeingBuilt;
    }

    public void showUndoMenu(ActionEvent event, JButton bUndo) {
        this.expressionBeingBuilt.showRevertPopmenu(bUndo);
    }

    void bColumn_Action(ActionEvent event) {
        this.expressionBeingBuilt.showColumnPopmenu(this.bColumn);
    }

    void bConstant_Request(Integer IconstantType) {
        int constantType = IconstantType;
        ConstantExpression newConstant = ConstantExpression.newPlaceHolder(constantType);
        if (constantType == 64) {
            newConstant = new ConstantExpression("24Jul1998:02:18:58.6", constantType);
        } else if (constantType == 32) {
            newConstant = new ConstantExpression("02:18:58", constantType);
        } else if (constantType == 16) {
            newConstant = new ConstantExpression("24Jul1998", constantType);
        }
        this.expressionBeingBuilt.replaceSelectedWith(newConstant);
    }

    void setUpWindow() {
        Expression selectedSubExpression = this.expressionBeingBuilt.getSelectedExpression();
        if (selectedSubExpression == null) {
            selectedSubExpression = this.expressionBeingBuilt.getExpression();
        }
        if (selectedSubExpression != null && selectedSubExpression.isParsed()) {
            this.bPlus.setEnabled(selectedSubExpression.getOperator(this.expressionBeingBuilt.getQuery(), "+", 2) != null);
            this.bConcat.setEnabled(selectedSubExpression.getOperator(this.expressionBeingBuilt.getQuery(), "||", 2) != null);
            this.bMinus.setEnabled(selectedSubExpression.getOperator(this.expressionBeingBuilt.getQuery(), "-", 2) != null);
            this.bTimes.setEnabled(selectedSubExpression.getOperator(this.expressionBeingBuilt.getQuery(), "*", 2) != null);
            this.bDivide.setEnabled(selectedSubExpression.getOperator(this.expressionBeingBuilt.getQuery(), "/", 2) != null);
        } else {
            this.bPlus.setEnabled(true);
            this.bConcat.setEnabled(true);
            this.bMinus.setEnabled(true);
            this.bTimes.setEnabled(true);
            this.bDivide.setEnabled(true);
        }
    }

    protected void setText(String text) {
        this.expressionBeingBuilt.setText(text);
    }

    protected String getText() {
        return this.expressionBeingBuilt.getText();
    }

    void bOperator_Action(ActionEvent event, String selectedOperator) {
        String suffix;
        String prefix;
        int curpos;
        JTextComponent widg = this.expressionBeingBuilt.getWidget();
        Expression myTopExpression = this.expressionBeingBuilt.getExpression();
        Expression selectedSubExpression = this.expressionBeingBuilt.getSelectedExpression();
        String curText = widg.getText();
        String curSelText = this.expressionBeingBuilt.getSelectedText();
        if (curSelText != null && curSelText.length() > 0) {
            curpos = widg.getSelectionEnd();
            prefix = curText.substring(0, this.expressionBeingBuilt.getWidget().getSelectionStart());
            suffix = curText.substring(widg.getSelectionEnd());
        } else {
            curSelText = "";
            curpos = widg.getCaretPosition();
            prefix = curText.substring(0, curpos);
            suffix = curText.substring(curpos);
        }
        if (selectedSubExpression == null || !selectedSubExpression.isParsed()) {
            String newText = "";
            int newpos = 0;
            if (selectedOperator != "()" && selectedOperator != "singlequote") {
                if (SqlTextHelper.isFunctionString(curSelText)) {
                    newText = prefix + selectedOperator + suffix;
                    newpos = curpos + selectedOperator.length() - curSelText.length();
                    this.expressionBeingBuilt.setText(newText);
                    widg.setCaretPosition(newpos);
                    this.expressionBeingBuilt.setSelection(newpos - selectedOperator.length(), newpos - 0);
                    this.expressionBeingBuilt.firePropertyChange("selectionChanged", null, null);
                } else {
                    String spaceValueSpace = bundle.getString("ExpressionEditPanel.bracketedValue.txt");
                    newText = prefix + " " + selectedOperator + " " + spaceValueSpace + " " + suffix;
                    newpos = curpos + selectedOperator.length() + spaceValueSpace.length() + 2 - curSelText.length();
                    this.expressionBeingBuilt.setText(newText);
                    widg.setCaretPosition(newpos);
                    this.expressionBeingBuilt.setSelection(newpos - spaceValueSpace.length(), newpos - 0);
                    this.expressionBeingBuilt.firePropertyChange("selectionChanged", null, null);
                }
            } else if (selectedOperator == "()") {
                newText = prefix + " ( " + curSelText + " ) " + suffix;
                newpos = prefix.length() + 6 + curSelText.length();
                this.expressionBeingBuilt.setText(newText);
                widg.setCaretPosition(newpos);
            } else if (selectedOperator == "singlequote") {
                String newcursel = QueryUtils.stripAndDouble(curSelText);
                newText = prefix + "'" + newcursel + "'" + suffix;
                newpos = prefix.length() + 2 + newcursel.length();
                this.expressionBeingBuilt.setText(newText);
                widg.setCaretPosition(newpos);
            }
        } else {
            Function myOpFun = selectedSubExpression.getOperator(this.expressionBeingBuilt.getQuery(), selectedOperator);
            if (myOpFun == null) {
                this.m_query.getMessageHandler().addInternalError("No such operator for this type");
                return;
            }
            if (SqlTextHelper.isFunctionString(curSelText) && selectedSubExpression instanceof CompoundExpression) {
                CompoundExpression myCompOp = (CompoundExpression)selectedSubExpression;
                myCompOp.setCurrentFunction(myOpFun);
                this.expressionBeingBuilt.recomputeDisplay();
            } else {
                CompoundExpression wrappedExpression = null;
                ConstantExpression newConstant = ConstantExpression.newPlaceHolder(selectedSubExpression.getDataType());
                wrappedExpression = new CompoundExpression(myOpFun, selectedSubExpression, newConstant);
                if (myTopExpression == selectedSubExpression) {
                    this.expressionBeingBuilt.setExpression(wrappedExpression);
                } else {
                    myTopExpression.replaceChildExpression(selectedSubExpression, wrappedExpression);
                    this.expressionBeingBuilt.recomputeDisplay();
                    this.expressionBeingBuilt.checkPoint();
                }
            }
        }
        widg.requestFocus();
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == ExpressionEditPanel.this.bPlus) {
                ExpressionEditPanel.this.bOperator_Action(event, "+");
            } else if (object == ExpressionEditPanel.this.bMinus) {
                ExpressionEditPanel.this.bOperator_Action(event, "-");
            } else if (object == ExpressionEditPanel.this.bTimes) {
                ExpressionEditPanel.this.bOperator_Action(event, "*");
            } else if (object == ExpressionEditPanel.this.bDivide) {
                ExpressionEditPanel.this.bOperator_Action(event, "/");
            } else if (object == ExpressionEditPanel.this.bConcat) {
                ExpressionEditPanel.this.bOperator_Action(event, "||");
            } else if (object == ExpressionEditPanel.this.bParenIt) {
                ExpressionEditPanel.this.bOperator_Action(event, "()");
            } else if (object == ExpressionEditPanel.this.bQuoteIt) {
                ExpressionEditPanel.this.bOperator_Action(event, "singlequote");
            } else if (object == ExpressionEditPanel.this.bColumn) {
                ExpressionEditPanel.this.bColumn_Action(event);
            }
        }
    }

    class ExpBuildKey
    extends KeyAdapter {
        ExpBuildKey() {
        }

        @Override
        public void keyReleased(KeyEvent event) {
            ExpressionEditPanel.this.setUpWindow();
        }
    }

    class ExpBuildMouse
    extends MouseAdapter {
        ExpBuildMouse() {
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            ExpressionEditPanel.this.setUpWindow();
        }
    }

    class ExpBuildFocus
    implements FocusListener {
        ExpBuildFocus() {
        }

        @Override
        public void focusGained(FocusEvent event) {
            if (ExpressionEditPanel.this.m_firstTime) {
                ExpressionEditPanel.this.m_firstTime = false;
                ExpressionEditPanel.this.expressionBeingBuilt.getWidget().setCaretPosition(ExpressionEditPanel.this.expressionBeingBuilt.getWidget().getText().length());
            }
            ExpressionEditPanel.this.setUpWindow();
        }

        @Override
        public void focusLost(FocusEvent event) {
        }
    }
}

