/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.models.Expression;
import com.sas.query.models.UnparsedExpression;
import com.sas.query.visuals.ButtonBar;
import com.sas.query.visuals.ExpressionEditPanel;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.SqlTextHelper;
import com.sas.query.visuals.SqlTextHelperConstants;
import com.sas.query.visuals.WindowUtil;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;

public class ExpressionEditDialog
extends JDialog
implements SqlTextHelperConstants {
    protected ExpressionEditPanel mainPanel;
    protected SqlTextHelper m_callingHelper = null;
    protected ButtonBar rightButtonPanel;
    protected JButton bOK;
    protected JButton bCancel;
    protected boolean m_success = false;
    protected SymWindow aSymWindow;
    protected SymAction actionListener;
    static QueryResource bundle = new QueryResource(ExpressionEditDialog.class);

    public ExpressionEditDialog(Frame parent, boolean modal, Expression expression, Query query) {
        super(parent, modal);
        this.mainPanel = new ExpressionEditPanel(expression, query);
        this._layoutWidgets();
        this.addAllListeners();
        this.setDefaultCloseOperation(2);
    }

    public ExpressionEditDialog(Frame parent, boolean modal, String string, Query query) {
        this(parent, modal, new UnparsedExpression(string), query);
    }

    public ExpressionEditDialog(Frame parent, boolean modal, SqlTextHelper helper) {
        super(parent, modal);
        this.mainPanel = new ExpressionEditPanel(helper);
        this.m_callingHelper = helper;
        this._layoutWidgets();
        this.addAllListeners();
        this.setDefaultCloseOperation(2);
    }

    @Override
    public void dispose() {
        this.removeAllListeners();
        super.dispose();
    }

    public void addAllListeners() {
        this.aSymWindow = new SymWindow();
        this.addWindowListener(this.aSymWindow);
        this.actionListener = new SymAction();
        this.bOK.addActionListener(this.actionListener);
        this.bCancel.addActionListener(this.actionListener);
    }

    public void removeAllListeners() {
        this.removeAll();
        this.rightButtonPanel.removeAllListeners();
        if (this.aSymWindow != null) {
            this.removeWindowListener(this.aSymWindow);
            this.aSymWindow = null;
        }
        if (this.actionListener != null) {
            this.bOK.removeActionListener(this.actionListener);
            this.bCancel.removeActionListener(this.actionListener);
            this.actionListener = null;
        }
    }

    protected void _layoutWidgets() {
        this.setTitle(bundle.getString("ExpressionEditDialog.Title.txt"));
        WindowUtil.busyOn(this);
        try {
            this.setSize(550, 355);
            this.mainPanel.setBorder(BorderFactory.createEmptyBorder(7, 4, 4, 0));
            this.getContentPane().setLayout(new BorderLayout(0, 0));
            this.getContentPane().add("Center", this.mainPanel);
            this.bOK = new JButton(bundle.getString("Common.OK.txt"));
            this.bCancel = new JButton(bundle.getString("Common.Cancel.txt"));
            Vector<Serializable> buttons = new Vector<Serializable>();
            buttons.addElement(new Integer(5));
            buttons.addElement(this.bOK);
            buttons.addElement(this.bCancel);
            Insets in = new Insets(10, 6, 0, 12);
            this.rightButtonPanel = new ButtonBar(3, buttons, in, false);
            this.getContentPane().add("East", this.rightButtonPanel);
        }
        catch (Throwable t) {
            WindowUtil.busyOff(this);
            if (this.m_callingHelper != null) {
                this.m_callingHelper.getQuery().getMessageHandler().addInternalError(t);
            }
            this.mainPanel.m_query.getMessageHandler().addInternalError(t);
        }
        WindowUtil.busyOff(this);
    }

    public int getReturnValue() {
        if (this.m_success) {
            return 1;
        }
        return 2;
    }

    public Expression getExpression() {
        return this.mainPanel.getExpression();
    }

    public String getRawText() {
        return this.mainPanel.getText();
    }

    public void setFullSQLMode() {
        this.setTitle(bundle.getString("ExpressionEditDialog.SQLEditTitle.txt"));
        this.setSize(WindowUtil.getBestWindowSize(new Dimension(715, 450)));
        this.mainPanel.getSqlTextPanel().setBehavior(1024);
    }

    void Dialog1_WindowClosing(WindowEvent event) {
        this.setVisible(false);
    }

    void bOK_Action(ActionEvent event) {
        if (this.m_callingHelper != null) {
            this.m_callingHelper.setExpression(this.mainPanel.getExpression());
        }
        this.m_success = true;
        this.dispose();
    }

    void bCancel_Action(ActionEvent event) {
        this.m_success = false;
        this.dispose();
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == ExpressionEditDialog.this) {
                ExpressionEditDialog.this.Dialog1_WindowClosing(event);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == ExpressionEditDialog.this.bOK) {
                ExpressionEditDialog.this.bOK_Action(event);
            } else if (object == ExpressionEditDialog.this.bCancel) {
                ExpressionEditDialog.this.bCancel_Action(event);
            }
        }
    }
}

