/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.QueryConfiguration;
import com.sas.query.visuals.FilterTreeView;
import com.sas.query.visuals.ImageHandler;
import com.sas.query.visuals.QueryResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import javax.swing.ImageIcon;

public abstract class DrawUtil {
    protected static QueryResource bundle = new QueryResource(DrawUtil.class);
    protected static final int INTER_NODE_AND_SPACE = Math.max(bundle.getInt("filternode.INTER_NODE_AND_SPACE"), 32);
    public static ImageIcon unionHorizontalIcon = null;
    public static ImageIcon unionLeftIcon = null;
    public static ImageIcon unionRightIcon = null;
    public static ImageIcon unionAllHorizontalIcon = null;
    public static ImageIcon unionAllLeftIcon = null;
    public static ImageIcon unionAllRightIcon = null;
    public static ImageIcon intersectHorizontalIcon = null;
    public static ImageIcon intersectLeftIcon = null;
    public static ImageIcon intersectRightIcon = null;
    public static ImageIcon exceptHorizontalIcon = null;
    public static ImageIcon exceptLeftIcon = null;
    public static ImageIcon exceptRightIcon = null;
    public static ImageIcon filterNodeSouthEastIcon = null;
    public static ImageIcon filterNodeSouthWestIcon = null;
    public static ImageIcon filterNodeNorthEastIcon = null;
    public static ImageIcon filterNodeNorthWestIcon = null;
    public static ImageIcon pipeFilterIcon = null;
    public static ImageIcon pipeFilterCollarIcon = null;
    public static ImageIcon pipeElboSouthEastIcon = null;
    public static ImageIcon pipeElboSouthWestIcon = null;
    public static ImageIcon pipeHorizontalIcon = null;
    public static ImageIcon pipeTeeEastIcon = null;
    public static ImageIcon pipeTeeSouthIcon = null;
    public static ImageIcon pipeTeeWestIcon = null;
    public static ImageIcon pipeVerticalIcon = null;
    public static ImageIcon pipeNodeConnectEastIcon = null;
    public static ImageIcon pipeNodeConnectWestIcon = null;
    public static ImageIcon pipeElboNorthEastIcon = null;
    public static ImageIcon pipeTerminatorIcon = null;
    protected static ImageIcon xIcon = null;
    protected static final int DEPTH_OFFSET = 1;
    protected static Font m_largeFont;
    protected static Font m_largeBoldFont;
    protected static Font m_smallFont;

    public static void drawJoinLine(Graphics g, boolean bSelected, int joinType, Rectangle source, Rectangle dest) {
        Rectangle leftSide = new Rectangle(source);
        Rectangle rightSide = new Rectangle(dest);
        if (source.x > dest.x) {
            leftSide = dest;
            rightSide = source;
            if (joinType == 1) {
                joinType = 2;
            } else if (joinType == 2) {
                joinType = 1;
            }
        }
        if (leftSide.height > 12) {
            leftSide.y += (int)Math.floor((leftSide.height - 12) / 2);
            leftSide.height = 12;
        }
        if (rightSide.height > 12) {
            rightSide.y += (int)Math.floor((rightSide.height - 12) / 2);
            rightSide.height = 12;
        }
        g.setColor(Color.black);
        if (joinType == 0) {
            g.drawLine(leftSide.x + leftSide.width, leftSide.y + 4, leftSide.x + leftSide.width + 16, leftSide.y + 4);
            g.drawLine(leftSide.x + leftSide.width, leftSide.y + 5, leftSide.x + leftSide.width + 17, leftSide.y + 5);
            g.drawLine(leftSide.x + leftSide.width, leftSide.y + 6, leftSide.x + leftSide.width + 17, leftSide.y + 6);
            g.drawLine(leftSide.x + leftSide.width, leftSide.y + 7, leftSide.x + leftSide.width + 17, leftSide.y + 7);
            g.drawLine(leftSide.x + leftSide.width, leftSide.y + 8, leftSide.x + leftSide.width + 16, leftSide.y + 8);
            g.drawLine(rightSide.x - 1, rightSide.y + 4, rightSide.x - 16, rightSide.y + 4);
            g.drawLine(rightSide.x - 1, rightSide.y + 5, rightSide.x - 17, rightSide.y + 5);
            g.drawLine(rightSide.x - 1, rightSide.y + 6, rightSide.x - 17, rightSide.y + 6);
            g.drawLine(rightSide.x - 1, rightSide.y + 7, rightSide.x - 17, rightSide.y + 7);
            g.drawLine(rightSide.x - 1, rightSide.y + 8, rightSide.x - 16, rightSide.y + 8);
            if (bSelected) {
                g.setColor(SystemColor.activeCaption);
                g.drawLine(leftSide.x + leftSide.width + 18, leftSide.y + 5, rightSide.x - 18, rightSide.y + 5);
                g.drawLine(leftSide.x + leftSide.width + 18, leftSide.y + 7, rightSide.x - 18, rightSide.y + 7);
                g.setColor(Color.white);
                g.drawLine(leftSide.x + leftSide.width + 18, leftSide.y + 6, rightSide.x - 18, rightSide.y + 6);
            } else {
                g.drawLine(leftSide.x + leftSide.width + 18, leftSide.y + 6, rightSide.x - 18, rightSide.y + 6);
            }
        }
        if (joinType == 1) {
            g.drawLine(leftSide.x + leftSide.width, leftSide.y + 1, leftSide.x + leftSide.width, leftSide.y + 5);
            g.drawLine(leftSide.x + leftSide.width + 1, leftSide.y + 2, leftSide.x + leftSide.width + 1, leftSide.y + 4);
            g.drawLine(leftSide.x + leftSide.width, leftSide.y + 7, leftSide.x + leftSide.width, leftSide.y + 11);
            g.drawLine(leftSide.x + leftSide.width + 1, leftSide.y + 8, leftSide.x + leftSide.width + 1, leftSide.y + 10);
            g.drawLine(leftSide.x + leftSide.width + 2, leftSide.y + 3, leftSide.x + leftSide.width + 14, leftSide.y + 3);
            g.drawLine(leftSide.x + leftSide.width + 2, leftSide.y + 9, leftSide.x + leftSide.width + 14, leftSide.y + 9);
            g.drawLine(leftSide.x + leftSide.width + 14, leftSide.y + 3, leftSide.x + leftSide.width + 16, leftSide.y + 5);
            g.drawLine(leftSide.x + leftSide.width + 14, leftSide.y + 9, leftSide.x + leftSide.width + 16, leftSide.y + 7);
            g.drawLine(rightSide.x - 1, rightSide.y + 4, rightSide.x - 16, rightSide.y + 4);
            g.drawLine(rightSide.x - 1, rightSide.y + 5, rightSide.x - 17, rightSide.y + 5);
            g.drawLine(rightSide.x - 1, rightSide.y + 6, rightSide.x - 17, rightSide.y + 6);
            g.drawLine(rightSide.x - 1, rightSide.y + 7, rightSide.x - 17, rightSide.y + 7);
            g.drawLine(rightSide.x - 1, rightSide.y + 8, rightSide.x - 16, rightSide.y + 8);
            if (bSelected) {
                g.setColor(SystemColor.activeCaption);
                g.drawLine(leftSide.x + leftSide.width + 17, leftSide.y + 5, rightSide.x - 18, rightSide.y + 5);
                g.drawLine(leftSide.x + leftSide.width + 17, leftSide.y + 7, rightSide.x - 18, rightSide.y + 7);
                g.setColor(Color.white);
                g.drawLine(leftSide.x + leftSide.width + 17, leftSide.y + 6, rightSide.x - 18, rightSide.y + 6);
            } else {
                g.drawLine(leftSide.x + leftSide.width + 17, leftSide.y + 6, rightSide.x - 18, rightSide.y + 6);
            }
        }
        if (joinType == 2) {
            g.drawLine(leftSide.x + leftSide.width, leftSide.y + 4, leftSide.x + leftSide.width + 16, leftSide.y + 4);
            g.drawLine(leftSide.x + leftSide.width, leftSide.y + 5, leftSide.x + leftSide.width + 17, leftSide.y + 5);
            g.drawLine(leftSide.x + leftSide.width, leftSide.y + 6, leftSide.x + leftSide.width + 17, leftSide.y + 6);
            g.drawLine(leftSide.x + leftSide.width, leftSide.y + 7, leftSide.x + leftSide.width + 17, leftSide.y + 7);
            g.drawLine(leftSide.x + leftSide.width, leftSide.y + 8, leftSide.x + leftSide.width + 16, leftSide.y + 8);
            g.drawLine(rightSide.x - 1, rightSide.y + 1, rightSide.x - 1, rightSide.y + 5);
            g.drawLine(rightSide.x - 2, rightSide.y + 2, rightSide.x - 2, rightSide.y + 4);
            g.drawLine(rightSide.x - 1, rightSide.y + 7, rightSide.x - 1, rightSide.y + 11);
            g.drawLine(rightSide.x - 2, rightSide.y + 8, rightSide.x - 2, rightSide.y + 10);
            g.drawLine(rightSide.x - 2, rightSide.y + 3, rightSide.x - 14, rightSide.y + 3);
            g.drawLine(rightSide.x - 2, rightSide.y + 9, rightSide.x - 14, rightSide.y + 9);
            g.drawLine(rightSide.x - 14, rightSide.y + 3, rightSide.x - 16, rightSide.y + 5);
            g.drawLine(rightSide.x - 14, rightSide.y + 9, rightSide.x - 16, rightSide.y + 7);
            if (bSelected) {
                g.setColor(SystemColor.activeCaption);
                g.drawLine(leftSide.x + leftSide.width + 18, leftSide.y + 5, rightSide.x - 17, rightSide.y + 5);
                g.drawLine(leftSide.x + leftSide.width + 18, leftSide.y + 7, rightSide.x - 17, rightSide.y + 7);
                g.setColor(Color.white);
                g.drawLine(leftSide.x + leftSide.width + 18, leftSide.y + 6, rightSide.x - 17, rightSide.y + 6);
            } else {
                g.drawLine(leftSide.x + leftSide.width + 18, leftSide.y + 6, rightSide.x - 17, rightSide.y + 6);
            }
        }
        if (joinType == 3) {
            g.drawLine(leftSide.x + leftSide.width, leftSide.y + 1, leftSide.x + leftSide.width, leftSide.y + 5);
            g.drawLine(leftSide.x + leftSide.width + 1, leftSide.y + 2, leftSide.x + leftSide.width + 1, leftSide.y + 4);
            g.drawLine(leftSide.x + leftSide.width, leftSide.y + 7, leftSide.x + leftSide.width, leftSide.y + 11);
            g.drawLine(leftSide.x + leftSide.width + 1, leftSide.y + 8, leftSide.x + leftSide.width + 1, leftSide.y + 10);
            g.drawLine(leftSide.x + leftSide.width + 2, leftSide.y + 3, leftSide.x + leftSide.width + 14, leftSide.y + 3);
            g.drawLine(leftSide.x + leftSide.width + 2, leftSide.y + 9, leftSide.x + leftSide.width + 14, leftSide.y + 9);
            g.drawLine(leftSide.x + leftSide.width + 14, leftSide.y + 3, leftSide.x + leftSide.width + 16, leftSide.y + 5);
            g.drawLine(leftSide.x + leftSide.width + 14, leftSide.y + 9, leftSide.x + leftSide.width + 16, leftSide.y + 7);
            g.drawLine(rightSide.x - 1, rightSide.y + 1, rightSide.x - 1, rightSide.y + 5);
            g.drawLine(rightSide.x - 2, rightSide.y + 2, rightSide.x - 2, rightSide.y + 4);
            g.drawLine(rightSide.x - 1, rightSide.y + 7, rightSide.x - 1, rightSide.y + 11);
            g.drawLine(rightSide.x - 2, rightSide.y + 8, rightSide.x - 2, rightSide.y + 10);
            g.drawLine(rightSide.x - 2, rightSide.y + 3, rightSide.x - 14, rightSide.y + 3);
            g.drawLine(rightSide.x - 2, rightSide.y + 9, rightSide.x - 14, rightSide.y + 9);
            g.drawLine(rightSide.x - 14, rightSide.y + 3, rightSide.x - 16, rightSide.y + 5);
            g.drawLine(rightSide.x - 14, rightSide.y + 9, rightSide.x - 16, rightSide.y + 7);
            if (bSelected) {
                g.setColor(SystemColor.activeCaption);
                g.drawLine(leftSide.x + leftSide.width + 17, leftSide.y + 5, rightSide.x - 17, rightSide.y + 5);
                g.drawLine(leftSide.x + leftSide.width + 17, leftSide.y + 7, rightSide.x - 17, rightSide.y + 7);
                g.setColor(Color.white);
                g.drawLine(leftSide.x + leftSide.width + 17, leftSide.y + 6, rightSide.x - 17, rightSide.y + 6);
            } else {
                g.drawLine(leftSide.x + leftSide.width + 17, leftSide.y + 6, rightSide.x - 17, rightSide.y + 6);
            }
        }
    }

    public static void drawJoinString(Graphics g, String str, Rectangle source, Rectangle dest) {
        Rectangle leftSide = new Rectangle(source);
        Rectangle rightSide = new Rectangle(dest);
        if (source.x > dest.x) {
            leftSide = dest;
            rightSide = source;
        }
        if (leftSide.height > 12) {
            leftSide.y += (int)Math.floor((leftSide.height - 12) / 2);
            leftSide.height = 12;
        }
        if (rightSide.height > 12) {
            rightSide.y += (int)Math.floor((rightSide.height - 12) / 2);
            rightSide.height = 12;
        }
        g.setColor(Color.black);
        FontMetrics fontmetrics = g.getFontMetrics(g.getFont());
        int centerX = (leftSide.x + leftSide.width + rightSide.x) / 2;
        int centerY = leftSide.y + leftSide.height / 2;
        int posX = centerX - fontmetrics.stringWidth(str) / 2;
        int posY = centerY + fontmetrics.getHeight() / 2;
        g.drawString(str, posX, posY);
    }

    public static void getJoinLineAreas(boolean bSelected, int joinType, Rectangle source, Rectangle dest, Rectangle rightRect, Rectangle leftRect, Point rightPoint, Point leftPoint) {
        boolean flipped = false;
        Rectangle leftSide = new Rectangle(source);
        Rectangle rightSide = new Rectangle(dest);
        if (source.x > dest.x) {
            leftSide = dest;
            rightSide = source;
            if (joinType == 1) {
                joinType = 2;
            } else if (joinType == 2) {
                joinType = 1;
            }
            flipped = true;
        }
        if (leftSide.height > 12) {
            leftSide.y += (int)Math.floor((leftSide.height - 12) / 2);
            leftSide.height = 12;
        }
        if (rightSide.height > 12) {
            rightSide.y += (int)Math.floor((rightSide.height - 12) / 2);
            rightSide.height = 12;
        }
        if (joinType == 0) {
            leftRect.x = leftSide.x + leftSide.width;
            leftRect.y = leftSide.y + 4;
            leftRect.width = 17;
            leftRect.height = 5;
            rightRect.x = rightSide.x - 17;
            rightRect.y = rightSide.y + 4;
            rightRect.width = 17;
            rightRect.height = 5;
            leftPoint.x = leftSide.x + leftSide.width + 18;
            leftPoint.y = leftSide.y + 6;
            rightPoint.x = rightSide.x - 18;
            rightPoint.y = rightSide.y + 6;
        }
        if (joinType == 1) {
            leftRect.x = leftSide.x + leftSide.width;
            leftRect.y = leftSide.y + 1;
            leftRect.width = 16;
            leftRect.height = 11;
            rightRect.x = rightSide.x - 17;
            rightRect.y = rightSide.y + 4;
            rightRect.width = 17;
            rightRect.height = 5;
            leftPoint.x = leftSide.x + leftSide.width + 17;
            leftPoint.y = leftSide.y + 6;
            rightPoint.x = rightSide.x - 18;
            rightPoint.y = rightSide.y + 6;
        }
        if (joinType == 2) {
            leftRect.x = leftSide.x + leftSide.width;
            leftRect.y = leftSide.y + 4;
            leftRect.width = 17;
            leftRect.height = 5;
            rightRect.x = rightSide.x - 17;
            rightRect.y = rightSide.y + 1;
            rightRect.width = 17;
            rightRect.height = 11;
            leftPoint.x = leftSide.x + leftSide.width + 18;
            leftPoint.y = leftSide.y + 6;
            rightPoint.x = rightSide.x - 17;
            rightPoint.y = rightSide.y + 6;
        }
        if (joinType == 3) {
            leftRect.x = leftSide.x + leftSide.width;
            leftRect.y = leftSide.y + 1;
            leftRect.width = 16;
            leftRect.height = 11;
            rightRect.x = rightSide.x - 17;
            rightRect.y = rightSide.y + 1;
            rightRect.width = 17;
            rightRect.height = 11;
            leftPoint.x = leftSide.x + leftSide.width + 17;
            leftPoint.y = leftSide.y + 6;
            rightPoint.x = rightSide.x - 17;
            rightPoint.y = rightSide.y + 6;
        }
        if (flipped) {
            Rectangle tempRect = new Rectangle(leftRect);
            leftRect.setBounds(rightRect);
            rightRect.setBounds(tempRect);
            Point tempPoint = new Point(leftPoint);
            leftPoint.setLocation(rightPoint);
            rightPoint.setLocation(tempPoint);
        }
    }

    public static double distanceToLine(Point endPointA, Point endPointB, Point checkPoint) {
        double mag2AB;
        double APx = checkPoint.x - endPointA.x;
        double ABx = endPointB.x - endPointA.x;
        double APy = checkPoint.y - endPointA.y;
        double ABy = endPointB.y - endPointA.y;
        double APdotAB = APx * ABx + APy * ABy;
        double distance = APdotAB < 0.0 ? Math.sqrt(APx * APx + APy * APy) : (APdotAB > (mag2AB = ABx * ABx + ABy * ABy) ? Math.sqrt((checkPoint.x - endPointB.x) * (checkPoint.x - endPointB.x) + (checkPoint.y - endPointB.y) * (checkPoint.y - endPointB.y)) : Math.sqrt(APx * APx + APy * APy - APdotAB * APdotAB / mag2AB));
        return distance;
    }

    public static void drawUnionLine(int type, Component visual, Graphics g, Rectangle source, Rectangle dest) {
        if (type == 0) {
            DrawUtil.drawUnion(visual, g, source, dest);
        } else if (type == 1) {
            DrawUtil.drawUnionAll(visual, g, source, dest);
        } else if (type == 2) {
            DrawUtil.drawIntersect(visual, g, source, dest);
        } else if (type == 3) {
            DrawUtil.drawExcept(visual, g, source, dest);
        }
    }

    public static void drawUnion(Component visual, Graphics g, Rectangle source, Rectangle dest) {
        if (unionHorizontalIcon == null) {
            unionHorizontalIcon = ImageHandler.getImageIcon(bundle, "unionHorizontalIcon");
            unionLeftIcon = ImageHandler.getImageIcon(bundle, "unionLeftAttachIcon");
            unionRightIcon = ImageHandler.getImageIcon(bundle, "unionRightAttachIcon");
        }
        DrawUtil.drawHorizontal(visual, g, source, dest, unionLeftIcon, unionHorizontalIcon, unionRightIcon);
    }

    public static void drawUnionAll(Component visual, Graphics g, Rectangle source, Rectangle dest) {
        if (unionAllHorizontalIcon == null) {
            unionAllHorizontalIcon = ImageHandler.getImageIcon(bundle, "unionAllHorizontalIcon");
            unionAllLeftIcon = ImageHandler.getImageIcon(bundle, "unionAllLeftAttachIcon");
            unionAllRightIcon = ImageHandler.getImageIcon(bundle, "unionAllRightAttachIcon");
        }
        DrawUtil.drawHorizontal(visual, g, source, dest, unionAllLeftIcon, unionAllHorizontalIcon, unionAllRightIcon);
    }

    public static void drawIntersect(Component visual, Graphics g, Rectangle source, Rectangle dest) {
        if (intersectHorizontalIcon == null) {
            intersectHorizontalIcon = ImageHandler.getImageIcon(bundle, "intersectHorizontalIcon");
            intersectLeftIcon = ImageHandler.getImageIcon(bundle, "intersectLeftAttachIcon");
            intersectRightIcon = ImageHandler.getImageIcon(bundle, "intersectRightAttachIcon");
        }
        DrawUtil.drawHorizontal(visual, g, source, dest, intersectLeftIcon, intersectHorizontalIcon, intersectRightIcon);
    }

    public static void drawExcept(Component visual, Graphics g, Rectangle source, Rectangle dest) {
        if (exceptHorizontalIcon == null) {
            exceptHorizontalIcon = ImageHandler.getImageIcon(bundle, "exceptHorizontalIcon");
            exceptLeftIcon = ImageHandler.getImageIcon(bundle, "exceptLeftAttachIcon");
            exceptRightIcon = ImageHandler.getImageIcon(bundle, "exceptRightAttachIcon");
        }
        DrawUtil.drawHorizontal(visual, g, source, dest, exceptLeftIcon, exceptHorizontalIcon, exceptRightIcon);
    }

    public static void drawHorizontal(Component visual, Graphics g, Rectangle source, Rectangle dest, ImageIcon leftIcon, ImageIcon centerIcon, ImageIcon rightIcon) {
        Rectangle leftSide = source;
        Rectangle rightSide = dest;
        if (source.x > dest.x) {
            leftSide = dest;
            rightSide = source;
        }
        g.setColor(visual.getBackground());
        if (leftIcon != null && centerIcon != null && rightIcon != null) {
            g.drawImage(leftIcon.getImage(), leftSide.x + leftSide.width, leftSide.y, visual);
            int width = rightSide.x - (leftSide.x + leftSide.width) - leftIcon.getIconWidth() - rightIcon.getIconWidth();
            g.drawImage(centerIcon.getImage(), leftSide.x + leftSide.width + leftIcon.getIconWidth(), leftSide.y, width, centerIcon.getIconHeight(), visual);
            g.drawImage(rightIcon.getImage(), rightSide.x - rightIcon.getIconWidth(), leftSide.y, visual);
        }
    }

    public static void drawSeparatorLine(Graphics g, Color background, Rectangle rect) {
        g.setColor(background.darker());
        g.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y);
        g.setColor(background.brighter());
        g.drawLine(rect.x, rect.y + 1, rect.x + rect.width, rect.y + 1);
    }

    public static void draw3DBox(Graphics g, Color fill, Color light, Color dark, int x, int y, int width, int height) {
        if (fill != null) {
            g.setColor(fill);
            g.fillRect(x, y, width, height);
        }
        g.setColor(dark);
        g.drawLine(x + width, y + height, x, y + height);
        g.drawLine(x + width, y + height - 1, x + width, y);
        g.setColor(light);
        g.drawLine(x, y, x + width, y);
        g.drawLine(x, y, x, y + height);
    }

    public static void drawRoundedBox(Component visual, Graphics g, Color fill, Color light, Color dark, int x, int y, int width, int height) {
        if (fill != null) {
            g.setColor(fill);
            g.fillRect(x + 2, y + 2, width - 5, height - 5);
        }
        if (filterNodeSouthEastIcon == null) {
            filterNodeSouthEastIcon = ImageHandler.getImageIcon(bundle, "filterNodeSouthEastIcon");
            filterNodeSouthWestIcon = ImageHandler.getImageIcon(bundle, "filterNodeSouthWestIcon");
            filterNodeNorthEastIcon = ImageHandler.getImageIcon(bundle, "filterNodeNorthEastIcon");
            filterNodeNorthWestIcon = ImageHandler.getImageIcon(bundle, "filterNodeNorthWestIcon");
        }
        int iconWidth = filterNodeNorthWestIcon.getIconWidth();
        int iconHeight = filterNodeNorthWestIcon.getIconHeight();
        g.drawImage(filterNodeNorthWestIcon.getImage(), x, y, visual);
        g.drawImage(filterNodeNorthEastIcon.getImage(), x + width - iconWidth, y, visual);
        g.drawImage(filterNodeSouthWestIcon.getImage(), x, y + height - iconHeight, visual);
        g.drawImage(filterNodeSouthEastIcon.getImage(), x + width - filterNodeSouthEastIcon.getIconWidth(), y + height - filterNodeSouthEastIcon.getIconHeight(), visual);
        g.setColor(dark);
        g.drawLine(x + iconWidth, y, x + width - iconWidth, y);
        g.drawLine(x, y + iconHeight, x, y + height - iconHeight);
        g.drawLine(x + iconWidth, y + height - 2, x + width - iconWidth - 2, y + height - 2);
        g.drawLine(x + width - 2, y + height - iconHeight - 1, x + width - 2, y + iconHeight);
        g.setColor(light);
        g.drawLine(x + iconWidth, y + 1, x + width - iconWidth - 1, y + 1);
        g.drawLine(x + 1, y + iconHeight, x + 1, y + height - iconHeight - 1);
        g.drawLine(x + iconWidth, y + height - 3, x + width - iconWidth - 2, y + height - 3);
        g.drawLine(x + width - 3, y + height - iconHeight - 1, x + width - 3, y + iconHeight);
        g.setColor(Color.black);
        g.drawLine(x + iconWidth, y + height - 1, x + width - iconWidth - 1, y + height - 1);
        g.drawLine(x + width - 1, y + iconHeight, x + width - 1, y + height - iconHeight - 1);
    }

    public static void drawRoundedBoxWithDepthAndRecordCount(Component visual, Graphics g, Color fill, Color light, Color dark, int x, int y, int width, int height, int depthOfNode, String strNodeRecordCount, String strNodeCountError, Color countMessageColor) {
        Color currentColor = g.getColor();
        Font currentFont = g.getFont();
        g.setColor(countMessageColor);
        g.setFont(DrawUtil.getSmallFont());
        FontMetrics fontmetrics = g.getFontMetrics(DrawUtil.getSmallFont());
        for (int i = 0; i < depthOfNode; ++i) {
            DrawUtil.drawRoundedBox(visual, g, fill, light, dark, x + depthOfNode - i - 1, y - depthOfNode + i + 1, width, height);
        }
        if (strNodeCountError != null) {
            if (xIcon == null) {
                xIcon = ImageHandler.getImageIcon(bundle, "xIcon");
            }
            g.setColor(countMessageColor);
            g.drawImage(xIcon.getImage(), x + 3, y + 2, visual);
            g.drawString(strNodeCountError, x + 20, y + 14);
        }
        if (strNodeRecordCount != null) {
            g.setColor(countMessageColor);
            g.drawString(strNodeRecordCount, x + width + depthOfNode - fontmetrics.stringWidth(strNodeRecordCount), y - depthOfNode - 2);
        }
        g.setColor(currentColor);
        g.setFont(currentFont);
    }

    public static Font getLargeFont() {
        if (m_largeFont == null) {
            m_largeFont = new Font(QueryConfiguration.getConfigurationString("DrawUtil.LargeFontName.txt", "MS Serif"), 0, 11);
        }
        return m_largeFont;
    }

    public static Font getLargeBoldFont() {
        if (m_largeBoldFont == null) {
            m_largeBoldFont = new Font(QueryConfiguration.getConfigurationString("DrawUtil.LargeBoldFontName.txt", "MS Serif"), 1, 11);
        }
        return m_largeBoldFont;
    }

    public static Font getSmallFont() {
        if (m_smallFont == null) {
            m_smallFont = new Font(QueryConfiguration.getConfigurationString("DrawUtil.SmallFontName.txt", "MS Serif"), 0, 9);
        }
        return m_smallFont;
    }

    public static void drawPipe(Component visual, Graphics g, Rectangle source, Rectangle dest, boolean sourceHasPrecedingVerticalPipe) {
        if (pipeElboSouthEastIcon == null) {
            pipeTerminatorIcon = ImageHandler.getImageIcon(bundle, "pipeTerminatorIcon");
            pipeElboNorthEastIcon = ImageHandler.getImageIcon(bundle, "pipeElboNorthEastIcon");
            pipeElboSouthEastIcon = ImageHandler.getImageIcon(bundle, "pipeElboSouthEastIcon");
            pipeElboSouthWestIcon = ImageHandler.getImageIcon(bundle, "pipeElboSouthWestIcon");
            pipeHorizontalIcon = ImageHandler.getImageIcon(bundle, "pipeHorizontalIcon");
            pipeTeeEastIcon = ImageHandler.getImageIcon(bundle, "pipeTeeEastIcon");
            pipeTeeSouthIcon = ImageHandler.getImageIcon(bundle, "pipeTeeSouthIcon");
            pipeTeeWestIcon = ImageHandler.getImageIcon(bundle, "pipeTeeWestIcon");
            pipeVerticalIcon = ImageHandler.getImageIcon(bundle, "pipeVerticalIcon");
            pipeNodeConnectEastIcon = ImageHandler.getImageIcon(bundle, "pipeNodeConnectEastIcon");
            pipeNodeConnectWestIcon = ImageHandler.getImageIcon(bundle, "pipeNodeConnectWestIcon");
        }
        int startX = source.x + source.width;
        int startY = source.y + 27 - pipeVerticalIcon.getIconHeight() / 2;
        int endX = dest.x - 1;
        int endY = dest.y + 27 - pipeVerticalIcon.getIconHeight() / 2;
        if (startY < endY) {
            FilterTreeView filterView;
            FilterTreeView filterView2;
            if (visual instanceof FilterTreeView && (filterView2 = (FilterTreeView)visual).is3DEnabled()) {
                pipeNodeConnectWestIcon = pipeHorizontalIcon;
            }
            startX = source.x - pipeNodeConnectWestIcon.getIconWidth() - pipeTeeSouthIcon.getIconWidth();
            Rectangle top = new Rectangle(startX, startY, 0, 0);
            Rectangle bottom = new Rectangle(top.x, endY, 0, 0);
            if (endY - startY > pipeTeeSouthIcon.getIconHeight()) {
                ImageIcon topImage = pipeTeeSouthIcon;
                if (sourceHasPrecedingVerticalPipe) {
                    topImage = pipeTeeEastIcon;
                }
                DrawUtil.tileVertical(visual, g, top, bottom, topImage, pipeVerticalIcon, pipeVerticalIcon);
            }
            Rectangle left = new Rectangle(startX, endY, 0, 0);
            Rectangle right = new Rectangle(dest.x - 1, left.y, 0, 0);
            if (visual instanceof FilterTreeView && (filterView = (FilterTreeView)visual).is3DEnabled()) {
                pipeNodeConnectWestIcon = pipeHorizontalIcon;
            }
            DrawUtil.tileHorizontal(visual, g, left, right, pipeElboSouthWestIcon, pipeHorizontalIcon, pipeNodeConnectWestIcon);
        } else if (startY > endY) {
            int midpointX = endX - 2 * INTER_NODE_AND_SPACE / 3 - 28;
            if (midpointX % 2 != 0) {
                ++midpointX;
            }
            Rectangle top = new Rectangle(midpointX, startY, 0, 0);
            Rectangle bottom = new Rectangle(midpointX, endY, 0, 0);
            DrawUtil.tileVertical(visual, g, top, bottom, pipeTeeSouthIcon, pipeVerticalIcon, pipeVerticalIcon);
            Rectangle left = new Rectangle(startX, startY, 0, 0);
            Rectangle right = new Rectangle(midpointX + pipeHorizontalIcon.getIconWidth() - 1, startY - 1, 0, 0);
            ImageIcon rightImage = pipeElboSouthEastIcon;
            if (sourceHasPrecedingVerticalPipe) {
                rightImage = pipeTeeWestIcon;
            }
            DrawUtil.tileHorizontal(visual, g, left, right, pipeNodeConnectEastIcon, pipeHorizontalIcon, rightImage);
        } else {
            FilterTreeView filterView;
            Rectangle left = new Rectangle(source.x + source.width, source.y + 27 - pipeHorizontalIcon.getIconHeight() / 2, 0, 0);
            Rectangle right = new Rectangle(dest.x - 1, dest.y + 27 - pipeHorizontalIcon.getIconHeight() / 2, 0, 0);
            if (visual instanceof FilterTreeView && (filterView = (FilterTreeView)visual).is3DEnabled()) {
                pipeNodeConnectWestIcon = pipeHorizontalIcon;
            }
            DrawUtil.tileHorizontal(visual, g, left, right, pipeNodeConnectEastIcon, pipeHorizontalIcon, pipeNodeConnectWestIcon);
        }
    }

    public static void drawTerminator(Component visual, Graphics g, Rectangle source, Rectangle dest, boolean sourceHasPrecedingVerticalPipe, String strTerminatorRecordCount) {
        Color currentColor = g.getColor();
        Font currentFont = g.getFont();
        g.setColor(Color.black);
        g.setFont(DrawUtil.getSmallFont());
        if (strTerminatorRecordCount != null) {
            g.drawString(strTerminatorRecordCount, dest.x + dest.width - 11, dest.y + dest.height);
        }
        DrawUtil.drawPipe(visual, g, source, dest, sourceHasPrecedingVerticalPipe);
        int startY = dest.y + 27 - pipeTerminatorIcon.getIconHeight() / 2;
        if (pipeTerminatorIcon != null && pipeElboNorthEastIcon != null) {
            g.drawImage(pipeElboNorthEastIcon.getImage(), dest.x, startY, visual);
            g.drawImage(pipeTerminatorIcon.getImage(), dest.x, startY + pipeElboNorthEastIcon.getIconHeight(), visual);
        } else {
            Color c = g.getColor();
            g.setColor(Color.blue);
            g.fillArc(dest.x, startY, 20, 20, 0, 360);
            g.setColor(c);
        }
        g.setColor(currentColor);
        g.setFont(currentFont);
    }

    public static void tileHorizontal(Component visual, Graphics g, Rectangle source, Rectangle dest, ImageIcon leftIcon, ImageIcon centerIcon, ImageIcon rightIcon) {
        Rectangle leftSide = source;
        Rectangle rightSide = dest;
        if (source.x > dest.x) {
            leftSide = dest;
            rightSide = source;
        }
        g.setColor(visual.getBackground());
        if (leftIcon != null && centerIcon != null && rightIcon != null) {
            int remainder;
            g.drawImage(leftIcon.getImage(), leftSide.x + leftSide.width, leftSide.y, visual);
            int width = rightSide.x - (leftSide.x + leftSide.width) - leftIcon.getIconWidth() - rightIcon.getIconWidth();
            if (width > 0) {
                int limit = width / centerIcon.getIconWidth();
                if (width % centerIcon.getIconWidth() != 0) {
                    ++limit;
                }
                for (int index = 0; index < limit; ++index) {
                    g.drawImage(centerIcon.getImage(), leftSide.x + leftSide.width + leftIcon.getIconWidth() + centerIcon.getIconWidth() * index, leftSide.y, visual);
                }
            }
            if ((remainder = rightSide.x - (leftSide.x + leftSide.width) - leftIcon.getIconWidth()) > 0) {
                g.drawImage(rightIcon.getImage(), rightSide.x - rightIcon.getIconWidth() + 1, leftSide.y, visual);
            }
        }
    }

    public static void tileVertical(Component visual, Graphics g, Rectangle source, Rectangle dest, ImageIcon topIcon, ImageIcon centerIcon, ImageIcon bottomIcon) {
        Rectangle topSide = source;
        Rectangle bottomSide = dest;
        if (source.y > dest.y) {
            topSide = dest;
            bottomSide = source;
        }
        g.setColor(visual.getBackground());
        if (topIcon != null && centerIcon != null && bottomIcon != null) {
            g.drawImage(topIcon.getImage(), topSide.x, topSide.y, visual);
            int height = bottomSide.y - bottomIcon.getIconHeight() - (topSide.y + topIcon.getIconHeight()) + centerIcon.getIconHeight() - 1;
            for (int index = 0; index < height / centerIcon.getIconHeight(); ++index) {
                g.drawImage(centerIcon.getImage(), topSide.x, topSide.y + topIcon.getIconHeight() + centerIcon.getIconHeight() * index, centerIcon.getIconWidth(), centerIcon.getIconHeight(), visual);
            }
            g.drawImage(bottomIcon.getImage(), bottomSide.x, bottomSide.y - bottomIcon.getIconHeight(), visual);
        }
    }

    public static final void drawFocusRect(Graphics g, int x, int y, int width, int height) {
        int i;
        g.setColor(Color.black);
        g.setXORMode(Color.white);
        for (i = 0; i < width; i += 2) {
            g.drawLine(x + i, y, x + i, y);
            g.drawLine(x + i, y + height - 1, x + i, y + height - 1);
        }
        for (i = 0; i < height; i += 2) {
            g.drawLine(x, y + i, x, y + i);
            g.drawLine(x + width - 1, y + i, x + width - 1, y + i);
        }
        g.setPaintMode();
    }
}

