/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import javax.swing.JButton;

public class DrawPlusButton
extends JButton {
    public static final int IMAGE_NOT_SHOWN = 0;
    public static final int IMAGE_LEFT_OF_LABEL = 1;
    public static final int IMAGE_RIGHT_OF_LABEL = 2;
    public static final int IMAGE_CHOICE_DOWNARROW = 1;
    int m_image;
    int m_iPositionImage = 0;

    DrawPlusButton() {
        this("", 1, 0);
    }

    DrawPlusButton(String str) {
        this(str, 1, 0);
    }

    DrawPlusButton(String str, int whichImage, int ipos) {
        super(str);
        this.setImage(whichImage);
        this.setImagePosition(ipos);
    }

    private boolean getOutline() {
        return true;
    }

    private boolean getDepressed() {
        return false;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.getOutline()) {
            Color currentColor = g.getColor();
            g.setColor(this.getForeground());
            if (this.m_image == 1) {
                int arrowUnit = 1 + this.getSize().height / 6;
                Polygon p = new Polygon();
                int centerY = this.getSize().height / 2 + 2;
                int centerX = 0;
                if (this.m_iPositionImage == 2) {
                    centerX = this.getSize().width - 2 * arrowUnit - 2;
                } else if (this.m_iPositionImage == 1) {
                    centerX = 2 * arrowUnit + 2;
                }
                if (this.m_iPositionImage != 0) {
                    p.addPoint(centerX - arrowUnit, centerY - arrowUnit);
                    p.addPoint(centerX + arrowUnit, centerY - arrowUnit);
                    p.addPoint(centerX, centerY);
                    p.addPoint(centerX - arrowUnit, centerY - arrowUnit);
                    g.fillPolygon(p);
                }
            }
            g.setColor(currentColor);
        }
    }

    public void setImage(int img) {
        this.m_image = img;
    }

    public void setImagePosition(int ipos) {
        this.m_iPositionImage = ipos;
    }
}

