/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.QueryUtils;
import com.sas.query.datasources.DataSourceClassInfo;
import com.sas.query.datasources.DataSourceClassInfoList;
import com.sas.query.models.DefinedConnection;
import com.sas.query.models.MessageHandler;
import com.sas.query.visuals.ConnectionPropertiesDefiner;
import com.sas.query.visuals.MessageUtil;
import com.sas.query.visuals.QueryComponentInterface;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.SqlTextHelperConstants;
import com.sas.query.visuals.StandardView;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DefinedConnectionPropertyView
extends StandardView
implements QueryComponentInterface,
SqlTextHelperConstants {
    protected DefinedConnection m_connection;
    protected Dimension m_windowRestoreSize;
    protected int m_selectedTabIndex;
    protected boolean m_doingDataExchange = false;
    public JTabbedPane m_tabPane;
    public DefinedConnectionGeneralPropertyView m_genPropertyView;
    public ConnectionPropertiesDefiner m_connectionDefiner;
    static QueryResource bundle = new QueryResource(DefinedConnectionPropertyView.class);
    static DataSourceClassInfoList m_classInfoList = new DataSourceClassInfoList();

    public DefinedConnectionPropertyView(Query query, DefinedConnection connection) {
        super(query);
        this.m_connection = connection;
        this._initialize();
        this._layoutWidgets();
    }

    public void setReadOnly() {
        this.m_genPropertyView.setReadOnly();
        if (this.m_connectionDefiner != null) {
            this.m_connectionDefiner.setReadOnly();
        }
    }

    public void setConnection(DefinedConnection connection) {
        this.doDataExchange(true);
        this.m_connection = connection;
        this.doDataExchange(false);
        if (this.m_connection == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    @Override
    public void closing() {
    }

    @Override
    public boolean validateInput() {
        return true;
    }

    @Override
    public void doDataExchange(boolean bSaveToModel) {
        if (this.m_connection == null) {
            return;
        }
        this.m_genPropertyView.doDataExchange(bSaveToModel);
        if (bSaveToModel) {
            if (this.m_connectionDefiner != null) {
                this.m_connection.setConnectionProperties(this.m_connectionDefiner.getConnectionProperties());
            }
        } else if (this.m_connectionDefiner != null) {
            this.m_connectionDefiner.setConnectionProperties(this.m_connection.getConnectionProperties());
        }
    }

    protected void _initialize() {
        this.m_tabPane = new JTabbedPane();
        this.m_tabPane.addChangeListener(new TabChangeListner());
        this.m_genPropertyView = new DefinedConnectionGeneralPropertyView(this.m_query);
        this.m_connectionDefiner = null;
        if (this.m_connection != null && this.m_connection.getType() != null) {
            DataSourceClassInfo selectedDataSourceInfo = (DataSourceClassInfo)m_classInfoList.get(this.m_connection.getType());
            String propertyDefinerClass = null;
            if (selectedDataSourceInfo != null) {
                propertyDefinerClass = selectedDataSourceInfo.getPropertiesDefiner();
            }
            if (propertyDefinerClass != null && propertyDefinerClass != "") {
                try {
                    Class<?> dataSourcePropertyDefinerClass = Class.forName(propertyDefinerClass);
                    this.m_connectionDefiner = (ConnectionPropertiesDefiner)dataSourcePropertyDefinerClass.newInstance();
                }
                catch (Exception e) {
                    MessageHandler messages = new MessageHandler();
                    messages.addError(bundle.getString("DefinedConnection.ClassLoadError.txt") + "\n" + e.getMessage());
                    MessageUtil.displayMessages(messages);
                }
            }
        }
    }

    protected void _layoutWidgets() {
        this.m_tabPane.addTab(bundle.getString("DefinedConnection.Label.GeneralTab.txt"), this.m_genPropertyView);
        if (this.m_connectionDefiner != null) {
            this.m_tabPane.addTab(bundle.getString("DefinedConnection.Label.ConnectTab.txt"), this.m_connectionDefiner);
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 0;
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(6, 4, 4, 0);
        gridBagLayout.setConstraints(this.m_tabPane, gbc);
        this.add(this.m_tabPane);
    }

    protected class DefinedConnectionGeneralPropertyView
    extends StandardView
    implements QueryComponentInterface,
    SqlTextHelperConstants {
        public JTextField m_displayStringText;
        public JComboBox m_typeChoice;
        public JTextField m_userNameText;
        public JPasswordField m_passwordText;
        public JTextField m_connectStringText;

        public DefinedConnectionGeneralPropertyView(Query query) {
            super(query);
            this._initialize();
            this._layoutWidgets();
        }

        public void setReadOnly() {
            this.m_displayStringText.setEditable(false);
            this.m_typeChoice.setEnabled(false);
            this.m_userNameText.setEditable(false);
            this.m_passwordText.setEditable(false);
            this.m_connectStringText.setEditable(false);
        }

        @Override
        public void closing() {
        }

        @Override
        public boolean validateInput() {
            return true;
        }

        @Override
        public void doDataExchange(boolean bSaveToModel) {
            DefinedConnectionPropertyView.this.m_doingDataExchange = true;
            if (DefinedConnectionPropertyView.this.m_connection == null) {
                DefinedConnectionPropertyView.this.m_doingDataExchange = false;
                return;
            }
            if (bSaveToModel) {
                String displayString = this.m_displayStringText.getText();
                DefinedConnectionPropertyView.this.m_connection.setDisplayString(displayString);
                Object selectedObject = this.m_typeChoice.getSelectedItem();
                DataSourceClassInfo classInfo = m_classInfoList.getClassInfoByDisplayName((String)selectedObject);
                DefinedConnectionPropertyView.this.m_connection.setType(classInfo.getClassType());
                DefinedConnectionPropertyView.this.m_connection.setUserName(this.m_userNameText.getText());
                DefinedConnectionPropertyView.this.m_connection.setPassword(QueryUtils.safeEncrypt(new String(this.m_passwordText.getPassword())));
                DefinedConnectionPropertyView.this.m_connection.setConnectString(this.m_connectStringText.getText());
            } else {
                this.m_displayStringText.setText(DefinedConnectionPropertyView.this.m_connection.getDisplayString());
                if (DefinedConnectionPropertyView.this.m_connection.getType() != null && DefinedConnectionPropertyView.this.m_connection.getType().length() != 0) {
                    String tmpstr = ((DataSourceClassInfo)m_classInfoList.get(DefinedConnectionPropertyView.this.m_connection.getType())).getDisplayName();
                    this.m_typeChoice.setSelectedItem(tmpstr);
                }
                this.m_userNameText.setText(DefinedConnectionPropertyView.this.m_connection.getUserName());
                this.m_passwordText.setText(QueryUtils.safeDecrypt(DefinedConnectionPropertyView.this.m_connection.getPassword()));
                this.m_connectStringText.setText(DefinedConnectionPropertyView.this.m_connection.getConnectString());
            }
            DefinedConnectionPropertyView.this.m_doingDataExchange = false;
        }

        protected void _initialize() {
            this.m_displayStringText = new JTextField();
            this.m_typeChoice = new JComboBox();
            Enumeration infolist = m_classInfoList.elements();
            while (infolist.hasMoreElements()) {
                this.m_typeChoice.addItem(((DataSourceClassInfo)infolist.nextElement()).getDisplayName());
            }
            this.m_typeChoice.addActionListener(new ComboHandler(this.m_typeChoice));
            this.m_userNameText = new JTextField();
            this.m_passwordText = new JPasswordField();
            this.m_connectStringText = new JTextField();
        }

        protected void _layoutWidgets() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            TitledBorder titleBorder = DefinedConnectionPropertyView.this.m_connection.isLocalDefinition() ? BorderFactory.createTitledBorder(bundle.getString("DefinedConnection.BorderTitle.Personal.txt")) : BorderFactory.createTitledBorder(bundle.getString("DefinedConnection.BorderTitle.System.txt"));
            this.setBorder(BorderFactory.createCompoundBorder(titleBorder, BorderFactory.createEmptyBorder(8, 8, 8, 8)));
            int gridy = 0;
            JLabel label = new JLabel(bundle.getString("DefinedConnection.Label.Description.txt"));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy;
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.insets = new Insets(0, 0, 0, 0);
            gridBagLayout.setConstraints(label, gbc);
            this.add(label);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = gridy++;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.insets = new Insets(0, 8, 0, 0);
            gridBagLayout.setConstraints(this.m_displayStringText, gbc);
            this.add(this.m_displayStringText);
            this.m_displayStringText.setColumns(22);
            label = new JLabel(bundle.getString("DefinedConnection.Label.Type.txt"));
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy;
            gbc.gridheight = 0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(10, 0, 0, 0);
            gridBagLayout.setConstraints(label, gbc);
            this.add(label);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = gridy++;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.insets = new Insets(8, 8, 0, 0);
            gridBagLayout.setConstraints(this.m_typeChoice, gbc);
            this.add(this.m_typeChoice);
            label = new JLabel(bundle.getString("DefinedConnection.Label.UserName.txt"));
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy;
            gbc.gridheight = 0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(10, 0, 0, 0);
            gridBagLayout.setConstraints(label, gbc);
            this.add(label);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = gridy++;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.insets = new Insets(8, 8, 0, 0);
            gridBagLayout.setConstraints(this.m_userNameText, gbc);
            this.add(this.m_userNameText);
            label = new JLabel(bundle.getString("DefinedConnection.Label.Password.txt") + "*");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy;
            gbc.gridheight = 0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(10, 0, 0, 0);
            gridBagLayout.setConstraints(label, gbc);
            this.add(label);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = gridy++;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.insets = new Insets(8, 8, 0, 0);
            gridBagLayout.setConstraints(this.m_passwordText, gbc);
            this.add(this.m_passwordText);
            label = new JLabel(bundle.getString("DefinedConnection.Label.ConnectString.txt"));
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy;
            gbc.gridheight = 0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(10, 0, 0, 0);
            gridBagLayout.setConstraints(label, gbc);
            this.add(label);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = gridy++;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.insets = new Insets(8, 8, 0, 0);
            gridBagLayout.setConstraints(this.m_connectStringText, gbc);
            this.add(this.m_connectStringText);
            label = new JLabel("* " + bundle.getString("DefinedConnection.Note.Password.txt"));
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy;
            gbc.gridwidth = 0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(15, 0, 0, 0);
            gridBagLayout.setConstraints(label, gbc);
            this.add(label);
        }
    }

    protected class TabChangeListner
    implements ChangeListener {
        protected Window m_window;

        protected TabChangeListner() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JTabbedPane tabber = (JTabbedPane)e.getSource();
            int tabIndex = tabber.getSelectedIndex();
            if (this.m_window == null) {
                Container cmponent = DefinedConnectionPropertyView.this;
                while (cmponent != null && !((cmponent = cmponent.getParent()) instanceof Window)) {
                }
                if (cmponent != null) {
                    this.m_window = (Window)cmponent;
                }
            }
            if (tabIndex != DefinedConnectionPropertyView.this.m_selectedTabIndex) {
                if (DefinedConnectionPropertyView.this.m_selectedTabIndex > 0 && tabIndex == 0) {
                    this.m_window.setSize(DefinedConnectionPropertyView.this.m_windowRestoreSize);
                    this.m_window.invalidate();
                    this.m_window.doLayout();
                } else if (tabIndex > 0) {
                    Component oldCom = tabber.getComponentAt(DefinedConnectionPropertyView.this.m_selectedTabIndex);
                    Component newCom = tabber.getComponentAt(tabIndex);
                    Dimension oldComSize = oldCom.getSize();
                    Dimension newComSize = newCom.getPreferredSize();
                    Dimension deltaSize = new Dimension(Math.max(0, oldComSize.width - newComSize.width), Math.max(0, oldComSize.height - newComSize.height));
                    if (DefinedConnectionPropertyView.this.m_selectedTabIndex == 0) {
                        DefinedConnectionPropertyView.this.m_windowRestoreSize = this.m_window.getSize();
                    }
                    if (deltaSize.width > 0 || deltaSize.height > 0) {
                        Dimension newSize = new Dimension(this.m_window.getSize().width + deltaSize.width, this.m_window.getSize().height + deltaSize.height);
                        this.m_window.setSize(newSize);
                        this.m_window.invalidate();
                        this.m_window.doLayout();
                    }
                }
                DefinedConnectionPropertyView.this.m_selectedTabIndex = tabIndex;
            }
        }
    }

    protected class ComboHandler
    implements ActionListener {
        JComboBox m_combo;

        ComboHandler(JComboBox combo) {
            this.m_combo = combo;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            DataSourceClassInfo selectedDataSourceInfo;
            String propertyDefinerClass;
            if (DefinedConnectionPropertyView.this.m_doingDataExchange) {
                return;
            }
            if (this.m_combo.getSelectedItem() == null || ((String)this.m_combo.getSelectedItem()).equals(DefinedConnectionPropertyView.this.m_connection.getType())) {
                return;
            }
            DefinedConnectionPropertyView.this.doDataExchange(true);
            if (DefinedConnectionPropertyView.this.m_connectionDefiner != null) {
                DefinedConnectionPropertyView.this.m_tabPane.remove(DefinedConnectionPropertyView.this.m_connectionDefiner);
                DefinedConnectionPropertyView.this.m_connectionDefiner = null;
            }
            if ((propertyDefinerClass = (selectedDataSourceInfo = m_classInfoList.getClassInfoByDisplayName((String)this.m_combo.getSelectedItem())).getPropertiesDefiner()) != null && propertyDefinerClass != "") {
                try {
                    Class<?> dataSourcePropertyDefinerClass = Class.forName(propertyDefinerClass);
                    DefinedConnectionPropertyView.this.m_connectionDefiner = (ConnectionPropertiesDefiner)dataSourcePropertyDefinerClass.newInstance();
                }
                catch (Exception e) {
                    MessageHandler messages = new MessageHandler();
                    messages.addError(bundle.getString("DefinedConnection.ClassLoadError.txt") + "\n" + e.getMessage());
                    MessageUtil.displayMessages(messages);
                    DefinedConnectionPropertyView.this.m_connectionDefiner = null;
                }
            }
            if (DefinedConnectionPropertyView.this.m_connectionDefiner != null) {
                DefinedConnectionPropertyView.this.m_tabPane.add("Connection Info", DefinedConnectionPropertyView.this.m_connectionDefiner);
            }
        }
    }
}

