/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.QueryConfiguration;
import com.sas.query.models.FilterNetwork;
import com.sas.query.models.FilterNetworkAtomExpression;
import com.sas.query.models.FilterNode;
import com.sas.query.models.ModelChangeEvent;
import com.sas.query.visuals.BarNoun;
import com.sas.query.visuals.BarPart;
import com.sas.query.visuals.BarVerb;
import com.sas.query.visuals.BarView;
import com.sas.query.visuals.DataFilterSection;
import com.sas.query.visuals.FilterEditDialog;
import com.sas.query.visuals.QueryComponentDialog;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.WindowUtil;
import java.awt.Color;
import javax.swing.JOptionPane;

public class DataFilterBarView
extends BarView {
    protected static QueryResource bundle = new QueryResource(DataFilterBarView.class);

    public DataFilterBarView(Query query) {
        super(query, bundle.getString("DataFilterBarView.DataFilters.txt"), new Color(102, 204, 153), Color.black);
        this.m_query.addPropertyListener(this, 32);
        this.setAllowArrangement(false);
        this.refresh();
    }

    @Override
    public void closing() {
        this.m_query.removePropertyListener(this);
    }

    @Override
    public void refresh() {
        this.removeAllParts();
        this.addFilterNodeParts();
        super.refresh();
        this.setSelection(this.m_query.getSelectedFilter());
    }

    @Override
    public void setSelectedPart(int i) {
        super.setSelectedPart(i);
        BarPart cursel = this.getSelectedPart();
        if (cursel instanceof BarNoun) {
            BarNoun curselNoun = (BarNoun)cursel;
            Object selFilter = curselNoun.getData();
            if (!(selFilter instanceof FilterNode)) {
                return;
            }
            if (this.m_query.getSelectedFilter() != selFilter) {
                this.m_query.setSelectedFilter((FilterNode)selFilter);
                this.firePropertyChanges();
            }
        }
    }

    public void setSelection(FilterNode sel) {
        for (int i = 0; i < this.m_parts.size(); ++i) {
            BarNoun candidateNoun;
            BarPart candidate = (BarPart)this.m_parts.elementAt(i);
            if (!(candidate instanceof BarNoun) || (candidateNoun = (BarNoun)candidate).getData() != sel) continue;
            super.setSelectedPart(i);
        }
    }

    public void addFilterNodeParts() {
        FilterNetwork filterNetwork = new FilterNetwork();
        FilterNetworkAtomExpression list = filterNetwork.generateOptimizedFilterClause(this.m_query, this.m_query.getWhereFilterTree());
        if (list == null) {
            return;
        }
        for (int index = 0; index < list.size(); ++index) {
            BarVerb verb;
            Object item = list.elementAt(index);
            if (item instanceof String) {
                verb = new BarVerb((String)item);
                this.addPart(verb);
                continue;
            }
            if (item instanceof FilterNode) {
                FilterNode node = (FilterNode)item;
                try {
                    BarNoun noun = new BarNoun(node, node.getClass().getMethod("toString", null));
                    this.addPart(noun);
                }
                catch (Exception e) {
                    this.m_query.getMessageHandler().addInternalError(bundle.messageString("DataFilterBarView.createRecordFilterBarnounerror.fmt.txt", e.getMessage()));
                }
                continue;
            }
            verb = new BarVerb(item.toString());
            this.addPart(verb);
        }
    }

    @Override
    public void modelChangeCallback(ModelChangeEvent event) {
        this.refresh();
    }

    @Override
    public void onEditBar() {
        DataFilterSection propertyPanel = new DataFilterSection(this.m_query);
        QueryComponentDialog editDialog = new QueryComponentDialog(WindowUtil.getParentFrame(this), this.m_query, propertyPanel, "BUG - need Prefix");
        editDialog.setBounds(200, 100, 550, 335);
        editDialog.setVisible(true);
        propertyPanel.closing();
        this.displayMessages();
    }

    @Override
    public void onEdit() {
        this.busyOn();
        try {
            FilterNode item = this.getSelectedItem();
            FilterEditDialog limitDialog = new FilterEditDialog(this.m_query, WindowUtil.getParentFrame(this), item);
            WindowUtil.centerOver(limitDialog, this.getParent());
            limitDialog.setVisible(true);
            this.m_query.isValidSql();
        }
        catch (Throwable t) {
            this.busyOff();
            this.m_query.getMessageHandler().addInternalError(t);
        }
        this.busyOff();
        this.firePropertyChanges();
        this.displayMessages();
    }

    @Override
    public void onInsert() {
        this.firePropertyChanges();
        this.displayMessages();
    }

    @Override
    public void onDelete() {
        FilterNode item = this.getSelectedItem();
        if (QueryConfiguration.getConfigurationBoolean("DeleteFilterWarningDialogEnabled.notrans", true)) {
            Object[] options = new Object[]{bundle.getString("Standard.ButtonLabel.Yes.txt"), bundle.getString("Standard.ButtonLabel.No.txt")};
            int annoyedUserSays = JOptionPane.showOptionDialog(null, bundle.messageString("FilterTree.Label.DeleteFilter.txt"), bundle.messageString("Title.Confirm.txt"), 0, 3, null, options, options[0]);
            if (annoyedUserSays != 0) {
                this.requestFocus();
                return;
            }
        }
        this.m_query.getWhereFilterTree().removeNode(item);
        this.displayMessages();
        this.firePropertyChanges();
        super.onDelete();
        this.firePropertyChanges();
    }

    @Override
    public void onMovePart(int oldIndex, int newIndex) {
        this.displayMessages();
        this.firePropertyChanges();
    }

    protected FilterNode getSelectedItem() {
        FilterNode item = null;
        if (this.getSelectedPart() != null) {
            item = (FilterNode)this.getSelectedPart().getData();
        }
        return item;
    }
}

