/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.QueryConfiguration;
import com.sas.query.visuals.DataBaseUIRequest;
import com.sas.query.visuals.LifeSign;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.WindowUtil;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class DataBaseProgressIndicator
extends JDialog {
    static QueryResource bundle = new QueryResource(DataBaseProgressIndicator.class);
    static QueryConfiguration queryConfig = new QueryConfiguration();
    protected Frame m_parentFrame;
    protected Component m_parentComponent;
    protected String m_strTitle;
    protected LifeSign m_activityIndicator;
    protected boolean m_didCancel = false;
    protected DataBaseUIRequest m_request;

    public DataBaseProgressIndicator(Frame parentFrame, DataBaseUIRequest request, String titleString, String contentString) {
        super(parentFrame, titleString, true);
        this.m_request = request;
        this.m_strTitle = titleString;
        this.m_parentFrame = parentFrame;
        this.m_parentComponent = parentFrame;
        this._initialization();
        this._layoutWidgets();
        this.pack();
    }

    public DataBaseProgressIndicator(JDialog parentDialog, DataBaseUIRequest request, String titleString, String contentString) {
        super(parentDialog, titleString, true);
        this.m_request = request;
        this.m_strTitle = titleString;
        this.m_parentComponent = parentDialog;
        this._initialization();
        this._layoutWidgets();
        this.pack();
    }

    @Override
    public void show() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new DialogCloser());
        WindowUtil.centerOverWindow(this, this.m_parentComponent);
        super.show();
    }

    protected void _initialization() {
        int lifeWidth = QueryConfiguration.getConfigurationInt("LifeSign.Width.notrans", 120);
        int lifeWaveSize = QueryConfiguration.getConfigurationInt("LifeSign.WaveSize.notrans", 120);
        this.m_activityIndicator = new LifeSign(lifeWidth, lifeWaveSize, 0);
        this.m_activityIndicator.setBackground(SystemColor.control);
        this.setResizable(true);
        this.setTitle(this.m_strTitle);
    }

    public void _layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        JLabel cancelMessage = new JLabel(bundle.messageString("DataBaseProgressIndicator.Label.Main.txt"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 10;
        gbc.insets = new Insets(10, 10, 10, 10);
        gridBagLayout.setConstraints(cancelMessage, gbc);
        this.getContentPane().add(cancelMessage);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 10, 0, 10);
        gridBagLayout.setConstraints(this.m_activityIndicator, gbc);
        this.getContentPane().add(this.m_activityIndicator);
        JButton closeButton = new JButton(bundle.messageString("Standard.ButtonLabel.Cancel.txt"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.insets = new Insets(10, 10, 10, 10);
        gridBagLayout.setConstraints(closeButton, gbc);
        this.getContentPane().add(closeButton);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DataBaseProgressIndicator.this.m_request.requestCancel();
                if (DataBaseProgressIndicator.this.m_request.m_cancellationRequested) {
                    DataBaseProgressIndicator.this.dispose();
                }
            }
        });
    }

    public void showActivity() {
        this.m_activityIndicator.pulse();
    }

    protected class DialogCloser
    extends WindowAdapter {
        protected DialogCloser() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            DataBaseProgressIndicator.this.m_request.requestCancel();
            if (DataBaseProgressIndicator.this.m_request.m_cancellationRequested) {
                DataBaseProgressIndicator.this.dispose();
            }
        }
    }
}

