/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.visuals.ImageHandler;
import com.sas.query.visuals.QueryResource;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class ClueView
extends JPanel {
    static QueryResource bundle = new QueryResource(ClueView.class);
    String m_message1;
    String m_message2;
    Dimension m_preferredSize = new Dimension(200, 50);
    ImageIcon m_bulbImage = null;
    int m_bulbWidth = 0;
    int m_lineHeight = 0;

    ClueView(String message1, String message2) {
        this.m_message1 = message1;
        this.m_message2 = message2;
        this.m_bulbImage = ImageHandler.getImageIcon(bundle, "bulbBlueIcon");
    }

    @Override
    public Dimension getPreferredSize() {
        return this.m_preferredSize;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.m_lineHeight == 0) {
            FontMetrics fontmetrics = this.getParent().getGraphics().getFontMetrics();
            this.m_lineHeight = fontmetrics.getAscent() + fontmetrics.getDescent() + 1;
            int bulbHeight = 0;
            this.m_bulbWidth = 0;
            if (this.m_bulbImage != null) {
                this.m_bulbWidth = this.m_bulbImage.getIconWidth();
                bulbHeight = this.m_bulbImage.getIconHeight();
            }
            int width = 8 + this.m_bulbWidth + 16 + Math.max(fontmetrics.stringWidth(this.m_message1), fontmetrics.stringWidth(this.m_message2));
            int height = Math.max((int)((double)this.m_lineHeight * 2.6), bulbHeight + 4);
            this.m_preferredSize = new Dimension(width, height);
            this.setSize(width, height);
            this.setMinimumSize(this.m_preferredSize);
        }
        Rectangle rect = this.getBounds();
        g.setColor(new Color(211, 211, 211));
        g.fillRect(0, 0, rect.width, rect.height);
        if (this.m_bulbImage != null) {
            g.drawImage(this.m_bulbImage.getImage(), 2, 2, new Color(211, 211, 211), this);
        }
        g.setColor(Color.black);
        g.drawString(this.m_message1, this.m_bulbWidth + 16, (int)((double)this.m_lineHeight * 1.2));
        g.drawString(this.m_message2, this.m_bulbWidth + 16, (int)((double)this.m_lineHeight * 1.2) + this.m_lineHeight);
        g.drawLine(0, rect.height - 1, rect.width - 1, rect.height - 1);
        g.drawLine(rect.width - 1, 0, rect.width - 1, rect.height - 1);
        g.setColor(Color.white);
        g.drawLine(0, 0, rect.width, 0);
        g.drawLine(0, 0, 0, rect.height);
    }
}

