/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.visuals.QueryResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class CheckBoxPanel
extends JPanel {
    protected String title;
    protected Border border;
    protected Border wrappedBorder;
    protected int titlePosition;
    protected JCheckBox m_checkBox;
    protected JPanel m_interiorPanel;
    protected JPanel m_filler;
    public static final int DEFAULT_POSITION = 0;
    public static final int ABOVE_TOP = 1;
    public static final int TOP = 2;
    public static final int BELOW_TOP = 3;
    public static final int ABOVE_BOTTOM = 4;
    public static final int BOTTOM = 5;
    public static final int BELOW_BOTTOM = 6;
    protected static QueryResource bundle = new QueryResource(CheckBoxPanel.class);

    public CheckBoxPanel(String title) {
        this(null, title, 2, false);
    }

    public CheckBoxPanel(Border border) {
        this(border, "", 2, false);
    }

    public CheckBoxPanel(Border border, String title) {
        this(border, title, 2, false);
    }

    public CheckBoxPanel(Border border, String title, int titlePosition) {
        this(border, title, titlePosition, false);
    }

    public CheckBoxPanel(String title, int titlePosition) {
        this(null, title, titlePosition, false);
    }

    public CheckBoxPanel(String title, boolean initialstate) {
        this(null, title, 2, initialstate);
    }

    public CheckBoxPanel(Border border, String title, int titlePosition, boolean initiallySetCheckBox) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.setBorder(border);
        this.titlePosition = titlePosition;
        this.m_checkBox = new JCheckBox(title, initiallySetCheckBox);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridy = titlePosition < 4 ? 0 : 2;
        gridBagLayout.setConstraints(this.m_checkBox, gbc);
        this.add(this.m_checkBox);
        this.m_interiorPanel = new JPanel();
        this.m_interiorPanel.setLayout(new BorderLayout(0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = titlePosition < 4 ? 2 : 0;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_interiorPanel, gbc);
        this.add(this.m_interiorPanel);
        this.m_checkBox.addItemListener(new CheckBoxHandler());
        this._setState();
    }

    public JPanel getInteriorPanel() {
        return this.m_interiorPanel;
    }

    public JCheckBox getCheckBox() {
        return this.m_checkBox;
    }

    @Override
    public void setBorder(Border newBorder) {
        this.border = newBorder;
        if (this.border == null) {
            this.border = UIManager.getBorder("TitledBorder.border");
        }
        this.wrappedBorder = new CheckBoxBorder();
        super.setBorder(this.wrappedBorder);
    }

    public int getTitlePosition() {
        return this.titlePosition;
    }

    public void setCheckBoxPosition(int titlePosition) {
        switch (titlePosition) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.titlePosition = titlePosition;
                break;
            }
            default: {
                throw new IllegalArgumentException(bundle.messageString("CheckBoxPanel.notValidTitlePos.fmt.txt", new Integer(titlePosition).toString()));
            }
        }
    }

    public void update() {
        this._setState();
    }

    protected void _setState() {
        boolean enableState = this.m_checkBox.isSelected();
        this.recursivelyEnable(this.m_interiorPanel, enableState);
    }

    protected void recursivelyEnable(JPanel panel, boolean state) {
        Component[] kids = panel.getComponents();
        for (int i = 0; i < kids.length; ++i) {
            kids[i].setEnabled(state);
            if (!(kids[i] instanceof JPanel)) continue;
            JPanel temp = (JPanel)kids[i];
            this.recursivelyEnable(temp, state);
        }
    }

    class CheckBoxHandler
    implements ItemListener {
        CheckBoxHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            CheckBoxPanel.this._setState();
        }
    }

    private class CheckBoxBorder
    extends AbstractBorder {
        private int xoffset = 0;
        private int yoffset = 0;

        CheckBoxBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            Insets t = CheckBoxPanel.this.border.getBorderInsets(c);
            return t;
        }

        @Override
        public boolean isBorderOpaque() {
            return CheckBoxPanel.this.border.isBorderOpaque();
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Insets myBorderInsets = CheckBoxPanel.this.border.getBorderInsets(c);
            switch (CheckBoxPanel.this.titlePosition) {
                case 1: {
                    this.yoffset = CheckBoxPanel.this.m_checkBox.getHeight();
                    break;
                }
                default: {
                    this.yoffset = CheckBoxPanel.this.m_checkBox.getHeight() / 2 + myBorderInsets.top;
                    break;
                }
                case 3: {
                    this.yoffset = 0;
                    break;
                }
                case 4: {
                    this.yoffset = 0;
                    break;
                }
                case 5: {
                    this.yoffset = CheckBoxPanel.this.m_checkBox.getHeight() / 2 + myBorderInsets.bottom;
                    break;
                }
                case 6: {
                    this.yoffset = CheckBoxPanel.this.m_checkBox.getHeight();
                }
            }
            if (CheckBoxPanel.this.titlePosition < 4) {
                CheckBoxPanel.this.border.paintBorder(c, g, x, y + this.yoffset, width, height - this.yoffset);
            } else {
                CheckBoxPanel.this.border.paintBorder(c, g, x, y, width, height - this.yoffset);
            }
        }
    }
}

