/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.visuals.BarVerb;
import com.sas.query.visuals.Part;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;

abstract class BarPart
extends Part {
    protected String m_displayString;
    protected boolean m_displayStringFits = true;
    protected static final String ELIPSIS_STRING = "...";
    protected int m_elipsisLength;
    protected static int MAX_WIDTH = 165;

    BarPart() {
    }

    @Override
    public Dimension getPreferredSize() {
        int width;
        int displayStringWidth;
        Graphics g = this.getParent().getGraphics();
        if (g == null) {
            return new Dimension(80, 25);
        }
        FontMetrics fontmetrics = g.getFontMetrics();
        int margin = 15;
        if (this instanceof BarVerb) {
            margin = 6;
        }
        if ((displayStringWidth = fontmetrics.stringWidth(this.m_displayString)) + margin > MAX_WIDTH) {
            width = MAX_WIDTH;
            this.m_displayStringFits = false;
        } else {
            width = displayStringWidth + margin;
            this.m_displayStringFits = true;
        }
        int height = fontmetrics.getAscent() + fontmetrics.getDescent() + 8;
        this.m_elipsisLength = fontmetrics.stringWidth(ELIPSIS_STRING);
        return new Dimension(width, height);
    }

    String getDisplayString() {
        return this.m_displayString;
    }

    Object getData() {
        return this.m_displayString;
    }

    public boolean isFocusTraversable() {
        return false;
    }
}

