/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.parser;

import com.sas.query.datasources.DataSource;
import com.sas.query.models.MessageHandler;
import com.sas.query.models.PhysicalColumn;
import com.sas.query.parser.Token;
import com.sas.query.parser.TokenConstants;
import com.sas.query.parser.Tokenizer;
import com.sas.query.visuals.QueryResource;
import java.util.Vector;

public class TokenList
implements TokenConstants {
    protected Vector m_list;
    protected String m_originalString;
    protected String m_debugPartialString;
    protected static QueryResource bundle = new QueryResource(TokenList.class);

    public TokenList(String originalString) {
        this.m_originalString = originalString;
        this.m_list = new Vector();
    }

    public TokenList duplicate() {
        TokenList retval = new TokenList(this.m_originalString);
        for (int i = 0; i < this.m_list.size(); ++i) {
            retval.m_list.addElement(this.m_list.elementAt(i));
        }
        return retval;
    }

    public TokenList(TokenList existingList, int startIndex, int stopIndex, boolean bInclusive) {
        if (!bInclusive) {
            ++startIndex;
            --stopIndex;
        }
        this.m_originalString = existingList.getOriginalString();
        if (startIndex >= 0 && stopIndex >= 0) {
            int startOfText = existingList.elementAt(startIndex).getStart();
            int endOfText = existingList.elementAt(stopIndex).getEnd();
            this.m_debugPartialString = existingList.getOriginalString().substring(startOfText, endOfText);
            this.m_list = new Vector(stopIndex - startIndex + 1);
            for (int index = startIndex; index <= stopIndex; ++index) {
                this.m_list.addElement(existingList.elementAt(index));
            }
        } else {
            this.m_list = new Vector();
            this.m_debugPartialString = bundle.messageString("delimTokensNotInOrigString.txt");
        }
    }

    public TokenList(TokenList existingList, Token startToken, Token stopToken, boolean bInclusive) {
        this(existingList, existingList.indexOf(startToken), existingList.indexOf(stopToken), bInclusive);
    }

    protected void dumpTokens() {
        for (int index = 0; index < this.size(); ++index) {
            Token token = this.elementAt(index);
            System.out.println("token = " + token.toString());
            System.out.println("\t\t\ttype = " + token.getTypeName());
            if (token.getSubType() == 0) continue;
            System.out.println("\t\t\tsubtype = " + token.getSubTypeName());
        }
    }

    public String toString() {
        if (this.size() == 0) {
            return "";
        }
        int startOfText = this.elementAt(0).getStart();
        int endOfText = this.elementAt(this.size() - 1).getEnd();
        return this.getOriginalString().substring(startOfText, endOfText);
    }

    public String unresolvedToString() {
        String retval = this.toString();
        if (this.size() < 1) {
            return retval;
        }
        Token first = this.elementAt(0);
        Object firstData = first.getData();
        if (firstData != null && firstData instanceof PhysicalColumn) {
            DataSource origds = first.m_tokenizer.m_dataSource;
            String origtokenizerInput = first.m_tokenizer.m_strInput;
            MessageHandler origMessages = first.m_tokenizer.m_messages;
            Tokenizer temp = new Tokenizer(origds, origtokenizerInput, origMessages);
            TokenList simpleTokenlist = temp.getSimpleTokens();
            int columnIndexInSimpleList = -1;
            for (int i = 0; i < simpleTokenlist.size(); ++i) {
                Token t = simpleTokenlist.elementAt(i);
                if (t.getStart() != first.getStart()) continue;
                columnIndexInSimpleList = i;
                break;
            }
            if (columnIndexInSimpleList >= 2 && simpleTokenlist.elementAt(columnIndexInSimpleList - 1).toString().equals(".")) {
                String qualifier = simpleTokenlist.elementAt(columnIndexInSimpleList - 2).toString();
                retval = qualifier + "." + retval;
            }
        }
        return retval;
    }

    public String getOriginalString() {
        return this.m_originalString;
    }

    public String getOriginalString(Token startToken, Token endToken) {
        return this.m_originalString.substring(startToken.getStart(), endToken.getEnd());
    }

    public int size() {
        return this.m_list.size();
    }

    public synchronized void addElement(Token object) {
        this.m_list.addElement(object);
    }

    public synchronized Token elementAt(int index) {
        return (Token)this.m_list.elementAt(index);
    }

    public final int indexOf(Token elem) {
        return this.m_list.indexOf(elem);
    }

    public final synchronized void removeAllElements() {
        this.m_list.removeAllElements();
    }

    public final boolean contains(Token elem) {
        return this.m_list.contains(elem);
    }

    public final int endOfCommaSeparatedClauseRespectingParens(int startingIndex) {
        int parenDepth = 0;
        for (int i = startingIndex; i < this.size(); ++i) {
            Token currentToken = this.elementAt(i);
            if (i == this.size() - 1) {
                return i;
            }
            if (currentToken.isType(13, 36)) {
                ++parenDepth;
                continue;
            }
            if (currentToken.isType(13, 37)) {
                --parenDepth;
                continue;
            }
            if (!currentToken.isType(13, 40) || parenDepth != 0) continue;
            return i - 1;
        }
        return -1;
    }

    public void insertElementAt(Token obj, int index) {
        this.m_list.insertElementAt(obj, index);
    }

    public final synchronized void removeElementAt(int index) {
        this.m_list.removeElementAt(index);
    }
}

