/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.parser;

import com.sas.query.parser.TokenConstants;
import com.sas.query.parser.Tokenizer;

public class Token
implements TokenConstants {
    protected int m_nStart;
    protected int m_nEnd;
    protected int m_tokenType;
    protected int m_tokenSubType;
    protected Object m_data;
    protected Tokenizer m_tokenizer;
    protected int m_parserData;
    private String m_me;
    private String m_mytype;
    private String m_mysubtype;

    public Token(Tokenizer tokenizer) {
        this.m_tokenizer = tokenizer;
        this.m_tokenType = 0;
        this.m_tokenSubType = 0;
        this.m_me = "";
        this.m_mytype = this.getTypeName();
        this.m_mysubtype = this.getSubTypeName();
    }

    public void fixupOriginalStringToBeThis(String newString) {
        if (this.toString().equals(newString)) {
            return;
        }
        char[] chars = this.m_tokenizer.m_strInput.toCharArray();
        int oldLength = this.m_nEnd - this.m_nStart;
        int newLength = newString.length();
        if (newLength <= oldLength) {
            int i;
            for (i = 0; i < newLength; ++i) {
                chars[i + this.m_nStart] = newString.charAt(i);
            }
            for (i = 0; i < oldLength - newLength; ++i) {
                chars[i + this.m_nStart + newLength] = 32;
                --this.m_nEnd;
            }
        }
        this.m_tokenizer.m_strInput = new String(chars);
    }

    public String toString() {
        return this.m_tokenizer.getInputString().substring(this.m_nStart, this.m_nEnd);
    }

    public String getUnquotedString() {
        int length;
        String retval = this.toString();
        if (this.isType(8)) {
            length = retval.length();
            retval = retval.substring(1, length - 1);
        }
        if (this.isType(1) && retval.charAt(0) == '\'' && retval.endsWith("'n")) {
            length = retval.length();
            retval = retval.substring(1, length - 2);
        }
        return retval;
    }

    public int getType() {
        return this.m_tokenType;
    }

    public void setType(int nType) {
        this.m_tokenType = nType;
        this.m_mytype = this.getTypeName();
    }

    public int getSubType() {
        return this.m_tokenSubType;
    }

    public void setSubType(int nSubType) {
        this.m_tokenSubType = nSubType;
        this.m_mysubtype = this.getSubTypeName();
    }

    public String getTypeName() {
        return TOKEN_TYPE_NAMES[this.m_tokenType];
    }

    public String getSubTypeName() {
        return TOKEN_TYPE_NAMES[this.m_tokenSubType];
    }

    public int getLength() {
        return this.m_nEnd - this.m_nStart + 1;
    }

    public int getStart() {
        return this.m_nStart;
    }

    public void setStart(int nStart) {
        this.m_nStart = nStart;
        this.m_me = this.getOriginalInput();
    }

    public int getEnd() {
        return this.m_nEnd;
    }

    public void setEnd(int nEnd) {
        this.m_nEnd = nEnd;
        this.m_me = this.getOriginalInput();
    }

    public Object getData() {
        return this.m_data;
    }

    public void setData(Object data) {
        this.m_data = data;
    }

    public int getParserData() {
        return this.m_parserData;
    }

    public void setParserData(int data) {
        this.m_parserData = data;
    }

    public boolean isType(int tokenType) {
        return this.m_tokenType == tokenType;
    }

    public boolean isType(int tokenType, int tokenSubType) {
        return this.m_tokenType == tokenType && this.m_tokenSubType == tokenSubType;
    }

    public boolean isKeyword(String keyword) {
        return this.isType(2) && this.toString().equalsIgnoreCase(keyword);
    }

    public boolean isOperator(String operatorName) {
        return this.isType(22) && this.toString().equalsIgnoreCase(operatorName);
    }

    public String getOriginalInput() {
        String ret = this.m_tokenizer.getInputString();
        ret = this.getStart() < 0 || this.getStart() > ret.length() || this.getEnd() < 0 || this.getEnd() > ret.length() || this.getStart() > this.getEnd() ? "token in transition" : ret.substring(this.getStart(), this.getEnd());
        return ret;
    }

    public boolean preceededByBlank() {
        if (this.getStart() < 1) {
            return false;
        }
        return this.m_tokenizer.getInputString().charAt(this.getStart() - 1) == ' ';
    }

    public char preceedingChar() {
        if (this.getStart() == 0) {
            return '\u0000';
        }
        return this.m_tokenizer.getInputString().charAt(this.getStart() - 1);
    }

    public char succeedingChar() {
        if (this.getEnd() >= this.m_tokenizer.getInputString().length() - 1) {
            return '\u0000';
        }
        return this.m_tokenizer.getInputString().charAt(this.getEnd());
    }

    public boolean followedByBlank() {
        if (this.getEnd() >= this.m_tokenizer.getInputString().length() - 1) {
            return false;
        }
        return this.m_tokenizer.getInputString().charAt(this.getEnd()) == ' ';
    }

    public boolean isDigitsOnly() {
        String str = this.getOriginalInput();
        char[] chars = str.toCharArray();
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isDigit(chars[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isFunctionName() {
        return this.toString().equalsIgnoreCase("IN");
    }
}

