/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.parser;

import com.sas.query.Query;
import com.sas.query.QueryUtils;
import com.sas.query.datasources.DataSource;
import com.sas.query.datasources.DataSourceTable;
import com.sas.query.datasources.Function;
import com.sas.query.datasources.FunctionConstants;
import com.sas.query.datasources.FunctionList;
import com.sas.query.datasources.Operator;
import com.sas.query.datasources.SqlProperties;
import com.sas.query.models.Column;
import com.sas.query.models.ColumnExpression;
import com.sas.query.models.CompoundExpression;
import com.sas.query.models.ConcatenatedExpression;
import com.sas.query.models.ConstantExpression;
import com.sas.query.models.DataItem;
import com.sas.query.models.Expression;
import com.sas.query.models.ExpressionConstants;
import com.sas.query.models.ExpressionList;
import com.sas.query.models.FilterNode;
import com.sas.query.models.FilterNodeWrapper;
import com.sas.query.models.FilterTree;
import com.sas.query.models.GroupItem;
import com.sas.query.models.Join;
import com.sas.query.models.JoinConstants;
import com.sas.query.models.JoinRelationship;
import com.sas.query.models.MessageHandler;
import com.sas.query.models.OrderItem;
import com.sas.query.models.ParenExpression;
import com.sas.query.models.QueryExpression;
import com.sas.query.models.ResultItem;
import com.sas.query.models.ResultItemList;
import com.sas.query.models.Table;
import com.sas.query.models.UnparsedExpression;
import com.sas.query.parser.ParserException;
import com.sas.query.parser.Token;
import com.sas.query.parser.TokenAndExpressionList;
import com.sas.query.parser.TokenConstants;
import com.sas.query.parser.TokenList;
import com.sas.query.parser.Tokenizer;
import com.sas.query.parser.TransientFromClauseToken;
import com.sas.query.visuals.QueryResource;
import java.util.Vector;

public class Parser
implements TokenConstants,
FunctionConstants,
ExpressionConstants,
JoinConstants {
    protected MessageHandler m_messages = new MessageHandler();
    protected DataSource m_dataSource;
    protected SqlProperties m_properties;
    protected Function m_andFunction;
    protected Function m_orFunction;
    protected static QueryResource bundle = new QueryResource(Parser.class);
    public static final int NO_PARSER_FLAGS = 0;
    public static final int NEGATION_FLAG = 1;
    public static final int BETWEEN_AND_FLAG = 2;
    public static final int extraJunkInUsingClause = 1;
    public static final int incompleteUsingClause = 2;
    public static final int extraJunkInUsingClauseExpectingLeftParen = 3;
    public static final int extraJunkInUsingClauseExpectingComma = 4;
    public static final int unbalancedParensInUsingClause = 5;
    public static final int badJoinTypeSpec = 6;
    public static final int dontHandleNaturalJoinsYet = 7;
    public static final int cantUseNaturalOnUnionJoin = 8;
    public static final int cantUseNaturalOnCrossJoin = 9;
    public static final int incompleteOnClause = 10;
    public static final int onClauseWithNoSearchExpression = 11;
    public static final int cantFindJoinForJustAddedTable = 12;
    public static final int cantFindColumnInTable = 13;
    public static final int unrecognizedTokenInFrom = 14;
    public static final int joinTreeNotSupported = 15;

    public Query parseQuery(DataSource dataSource, String strSQL, MessageHandler messages) {
        Query query = new Query(dataSource, this.m_messages);
        this.parseQuery(query, strSQL, messages);
        return query;
    }

    protected void _initParser(Query query, MessageHandler messages) {
        this.m_messages = messages;
        this.m_dataSource = query.getDataSource();
        this.m_properties = this.m_dataSource.getProperties();
        if (this.m_orFunction == null) {
            this.m_andFunction = this.m_dataSource.getProperties().getAllFunctions().getSubset("AND", 32768, 32768).elementAt(0);
            this.m_orFunction = this.m_dataSource.getProperties().getAllFunctions().getSubset("OR", 32768, 32768).elementAt(0);
        }
    }

    public void parseQuery(Query query, String strSQL, MessageHandler messages) {
        this._initParser(query, messages);
        Tokenizer tokenizer = new Tokenizer(this.m_dataSource, strSQL, messages);
        TokenList tokenList = tokenizer.getTokens();
        this._detectNonJoinTableExpression(tokenList);
        if (messages.failureHasOccurred()) {
            return;
        }
        TokenList selectList = new TokenList(strSQL);
        TokenList fromList = new TokenList(strSQL);
        TokenList whereList = new TokenList(strSQL);
        TokenList orderList = new TokenList(strSQL);
        TokenList groupList = new TokenList(strSQL);
        TokenList havingList = new TokenList(strSQL);
        this._splitQueryParts(tokenList, selectList, fromList, whereList, orderList, groupList, havingList);
        this.parseFromList(query, fromList);
        if (messages.failureHasOccurred()) {
            return;
        }
        Tokenizer.resolveColumns(selectList, query);
        Tokenizer.resolveColumns(whereList, query);
        Tokenizer.resolveColumns(orderList, query);
        Tokenizer.resolveColumns(groupList, query);
        Tokenizer.resolveColumns(havingList, query);
        this.parseSelectList(query, selectList);
        this.parseWhereList(query, whereList);
        this.parseOrderList(query, orderList);
        this.parseGroupList(query, groupList);
        this.parseHavingList(query, havingList);
    }

    protected void _detectNonJoinTableExpression(TokenList tokens) {
        for (int index = 1; index < tokens.size(); ++index) {
            Token pred;
            Token t = tokens.elementAt(index);
            if (!t.isKeyword("ALL") && !t.isKeyword("CORRESPONDING") && !t.isKeyword("SELECT") || !(pred = tokens.elementAt(index - 1)).isKeyword("UNION") && !pred.isKeyword("INTERSECT") && !pred.isKeyword("EXCEPT")) continue;
            this.m_messages.addError(bundle, "Messages.cantDoUnionsOrIntersectsYet.txt");
            return;
        }
    }

    public void parseHaving(Query query, String strHaving) {
        this._initParser(query, query.getMessageHandler());
        Tokenizer tokenizer = new Tokenizer(this.m_dataSource, strHaving, this.m_messages);
        TokenList havingList = tokenizer.getTokens();
        Tokenizer.resolveColumns(havingList, query);
        this.parseHavingList(query, havingList);
    }

    public void parseWhere(Query query, String strWhere) {
        this._initParser(query, query.getMessageHandler());
        Tokenizer tokenizer = new Tokenizer(this.m_dataSource, strWhere, this.m_messages);
        TokenList whereList = tokenizer.getTokens();
        Tokenizer.resolveColumns(whereList, query);
        this.parseWhereList(query, whereList);
    }

    protected void _splitQueryParts(TokenList tokenList, TokenList selectList, TokenList fromList, TokenList whereList, TokenList orderList, TokenList groupList, TokenList havingList) {
        int index = 0;
        while (index < tokenList.size()) {
            Token token;
            if ((token = tokenList.elementAt(index++)).isKeyword("SELECT")) {
                index = this._getTokensForClause(tokenList, selectList, ",FROM,WHERE,GROUP BY,HAVING,ORDER BY,", index);
                continue;
            }
            if (token.isKeyword("FROM")) {
                index = this._getTokensForClause(tokenList, fromList, ",WHERE,GROUP BY,HAVING,ORDER BY,", index);
                continue;
            }
            if (token.isKeyword("WHERE")) {
                index = this._getTokensForClause(tokenList, whereList, ",GROUP BY,HAVING,ORDER BY,", index);
                continue;
            }
            if (token.isKeyword("GROUP BY")) {
                index = this._getTokensForClause(tokenList, groupList, ",WHERE,HAVING,ORDER BY,", index);
                continue;
            }
            if (token.isKeyword("HAVING")) {
                index = this._getTokensForClause(tokenList, havingList, ",WHERE,GROUP BY,ORDER BY,", index);
                continue;
            }
            if (token.isKeyword("ORDER BY")) {
                index = this._getTokensForClause(tokenList, orderList, ",WHERE,HAVING,GROUP BY,", index);
                continue;
            }
            this.m_messages.addError(bundle.messageString("ExpectingClauseKeyword.fmt.txt", token));
            return;
        }
    }

    protected int _getTokensForClause(TokenList mainTokenList, TokenList clauseTokenList, String stopTokens, int index) {
        while (index < mainTokenList.size()) {
            Token token = mainTokenList.elementAt(index++);
            String strTest = "," + token.toString() + ",";
            if (stopTokens.indexOf(strTest = strTest.toUpperCase()) != -1) {
                --index;
                break;
            }
            clauseTokenList.addElement(token);
        }
        return index;
    }

    protected void parseSelectList(Query query, TokenList tokenList) {
        if (tokenList.size() == 0) {
            return;
        }
        boolean autoGroupState = query.autoGroup();
        query.setAutoGroup(false);
        query.setDuplicateRowsRule(1);
        if (tokenList.elementAt(0).isKeyword("DISTINCT")) {
            tokenList.removeElementAt(0);
            query.setDuplicateRowsRule(0);
        } else if (tokenList.elementAt(0).isKeyword("ALL")) {
            tokenList.removeElementAt(0);
            query.setDuplicateRowsRule(2);
        }
        this._parseAllSelectPieces(query, tokenList);
        query.setAutoGroup(autoGroupState);
    }

    private int _formatTokenCount(TokenList tokenList, int startIndex) {
        int cursor = startIndex;
        int count = 0;
        Token currentToken = tokenList.elementAt(cursor + count);
        if (!(currentToken.isType(0) || currentToken.isType(8) || currentToken.isType(21))) {
            return count;
        }
        if (currentToken.toString().equalsIgnoreCase("FORMAT") || currentToken.toString().equalsIgnoreCase("INFORMAT") || currentToken.toString().equalsIgnoreCase("LABEL") || currentToken.toString().equalsIgnoreCase("AS")) {
            return count;
        }
        if (++count + cursor == tokenList.size()) {
            return count;
        }
        currentToken = tokenList.elementAt(cursor + count);
        if (!currentToken.isType(13, 42)) {
            return count;
        }
        if (++count + cursor == tokenList.size()) {
            return count;
        }
        currentToken = tokenList.elementAt(cursor + count);
        if (!currentToken.isDigitsOnly()) {
            return count;
        }
        return ++count;
    }

    protected void _parseAllSelectPieces(Query query, TokenList tokenList) {
        Vector<TokenList> pieceTokenLists = new Vector<TokenList>();
        int startingIndex = 0;
        while (startingIndex < tokenList.size()) {
            int endingIndex = tokenList.endOfCommaSeparatedClauseRespectingParens(startingIndex);
            pieceTokenLists.addElement(new TokenList(tokenList, startingIndex, endingIndex, true));
            startingIndex = endingIndex + 2;
        }
        for (int index = 0; index < pieceTokenLists.size(); ++index) {
            TokenList piece = (TokenList)pieceTokenLists.elementAt(index);
            this._processOneSelectPiece(query, piece, tokenList, null);
        }
    }

    public void parseDataItem(Query query, DataItem dataItem, String strSql, MessageHandler messages) {
        Tokenizer tokenizer = new Tokenizer(query.getDataSource(), strSql, messages);
        TokenList tokenList = tokenizer.getTokens();
        this._processOneSelectPiece(query, tokenList, tokenList, dataItem);
    }

    protected void _processOneSelectPiece(Query query, TokenList resultItemTokenList, TokenList wholeSelectListSansDistinctAll, DataItem existingDataItem) {
        Token onlyToken;
        boolean dsSupportsFormats;
        int index = 0;
        Expression expression = null;
        String alias = null;
        String label = null;
        String format = null;
        String informat = null;
        ResultItem newResult = null;
        TokenList expressionTokenList = new TokenList(resultItemTokenList.getOriginalString());
        if (existingDataItem != null) {
            Tokenizer.resolveColumns(resultItemTokenList, query);
        }
        index = this._getTokensForClause(resultItemTokenList, expressionTokenList, ",AS,LABEL,FORMAT,INFORMAT,,,", index);
        boolean dsSupportsLabels = dsSupportsFormats = query.getDataSource().getProperties().supportsFormats();
        try {
            while (index < resultItemTokenList.size()) {
                int formatDefTokenCount;
                Token token;
                if ((token = resultItemTokenList.elementAt(index++)).isKeyword("AS")) {
                    if (((token = resultItemTokenList.elementAt(index++)).toString().equalsIgnoreCase("FORMAT") || token.toString().equalsIgnoreCase("INFORMAT") || token.toString().equalsIgnoreCase("LABEL") || token.toString().equalsIgnoreCase("AS")) && dsSupportsLabels) {
                        --index;
                        continue;
                    }
                    alias = token.getUnquotedString();
                    continue;
                }
                if (dsSupportsLabels && token.isKeyword("LABEL")) {
                    if (!(token = resultItemTokenList.elementAt(index++)).toString().equals("=")) {
                        --index;
                        continue;
                    }
                    if ((token = resultItemTokenList.elementAt(index++)).toString().equalsIgnoreCase("FORMAT") || token.toString().equalsIgnoreCase("INFORMAT") || token.toString().equalsIgnoreCase("LABEL") || token.toString().equalsIgnoreCase("AS")) {
                        --index;
                        continue;
                    }
                    label = token.getUnquotedString();
                    continue;
                }
                if (dsSupportsFormats && token.isKeyword("FORMAT")) {
                    if (!(token = resultItemTokenList.elementAt(index++)).toString().equals("=")) {
                        --index;
                        continue;
                    }
                    formatDefTokenCount = this._formatTokenCount(resultItemTokenList, index);
                    if (formatDefTokenCount < 1) continue;
                    TokenList formatList = new TokenList(resultItemTokenList, index, index + formatDefTokenCount - 1, true);
                    format = this._fixupFormatInformatName(query, formatList);
                    index += formatDefTokenCount;
                    continue;
                }
                if (dsSupportsFormats && token.isKeyword("INFORMAT")) {
                    if (!(token = resultItemTokenList.elementAt(index++)).toString().equals("=")) {
                        --index;
                        continue;
                    }
                    formatDefTokenCount = this._formatTokenCount(resultItemTokenList, index);
                    if (formatDefTokenCount < 1) continue;
                    TokenList informatList = new TokenList(resultItemTokenList, index, index + formatDefTokenCount - 1, true);
                    informat = this._fixupFormatInformatName(query, informatList);
                    index += formatDefTokenCount;
                    continue;
                }
                expressionTokenList.addElement(token);
            }
        }
        catch (Throwable token) {
            // empty catch block
        }
        expression = null;
        if (expressionTokenList.size() == 1 && (onlyToken = expressionTokenList.elementAt(0)).toString().equals("*")) {
            expression = new UnparsedExpression("*");
        }
        if (expression == null) {
            String expString = expressionTokenList.unresolvedToString();
            try {
                expression = this.parseExpression(query, expressionTokenList);
            }
            catch (ParserException pe) {
                expression = new UnparsedExpression(expString);
            }
        }
        if (existingDataItem == null) {
            newResult = query.addResultItem(expression);
        } else {
            newResult = existingDataItem.getResultItem();
            existingDataItem.setExpression(expression);
        }
        if (alias != null) {
            newResult.setAlias(alias);
        }
        if (label != null) {
            newResult.setLabel(label);
        }
        if (format != null) {
            newResult.setFormat(format);
        }
        if (informat != null) {
            newResult.setInformat(informat);
        }
    }

    protected String _fixupFormatInformatName(Query query, TokenList formatList) {
        String retVal = "";
        if (formatList.size() <= 0) {
            return retVal;
        }
        retVal = retVal + formatList.elementAt(0).getUnquotedString();
        if (formatList.elementAt(0).isType(8)) {
            query.getMessageHandler().addWarning(bundle.getString("formatNamesAreNotQuoted.txt"));
        }
        if (formatList.size() == 1) {
            if (retVal.charAt(retVal.length() - 1) != '.') {
                query.getMessageHandler().addWarning(bundle.getString("formatsEndInPeriod.txt"));
                return retVal + ".";
            }
            return retVal;
        }
        retVal = retVal + formatList.elementAt(1).getUnquotedString();
        if (formatList.size() > 2) {
            retVal = retVal + formatList.elementAt(2).getUnquotedString();
        }
        return retVal;
    }

    protected void parseFromList(Query query, TokenList tokenList) {
        Tokenizer.resolveDataSourceTables(tokenList, query, this.m_dataSource);
        this._collapseDataSourceTableOptions(query, tokenList);
        this._collapseUsingClauses(query, tokenList);
        this._collapseJoinTokens(query, tokenList);
        this._collapseOnClauses(query, tokenList);
        boolean previousAutoJoinState = query.isAutoJoinEnabled();
        query.enableAutoJoin(false);
        this._processAllFromPieces(query, tokenList);
        query.enableAutoJoin(previousAutoJoinState);
    }

    protected void _collapseDataSourceTableOptions(Query query, TokenList tokenList) {
        if (tokenList.size() < 1) {
            return;
        }
        for (int currentIndex = 0; currentIndex < tokenList.size() - 1; ++currentIndex) {
            Token currentToken = tokenList.elementAt(currentIndex);
            if (!currentToken.isType(1, 72)) continue;
            DataSourceTable table = (DataSourceTable)currentToken.getData();
            Token nextToken = tokenList.elementAt(currentIndex + 1);
            if (!nextToken.toString().equals("(")) continue;
            Token closeparen = (Token)nextToken.getData();
            String options = tokenList.getOriginalString().substring(nextToken.getEnd(), closeparen.getStart());
            table.setTableOptions(options);
            int leftindex = currentIndex + 1;
            int rightindex = tokenList.indexOf(closeparen);
            for (int i = leftindex; i <= rightindex; ++i) {
                tokenList.removeElementAt(leftindex);
            }
        }
    }

    protected void _processAllFromPieces(Query query, TokenList tokenList) {
        Vector<TokenList> pieceTokenLists = new Vector<TokenList>();
        int startingIndex = 0;
        while (startingIndex < tokenList.size()) {
            int endingIndex = tokenList.endOfCommaSeparatedClauseRespectingParens(startingIndex);
            pieceTokenLists.addElement(new TokenList(tokenList, startingIndex, endingIndex, true));
            startingIndex = endingIndex + 2;
        }
        for (int index = 0; index < pieceTokenLists.size(); ++index) {
            TokenList piece = (TokenList)pieceTokenLists.elementAt(index);
            this._processOneFromPiece(query, piece, tokenList);
        }
    }

    protected boolean _processJustAnAsClause(Query query, TokenList tokenList) {
        Table justAddedTable = null;
        if (tokenList.size() != 3) {
            return false;
        }
        Token token = tokenList.elementAt(0);
        if (token.isType(1, 72)) {
            DataSourceTable table = (DataSourceTable)token.getData();
            if (tokenList.elementAt(1).isKeyword("AS")) {
                token = tokenList.elementAt(2);
                String correlationName = token.getUnquotedString();
                justAddedTable = query.addTable(table);
                if (justAddedTable == null) {
                    return true;
                }
                justAddedTable.setCorrelationName(correlationName);
                Tokenizer.resolveTables(tokenList, query);
                Tokenizer.resolveColumns(tokenList, query);
                return true;
            }
            return false;
        }
        return false;
    }

    protected boolean _fromPieceDoesNotStartWithTable(Query query, TokenList tokenList) {
        Token token = tokenList.elementAt(0);
        return !token.isType(1, 72);
    }

    protected boolean _processSingleTableNameInPiece(Query query, TokenList tokenList) {
        Table justAddedTable = null;
        if (tokenList.size() > 1) {
            return false;
        }
        Token token = tokenList.elementAt(0);
        if (token.isType(1, 72)) {
            DataSourceTable table = (DataSourceTable)token.getData();
            justAddedTable = query.addTable(table);
            Tokenizer.resolveTables(tokenList, query);
            Tokenizer.resolveColumns(tokenList, query);
            return true;
        }
        return false;
    }

    protected void _processOneFromPiece(Query query, TokenList tokenList, TokenList completeFromClause) {
        try {
            if (this._processSingleTableNameInPiece(query, tokenList)) {
                return;
            }
            if (this._processJustAnAsClause(query, tokenList)) {
                return;
            }
            if (this._fromPieceDoesNotStartWithTable(query, tokenList)) {
                if (tokenList.size() >= 3 && tokenList.elementAt(0).isType(1, 73) && tokenList.elementAt(1).isType(13, 42)) {
                    String containerName = tokenList.elementAt(0).toString();
                    String nonTableName = tokenList.elementAt(2).toString();
                    this.m_messages.addError(bundle.messageString("tableTokenNotFoundInContainer.fmt.txt", containerName, nonTableName));
                } else if (tokenList.size() > 0) {
                    String nonTableName = tokenList.elementAt(0).toString();
                    this.m_messages.addError(bundle.messageString("unrecognizedTokenFoundInFromExpectingTable.fmt.txt", nonTableName));
                }
                return;
            }
            int currentPriority = 0;
            TransientFromClauseToken lastTableSeen = null;
            Vector<TransientFromClauseToken> parenLessList = new Vector<TransientFromClauseToken>();
            for (int index = 0; index < tokenList.size(); ++index) {
                Token token = tokenList.elementAt(index);
                TransientFromClauseToken tokenPlus = new TransientFromClauseToken(token);
                if (tokenPlus.isLeftParen()) {
                    ++currentPriority;
                    continue;
                }
                if (tokenPlus.isRightParen()) {
                    --currentPriority;
                    continue;
                }
                if (tokenPlus.isTable()) {
                    parenLessList.addElement(tokenPlus);
                    tokenPlus.setPriority(currentPriority);
                    lastTableSeen = tokenPlus;
                    continue;
                }
                if (tokenPlus.isAs()) {
                    token = tokenList.elementAt(++index);
                    lastTableSeen.setAlias(token.getUnquotedString());
                    continue;
                }
                if (tokenPlus.isJoin()) {
                    parenLessList.addElement(tokenPlus);
                    tokenPlus.setPriority(currentPriority);
                    continue;
                }
                if (tokenPlus.isJoinCondition()) {
                    parenLessList.addElement(tokenPlus);
                    tokenPlus.setPriority(currentPriority);
                    continue;
                }
                this.m_messages.addError(bundle.messageString("unrecognizedTokenFoundInFrom.fmt.txt", tokenPlus.toString()));
                return;
            }
            int maxPriority = -1;
            boolean maxPriorityHit = false;
            int startingTokenIndex = -1;
            for (int index = 0; index < parenLessList.size(); ++index) {
                TransientFromClauseToken tokenPlus = (TransientFromClauseToken)parenLessList.elementAt(index);
                if (!tokenPlus.isTable()) continue;
                if (tokenPlus.getPriority() > maxPriority && maxPriorityHit) {
                    this.addDefinedError(15);
                    return;
                }
                if (tokenPlus.getPriority() > maxPriority) {
                    maxPriority = tokenPlus.getPriority();
                    startingTokenIndex = index;
                    continue;
                }
                if (tokenPlus.getPriority() >= maxPriority) continue;
                maxPriorityHit = true;
            }
            TransientFromClauseToken currentTokenPlus = (TransientFromClauseToken)parenLessList.elementAt(startingTokenIndex);
            Table justAddedTable = currentTokenPlus.addToQuery(query, completeFromClause);
            Table previousTableInGroup = null;
            int processedStartIndex = startingTokenIndex;
            int processedEndIndex = startingTokenIndex;
            TransientFromClauseToken priorTable = null;
            TransientFromClauseToken priorJoin = null;
            TransientFromClauseToken priorJoinCondition = null;
            TransientFromClauseToken temp = null;
            int priorTableIndex = 0;
            TransientFromClauseToken nextTable = null;
            TransientFromClauseToken nextJoin = null;
            TransientFromClauseToken nextJoinCondition = null;
            int nextTableIndex = 0;
            while (processedStartIndex > 0 || processedEndIndex < parenLessList.size() - 1) {
                int subjectindex = processedStartIndex;
                if (subjectindex > 0) {
                    priorJoin = (TransientFromClauseToken)parenLessList.elementAt(--subjectindex);
                }
                if (subjectindex > 0) {
                    if ((temp = (TransientFromClauseToken)parenLessList.elementAt(--subjectindex)).isJoinCondition()) {
                        priorJoinCondition = temp;
                        if (subjectindex > 0 && (temp = (TransientFromClauseToken)parenLessList.elementAt(--subjectindex)).isTable()) {
                            priorTable = temp;
                            priorTableIndex = subjectindex;
                        }
                    } else {
                        priorTable = temp;
                        priorTableIndex = subjectindex;
                    }
                }
                TransientFromClauseToken nextToken = null;
                subjectindex = processedEndIndex;
                if (subjectindex < parenLessList.size() - 1) {
                    nextToken = (TransientFromClauseToken)parenLessList.elementAt(++subjectindex);
                }
                if (nextToken != null && nextToken.isJoinCondition()) {
                    priorJoinCondition = nextToken;
                    nextToken = ++subjectindex < parenLessList.size() - 1 ? (TransientFromClauseToken)parenLessList.elementAt(subjectindex) : null;
                }
                if (nextToken != null) {
                    if (nextToken.isJoin()) {
                        nextJoin = nextToken;
                    }
                    nextToken = ++subjectindex < parenLessList.size() - 1 ? (TransientFromClauseToken)parenLessList.elementAt(subjectindex) : null;
                }
                nextTable = nextToken;
                nextTableIndex = subjectindex;
                if (subjectindex < parenLessList.size() - 1) {
                    if ((nextToken = (TransientFromClauseToken)parenLessList.elementAt(++subjectindex)).isJoinCondition()) {
                        nextJoinCondition = nextToken;
                    }
                } else {
                    nextJoinCondition = null;
                }
                if (nextTable != null && priorTable != null) {
                    if (priorTable.getPriority() > nextTable.getPriority()) {
                        previousTableInGroup = justAddedTable;
                        justAddedTable = priorTable.addToQuery(query, completeFromClause);
                        processedStartIndex = priorTableIndex;
                        if (priorJoinCondition != null) {
                            ++processedEndIndex;
                            this._addJoinInfo(query, previousTableInGroup, justAddedTable, priorJoin.getToken(), priorJoinCondition.getToken(), true);
                            continue;
                        }
                        this._addJoinInfo(query, previousTableInGroup, justAddedTable, priorJoin.getToken(), null, true);
                        continue;
                    }
                    previousTableInGroup = justAddedTable;
                    justAddedTable = nextTable.addToQuery(query, completeFromClause);
                    processedEndIndex = nextTableIndex;
                    if (nextJoinCondition != null) {
                        ++processedEndIndex;
                        this._addJoinInfo(query, previousTableInGroup, justAddedTable, nextJoin.getToken(), nextJoinCondition.getToken(), false);
                        continue;
                    }
                    this._addJoinInfo(query, previousTableInGroup, justAddedTable, nextJoin.getToken(), null, false);
                    continue;
                }
                if (nextTable != null) {
                    previousTableInGroup = justAddedTable;
                    justAddedTable = nextTable.addToQuery(query, completeFromClause);
                    processedEndIndex = nextTableIndex;
                    if (nextJoinCondition != null) {
                        ++processedEndIndex;
                        this._addJoinInfo(query, previousTableInGroup, justAddedTable, nextJoin.getToken(), nextJoinCondition.getToken(), false);
                        continue;
                    }
                    this._addJoinInfo(query, previousTableInGroup, justAddedTable, nextJoin.getToken(), null, false);
                    continue;
                }
                if (priorTable == null) {
                    this.m_messages.addError(bundle.messageString("UnknownTableInFROM.fmt.txt", " "));
                    return;
                }
                previousTableInGroup = justAddedTable;
                justAddedTable = priorTable.addToQuery(query, completeFromClause);
                processedStartIndex = priorTableIndex;
                if (priorJoinCondition != null) {
                    ++processedEndIndex;
                    this._addJoinInfo(query, previousTableInGroup, justAddedTable, priorJoin.getToken(), priorJoinCondition.getToken(), true);
                    continue;
                }
                this._addJoinInfo(query, previousTableInGroup, justAddedTable, priorJoin.getToken(), null, true);
            }
        }
        catch (ParserException pExcept) {
            this.m_messages.addError(pExcept.toString());
        }
    }

    protected void _addJoinInfo(Query query, Table previousTableInGroup, Table justAddedTable, Token joinToken, Token joinCondition, boolean flipped) {
        Join justAddedJoin = query.getJoin(justAddedTable);
        if (justAddedJoin == null) {
            this.addDefinedError(12);
            return;
        }
        if (previousTableInGroup != null) {
            if (joinCondition == null) {
                return;
            }
            if (joinCondition.isKeyword("ON")) {
                Expression expression;
                TokenList onTokenList = (TokenList)joinCondition.getData();
                Tokenizer.resolveColumns(onTokenList, query);
                TokenAndExpressionList tAndEList = new TokenAndExpressionList(onTokenList);
                String onString = onTokenList.unresolvedToString();
                try {
                    expression = this.parseExpression(query, tAndEList);
                }
                catch (ParserException pe) {
                    expression = new UnparsedExpression(onString);
                }
                this.addOnJoinRel(query, previousTableInGroup, justAddedJoin.getTable(), expression);
            } else if (joinCondition.isKeyword("USING")) {
                Vector unqualifiedColumnNames = (Vector)joinCondition.getData();
                for (int index = 0; index < unqualifiedColumnNames.size(); ++index) {
                    Column col1 = previousTableInGroup.getColumn((String)unqualifiedColumnNames.elementAt(index));
                    Column col2 = justAddedTable.getColumn((String)unqualifiedColumnNames.elementAt(index));
                    if (col1 == null) {
                        this.addDefinedError(13);
                    }
                    if (col2 == null) {
                        this.addDefinedError(13);
                    }
                    JoinRelationship rel = new JoinRelationship(query, col1, col2);
                    query.addJoinRelationship(rel);
                }
            }
            int indicatedJoinType = (Integer)joinToken.getData();
            justAddedJoin.setJoinType(Join.calculateJoinType(indicatedJoinType, flipped));
        }
    }

    protected void addOnJoinRel(Query query, Table previousTable, Table justAddedTable, Expression expression) {
        if (expression instanceof ParenExpression) {
            expression = ((ParenExpression)expression).getExpression();
        }
        if (expression instanceof CompoundExpression) {
            CompoundExpression ce = (CompoundExpression)expression;
            Function fun = ce.getCurrentFunction();
            if (fun.getFunctionType() == 8 && fun.getName().equals("AND")) {
                Expression left = ce.getParameter(0);
                Expression right = ce.getParameter(1);
                this.addOnJoinRel(query, previousTable, justAddedTable, left);
                this.addOnJoinRel(query, previousTable, justAddedTable, right);
            } else {
                JoinRelationship rel = new JoinRelationship(query, previousTable, justAddedTable, 4, expression);
                query.addJoinRelationship(rel);
            }
        } else {
            JoinRelationship rel = new JoinRelationship(query, previousTable, justAddedTable, 4, expression);
            query.addJoinRelationship(rel);
        }
    }

    protected void _collapseJoinTokens(Query query, TokenList tokenList) {
        for (int index = 0; index < tokenList.size(); ++index) {
            if (!tokenList.elementAt(index).isKeyword("JOIN") || tokenList.elementAt(index).getParserData() != 0) continue;
            int joinIndex = index;
            Token joinToken = tokenList.elementAt(index);
            joinToken.setParserData(1);
            joinToken.setData(new Integer(0));
            int eatcount = 0;
            if (joinIndex + eatcount > 0) {
                Token pred = tokenList.elementAt(joinIndex + eatcount - 1);
                if (pred.isKeyword("OUTER")) {
                    if (joinIndex < eatcount + 2) {
                        this.addDefinedError(6);
                    }
                    pred = tokenList.elementAt(joinIndex - (++eatcount + 1));
                }
                if (pred.isType(2)) {
                    if (pred.isKeyword("FULL")) {
                        joinToken.setData(new Integer(3));
                        ++eatcount;
                    } else if (pred.isKeyword("LEFT")) {
                        joinToken.setData(new Integer(1));
                        ++eatcount;
                    } else if (pred.isKeyword("RIGHT")) {
                        joinToken.setData(new Integer(2));
                        ++eatcount;
                    } else if (pred.isKeyword("INNER")) {
                        ++eatcount;
                    } else if (pred.isKeyword("CROSS")) {
                        joinToken.setData(new Integer(4));
                        ++eatcount;
                    } else if (pred.isKeyword("UNION")) {
                        joinToken.setData(new Integer(5));
                        this.m_messages.addError(bundle, "unionNotHandled.txt");
                        ++eatcount;
                    }
                    if (joinIndex >= eatcount + 1) {
                        pred = tokenList.elementAt(joinIndex + eatcount - 1);
                    }
                    if (pred.isKeyword("NATURAL")) {
                        joinToken.setParserData(2);
                        this.m_messages.addError(bundle, "naturalNotHandled.txt");
                        ++eatcount;
                        Integer joinType = (Integer)joinToken.getData();
                        if (joinType == 4) {
                            this.addDefinedError(9);
                        }
                        if (joinType == 5) {
                            this.addDefinedError(8);
                        }
                        this.addDefinedError(7);
                    }
                }
            }
            for (int k = 0; k < eatcount; ++k) {
                tokenList.removeElementAt(joinIndex-- - 1);
            }
            this._collapseJoinTokens(query, tokenList);
        }
    }

    protected void _collapseUsingClauses(Query query, TokenList tokenList) {
        for (int index = 0; index < tokenList.size(); ++index) {
            if (!tokenList.elementAt(index).isKeyword("USING") || tokenList.elementAt(index).getData() != null) continue;
            int usingIndex = index;
            Token usingToken = tokenList.elementAt(index);
            TokenAndExpressionList tAndEList = new TokenAndExpressionList(tokenList);
            Vector<String> columnNames = new Vector<String>();
            usingToken.setData(columnNames);
            if (index + 1 == tokenList.size()) {
                this.addDefinedError(2);
                continue;
            }
            Token leftParen = tokenList.elementAt(++index);
            int leftParenIndex = index;
            if (leftParen.isType(13, 36)) {
                int endOfUsing = tAndEList.indexOfCorrespondingRightParen(index);
                if (endOfUsing < 0) {
                    this.addDefinedError(5);
                }
                for (int j = leftParenIndex + 1; j < endOfUsing; ++j) {
                    Token columnName = tokenList.elementAt(j);
                    columnNames.addElement(columnName.toString());
                    if (j >= endOfUsing - 2) continue;
                    ++j;
                    if (leftParen.isType(13, 40)) continue;
                    this.addDefinedError(4);
                }
                for (int k = usingIndex + 1; k <= endOfUsing; ++k) {
                    tokenList.removeElementAt(usingIndex + 1);
                }
                this._collapseUsingClauses(query, tokenList);
                continue;
            }
            this.addDefinedError(3);
        }
    }

    protected int findEndOfOnClauseTokenIndex(int onIndex, TokenList tokenList) {
        int retvalue = onIndex;
        TokenAndExpressionList parallelTandEList = new TokenAndExpressionList(tokenList);
        for (int index = onIndex + 1; index < tokenList.size(); ++index) {
            Token nextTok = tokenList.elementAt(index);
            if (nextTok.isType(13, 36)) {
                index = retvalue = parallelTandEList.indexOfCorrespondingRightParen(index);
                continue;
            }
            if (!this.tokenEndsOnClause(nextTok)) {
                ++retvalue;
                continue;
            }
            return retvalue;
        }
        return retvalue;
    }

    protected void _collapseOnClauses(Query query, TokenList tokenList) {
        for (int index = 0; index < tokenList.size(); ++index) {
            int kill;
            int endOfOnClause;
            if (!tokenList.elementAt(index).isKeyword("ON") || tokenList.elementAt(index).getData() != null) continue;
            int onIndex = index;
            Token onToken = tokenList.elementAt(index);
            TokenList onTokenList = tokenList.duplicate();
            onToken.setData(onTokenList);
            if (index + 1 == tokenList.size()) {
                this.addDefinedError(10);
            }
            if ((endOfOnClause = this.findEndOfOnClauseTokenIndex(onIndex, onTokenList)) == onIndex) {
                this.addDefinedError(11);
            }
            int originalListSize = onTokenList.size();
            for (kill = endOfOnClause + 1; kill < originalListSize; ++kill) {
                onTokenList.removeElementAt(endOfOnClause + 1);
            }
            for (kill = 0; kill <= onIndex; ++kill) {
                onTokenList.removeElementAt(0);
            }
            for (kill = onIndex + 1; kill <= endOfOnClause; ++kill) {
                tokenList.removeElementAt(onIndex + 1);
            }
            this._collapseOnClauses(query, tokenList);
        }
    }

    protected boolean tokenEndsOnClause(Token token) {
        if (token.isType(13, 40)) {
            return true;
        }
        if (token.isKeyword("JOIN")) {
            return true;
        }
        if (token.isKeyword("AS")) {
            return true;
        }
        return token.isType(13, 37);
    }

    protected void parseWhereList(Query query, TokenList tokenList) {
        Expression expression = null;
        if (tokenList.size() > 0) {
            String whereString = tokenList.unresolvedToString();
            try {
                expression = this.parseExpression(query, tokenList);
            }
            catch (ParserException pe) {
                expression = new UnparsedExpression(whereString);
            }
        }
        if (expression != null) {
            this.convertExpressionToFilterTree(query, expression, query.getWhereFilterTree());
        } else {
            query.getWhereFilterTree().setRoot(null);
        }
    }

    protected void convertExpressionToFilterTree(Query query, Expression totalExpression, FilterTree filterTree) {
        FilterNodeWrapper result = totalExpression.generateFilterNodes(query, this.m_andFunction, this.m_orFunction);
        FilterNode root = result.getHead();
        filterTree.setRoot(root);
        filterTree.optimize();
    }

    public Expression parseExpression(Query query, String string) {
        try {
            this._initParser(query, query.getMessageHandler());
            Tokenizer tokenizer = new Tokenizer(query.getDataSource(), string, query.getMessageHandler());
            TokenList phraseList = tokenizer.getTokens();
            Tokenizer.resolveColumns(phraseList, query);
            return this.parseExpression(query, phraseList);
        }
        catch (ParserException pe) {
            return new UnparsedExpression(string);
        }
    }

    public void reset() {
        this.m_messages = null;
        this.m_dataSource = null;
        this.m_properties = null;
    }

    protected Expression parseExpression(Query query, TokenList tokenList) throws ParserException {
        TokenAndExpressionList x = new TokenAndExpressionList(tokenList);
        return this.parseExpression(query, x);
    }

    protected Expression parseExpression(Query query, TokenAndExpressionList tAndElist) throws ParserException {
        if (tAndElist.hasSubquery()) {
            int subqueryIndex = tAndElist.indexOfNextSubquery();
            Token subqueryToken = (Token)tAndElist.elementAt(subqueryIndex);
            QueryExpression subquery = new QueryExpression((TokenList)subqueryToken.getData());
            tAndElist.replaceRange(subqueryIndex, subqueryIndex, subquery);
            return this.parseExpression(query, tAndElist);
        }
        if (tAndElist.hasCountStar()) {
            int CountStarIndex = tAndElist.indexOfNextCountStar();
            FunctionList funs = query.getDataSource().getProperties().getAllFunctions();
            Expression inner = (funs = funs.getSubsetByName("COUNT*")).size() == 1 ? new CompoundExpression(funs.elementAt(0), new ExpressionList()) : new UnparsedExpression("COUNT(*)");
            tAndElist.replaceRange(CountStarIndex, CountStarIndex + 3, inner);
            return this.parseExpression(query, tAndElist);
        }
        if (tAndElist.hasLeftParen()) {
            int left = tAndElist.indexOfNextLeftParen();
            int right = tAndElist.indexOfCorrespondingRightParen(left);
            if (right != -1) {
                String originalInputStringAll = tAndElist.getUnderlyingTokenList().getOriginalString();
                Token leftparenToken = (Token)tAndElist.elementAt(left);
                Token rightparenToken = (Token)tAndElist.elementAt(right);
                String originalTextIncludingParens = originalInputStringAll.substring(leftparenToken.getStart(), rightparenToken.getEnd());
                TokenAndExpressionList insides = new TokenAndExpressionList(tAndElist, left + 1, right - 1);
                Token predOfParens = null;
                if (left > 0 && tAndElist.elementAt(left - 1) instanceof Token) {
                    predOfParens = (Token)tAndElist.elementAt(left - 1);
                }
                if (predOfParens == null || !predOfParens.isType(21) && !predOfParens.toString().equalsIgnoreCase("NOT")) {
                    Expression inner = this.parseExpression(query, insides);
                    if (inner instanceof CompoundExpression || inner instanceof UnparsedExpression) {
                        inner = new ParenExpression(inner);
                    }
                    tAndElist.replaceRange(left, right, inner);
                    return this.parseExpression(query, tAndElist);
                }
                ConcatenatedExpression results = new ConcatenatedExpression();
                TokenList t = new TokenList(tAndElist.getUnderlyingTokenList().getOriginalString());
                for (int index = left + 1; index < right; ++index) {
                    Object current = tAndElist.elementAt(index);
                    if (index == left + 1 && current != null && current instanceof Token && ((Token)current).toString().trim().equalsIgnoreCase("DISTINCT")) {
                        String possibleNewFunctionName = predOfParens.toString().trim();
                        possibleNewFunctionName = possibleNewFunctionName + " DISTINCT";
                        FunctionList possiblefuns = query.getDataSource().getProperties().getAllFunctions();
                        if ((possiblefuns = possiblefuns.getSubsetByName(possibleNewFunctionName.toUpperCase())).size() > 0) {
                            predOfParens.setData(possiblefuns.elementAt(0));
                            continue;
                        }
                    }
                    if (current instanceof Expression) {
                        results.addExpression((Expression)current);
                        continue;
                    }
                    if (!(current instanceof Token)) continue;
                    Token token = (Token)current;
                    if (token.isType(13, 40)) {
                        Expression thisBunch;
                        String tString = t.toString();
                        try {
                            thisBunch = this.parseExpression(query, t);
                        }
                        catch (ParserException pe) {
                            thisBunch = new UnparsedExpression(tString);
                        }
                        t.removeAllElements();
                        results.addExpression(thisBunch);
                        continue;
                    }
                    int nextStop = tAndElist.indexOfNextCommaRespectingParens(index);
                    if (nextStop == -1) {
                        for (int sluff = index; sluff < right; ++sluff) {
                            Object guy = tAndElist.elementAt(sluff);
                            if (!(guy instanceof Token)) {
                                throw new ParserException("hit expression when evaluating parm, expected token");
                            }
                            t.addElement((Token)guy);
                        }
                        index = tAndElist.size();
                        continue;
                    }
                    for (int adder = index; adder < nextStop; ++adder) {
                        t.addElement((Token)tAndElist.elementAt(adder));
                    }
                    index = nextStop - 1;
                }
                if (t.size() > 0) {
                    Expression thisBunch = this.parseExpression(query, t);
                    t.removeAllElements();
                    results.addExpression(thisBunch);
                }
                ParenExpression paren = new ParenExpression(results);
                Expression negatedParenedExpression = null;
                if (predOfParens.toString().equalsIgnoreCase("NOT")) {
                    if (results.getExpressionCount() > 1) {
                        throw new ParserException(bundle.getString("multipleParmsinNOT.ex.txt"));
                    }
                    negatedParenedExpression = results.getExpression(0);
                    try {
                        negatedParenedExpression.toggleLogicalNegation(this.m_andFunction, this.m_orFunction);
                    }
                    catch (Throwable toss) {
                        negatedParenedExpression = new UnparsedExpression("NOT" + originalTextIncludingParens);
                    }
                    tAndElist.replaceRange(left - 1, right, negatedParenedExpression);
                } else {
                    tAndElist.replaceRange(left, right, paren);
                }
                return this.parseExpression(query, tAndElist);
            }
            throw new ParserException("mismatched parens!");
        }
        if (tAndElist.hasOR()) {
            Expression rightExpression;
            Expression leftExpression;
            int orIndex = tAndElist.indexOfNextOR();
            TokenAndExpressionList lhs = new TokenAndExpressionList(tAndElist, 0, orIndex - 1);
            String lhsString = lhs.unresolvedToString();
            TokenAndExpressionList rhs = new TokenAndExpressionList(tAndElist, orIndex + 1, tAndElist.size() - 1);
            String rhsString = rhs.unresolvedToString();
            try {
                leftExpression = this.parseExpression(query, lhs);
            }
            catch (ParserException pe) {
                leftExpression = new UnparsedExpression(lhsString);
            }
            try {
                rightExpression = this.parseExpression(query, rhs);
            }
            catch (ParserException pe) {
                rightExpression = new UnparsedExpression(rhsString);
            }
            ExpressionList parameters = new ExpressionList(2);
            parameters.addElement(leftExpression);
            parameters.addElement(rightExpression);
            CompoundExpression newCompound = new CompoundExpression(this.m_orFunction, parameters);
            return newCompound;
        }
        if (tAndElist.hasAND()) {
            Expression rightExpression;
            Expression leftExpression;
            int andIndex = tAndElist.indexOfNextAND();
            TokenAndExpressionList lhs = new TokenAndExpressionList(tAndElist, 0, andIndex - 1);
            TokenAndExpressionList rhs = new TokenAndExpressionList(tAndElist, andIndex + 1, tAndElist.size() - 1);
            String lhsString = lhs.unresolvedToString();
            String rhsString = rhs.unresolvedToString();
            try {
                leftExpression = this.parseExpression(query, lhs);
            }
            catch (ParserException pe) {
                leftExpression = new UnparsedExpression(lhsString);
            }
            try {
                rightExpression = this.parseExpression(query, rhs);
            }
            catch (ParserException pe) {
                rightExpression = new UnparsedExpression(rhsString);
            }
            ExpressionList parameters = new ExpressionList(2);
            parameters.addElement(leftExpression);
            parameters.addElement(rightExpression);
            CompoundExpression newCompound = new CompoundExpression(this.m_andFunction, parameters);
            return newCompound;
        }
        if (tAndElist.hasNOT()) {
            int notIndex = tAndElist.indexOfNextNOT();
            if (notIndex != 0) {
                // empty if block
            }
            TokenAndExpressionList negateThing = new TokenAndExpressionList(tAndElist, notIndex + 1, tAndElist.size() - 1);
            Expression negateExp = this.parseExpression(query, negateThing);
            String textOfThis = negateThing.toString();
            try {
                negateExp.toggleLogicalNegation(this.m_andFunction, this.m_orFunction);
                return negateExp;
            }
            catch (Throwable t) {
                if (textOfThis.toUpperCase().trim().equals("NULL")) {
                    if (notIndex >= 2 && tAndElist.elementAt(notIndex - 1).toString().trim().equalsIgnoreCase("IS")) {
                        TokenAndExpressionList isNotNullThing = new TokenAndExpressionList(tAndElist, 0, notIndex - 2);
                        try {
                            Expression isNotNullExp = this.parseExpression(query, isNotNullThing);
                            FunctionList funs = query.getDataSource().getProperties().getAllFunctions();
                            funs = funs.getSubsetByName("ISNULL");
                            CompoundExpression ce = null;
                            if (funs.size() != 1) {
                                throw new ParserException("Couldn't find IS NULL function");
                            }
                            ce = new CompoundExpression(funs.elementAt(0), isNotNullExp);
                            ce.toggleLogicalNegation(this.m_andFunction, this.m_orFunction);
                            return ce;
                        }
                        catch (Throwable isNotNullExp) {
                            // empty catch block
                        }
                    }
                    throw new ParserException("I do not understand NOT in this context");
                }
                return new UnparsedExpression("NOT(" + textOfThis + ")");
            }
        }
        if (tAndElist.hasEXISTS()) {
            int existsIndex = tAndElist.indexOfNextEXISTS();
            if (existsIndex != 0) {
                // empty if block
            }
            TokenAndExpressionList existsThing = new TokenAndExpressionList(tAndElist, existsIndex + 1, tAndElist.size() - 1);
            Expression existsExp = this.parseExpression(query, existsThing);
            FunctionList existsList = query.getDataSourceFunctions().getSubsetByName("EXISTS");
            if (existsList.size() != 1) {
                throw new ParserException("Exists function not found");
            }
            Function existsFunction = existsList.elementAt(0);
            CompoundExpression returnExpression = new CompoundExpression(existsFunction, existsExp);
            return returnExpression;
        }
        if (tAndElist.hasCONDITIONAL()) {
            int functionOffset = tAndElist.indexOfNextCONDITIONAL();
            TokenAndExpressionList lhs = new TokenAndExpressionList(tAndElist, 0, functionOffset - 1);
            Token functionToken = (Token)tAndElist.elementAt(functionOffset);
            Function function = (Function)functionToken.getData();
            Expression lhsEval = this.parseExpression(query, lhs);
            if (functionToken.toString().equalsIgnoreCase("LIKE")) {
                TokenAndExpressionList rhs = new TokenAndExpressionList(tAndElist, functionOffset + 1, tAndElist.size() - 1);
                Expression rhsEval = this.parseExpression(query, rhs);
                CompoundExpression retVal = new CompoundExpression(function, lhsEval, rhsEval);
                if (functionToken.getParserData() == 1) {
                    retVal.setLogicalNegation(true);
                }
                return retVal;
            }
            if (functionToken.toString().equalsIgnoreCase("CONTAINS")) {
                TokenAndExpressionList rhs = new TokenAndExpressionList(tAndElist, functionOffset + 1, tAndElist.size() - 1);
                Expression rhsEval = this.parseExpression(query, rhs);
                CompoundExpression retVal = new CompoundExpression(function, lhsEval, rhsEval);
                if (functionToken.getParserData() == 1) {
                    retVal.setLogicalNegation(true);
                }
                return retVal;
            }
            if (functionToken.toString().equalsIgnoreCase("BETWEEN")) {
                int betweensAndOffset = tAndElist.indexOfNextBETWEENAND();
                TokenAndExpressionList rhs1 = new TokenAndExpressionList(tAndElist, functionOffset + 1, betweensAndOffset - 1);
                TokenAndExpressionList rhs2 = new TokenAndExpressionList(tAndElist, betweensAndOffset + 1, tAndElist.size() - 1);
                Expression rhs1Eval = this.parseExpression(query, rhs1);
                Expression rhs2Eval = this.parseExpression(query, rhs2);
                ExpressionList e = new ExpressionList();
                e.addElement(lhsEval);
                e.addElement(rhs1Eval);
                e.addElement(rhs2Eval);
                CompoundExpression retVal = new CompoundExpression(function, e);
                if (functionToken.getParserData() == 1) {
                    retVal.setLogicalNegation(true);
                }
                return retVal;
            }
            if (functionToken.toString().equalsIgnoreCase("IN")) {
                ExpressionList e = new ExpressionList();
                e.addElement(lhsEval);
                Expression rhsOfIn = null;
                Object x = null;
                if (tAndElist.size() > functionOffset + 1) {
                    x = tAndElist.elementAt(functionOffset + 1);
                    if (x instanceof ParenExpression) {
                        rhsOfIn = (Expression)x;
                    }
                    if (x instanceof QueryExpression) {
                        rhsOfIn = (Expression)x;
                    }
                    if (x instanceof Token) {
                        throw new ParserException("missing paren list");
                    }
                } else {
                    throw new ParserException("missing param");
                }
                if (rhsOfIn instanceof ParenExpression) {
                    ParenExpression pe = (ParenExpression)tAndElist.elementAt(functionOffset + 1);
                    ConcatenatedExpression parms = (ConcatenatedExpression)pe.getExpression();
                    for (int index = 0; index < parms.getExpressionCount(); ++index) {
                        e.addElement(parms.getExpression(index));
                    }
                } else if (rhsOfIn instanceof QueryExpression) {
                    QueryExpression subquery = (QueryExpression)tAndElist.elementAt(functionOffset + 1);
                    e.addElement(subquery);
                } else {
                    throw new ParserException(bundle.getString("woParenExpOrSubquery.txt"));
                }
                CompoundExpression retVal = new CompoundExpression(function, e);
                if (functionToken.getParserData() == 1) {
                    retVal.setLogicalNegation(true);
                }
                return retVal;
            }
            if (function.getName().equalsIgnoreCase("ISNULL")) {
                CompoundExpression retVal = new CompoundExpression(function, lhsEval);
                if (functionToken.getParserData() == 1) {
                    retVal.setLogicalNegation(true);
                }
                return retVal;
            }
            throw new ParserException("unhandled conditional");
        }
        if (tAndElist.size() == 1) {
            Object onlyToken = tAndElist.elementAt(0);
            if (onlyToken instanceof Token) {
                TokenList justOneToken = new TokenList(tAndElist.getUnderlyingTokenList(), (Token)onlyToken, (Token)onlyToken, true);
                ConcatenatedExpression cce = this.parseSimpleExpression(justOneToken);
                return this.parseConcatenatedExpression(query, cce);
            }
            return (Expression)tAndElist.elementAt(0);
        }
        if (tAndElist.size() == 0) {
            return new UnparsedExpression(" ");
        }
        return this.parseTandE(tAndElist, query);
    }

    protected Expression parseTandE(TokenAndExpressionList tAndElist, Query query) throws ParserException {
        ConcatenatedExpression cce = new ConcatenatedExpression();
        TokenList piece = new TokenList(tAndElist.getUnderlyingTokenList().getOriginalString());
        for (int index = 0; index < tAndElist.size(); ++index) {
            Object o = tAndElist.elementAt(index);
            if (o instanceof Expression) {
                if (piece.size() > 0) {
                    ConcatenatedExpression partcce = this.parseSimpleExpression(piece);
                    piece.removeAllElements();
                    cce.addExpression(partcce);
                }
                cce.addExpression((Expression)o);
                continue;
            }
            piece.addElement((Token)o);
        }
        if (piece.size() > 0) {
            ConcatenatedExpression partcce = this.parseSimpleExpression(piece);
            piece.removeAllElements();
            cce.addExpression(partcce);
        }
        return this.parseConcatenatedExpression(query, cce);
    }

    protected ConcatenatedExpression parseSimpleExpression(TokenList tokenList) {
        if (tokenList.size() < 1) {
            return null;
        }
        ConcatenatedExpression concatExpression = new ConcatenatedExpression();
        for (int index = 0; index < tokenList.size(); ++index) {
            Token token = tokenList.elementAt(index);
            if (token.isType(1, 70)) {
                Column column = (Column)token.getData();
                concatExpression.addExpression(new ColumnExpression(column));
                continue;
            }
            if (token.isType(8)) {
                String constString = token.toString();
                ConstantExpression constExpression = new ConstantExpression(constString, 4, true);
                if (tokenList.size() > index + 1) {
                    Token nextOne = tokenList.elementAt(index + 1);
                    if (nextOne.toString().equalsIgnoreCase("T")) {
                        constExpression = new ConstantExpression(constString, 32);
                        ++index;
                    } else if (nextOne.toString().equalsIgnoreCase("D")) {
                        constExpression = new ConstantExpression(constString, 16);
                        ++index;
                    } else if (nextOne.toString().equalsIgnoreCase("DT")) {
                        constExpression = new ConstantExpression(constString, 64);
                        ++index;
                    }
                }
                concatExpression.addExpression(constExpression);
                continue;
            }
            if (token.isType(13, 51) && tokenList.size() > index + 2) {
                Token rightCurl = tokenList.elementAt(index + 3);
                Token dtType = tokenList.elementAt(index + 1);
                boolean goodDtType = false;
                if (dtType.toString().equalsIgnoreCase("TS")) {
                    goodDtType = true;
                }
                if (dtType.toString().equalsIgnoreCase("D")) {
                    goodDtType = true;
                }
                if (dtType.toString().equalsIgnoreCase("T")) {
                    goodDtType = true;
                }
                if (!rightCurl.isType(13, 52) || !goodDtType) {
                    UnparsedExpression newExpression = new UnparsedExpression(token.toString());
                    newExpression.setUserData(token);
                    concatExpression.addExpression(newExpression);
                    continue;
                }
                Token value = tokenList.elementAt(index + 2);
                String constString = QueryUtils.stripAndDouble(value.toString());
                ConstantExpression constExpression = dtType.toString().equalsIgnoreCase("TS") ? new ConstantExpression(constString, 64) : (dtType.toString().equalsIgnoreCase("D") ? new ConstantExpression(constString, 16) : new ConstantExpression(constString, 32));
                concatExpression.addExpression(constExpression);
                index += 3;
                continue;
            }
            String tokenString = token.getOriginalInput();
            UnparsedExpression newExpression = new UnparsedExpression(tokenString);
            newExpression.setUserData(token);
            concatExpression.addExpression(newExpression);
        }
        return concatExpression;
    }

    public Expression parseConcatenatedExpression(Query query, ConcatenatedExpression concatExpression) throws ParserException {
        CompoundExpression newCompound;
        Expression returnExpression = concatExpression;
        for (int index = 0; index < concatExpression.getExpressionCount(); ++index) {
            Expression shouldBeParenExp;
            Token token;
            Expression expression = concatExpression.getExpression(index);
            if (!(expression instanceof UnparsedExpression) || expression instanceof QueryExpression || !(token = (Token)((UnparsedExpression)expression).getUserData()).isType(21)) continue;
            Function function = (Function)token.getData();
            Token functionToken = token;
            if (function.getMaxParms() == 0) {
                newCompound = new CompoundExpression(function, (Expression)null);
                concatExpression.replaceExpression(index, newCompound);
                continue;
            }
            Vector templateParts = function.getFormatTokens(2);
            if ((shouldBeParenExp = concatExpression.getExpression(++index)) instanceof ParenExpression) {
                int i;
                ExpressionList parms = new ExpressionList();
                ParenExpression myparmsInParenExpression = (ParenExpression)shouldBeParenExp;
                ConcatenatedExpression myParmsinCCE = (ConcatenatedExpression)myparmsInParenExpression.getExpression();
                for (int i2 = 0; i2 < myParmsinCCE.getExpressionCount(); ++i2) {
                    parms.addElement(myParmsinCCE.getExpression(i2));
                }
                CompoundExpression newCompound2 = null;
                if (function.getMaxParms() >= parms.size() && function.getMinParms() <= parms.size()) {
                    newCompound2 = new CompoundExpression(function, parms);
                } else {
                    String desiredFunctionName = function.getName();
                    Function newFunction = query.getDataSourceFunction(0, desiredFunctionName, 0, 0, parms.size());
                    if (newFunction == null) {
                        throw new ParserException("error, given " + parms.size() + " parms, but function " + desiredFunctionName + " does not support that number");
                    }
                    newCompound2 = new CompoundExpression(newFunction, parms);
                    functionToken.setData(newFunction);
                }
                if (concatExpression.getExpressionCount() == 2) {
                    return newCompound2;
                }
                ConcatenatedExpression newce = new ConcatenatedExpression();
                for (i = 0; i < index - 1; ++i) {
                    newce.addExpression(concatExpression.getExpression(i));
                }
                newce.addExpression(newCompound2);
                for (i = index + 1; i < concatExpression.getExpressionCount(); ++i) {
                    newce.addExpression(concatExpression.getExpression(i));
                }
                return this.parseConcatenatedExpression(query, newce);
            }
            --index;
        }
        Operator operator = null;
        int operatorIndex = 0;
        for (int index = 0; index < concatExpression.getExpressionCount(); ++index) {
            Token token;
            Expression expression = concatExpression.getExpression(index);
            if (!(expression instanceof UnparsedExpression) || expression instanceof QueryExpression || !(token = (Token)((UnparsedExpression)expression).getUserData()).isType(22) || operator != null && ((Operator)token.getData()).getPrecedence() >= operator.getPrecedence()) continue;
            operator = (Operator)token.getData();
            operatorIndex = index;
        }
        if (operator != null) {
            ConcatenatedExpression leftExpression = new ConcatenatedExpression();
            for (int index = 0; index < operatorIndex; ++index) {
                leftExpression.addExpression(concatExpression.getExpression(index));
            }
            ConcatenatedExpression rightExpression = new ConcatenatedExpression();
            for (int index = operatorIndex + 1; index < concatExpression.getExpressionCount(); ++index) {
                rightExpression.addExpression(concatExpression.getExpression(index));
            }
            ExpressionList parameters = new ExpressionList(2);
            parameters.addElement(this.parseConcatenatedExpression(query, leftExpression));
            parameters.addElement(this.parseConcatenatedExpression(query, rightExpression));
            newCompound = new CompoundExpression((Function)operator, parameters);
            returnExpression = newCompound;
        }
        if (returnExpression instanceof ConcatenatedExpression) {
            if ((returnExpression = returnExpression.getSimplestExpression()) == null) {
                throw new ParserException("concatexp null...probable missing parm to operator (unary negation?)");
            }
            if (returnExpression instanceof ConcatenatedExpression) {
                throw new ParserException("Simplified expression still concatenated");
            }
        }
        return returnExpression;
    }

    protected void parseOrderList(Query query, TokenList tokenList) {
        if (tokenList.size() < 1) {
            return;
        }
        int index = 0;
        while (index < tokenList.size()) {
            int i;
            Expression expression = null;
            OrderItem newItem = null;
            int sortDirection = 0;
            TokenList expressionTokenList = new TokenList(tokenList.getOriginalString());
            TokenAndExpressionList tandE = new TokenAndExpressionList(tokenList);
            int nextComma = tandE.indexOfNextCommaRespectingParens(index);
            if (nextComma == -1) {
                for (i = index; i < tokenList.size(); ++i) {
                    expressionTokenList.addElement(tokenList.elementAt(i));
                }
                index = tokenList.size();
            } else {
                for (i = index; i < nextComma; ++i) {
                    expressionTokenList.addElement(tokenList.elementAt(i));
                }
                index = nextComma + 1;
            }
            if (expressionTokenList.size() < 1) {
                return;
            }
            Token lastToken = expressionTokenList.elementAt(expressionTokenList.size() - 1);
            if (lastToken.isKeyword("ASC")) {
                sortDirection = 1;
                expressionTokenList.removeElementAt(expressionTokenList.size() - 1);
            } else if (lastToken.isKeyword("DESC")) {
                sortDirection = 2;
                expressionTokenList.removeElementAt(expressionTokenList.size() - 1);
            }
            String expString = expressionTokenList.unresolvedToString();
            try {
                expression = this.parseExpression(query, expressionTokenList);
            }
            catch (ParserException pe) {
                expression = new UnparsedExpression(expString);
            }
            ResultItem resultItem = null;
            ResultItemList itemList = query.getResultItems();
            for (int resultIndex = 0; resultIndex < itemList.size(); ++resultIndex) {
                if (!itemList.elementAt(resultIndex).getExpression().equivalentTo(query, expression)) continue;
                resultItem = itemList.elementAt(resultIndex);
                break;
            }
            if (resultItem == null) {
                String tmpstr = new String(expression.toString());
                boolean casecompare = false;
                if (tmpstr.indexOf(34) == 0 && tmpstr.lastIndexOf(34) == tmpstr.length() - 1) {
                    casecompare = true;
                    tmpstr = tmpstr.substring(1, tmpstr.length() - 1);
                }
                for (int resultIndex = 0; resultIndex < itemList.size(); ++resultIndex) {
                    if (itemList.elementAt(resultIndex).getAlias() == null) continue;
                    if (casecompare) {
                        if (!itemList.elementAt(resultIndex).getAlias().equals(tmpstr)) continue;
                        resultItem = itemList.elementAt(resultIndex);
                        break;
                    }
                    if (!itemList.elementAt(resultIndex).getAlias().equalsIgnoreCase(tmpstr)) continue;
                    resultItem = itemList.elementAt(resultIndex);
                    break;
                }
            }
            if (resultItem != null) {
                newItem = new OrderItem(resultItem);
            } else {
                if (!this.m_properties.supportsOrderByUnrelated()) {
                    this.m_messages.addError(bundle.messageString("NoUnrelatedOrderBy.fmt.txt", expression));
                }
                newItem = new OrderItem(query, expression);
            }
            newItem.setSortingDirection(sortDirection);
            query.addOrderItem(newItem);
        }
    }

    protected void parseGroupList(Query query, TokenList tokenList) {
        if (tokenList.size() < 1) {
            return;
        }
        int index = 0;
        while (index < tokenList.size()) {
            int i;
            Expression expression = null;
            GroupItem newItem = null;
            TokenList expressionTokenList = new TokenList(tokenList.getOriginalString());
            TokenAndExpressionList tandE = new TokenAndExpressionList(tokenList);
            int nextComma = tandE.indexOfNextCommaRespectingParens(index);
            if (nextComma == -1) {
                for (i = index; i < tokenList.size(); ++i) {
                    expressionTokenList.addElement(tokenList.elementAt(i));
                }
                index = tokenList.size();
            } else {
                for (i = index; i < nextComma; ++i) {
                    expressionTokenList.addElement(tokenList.elementAt(i));
                }
                index = nextComma + 1;
            }
            if (expressionTokenList.size() < 1) {
                return;
            }
            String expString = expressionTokenList.unresolvedToString();
            try {
                expression = this.parseExpression(query, expressionTokenList);
            }
            catch (ParserException pe) {
                expression = new UnparsedExpression(expString);
            }
            ResultItem resultItem = null;
            ResultItemList itemList = query.getResultItems();
            for (int resultIndex = 0; resultIndex < itemList.size(); ++resultIndex) {
                if (!itemList.elementAt(resultIndex).getExpression().equivalentTo(query, expression)) continue;
                resultItem = itemList.elementAt(resultIndex);
                break;
            }
            if (resultItem == null) {
                String tmpstr = new String(expression.toString());
                boolean casecompare = false;
                if (tmpstr.indexOf(34) == 0 && tmpstr.lastIndexOf(34) == tmpstr.length() - 1) {
                    casecompare = true;
                    tmpstr = tmpstr.substring(1, tmpstr.length() - 1);
                }
                for (int resultIndex = 0; resultIndex < itemList.size(); ++resultIndex) {
                    if (itemList.elementAt(resultIndex).getAlias() == null) continue;
                    if (casecompare) {
                        if (!itemList.elementAt(resultIndex).getAlias().equals(tmpstr)) continue;
                        resultItem = itemList.elementAt(resultIndex);
                        break;
                    }
                    if (!itemList.elementAt(resultIndex).getAlias().equalsIgnoreCase(tmpstr)) continue;
                    resultItem = itemList.elementAt(resultIndex);
                    break;
                }
            }
            if (resultItem != null) {
                newItem = new GroupItem(resultItem);
            } else {
                if (!this.m_properties.supportsGroupByUnrelated()) {
                    this.m_messages.addError(bundle.messageString("NoUnrelatedGroupBy.fmt.txt", expression));
                }
                newItem = new GroupItem(query, expression);
            }
            query.addGroupItem(newItem);
        }
    }

    protected void parseHavingList(Query query, TokenList tokenList) {
        Expression expression = null;
        if (tokenList.size() > 0) {
            String havingString = tokenList.unresolvedToString();
            try {
                expression = this.parseExpression(query, tokenList);
            }
            catch (ParserException pe) {
                expression = new UnparsedExpression(havingString);
            }
        }
        if (expression != null) {
            this.convertExpressionToFilterTree(query, expression, query.getHavingFilterTree());
        } else {
            query.getHavingFilterTree().setRoot(null);
        }
    }

    protected void addDefinedError(int errorno) {
        switch (errorno) {
            case 1: {
                this.m_messages.addError(bundle, "Messages.extraJunkInUsingClause.txt");
                break;
            }
            case 2: {
                this.m_messages.addError(bundle, "Messages.incompleteUsingClause.txt");
                break;
            }
            case 3: {
                this.m_messages.addError(bundle, "Messages.extraJunkInUsingClauseExpectingLeftParen.txt");
                break;
            }
            case 4: {
                this.m_messages.addError(bundle, "Messages.extraJunkInUsingClauseExpectingComma.txt");
                break;
            }
            case 5: {
                this.m_messages.addError(bundle, "Messages.unbalancedParensInUsingClause.txt");
                break;
            }
            case 6: {
                this.m_messages.addError(bundle, "Messages.badJoinTypeSpec.txt");
                break;
            }
            case 7: {
                this.m_messages.addError(bundle, "Messages.dontHandleNaturalJoinsYet.txt");
                break;
            }
            case 8: {
                this.m_messages.addError(bundle, "Messages.cantUseNaturalOnUnionJoin.txt");
                break;
            }
            case 9: {
                this.m_messages.addError(bundle, "Messages.cantUseNaturalOnCrossJoin.txt");
                break;
            }
            case 10: {
                this.m_messages.addError(bundle, "Messages.incompleteOnClause.txt");
                break;
            }
            case 11: {
                this.m_messages.addError(bundle, "Messages.onClauseWithNoSearchExpression.txt");
                break;
            }
            case 12: {
                this.m_messages.addError(bundle, "Messages.cantFindJoinForJustAddedTable.txt");
                break;
            }
            case 13: {
                this.m_messages.addError(bundle, "Messages.cantFindColumnInTable.txt");
                break;
            }
            case 14: {
                this.m_messages.addError(bundle, "Messages.unrecognizedTokenInFrom.txt");
                break;
            }
            case 15: {
                this.m_messages.addError(bundle, "Messages.joinTreeNotSupported.txt");
            }
        }
    }
}

