/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.models;

import com.sas.query.models.Comparison;
import com.sas.query.models.StringIgnoreCaseComparison;
import java.util.Vector;
import javax.swing.DefaultListModel;

public class VectorSort {
    public static final int ASCENDING = 1;
    public static final int DESCENDING = 2;

    public static void sort(Vector myVec) {
        VectorSort.sort(myVec, 1);
    }

    public static void sort(Vector myVec, int orderType) {
        VectorSort.sort(myVec, new StringIgnoreCaseComparison(), orderType);
    }

    public static void sort(Vector myVec, Comparison comparisonType, int orderType) {
        VectorSort.quickSort(myVec, 0, myVec.size() - 1, comparisonType, orderType);
    }

    public static void sort(DefaultListModel listModel) {
        int index;
        Vector localVector = new Vector(listModel.size());
        for (index = 0; index < listModel.size(); ++index) {
            localVector.addElement(listModel.elementAt(index));
        }
        VectorSort.sort(localVector, 1);
        listModel.removeAllElements();
        for (index = 0; index < localVector.size(); ++index) {
            listModel.addElement(localVector.elementAt(index));
        }
    }

    protected static void quickSort(Vector myVec, int left, int right, Comparison comparisonType, int orderType) {
        if (left < right) {
            int pivot = VectorSort.Pivot(myVec, left, right, comparisonType, orderType);
            VectorSort.quickSort(myVec, left, pivot - 1, comparisonType, orderType);
            VectorSort.quickSort(myVec, pivot + 1, right, comparisonType, orderType);
        }
    }

    protected static int Pivot(Vector myVec, int left, int right, Comparison comparisonType, int orderType) {
        int j = left;
        Object elementAtPivot = myVec.elementAt(left);
        for (int i = left + 1; i <= right; ++i) {
            if (orderType == 1) {
                if (comparisonType.compare(myVec.elementAt(i), elementAtPivot) > 0) continue;
                VectorSort.swap(myVec, i, ++j);
                continue;
            }
            if (comparisonType.compare(myVec.elementAt(i), elementAtPivot) < 0) continue;
            VectorSort.swap(myVec, i, ++j);
        }
        VectorSort.swap(myVec, j, left);
        return j;
    }

    protected static void swap(Vector v, int index1, int index2) {
        v.addElement(new Integer(0));
        int tempIndex = v.size() - 1;
        v.setElementAt(v.elementAt(index1), tempIndex);
        v.setElementAt(v.elementAt(index2), index1);
        v.setElementAt(v.elementAt(tempIndex), index2);
        v.removeElementAt(tempIndex);
    }
}

