/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.models;

import com.sas.query.datasources.SqlLogic;
import com.sas.query.models.Expression;
import com.sas.query.parser.Token;
import com.sas.query.parser.TokenConstants;

public class UnparsedExpression
extends Expression
implements TokenConstants {
    protected Object m_userData;
    protected String m_strUnparsedValue = null;

    public UnparsedExpression() {
    }

    public UnparsedExpression(String strExpression) {
        this.m_strUnparsedValue = strExpression;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new UnparsedExpression(this);
    }

    public UnparsedExpression(UnparsedExpression guyToCopy) {
        super(guyToCopy);
        this.m_strUnparsedValue = new String(guyToCopy.m_strUnparsedValue);
        this.m_userData = guyToCopy.m_userData;
    }

    @Override
    public String toString() {
        return this.m_strUnparsedValue;
    }

    @Override
    public boolean isParsed() {
        return false;
    }

    @Override
    public String generateSQL(SqlLogic sqlLogic, int declareOrReference) {
        String alias;
        String retString = this.toString();
        if (declareOrReference == 2 && (alias = this.getAlias(sqlLogic)) != null) {
            retString = alias;
            String prodname = sqlLogic.getQuery().getDataSource().getDatabaseProductName();
            if (prodname.equals("Sas")) {
                retString = "CALCULATED " + retString;
            }
        }
        return retString;
    }

    public boolean merge(UnparsedExpression guyToMergeIn) {
        if (this.getUserData() == null) {
            return false;
        }
        if (guyToMergeIn.getUserData() == null) {
            return false;
        }
        Object mydata = this.getUserData();
        if (!(mydata instanceof Token)) {
            return false;
        }
        Token underlyingT1 = (Token)this.getUserData();
        Object guyData = guyToMergeIn.getUserData();
        if (!(guyData instanceof Token)) {
            return false;
        }
        Token underlyingT2 = (Token)guyToMergeIn.getUserData();
        if (underlyingT1.getEnd() != underlyingT2.getStart()) {
            return false;
        }
        underlyingT1.setEnd(underlyingT2.getEnd());
        this.m_strUnparsedValue = this.m_strUnparsedValue + guyToMergeIn.m_strUnparsedValue;
        return true;
    }

    public void setValue(String value) {
        this.m_strUnparsedValue = value;
        this.m_dataType = 0;
    }

    public void setValue(String value, int dataType) {
        this.m_strUnparsedValue = value;
        this.m_dataType = dataType;
    }

    public void setUserData(Object data) {
        this.m_userData = data;
    }

    public Object getUserData() {
        return this.m_userData;
    }
}

