/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.models;

import com.sas.query.models.ResultItem;
import com.sas.query.models.SimpleModel;
import java.util.Hashtable;
import java.util.Vector;

public class ResultItemList
extends SimpleModel {
    static final long serialVersionUID = 8334942419673005007L;
    protected Vector m_list;

    public ResultItemList() {
        this.m_list = new Vector();
    }

    public ResultItemList(int initialSize) {
        this.m_list = new Vector(initialSize);
    }

    public int size() {
        return this.m_list.size();
    }

    public synchronized void add(ResultItemList newList) {
        if (newList == null) {
            return;
        }
        for (int index = 0; index < newList.size(); ++index) {
            this.addElement(newList.elementAt(index));
        }
    }

    public synchronized void addElement(ResultItem object) {
        this.m_list.addElement(object);
    }

    public synchronized ResultItem elementAt(int index) {
        return (ResultItem)this.m_list.elementAt(index);
    }

    public final synchronized void insertElementAt(ResultItem object, int index) {
        this.m_list.insertElementAt(object, index);
    }

    public final int indexOf(ResultItem elem) {
        return this.m_list.indexOf(elem);
    }

    public final synchronized void removeAllElements() {
        this.m_list.removeAllElements();
    }

    public final boolean contains(ResultItem elem) {
        return this.m_list.contains(elem);
    }

    public final synchronized void removeElementAt(int index) {
        this.m_list.removeElementAt(index);
    }

    public Hashtable getAliasTable() {
        int lsize = this.m_list.size();
        Hashtable<String, ResultItem> aliasTable = new Hashtable<String, ResultItem>(lsize);
        for (int i = 0; i < lsize; ++i) {
            ResultItem resItem = (ResultItem)this.m_list.elementAt(i);
            String alias = resItem.getDisplayName();
            if (alias == null) continue;
            aliasTable.put(alias.toUpperCase(), resItem);
        }
        return aliasTable;
    }
}

