/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.models;

import com.sas.query.Query;
import com.sas.query.models.ColumnExpression;
import com.sas.query.models.Expression;
import com.sas.query.models.ResultItemList;
import com.sas.query.models.StandardModel;
import com.sas.query.visuals.QueryResource;
import java.util.Hashtable;

public class ResultItem
extends StandardModel {
    static final long serialVersionUID = 3894258352818606685L;
    static QueryResource bundle = new QueryResource(ResultItem.class);
    public static final String ExpressionProperty = "expression";
    public static final String AliasProperty = "alias";
    public static final String LabelProperty = "label";
    public static final String FormatProperty = "format";
    public static final String InformatProperty = "informat";
    protected String m_strAlias;
    protected String m_strLabel;
    protected String m_strFormat;
    protected String m_strInformat;
    protected Expression m_expression;

    public ResultItem(Query query, Expression expression) {
        this(query, expression, null);
    }

    public ResultItem(Query query, Expression expression, String strAlias) {
        super(query);
        this.m_expression = expression;
        this.m_strAlias = strAlias;
    }

    public Expression getExpression() {
        return this.m_expression;
    }

    public void setExpression(Expression expression) {
        if (this.m_expression == expression) {
            return;
        }
        Expression oldExpression = this.m_expression;
        this.m_expression = expression;
        this.queueDataChange(4, ExpressionProperty, oldExpression);
    }

    public String getAlias() {
        return this.m_strAlias;
    }

    public String getAliasString() {
        if (this.m_strAlias == null) {
            return "";
        }
        return this.m_strAlias;
    }

    public void setAlias(String strAlias) {
        ResultItem dupItem;
        boolean isError = false;
        String oldStrAlias = this.m_strAlias;
        if (strAlias != null && strAlias.length() > this.getSqlProperties().getMaxColumnNameLength()) {
            this.addError(bundle.messageString("Message.Query.ExceedMaxNameLen.fmt.txt", new Integer(this.getSqlProperties().getMaxColumnNameLength())));
            isError = true;
        }
        ResultItemList resList = this.m_query.getResultItems();
        Hashtable aTable = resList.getAliasTable();
        if (strAlias != null && aTable.containsKey(strAlias.toUpperCase()) && (dupItem = (ResultItem)aTable.get(strAlias.toUpperCase())) != this) {
            String iname = dupItem.getExpression().getDisplayString();
            String errmsg = bundle.messageString("Message.ResultItem.DuplicateAlias.fmt.txt", strAlias, iname);
            this.addError(errmsg);
            isError = true;
        }
        if (!isError && !this.getSqlLogic().identifierEquals(oldStrAlias, strAlias)) {
            this.m_strAlias = strAlias;
            this.queueDataChange(4, AliasProperty, oldStrAlias);
        }
    }

    public String getLabel() {
        return this.m_strLabel;
    }

    public void setLabel(String strLabel) {
        String oldStrLabel = this.m_strLabel;
        this.m_strLabel = strLabel;
        this.queueDataChange(4, LabelProperty, oldStrLabel);
    }

    public String getFormat() {
        return this.m_strFormat;
    }

    public void setFormat(String strFormat) {
        String oldStrFormat = this.m_strFormat;
        this.m_strFormat = strFormat;
        this.queueDataChange(4, FormatProperty, oldStrFormat);
    }

    public String getInformat() {
        return this.m_strInformat;
    }

    public void setInformat(String strInformat) {
        String oldStrInformat = this.m_strInformat;
        this.m_strInformat = strInformat;
        this.queueDataChange(4, InformatProperty, oldStrInformat);
    }

    public String toString() {
        return this.getDisplayString();
    }

    public String getDisplayString() {
        if (this.m_strAlias != null) {
            return this.m_strAlias;
        }
        return this.m_expression.getDisplayString();
    }

    public String getDisplayName() {
        if (this.m_strAlias != null) {
            return this.m_strAlias;
        }
        if (this.m_expression instanceof ColumnExpression) {
            return ((ColumnExpression)this.m_expression).getColumn().getName();
        }
        return null;
    }
}

