/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.models;

import com.sas.collection.OrderedCollection;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.models.Node;
import com.sas.models.NodeInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.models.TreeInterface;
import com.sas.query.QueryException;
import com.sas.query.models.ColumnList;
import com.sas.query.models.ReferableTreeColumn;
import com.sas.query.models.Table;
import com.sas.query.visuals.QueryResource;

public class ReferableTreeTable
implements TreeInterface,
NodeInterface {
    protected Table m_table;
    protected OrderedCollection m_columnCollection;
    protected boolean m_fColumnsReadYet = false;
    protected static QueryResource bundle = new QueryResource(ReferableTreeTable.class);

    public ReferableTreeTable(Table table) {
        this.m_table = table;
    }

    public OrderedCollection getColumnCollection() {
        if (!this.m_fColumnsReadYet) {
            this._readColumnInfo();
        }
        return this.m_columnCollection;
    }

    protected void _readColumnInfo() {
        this.m_fColumnsReadYet = true;
        this.m_columnCollection = new OrderedCollection();
        ColumnList columnList = this.m_table.getColumns();
        int cColumns = columnList.size();
        for (int columnIndex = 0; columnIndex < cColumns; ++columnIndex) {
            ReferableTreeColumn column = new ReferableTreeColumn(this, columnList.elementAt(columnIndex));
            this.m_columnCollection.add((Object)column);
        }
    }

    public Table getMetadataSource() {
        return this.m_table;
    }

    public int getColumnIndexByName(String columnName) throws QueryException {
        for (int index = 0; index < this.getColumnCollection().count(); ++index) {
            ReferableTreeColumn column = (ReferableTreeColumn)this.getColumnCollection().get(index);
            if (!columnName.equals(column.getText())) continue;
            return index;
        }
        throw new QueryException(bundle.messageString("Exception.Metadata.Table.UnknownColumn.fmt.txt", columnName, this.getText()));
    }

    public ReferableTreeColumn getColumnByName(String columnName) throws QueryException {
        for (int index = 0; index < this.getColumnCollection().count(); ++index) {
            ReferableTreeColumn column = (ReferableTreeColumn)this.getColumnCollection().get(index);
            if (!columnName.equals(column.getText())) continue;
            return column;
        }
        throw new QueryException(bundle.messageString("Exception.Metadata.Table.UnknownColumn.fmt.txt", columnName, this.getText()));
    }

    public synchronized NodeInterface getRoot() {
        Node rootN = new Node(bundle.getString("metadata.Tree.Title.txt"), "ReferableTreeTable");
        rootN.setNodeChildren((StaticOrderedCollectionInterface)this.getColumnCollection());
        return rootN;
    }

    public String getNodeExpandedText() {
        return this.m_table.getDisplayName();
    }

    public String getNodeType() {
        return "DataSet";
    }

    public String getNodeText() {
        return this.m_table.getDisplayName();
    }

    public int countNodeChildren(int maximumChildCount) {
        if (this.getColumnCollection().count() > maximumChildCount) {
            return maximumChildCount;
        }
        if (this.getColumnCollection().count() == maximumChildCount) {
            return -maximumChildCount;
        }
        return this.getColumnCollection().count();
    }

    public int getNodeChildCount() {
        return this.getColumnCollection().count();
    }

    public boolean isLeafNode() {
        return false;
    }

    public SimpleNodeInterface getNodeChild(int index) {
        return (SimpleNodeInterface)this.getColumnCollection().get(index);
    }

    public SimpleNodeInterface[] getNodeChildren(int startIndex, int count) {
        OrderedCollection oc = this.getChildren();
        Object[] array = oc.toArray();
        if (array != null) {
            NodeInterface[] sni = new NodeInterface[array.length];
            for (int i = 0; i < array.length; ++i) {
                if (!(array[i] instanceof NodeInterface)) continue;
                sni[i] = (NodeInterface)array[i];
            }
            return sni;
        }
        return null;
    }

    public OrderedCollection getChildren() {
        return this.getColumnCollection();
    }

    public String getExpandedText() {
        return this.m_table.getDisplayName();
    }

    public String getText() {
        return this.m_table.getDisplayName();
    }

    public boolean hasChildren() {
        return true;
    }

    public void setExpandedText(String expandedText) {
    }

    public void setNodeType(String type) {
    }

    public void setText(String text) {
    }
}

