/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.models;

import com.sas.query.QueryUtils;
import com.sas.query.models.MessageHandler;
import com.sas.query.models.ModelChangeEvent;
import com.sas.query.models.ModelChangeListener;
import com.sas.query.models.PropertyChangeConstants;
import com.sas.query.visuals.QueryResource;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class PropertyChangeHandler
implements PropertyChangeConstants {
    private transient Hashtable m_listenerList = new Hashtable();
    private transient Vector m_structureChangeList = new Vector();
    private transient Vector m_dataChangeList = new Vector();
    static QueryResource bundle = new QueryResource(PropertyChangeHandler.class);

    public synchronized void addPropertyListener(ModelChangeListener listener) {
        this.addPropertyListener(listener, 65535, 65535);
    }

    public synchronized void addPropertyListener(ModelChangeListener listener, int area) {
        this.addPropertyListener(listener, area, 65535);
    }

    public synchronized void addPropertyListener(ModelChangeListener listener, int area, int type) {
        ListenerInfo info;
        if (listener == null) {
            QueryUtils.printStackTrace();
        }
        if ((info = (ListenerInfo)this.m_listenerList.get(listener)) != null) {
            info.area |= area;
            info.type |= type;
        } else {
            this.m_listenerList.put(listener, new ListenerInfo(listener, area, type));
        }
    }

    public synchronized void removePropertyListener(ModelChangeListener listener) {
        this.m_listenerList.remove(listener);
    }

    public synchronized void queueDataChange(int area, Object source, String changedAttribute, int oldIntValue) {
        this.m_dataChangeList.addElement(new DataChangeInfo(area, source, changedAttribute, oldIntValue));
    }

    public synchronized void queueDataChange(int area, Object source, String changedAttribute, String oldStringValue) {
        this.m_dataChangeList.addElement(new DataChangeInfo(area, source, changedAttribute, oldStringValue));
    }

    public synchronized void queueDataChange(int area, Object source, String changedAttribute, Object oldValue) {
        this.m_dataChangeList.addElement(new DataChangeInfo(area, source, changedAttribute, oldValue));
    }

    public synchronized void queueStructureChange(int area, int type, Object source, Object newValue) {
        this.m_structureChangeList.addElement(new StructureChangeInfo(area, type, source, newValue));
    }

    public synchronized void queueStructureChange(int area) {
        this.queueStructureChange(area, 16, this, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChanges() {
        Vector dataList;
        Vector structureList;
        Enumeration targetList;
        PropertyChangeHandler propertyChangeHandler = this;
        synchronized (propertyChangeHandler) {
            Hashtable clonedListenersCopy = (Hashtable)this.m_listenerList.clone();
            targetList = clonedListenersCopy.elements();
            structureList = this.m_structureChangeList;
            this.m_structureChangeList = new Vector();
            dataList = this.m_dataChangeList;
            this.m_dataChangeList = new Vector();
        }
        if (structureList.size() == 0 && dataList.size() == 0) {
            return;
        }
        while (targetList.hasMoreElements()) {
            ListenerInfo target = (ListenerInfo)targetList.nextElement();
            this.callModelCallback(target, structureList, dataList);
        }
    }

    public void callModelCallback(ListenerInfo target, Vector structureList, Vector dataList) {
        Object info;
        int index;
        ModelChangeEvent modelEvent = new ModelChangeEvent();
        for (index = 0; index < structureList.size(); ++index) {
            info = (StructureChangeInfo)structureList.elementAt(index);
            if ((((StructureChangeInfo)info).area & target.area) == 0) continue;
            modelEvent.addStructureChanges((StructureChangeInfo)info);
        }
        for (index = 0; index < dataList.size(); ++index) {
            info = (DataChangeInfo)dataList.elementAt(index);
            if ((((DataChangeInfo)info).area & target.area) == 0) continue;
            modelEvent.addDataChanges((DataChangeInfo)info);
        }
        if ((modelEvent.didThisStructureAreaChange(target.area) || modelEvent.didThisDataAreaChange(target.area)) && target.listener instanceof ModelChangeListener) {
            try {
                ModelChangeListener listener = (ModelChangeListener)target.listener;
                listener.modelChangeCallback(modelEvent);
            }
            catch (Exception e) {
                MessageHandler.addStaticError(bundle.messageString("model.callStrChgCallback.txt") + e);
                e.printStackTrace();
            }
        }
    }

    class ListenerInfo {
        public Object listener;
        public int area;
        public int type;

        public ListenerInfo(Object listenerParm, int areaParm, int typeParm) {
            this.listener = listenerParm;
            this.area = areaParm;
            this.type = typeParm;
        }
    }

    class DataChangeInfo {
        public int area;
        public Object source;
        public String changedAttribute;
        public int valueType;
        public int oldIntValue;
        public String oldStringValue;
        public Object oldValue;

        public DataChangeInfo(int areaParm, Object sourceParm, String changedAttributeParm, int oldIntValueParm) {
            this.area = areaParm;
            this.source = sourceParm;
            this.changedAttribute = changedAttributeParm;
            this.oldIntValue = oldIntValueParm;
            this.valueType = 0;
        }

        public DataChangeInfo(int areaParm, Object sourceParm, String changedAttributeParm, String oldStringValueParm) {
            this.area = areaParm;
            this.source = sourceParm;
            this.changedAttribute = changedAttributeParm;
            this.oldStringValue = oldStringValueParm;
            this.valueType = 1;
        }

        public DataChangeInfo(int areaParm, Object sourceParm, String changedAttributeParm, Object oldValueParm) {
            this.area = areaParm;
            this.source = sourceParm;
            this.changedAttribute = changedAttributeParm;
            this.oldValue = oldValueParm;
            this.valueType = 2;
        }
    }

    class StructureChangeInfo {
        public int area;
        public int type;
        public Object source;
        public Object newValue;

        public StructureChangeInfo(int areaParm, int typeParm, Object sourceParm, Object newValueParm) {
            this.area = areaParm;
            this.type = typeParm;
            this.source = sourceParm;
            this.newValue = newValueParm;
        }
    }
}

