/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.models;

import com.sas.query.Query;
import com.sas.query.datasources.Function;
import com.sas.query.datasources.SqlLogic;
import com.sas.query.models.Expression;
import com.sas.query.models.FilterNodeWrapper;
import com.sas.query.models.UnparsedExpression;
import com.sas.query.parser.ParserException;

public class ParenExpression
extends Expression {
    protected Expression m_insideExpression;

    public ParenExpression(Expression insideExpression) {
        this.m_insideExpression = insideExpression;
    }

    @Override
    public void toggleLogicalNegation(Function andFunction, Function orFunction) throws ParserException {
        if (this.m_insideExpression == null) {
            throw new ParserException("null expression in parenExpression, can not toggleNegation");
        }
        this.m_insideExpression.toggleLogicalNegation(andFunction, orFunction);
    }

    @Override
    public String toString() {
        return "(" + this.m_insideExpression.toString() + ")";
    }

    @Override
    public String generateSQL(SqlLogic sqlLogic, int declareOrReference) {
        if (this.m_insideExpression != null) {
            return "(" + this.m_insideExpression.generateSQL(sqlLogic, declareOrReference) + ")";
        }
        return "()";
    }

    public Expression getExpression() {
        return this.m_insideExpression;
    }

    @Override
    public FilterNodeWrapper generateFilterNodes(Query query, Function andFunction, Function orFunction) {
        if (this.m_insideExpression != null) {
            return this.m_insideExpression.generateFilterNodes(query, andFunction, orFunction);
        }
        UnparsedExpression dummy = new UnparsedExpression("()");
        return dummy.generateFilterNodes(query, andFunction, orFunction);
    }
}

