/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.models;

import com.sas.query.Query;
import com.sas.query.datasources.Function;
import com.sas.query.models.Column;
import com.sas.query.models.ColumnExpression;
import com.sas.query.models.ColumnList;
import com.sas.query.models.CompoundExpression;
import com.sas.query.models.Expression;
import com.sas.query.models.ExpressionList;
import com.sas.query.models.JoinConstants;
import com.sas.query.models.StandardModel;
import com.sas.query.models.Table;

public class JoinRelationship
extends StandardModel
implements JoinConstants {
    public static final String comparsionTypeProperty = "comparisonType";
    public static final String comparsionDetailsProperty = "comparisonDetails";
    public static final String leftTableProperty = "leftTable";
    public static final String rightTableProperty = "rightTable";
    protected Table m_leftTable;
    protected Table m_rightTable;
    protected String m_strCorrelationName;
    protected int m_nComparisonType;
    protected Expression m_onCondition;
    protected ColumnList m_columnList;
    protected ColumnList m_aliasedColumnList = null;
    protected boolean m_flipOuterJoin = false;

    public JoinRelationship(Query query, Column firstColumn, Column otherColumn) {
        super(query);
        Function equals = query.getDataSourceFunction(12, "=", firstColumn.getDataType(), 32768, 2);
        ExpressionList paramList = new ExpressionList(2);
        paramList.addElement(new ColumnExpression(firstColumn));
        paramList.addElement(new ColumnExpression(otherColumn));
        CompoundExpression comparisonDetail = new CompoundExpression(equals, paramList);
        this.initialize(firstColumn.getParent(), otherColumn.getParent(), 4, comparisonDetail);
    }

    public JoinRelationship(Query query, Table firstTable, Table otherTable, int comparisonType, String strComparisonDetail) {
        super(query);
        Expression comparisonDetail = Expression.createInstance(query, strComparisonDetail);
        this.initialize(firstTable, otherTable, comparisonType, comparisonDetail);
    }

    public JoinRelationship(Query query, Table firstTable, Table otherTable, int comparisonType, Object comparisonDetail) {
        super(query);
        this.initialize(firstTable, otherTable, comparisonType, comparisonDetail);
    }

    protected void initialize(Table firstTable, Table otherTable, int comparisonType, Object comparisonDetail) {
        this.setLeftTable(firstTable);
        this.setRightTable(otherTable);
        this.modifyJoinRelationship(comparisonType, comparisonDetail);
    }

    public String getName() {
        return this.m_strCorrelationName;
    }

    public Table[] getTables() {
        return null;
    }

    public int getColumnCount() {
        int size = 0;
        size = this.m_aliasedColumnList != null && this.m_aliasedColumnList.size() != 0 ? this.m_aliasedColumnList.size() : this.m_leftTable.getColumnCount() + this.m_rightTable.getColumnCount();
        return size;
    }

    public ColumnList getColumns() {
        ColumnList returnList = null;
        if (this.m_aliasedColumnList != null && this.m_aliasedColumnList.size() != 0) {
            returnList = this.m_aliasedColumnList;
        } else {
            returnList = new ColumnList();
            ColumnList leftList = this.m_leftTable.getColumns();
            for (int index = 0; index < this.m_leftTable.getColumnCount(); ++index) {
                returnList.addElement(leftList.elementAt(index));
            }
            ColumnList rightList = this.m_rightTable.getColumns();
            for (int index = 0; index < this.m_rightTable.getColumnCount(); ++index) {
                returnList.addElement(rightList.elementAt(index));
            }
        }
        return returnList;
    }

    public void modifyJoinRelationship(int comparisonType, Object comparisonDetail) {
        int oldType = this.m_nComparisonType;
        this.m_nComparisonType = comparisonType;
        if (this.m_nComparisonType != 1 && this.m_nComparisonType != 2) {
            if (this.m_nComparisonType == 4) {
                if (!(comparisonDetail instanceof Expression)) {
                    // empty if block
                }
                this.m_onCondition = (Expression)comparisonDetail;
            } else if (this.m_nComparisonType == 5) {
                this.m_onCondition = (Expression)comparisonDetail;
            }
        }
        this.queueDataChange(16, comparsionTypeProperty, new Integer(oldType));
    }

    public Table getLeftTable() {
        return this.m_leftTable;
    }

    public void setLeftTable(Table newLeftTable) {
        this.queueDataChange(16, leftTableProperty, this.m_leftTable);
        this.m_leftTable = newLeftTable;
    }

    public Table getRightTable() {
        return this.m_rightTable;
    }

    public void setRightTable(Table newRightTable) {
        this.queueDataChange(16, rightTableProperty, this.m_rightTable);
        this.m_rightTable = newRightTable;
    }

    public int getComparisonType() {
        return this.m_nComparisonType;
    }

    public Expression getComparisonDetails() {
        if (this.m_nComparisonType != 1 && this.m_nComparisonType != 2) {
            if (this.m_nComparisonType == 4) {
                return this.m_onCondition;
            }
            if (this.m_nComparisonType == 5) {
                return this.m_onCondition;
            }
        }
        return null;
    }

    public void setComparisonDetails(Expression expression) {
        this.queueDataChange(16, comparsionDetailsProperty, this.m_onCondition);
        this.m_onCondition = expression;
    }

    public String toString() {
        return this.getComparisonDetails().generateSQL(this.getSqlLogic(), 1);
    }
}

