/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.models;

import com.sas.query.Query;
import com.sas.query.QueryConfiguration;
import com.sas.query.datasources.Function;
import com.sas.query.models.ColumnList;
import com.sas.query.models.CompoundExpression;
import com.sas.query.models.Expression;
import com.sas.query.models.ExpressionList;
import com.sas.query.models.FilterNode;
import com.sas.query.models.StandardModel;
import java.util.Vector;

public class FilterTree
extends StandardModel {
    static final long serialVersionUID = 7954402014359978201L;
    static int queryAllowsFilterTreeOptimization = -1;
    protected static final int AND_CHILD = 1;
    protected static final int OR_CHILD = 2;
    protected FilterNode m_rootNode = null;
    protected FilterNode m_selectedNode = null;

    public FilterTree(Query query) {
        super(query);
    }

    public FilterTree(FilterNode root) {
        super(root);
        this.setRoot(root);
    }

    public void setRoot(FilterNode newRootNode) {
        if (newRootNode != null && (newRootNode == this.m_rootNode || newRootNode.equals(this.m_rootNode))) {
            return;
        }
        if (newRootNode == null && this.m_rootNode == null) {
            return;
        }
        this.m_rootNode = newRootNode;
        if (newRootNode == null) {
            this.setSelectedNode(newRootNode);
        }
        this.queueStructureChange(32, 1, newRootNode);
    }

    public FilterNode getRoot() {
        return this.m_rootNode;
    }

    public FilterNode addAnd(Expression expressionToBaseFilterOn) {
        FilterNode newNode = new FilterNode(this.getQuery(), expressionToBaseFilterOn);
        this.addAnd(newNode);
        return newNode;
    }

    public void addAnd(FilterNode newNode) {
        if (this.m_selectedNode == null) {
            if (this.getRoot() == null) {
                this.setRoot(newNode);
            } else {
                this.getRoot().addOr(newNode);
            }
        } else {
            FilterNode parentNode = this.m_selectedNode;
            parentNode.addAnd(newNode);
            if (this.getRoot() == null) {
                this.setRoot(newNode);
            }
        }
        this.setSelectedNode(newNode);
    }

    public void addOr(FilterNode newNode) {
        if (this.m_selectedNode == null) {
            if (this.getRoot() == null) {
                this.setRoot(newNode);
            } else {
                this.getRoot().addOr(newNode);
            }
        } else {
            FilterNode parentNode = this.m_selectedNode;
            parentNode.addOr(newNode);
            if (this.getRoot() == null) {
                this.setRoot(newNode);
            }
        }
        this.setSelectedNode(newNode);
    }

    public synchronized void setSelectedNode(FilterNode node) {
        if (this.m_selectedNode != null) {
            this.m_selectedNode.setSelected(false);
        }
        this.m_selectedNode = node;
        if (this.m_selectedNode != null) {
            this.m_selectedNode.setSelected(true);
        }
        this.queueStructureChange(32, 8, this.m_selectedNode);
    }

    public FilterNode getSelectedNode() {
        return this.m_selectedNode;
    }

    public void optimize() {
        if (queryAllowsFilterTreeOptimization == -1) {
            queryAllowsFilterTreeOptimization = QueryConfiguration.getConfigurationBoolean("Queries.FilterTreeOptimization.Enabled.notrans", true) ? 1 : 0;
        }
        if (queryAllowsFilterTreeOptimization != 1) {
            return;
        }
        FilterNode[] x = this.getNodesArray();
        Vector<FilterNode> filterNodes = new Vector<FilterNode>();
        Vector<String> nodesSQL = new Vector<String>();
        Vector<String> thisNodeOnSQL = new Vector<String>();
        for (int i = 0; i < x.length; ++i) {
            filterNodes.addElement(x[i]);
            nodesSQL.addElement(x[i].generateSQLThroughThisNodeIncludingItsOrChildren());
            thisNodeOnSQL.addElement(x[i].generateSQLForThisNodesExpressionAndAllFollowingNodes());
        }
        int numberOfNodes = x.length;
        for (int i = 0; i < numberOfNodes; ++i) {
            String olderSQL = (String)nodesSQL.elementAt(i);
            String olderSQLforOrs = (String)thisNodeOnSQL.elementAt(i);
            FilterNode olderNode = (FilterNode)filterNodes.elementAt(i);
            if (olderNode == null || olderNode.isDeleted() || olderSQL == null || olderSQLforOrs == null) continue;
            for (int j = i + 1; j < numberOfNodes; ++j) {
                String newerSQL = (String)nodesSQL.elementAt(j);
                String newerSQLforOrs = (String)thisNodeOnSQL.elementAt(j);
                FilterNode newerNode = (FilterNode)filterNodes.elementAt(j);
                if (newerNode == null || newerNode.isDeleted() || newerSQL == null || newerSQLforOrs == null) continue;
                if (olderSQL.equals(newerSQL)) {
                    olderNode.mergeInAnds(newerNode);
                    continue;
                }
                if (!olderSQLforOrs.equals(newerSQLforOrs)) continue;
                olderNode.mergeInOrs(newerNode);
            }
        }
        this.mergeBackInTheOrIsNulls();
    }

    public void mergeBackInTheOrIsNulls() {
        int i;
        FilterNode[] x = this.getNodesArray();
        Vector<FilterNode> filterNodesAreISNULL = new Vector<FilterNode>();
        Vector<FilterNode> filterNodesAreNOTisnull = new Vector<FilterNode>();
        Vector<String> filterNodesAreisnullLHSSQL = new Vector<String>();
        Vector<String> filterNodesAreNOTisnullLHSSQL = new Vector<String>();
        for (i = 0; i < x.length; ++i) {
            Expression nodeExp = x[i].getNodeData();
            if (!(nodeExp instanceof CompoundExpression)) continue;
            CompoundExpression ce = (CompoundExpression)nodeExp;
            Function cefun = ce.getCurrentFunction();
            if (cefun.getFunctionName() != "ISNULL") {
                if (ce.getParameters().size() <= 0) continue;
                filterNodesAreNOTisnull.addElement(x[i]);
                filterNodesAreNOTisnullLHSSQL.addElement(ce.getParameter(0).generateSQL(this.getSqlLogic(), 2));
                continue;
            }
            if (ce.getParameters().size() <= 0) continue;
            filterNodesAreISNULL.addElement(x[i]);
            filterNodesAreisnullLHSSQL.addElement(ce.getParameter(0).generateSQL(x[i].getSqlLogic(), 2));
        }
        for (i = 0; i < filterNodesAreISNULL.size(); ++i) {
            if (filterNodesAreisnullLHSSQL.elementAt(i) == null) continue;
            String isnulledSQL = (String)filterNodesAreisnullLHSSQL.elementAt(i);
            for (int j = 0; j < filterNodesAreNOTisnull.size(); ++j) {
                String somethingElseSQL;
                if (filterNodesAreNOTisnullLHSSQL.elementAt(j) == null || !isnulledSQL.equals(somethingElseSQL = (String)filterNodesAreNOTisnullLHSSQL.elementAt(j))) continue;
                FilterNode realExpressionNode = (FilterNode)filterNodesAreNOTisnull.elementAt(j);
                FilterNode isNullNode = (FilterNode)filterNodesAreISNULL.elementAt(i);
                if (isNullNode == null || !FilterNode.mergeExpressionAndLHSIsNull(realExpressionNode, isNullNode, this)) continue;
                filterNodesAreNOTisnull.setElementAt(null, j);
                filterNodesAreNOTisnullLHSSQL.setElementAt(null, j);
                filterNodesAreISNULL.setElementAt(null, i);
                filterNodesAreisnullLHSSQL.setElementAt(null, i);
            }
        }
    }

    public FilterNode removeNode(FilterNode nodeToRemove) {
        FilterNode replacementNode = null;
        FilterNode[] parentNodes = nodeToRemove.getParentNodes();
        FilterNode childAndNode = nodeToRemove.getAnd();
        FilterNode childOrNode = nodeToRemove.getOr();
        FilterNode oldestAndChild = nodeToRemove.getOldestAndChild();
        nodeToRemove.setAnd(null);
        nodeToRemove.setOr(null);
        if (parentNodes.length == 0) {
            if (childAndNode == null && childOrNode == null) {
                this.setRoot(null);
            } else if (childAndNode != null && childOrNode == null) {
                this.setRoot(childAndNode);
            } else if (childAndNode == null && childOrNode != null) {
                this.setRoot(childOrNode);
            } else {
                boolean childOrNodeConvergesBeforeChildAndNode = false;
                childOrNodeConvergesBeforeChildAndNode = childOrNode.isFilterNodeInPath(childAndNode);
                if (childOrNodeConvergesBeforeChildAndNode) {
                    this.setRoot(childOrNode);
                } else {
                    this.setRoot(childAndNode);
                    childAndNode.addOr(childOrNode);
                }
            }
            replacementNode = this.getRoot();
        }
        for (int index = 0; index < parentNodes.length; ++index) {
            FilterNode parent = parentNodes[index];
            FilterNode parentAndNode = parent.getAnd();
            int parentRelationship = nodeToRemove.equals(parentAndNode) ? 1 : 2;
            if (childAndNode == null && childOrNode == null) {
                if (parentRelationship == 2) {
                    parent.setOr(null);
                } else {
                    parent.setAnd(null);
                }
            } else if (parentRelationship == 2) {
                boolean childAndNodeConvergesWithParentAndNode = false;
                if (parentAndNode != null) {
                    childAndNodeConvergesWithParentAndNode = parentAndNode.isFilterNodeInPath(childAndNode);
                }
                boolean childOrNodeConvergesWithChildAndNode = false;
                if (childOrNode != null) {
                    childOrNodeConvergesWithChildAndNode = childOrNode.isFilterNodeInPath(childAndNode);
                }
                if (!childAndNodeConvergesWithParentAndNode && !childOrNodeConvergesWithChildAndNode) {
                    if (oldestAndChild != null) {
                        oldestAndChild.setOr(childOrNode);
                        parent.setOr(childAndNode);
                        replacementNode = childAndNode;
                    } else {
                        parent.setOr(childOrNode);
                        replacementNode = childOrNode;
                    }
                } else {
                    parent.setOr(childOrNode);
                    replacementNode = childOrNode;
                }
            } else {
                boolean childOrNodeConvergesBeforeChildAndNode = false;
                if (childOrNode != null) {
                    childOrNodeConvergesBeforeChildAndNode = childOrNode.isFilterNodeInPath(childAndNode);
                }
                if (childAndNode == null || childOrNodeConvergesBeforeChildAndNode) {
                    parent.setAnd(childOrNode);
                    replacementNode = childOrNode;
                } else {
                    parent.setAnd(childAndNode);
                    replacementNode = childAndNode;
                    if (childOrNode != null && !childOrNode.equals(childAndNode.getOr())) {
                        childAndNode.addOr(childOrNode);
                    }
                }
            }
            if (replacementNode != null) continue;
            replacementNode = parent;
        }
        this.queueStructureChange(32, 2, nodeToRemove);
        return replacementNode;
    }

    public void removeNodesNotInPath(FilterNode requestedNode) {
        Vector nodesInTree = new Vector();
        this.getNodesVector(nodesInTree, this.getRoot());
        for (int index = 0; index < nodesInTree.size(); ++index) {
            FilterNode node = (FilterNode)nodesInTree.elementAt(index);
            if (node == requestedNode || node.getAnd() != null && node.getAnd().isFilterNodeInPath(requestedNode)) continue;
            this.removeNode(node);
        }
    }

    public FilterNode[] getNodesArray() {
        Vector nodesInTree = new Vector();
        this.getNodesVector(nodesInTree, this.getRoot());
        FilterNode[] nodeArray = new FilterNode[nodesInTree.size()];
        for (int index = 0; index < nodesInTree.size(); ++index) {
            nodeArray[index] = (FilterNode)nodesInTree.elementAt(index);
        }
        return nodeArray;
    }

    public Vector getNodesVector() {
        Vector nodesInTree = new Vector();
        this.getNodesVector(nodesInTree, this.getRoot());
        return nodesInTree;
    }

    public void getNodesVector(Vector nodeList, FilterNode node) {
        if (node == null || nodeList.contains(node)) {
            return;
        }
        nodeList.addElement(node);
        this.getNodesVector(nodeList, node.getAnd());
        this.getNodesVector(nodeList, node.getOr());
    }

    public ExpressionList getExpressions() {
        ExpressionList expressionList = new ExpressionList();
        FilterNode[] nodeArray = this.getNodesArray();
        for (int index = 0; index < nodeArray.length; ++index) {
            if (nodeArray[index].getNodeData() == null) continue;
            expressionList.addElement(nodeArray[index].getNodeData());
        }
        return expressionList;
    }

    public ColumnList getUsedColumns() {
        ExpressionList expressionList = this.getExpressions();
        ColumnList columnList = new ColumnList();
        for (int index = 0; index < expressionList.size(); ++index) {
            ColumnList newList = expressionList.elementAt(index).getReferencedColumns();
            columnList.add(newList);
        }
        return columnList;
    }
}

