/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.models;

import com.sas.query.Query;
import com.sas.query.datasources.Function;
import com.sas.query.models.Column;
import com.sas.query.models.ColumnExpression;
import com.sas.query.models.CompoundExpression;
import com.sas.query.models.Expression;
import com.sas.query.models.ExpressionConstants;
import com.sas.query.models.FilterTree;
import com.sas.query.models.ModelChangeEvent;
import com.sas.query.models.ModelChangeListener;
import com.sas.query.models.ResultItem;
import com.sas.query.models.ResultItemList;
import com.sas.query.models.StandardModel;
import com.sas.query.visuals.QueryResource;
import java.util.Vector;

public class FilterNode
extends StandardModel
implements ExpressionConstants,
ModelChangeListener {
    static final long serialVersionUID = -5673940694267512034L;
    private static long idcount = 1L;
    private boolean m_markDeleted = false;
    public static final String dataPropertyChange = "data";
    public static final String andPropertyChange = "and";
    public static final String orPropertyChange = "or";
    static QueryResource bundle = new QueryResource(FilterNode.class);
    protected Column m_column = null;
    protected boolean m_fIsSelected;
    protected long m_id;
    protected FilterNode m_andNode = null;
    protected FilterNode m_orNode = null;
    protected Vector m_andParents = new Vector();
    protected FilterNode m_orParent = null;
    protected Expression m_data = null;
    protected String m_limitString;

    protected long getId() {
        return ++idcount - 1L;
    }

    public FilterNode(Query query, Expression data) {
        super(query);
        this.setNodeData(data);
        this.m_id = this.getId();
    }

    public Object deepClone() throws CloneNotSupportedException {
        FilterNode shallowClone = (FilterNode)this.clone();
        if (this.getOr() != null) {
            shallowClone.setOr((FilterNode)this.getOr().deepClone());
        }
        if (this.getAnd() != null) {
            shallowClone.setAnd((FilterNode)this.getAnd().deepClone());
        }
        return shallowClone;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        FilterNode newNode = (FilterNode)super.clone();
        newNode.m_column = this.m_column;
        if (this.m_data != null) {
            newNode.setNodeData((Expression)this.m_data.clone());
        } else {
            newNode.m_data = null;
        }
        newNode.m_limitString = this.m_limitString;
        newNode.m_andNode = null;
        newNode.m_orNode = null;
        newNode.m_andParents = new Vector();
        newNode.m_orParent = null;
        return newNode;
    }

    public boolean isDeleted() {
        return this.m_markDeleted;
    }

    public void markDeleted() {
        this.m_markDeleted = true;
    }

    public void deleteChain() {
        if (this.isDeleted()) {
            this.m_query.getMessageHandler().addInternalError("cycle in deleted nodes found");
            return;
        }
        this.markDeleted();
        if (this.m_andNode != null) {
            this.m_andNode.deleteChain();
        }
        if (this.m_orNode != null) {
            this.m_orNode.deleteChain();
        }
    }

    public void deleteCreatedOrphans(FilterNode headOfOlderChain) {
        if (headOfOlderChain == null) {
            this.markDeleted();
            if (this.getAnd() != null) {
                this.getAnd().deleteChain();
            }
        } else if (!headOfOlderChain.isFilterNodeInPath(this)) {
            this.markDeleted();
            if (this.m_andNode != null) {
                this.m_andNode.deleteCreatedOrphans(headOfOlderChain);
            }
            if (this.m_orNode != null) {
                this.m_orNode.deleteCreatedOrphans(headOfOlderChain);
            }
        }
    }

    public Column getColumn() {
        if (this.m_column != null) {
            return this.m_column;
        }
        if (this.m_data != null && this.m_data instanceof ColumnExpression) {
            return ((ColumnExpression)this.m_data).getColumn();
        }
        return null;
    }

    public String generateSQLThroughThisNodeIncludingItsOrChildren() {
        FilterTree tempTree = new FilterTree(this.getQuery());
        try {
            tempTree.setRoot((FilterNode)this.deepClone());
        }
        catch (Exception t) {
            return "";
        }
        String result = this.m_query.getSqlLogic().genSQLForFilterTree(tempTree);
        return result;
    }

    public String generateSQLforThisNodeOnly() {
        String retval = "";
        Expression nodeData = this.getNodeData();
        if (this.getSqlLogic() != null && nodeData != null) {
            if (nodeData instanceof Expression) {
                Expression exp = nodeData;
                retval = exp.generateSQL(this.getSqlLogic(), 2);
                if (retval == null) {
                    retval = "";
                }
            } else {
                this.m_query.getMessageHandler().addInternalError(bundle.messageString("model.nodedataNotExpr.txt"));
            }
        }
        return retval;
    }

    public String generateSQLForThisNodesExpressionAndAllFollowingNodes() {
        FilterTree tempTree = new FilterTree(this.getQuery());
        try {
            FilterNode nodeInQuestion = (FilterNode)this.clone();
            if (this.m_andNode != null) {
                nodeInQuestion.addAnd((FilterNode)this.m_andNode.deepClone());
            }
            tempTree.setRoot(nodeInQuestion);
        }
        catch (Exception t) {
            return "";
        }
        String result = this.m_query.getSqlLogic().genSQLForFilterTree(tempTree);
        return result;
    }

    public boolean mergeInAnds(FilterNode possiblyRedundantGuy) {
        if (possiblyRedundantGuy.isDeleted()) {
            return false;
        }
        if (this.getOrParent() == null && possiblyRedundantGuy.getAndParents().size() > 0) {
            Vector andParents = possiblyRedundantGuy.getAndParents();
            for (int i = 0; i < andParents.size(); ++i) {
                FilterNode ancestor = (FilterNode)andParents.elementAt(i);
                if (this == ancestor) {
                    this.m_query.getMessageHandler().addInternalError("Illegal cyclical reference detected.");
                }
                ancestor.setAnd(this);
            }
            possiblyRedundantGuy.deleteChain();
            if (possiblyRedundantGuy.getAnd() != null) {
                FilterNode guyWithLint = possiblyRedundantGuy.getAnd();
                guyWithLint.removeAndParent(possiblyRedundantGuy);
            }
            return true;
        }
        return false;
    }

    public boolean mergeInOrs(FilterNode possiblyRedundantGuy) {
        if (possiblyRedundantGuy.isDeleted()) {
            return false;
        }
        FilterNode olderOldestOrParent = this;
        while (olderOldestOrParent.getOrParent() != null) {
            olderOldestOrParent = olderOldestOrParent.getOrParent();
        }
        FilterNode potentiallyRedundantsOldestOrParent = possiblyRedundantGuy;
        while (potentiallyRedundantsOldestOrParent.getOrParent() != null) {
            potentiallyRedundantsOldestOrParent = potentiallyRedundantsOldestOrParent.getOrParent();
        }
        if (potentiallyRedundantsOldestOrParent == olderOldestOrParent) {
            FilterNode andChildOfDupe = possiblyRedundantGuy.getAnd();
            if (andChildOfDupe != null) {
                andChildOfDupe.removeAndParent(possiblyRedundantGuy);
            }
            possiblyRedundantGuy.deleteCreatedOrphans(this.getAnd());
            FilterNode orParentOfDupe = possiblyRedundantGuy.getOrParent();
            orParentOfDupe.setOr(possiblyRedundantGuy.getOr());
            return true;
        }
        return false;
    }

    public static boolean mergeExpressionAndLHSIsNull(FilterNode expression, FilterNode orIsNull, FilterTree containingTree) {
        FilterNode KillOrChild;
        FilterNode orIsNullAndChild;
        if (expression.getFirstOrParent() != orIsNull.getFirstOrParent()) {
            return false;
        }
        FilterNode expressionAndChild = expression.getAnd();
        if (expressionAndChild != (orIsNullAndChild = orIsNull.getAnd())) {
            return false;
        }
        Expression tmp = expression.getNodeData();
        tmp = Expression.wrapWithOrIsNull(tmp, expression.getQuery());
        FilterNode Keep = expression;
        FilterNode Kill = orIsNull;
        if (orIsNull.getAndParents().size() > 0) {
            Kill = Keep;
            Keep = orIsNull;
        }
        Keep.setNodeData(tmp);
        if (Kill.getAnd() != null) {
            Kill.getAnd().removeAndParent(Kill);
        }
        if ((KillOrChild = Kill.getOr()) != null) {
            KillOrChild.m_orParent = Kill.m_orParent;
        }
        if (Kill.m_orParent != null) {
            Kill.m_orParent.m_orNode = KillOrChild;
        }
        if (containingTree.getRoot() == Kill) {
            containingTree.setRoot(Kill.getOr());
        }
        return true;
    }

    public String getLimitString() {
        return this.m_limitString;
    }

    public void setNodeData(Expression expression) {
        Expression newExpression;
        Expression oldExpression = this.getNodeData();
        this.m_data = null;
        this.m_data = newExpression = this.m_query.shareExpressionWithResultItem(expression, this);
        this.m_limitString = null;
        if (this.m_data != null) {
            this.m_limitString = this.m_data.generateSQL(this.getSqlLogic(), 2);
        }
        this.m_column = null;
        newExpression = this.getNodeData();
        if (newExpression instanceof CompoundExpression) {
            Expression insideGuy;
            Function neFun;
            CompoundExpression ce = (CompoundExpression)newExpression;
            if (ce.getCurrentFunction().getName().equals("<>") && ce.getCurrentFunction().getReturnType() != 32768 && (neFun = this.m_query.getDataSourceFunction(12, this.m_query.getDataSource().getProperties().logicalNotEqualsConditionalName(), 4095, 32768, 2)) != null) {
                ce.setCurrentFunction(neFun);
            }
            if ((insideGuy = CompoundExpression.unwrapIfHasOrIsNull((CompoundExpression)newExpression, this.m_query)) instanceof CompoundExpression && ((CompoundExpression)insideGuy).getParameters().size() > 0 && ((CompoundExpression)insideGuy).getParameters().elementAt(0) instanceof ColumnExpression) {
                this.m_column = ((ColumnExpression)((CompoundExpression)insideGuy).getParameters().elementAt(0)).getColumn();
            }
        }
        this.queueDataChange(32, dataPropertyChange, oldExpression);
    }

    public Expression getNodeData() {
        return this.m_data;
    }

    public void setSelected(boolean selected) {
        if (this.m_fIsSelected != selected) {
            this.m_fIsSelected = selected;
        }
    }

    public boolean isSelected() {
        return this.m_fIsSelected;
    }

    public String toString() {
        return this.getLimitString();
    }

    public FilterNode getAnd() {
        return this.m_andNode;
    }

    public void addAnd(FilterNode newNode) {
        if (this.m_andNode != null) {
            newNode.addAnd(this.m_andNode);
        }
        this.setAnd(newNode);
        this.queueStructureChange(32, 1, newNode);
    }

    public void setAnd(FilterNode newNode) {
        if (this.m_andNode != null) {
            this.m_andNode.removeAndParent(this);
        }
        this.m_andNode = newNode;
        if (newNode != null && !newNode.addAndParent(this)) {
            this.m_andNode = null;
        }
        this.queueStructureChange(32);
    }

    public FilterNode getOr() {
        return this.m_orNode;
    }

    public void addOr(FilterNode newNode) {
        if (this.m_orNode != null) {
            newNode.addOr(this.m_orNode);
        }
        this.setOr(newNode);
        this.queueStructureChange(32, 1, newNode);
    }

    public void setOr(FilterNode newNode) {
        if (this.m_orNode != null) {
            this.m_orNode.removeOrParent(this);
        }
        this.m_orNode = newNode;
        if (newNode != null && !newNode.addOrParent(this)) {
            this.m_orNode = null;
        }
        this.queueStructureChange(32);
    }

    public FilterNode getOldestAndChild() {
        FilterNode oldestChild;
        for (oldestChild = this.getAnd(); oldestChild != null && oldestChild.getOr() != null; oldestChild = oldestChild.getOr()) {
        }
        return oldestChild;
    }

    public boolean isFilterNodeInPath(FilterNode searchNode) {
        if (searchNode == null) {
            return false;
        }
        if (searchNode.equals(this)) {
            return true;
        }
        if (searchNode.equals(this.m_andNode)) {
            return true;
        }
        if (searchNode.equals(this.m_orNode)) {
            return true;
        }
        if (this.m_andNode != null && this.m_andNode.isFilterNodeInPath(searchNode)) {
            return true;
        }
        return this.m_orNode != null && this.m_orNode.isFilterNodeInPath(searchNode);
    }

    public Vector getAndParents() {
        return this.m_andParents;
    }

    public FilterNode getOrParent() {
        return this.m_orParent;
    }

    protected boolean addAndParent(FilterNode newParent) {
        if (this.m_orParent != null) {
            this.m_query.getMessageHandler().addError(bundle.messageString("model.addORandAND.fmt.txt", this.toString()));
            return false;
        }
        if (!this.m_andParents.contains(newParent)) {
            this.m_andParents.addElement(newParent);
        }
        return true;
    }

    protected void removeAndParent(FilterNode oldParent) {
        this.m_andParents.removeElement(oldParent);
    }

    protected boolean addOrParent(FilterNode newParent) {
        if (this.m_andParents.size() > 0) {
            this.m_query.getMessageHandler().addError(bundle.messageString("model.addORandAND.fmt.txt", this.toString()));
            return false;
        }
        this.m_orParent = newParent;
        return true;
    }

    protected void removeOrParent(FilterNode oldParent) {
        if (this.m_orParent != null && this.m_orParent.equals(oldParent)) {
            this.m_orParent = null;
        }
    }

    private FilterNode getFirstOrParent() {
        if (this.getOrParent() == null) {
            return this;
        }
        return this.getOrParent().getFirstOrParent();
    }

    public FilterNode[] getParentNodes() {
        FilterNode[] parentNodes = new FilterNode[]{};
        if (this.m_andParents.size() > 0) {
            parentNodes = new FilterNode[this.m_andParents.size()];
            for (int index = 0; index < this.m_andParents.size(); ++index) {
                parentNodes[index] = (FilterNode)this.m_andParents.elementAt(index);
            }
        } else if (this.m_orParent != null) {
            parentNodes = new FilterNode[]{this.m_orParent};
        }
        return parentNodes;
    }

    @Override
    public void modelChangeCallback(ModelChangeEvent event) {
        if (event.didThisDataAreaChange(4)) {
            ResultItemList resultList = this.m_query.getResultItems();
            for (int index = 0; index < resultList.size(); ++index) {
                Expression newExpression;
                ResultItem resultItem = resultList.elementAt(index);
                Object oldValue = event.getOldValueForDataChangeObject(resultItem);
                if (oldValue == null || !(oldValue instanceof Expression) || ((newExpression = resultItem.getExpression()).isAggregation() || newExpression.hasAggregation()) && this.m_query.getWhereFilterTree().getNodesVector().contains(this)) continue;
                if (oldValue == this.m_data) {
                    this.m_data = resultItem.getExpression();
                } else if (this.m_data instanceof CompoundExpression) {
                    CompoundExpression compound = (CompoundExpression)this.m_data;
                    compound.replaceChildExpression((Expression)oldValue, resultItem.getExpression());
                }
                this.setNodeData(this.m_data);
            }
        }
    }
}

