/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.models;

import com.sas.query.models.FilterNetworkAtom;
import com.sas.query.models.FilterNetworkAtomExpression;
import com.sas.query.models.FilterNetworkAtomList;
import com.sas.query.models.FilterNetworkConstants;
import com.sas.query.models.MessageHandler;
import com.sas.query.visuals.QueryResource;
import java.util.Vector;

public class FilterNetworkConnector
implements FilterNetworkConstants {
    protected FilterNetworkAtomList m_predAtoms = new FilterNetworkAtomList();
    protected FilterNetworkAtomList m_succAtoms = new FilterNetworkAtomList();
    protected FilterNetworkAtomExpression m_contents = new FilterNetworkAtomExpression();
    protected static QueryResource bundle = new QueryResource(FilterNetworkConnector.class);

    public FilterNetworkConnector() {
    }

    public FilterNetworkConnector(FilterNetworkAtom pred) {
        this();
        pred.setSuccessor(this);
    }

    public FilterNetworkAtomExpression getContents() {
        return this.m_contents;
    }

    public FilterNetworkAtomExpression generateRemaindingNetworkContents() {
        FilterNetworkAtomExpression retVal = null;
        FilterNetworkAtomList succs = this.getSuccessors();
        if (succs.size() == 0) {
            return this.getContents();
        }
        if (succs.size() == 1) {
            retVal = new FilterNetworkAtomExpression();
            if (!this.getContents().isEmpty()) {
                retVal.append(this.getContents().appropriatelyWrappedList(" AND"));
                retVal.addElement(" AND");
            }
            FilterNetworkAtomExpression temp2 = succs.getElement(0).generateRemaindingNetworkContents();
            retVal.append(temp2.appropriatelyWrappedList(" AND"));
            return retVal;
        }
        retVal = new FilterNetworkAtomExpression();
        if (!this.getContents().isEmpty()) {
            retVal.addElement(" AND");
        }
        retVal.addElement("(");
        for (int i = 0; i < succs.size(); ++i) {
            FilterNetworkAtomExpression temp = succs.getElement(i).generateRemaindingNetworkContents();
            retVal.append(temp.appropriatelyWrappedList(" OR"));
            if (i >= succs.size() - 1) continue;
            retVal.addElement(" OR");
        }
        retVal.addElement(")");
        return retVal;
    }

    public int NetworkConnectorNodeCount(Vector traversedList) {
        int currentCount = 0;
        if (traversedList.contains(this)) {
            return currentCount;
        }
        traversedList.addElement(this);
        currentCount = 1;
        for (int i = 0; i < this.getSuccessors().size(); ++i) {
            FilterNetworkAtom childAtom = this.getSuccessors().getElement(i);
            FilterNetworkConnector child = childAtom.getSuccessor();
            if (child == null) continue;
            currentCount += child.NetworkConnectorNodeCount(traversedList);
        }
        return currentCount;
    }

    public void setContents(FilterNetworkAtomExpression newcontent) {
        this.m_contents = newcontent;
    }

    public FilterNetworkAtomList getSuccessors() {
        return this.m_succAtoms;
    }

    public FilterNetworkAtomList getPredecessors() {
        return this.m_predAtoms;
    }

    public void setSuccessors(FilterNetworkAtomList newlist) {
        this.m_succAtoms = newlist;
        for (int i = 0; i < newlist.size(); ++i) {
            newlist.getElement(i).setPredecessor(this);
        }
    }

    public void setPredecessors(FilterNetworkAtomList newlist) {
        this.m_predAtoms = newlist;
        for (int i = 0; i < newlist.size(); ++i) {
            newlist.getElement(i).setSuccessor(this);
        }
    }

    public FilterNetworkConnector getFirstSuccessorConnector() {
        if (this.getSuccessors().size() < 1) {
            MessageHandler.addStaticError(bundle.messageString("model.getFSCTermNode.txt"));
            return null;
        }
        return this.getSuccessors().getElement(0).getSuccessor();
    }

    public void removePredecessor(FilterNetworkAtom atom) {
        this.m_predAtoms.removeIfFound(atom);
    }

    public void removeSuccessor(FilterNetworkAtom atom) {
        this.m_succAtoms.removeIfFound(atom);
    }

    public void addPredecessor(FilterNetworkAtom atom) {
        this.m_predAtoms.addNoDupe(atom);
        if (atom.getSuccessor() != this) {
            atom.setSuccessor(this);
        }
    }

    public void addSuccessor(FilterNetworkAtom atom) {
        this.m_succAtoms.addNoDupe(atom);
        if (atom.getPredecessor() != this) {
            atom.setPredecessor(this);
        }
    }

    public void sweepForward() {
        if (this.getSuccessors() == null) {
            return;
        }
        for (int i = this.getSuccessors().size() - 1; i >= 0; --i) {
            if (!this.getSuccessors().getElement(i).isMarked()) {
                this.removeSuccessor(this.getSuccessors().getElement(i));
                continue;
            }
            if (this.getSuccessors().getElement(i).getSuccessor() == null) continue;
            this.getSuccessors().getElement(i).getSuccessor().sweepForward();
        }
    }
}

