/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.models;

import com.sas.query.models.FilterNetworkAtomList;
import com.sas.query.models.FilterNetworkConstants;
import com.sas.query.models.FilterNode;
import com.sas.query.models.MessageHandler;
import com.sas.query.visuals.QueryResource;
import java.util.StringTokenizer;
import java.util.Vector;

public class FilterNetworkAtomExpression
extends Vector
implements FilterNetworkConstants {
    protected static QueryResource bundle = new QueryResource(FilterNetworkAtomExpression.class);

    public FilterNetworkAtomExpression() {
    }

    public FilterNetworkAtomExpression(String initialValue) {
        if (initialValue != null) {
            this.addElement(initialValue);
        }
    }

    public void dumpout() {
        System.out.println("Result is:");
        for (int i = 0; i < this.size(); ++i) {
            System.out.print(" " + this.elementAt(i));
        }
        System.out.println(".");
    }

    private boolean isComplex() {
        return this.size() > 1;
    }

    public static FilterNetworkAtomExpression or(FilterNetworkAtomList atomsToOrIntoExpression) {
        FilterNetworkAtomExpression retVal = new FilterNetworkAtomExpression();
        if (atomsToOrIntoExpression.size() == 0) {
            return retVal;
        }
        FilterNetworkAtomExpression first = atomsToOrIntoExpression.getElement(0).getContents();
        if (atomsToOrIntoExpression.size() == 1) {
            return first;
        }
        retVal = first;
        for (int i = 1; i < atomsToOrIntoExpression.size(); ++i) {
            FilterNetworkAtomExpression second = atomsToOrIntoExpression.getElement(i).getContents();
            retVal = retVal.or(second);
        }
        return retVal;
    }

    public FilterNetworkAtomExpression or(FilterNetworkAtomExpression second) {
        FilterNetworkAtomExpression p1 = this.appropriatelyWrappedList(" OR");
        FilterNetworkAtomExpression p2 = second.appropriatelyWrappedList(" OR");
        if (p1.isEmpty()) {
            return p2;
        }
        if (p2.isEmpty()) {
            return p1;
        }
        p1.addElement(" OR");
        p1.append(p2);
        return p1;
    }

    public FilterNetworkAtomExpression and(FilterNetworkAtomExpression second) {
        FilterNetworkAtomExpression p1 = this.appropriatelyWrappedList(" AND");
        FilterNetworkAtomExpression p2 = second.appropriatelyWrappedList(" AND");
        if (p1.isEmpty()) {
            return second;
        }
        if (second.isEmpty()) {
            return this;
        }
        p1.addElement(" AND");
        p1.append(p2);
        return p1;
    }

    public FilterNetworkAtomExpression and(FilterNetworkAtomExpression second, FilterNetworkAtomExpression third) {
        if (this.isEmpty()) {
            return second.and(third);
        }
        if (third.isEmpty()) {
            return this.and(second);
        }
        if (second.isEmpty()) {
            return this.and(third);
        }
        return this.and(second.and(third));
    }

    public FilterNetworkAtomExpression appropriatelyWrappedList(String aboutToBeVERBed) {
        if (aboutToBeVERBed.equals(" AND")) {
            if (this.hasTopLevel(" OR")) {
                return this.paren();
            }
            return this;
        }
        if (aboutToBeVERBed.equals(" OR")) {
            if (this.hasTopLevel(" AND")) {
                return this.paren();
            }
            return this;
        }
        MessageHandler.addStaticError(bundle.messageString("model.appwrpWithBadParm.txt") + aboutToBeVERBed);
        return null;
    }

    private boolean hasTopLevel(String verb) {
        boolean retval = false;
        int parenLevel = 0;
        for (int i = 0; i < this.size(); ++i) {
            Object current = this.elementAt(i);
            if (current instanceof String) {
                String currentString = (String)current;
                if (currentString.equals("(")) {
                    ++parenLevel;
                    continue;
                }
                if (currentString.equals(")")) {
                    --parenLevel;
                    continue;
                }
                if (parenLevel != 0 || !currentString.equals(verb)) continue;
                return true;
            }
            if (!(current instanceof FilterNode) || parenLevel != 0) continue;
            FilterNode fn = (FilterNode)current;
            String nodeSQL = fn.generateSQLforThisNodeOnly();
            nodeSQL = nodeSQL.toUpperCase();
            String verbString = verb.trim();
            StringTokenizer st = new StringTokenizer(nodeSQL, " '()\"[]{}|^.");
            while (st.hasMoreTokens()) {
                String currentToken = st.nextToken();
                if (!currentToken.equals(verbString)) continue;
                return true;
            }
        }
        return retval;
    }

    private FilterNetworkAtomExpression paren() {
        FilterNetworkAtomExpression ret = new FilterNetworkAtomExpression();
        ret.addElement("(");
        ret.append(this);
        ret.addElement(")");
        return ret;
    }

    public void append(FilterNetworkAtomExpression newstuff) {
        for (int i = 0; i < newstuff.size(); ++i) {
            this.addElement(newstuff.elementAt(i));
        }
    }
}

