/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.models;

import com.sas.query.QueryUtils;
import com.sas.query.visuals.QueryResource;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Properties;

public class DefinedConnection {
    protected boolean m_bLocalDefinition;
    protected String m_displayString;
    protected String m_type;
    protected String m_userName;
    protected String m_password = "";
    protected String m_connectString;
    protected Properties m_extraProperties;

    public DefinedConnection() {
    }

    public DefinedConnection(QueryResource connectProperties, int index) {
        String prefix = "DefinedDataSource" + index;
        this.m_bLocalDefinition = false;
        this.m_displayString = connectProperties.getRawString(prefix + ".DisplayString.txt");
        this.m_type = connectProperties.getRawString(prefix + ".Type");
        this.m_userName = connectProperties.getRawString(prefix + ".Username");
        this.m_password = connectProperties.getRawString(prefix + ".Password");
        this.m_connectString = connectProperties.getRawString(prefix + ".ConnectString");
        this.m_extraProperties = new Properties();
        Enumeration keys = connectProperties.getKeys();
        while (keys != null && keys.hasMoreElements()) {
            String strKey = (String)keys.nextElement();
            if (strKey.equalsIgnoreCase(prefix + ".DisplayString.txt") || strKey.equalsIgnoreCase(prefix + ".Type") || strKey.equalsIgnoreCase(prefix + ".Username") || strKey.equalsIgnoreCase(prefix + ".Password") || strKey.equalsIgnoreCase(prefix + ".ConnectString") || !strKey.startsWith(prefix)) continue;
            this.m_extraProperties.put(strKey.substring(prefix.length() + 1), connectProperties.getRawString(strKey));
        }
    }

    public DefinedConnection(Properties connectProperties, int index) {
        String prefix = "DefinedDataSource" + index;
        this.m_bLocalDefinition = true;
        this.m_displayString = connectProperties.getProperty(prefix + ".DisplayString.txt");
        this.m_type = connectProperties.getProperty(prefix + ".Type");
        this.m_userName = connectProperties.getProperty(prefix + ".Username");
        this.m_password = connectProperties.getProperty(prefix + ".Password");
        this.m_connectString = connectProperties.getProperty(prefix + ".ConnectString");
        this.m_extraProperties = new Properties();
        Enumeration<Object> keys = connectProperties.keys();
        while (keys.hasMoreElements()) {
            String strKey = (String)keys.nextElement();
            if (strKey.equalsIgnoreCase(prefix + ".DisplayString.txt") || strKey.equalsIgnoreCase(prefix + ".Type") || strKey.equalsIgnoreCase(prefix + ".Username") || strKey.equalsIgnoreCase(prefix + ".Password") || strKey.equalsIgnoreCase(prefix + ".ConnectString") || !strKey.startsWith(prefix)) continue;
            this.m_extraProperties.put(strKey.substring(prefix.length() + 1), connectProperties.getProperty(strKey));
        }
    }

    public boolean equals(DefinedConnection otherObject) {
        return this.m_bLocalDefinition == otherObject.m_bLocalDefinition && this.m_displayString.equals(otherObject.m_displayString) && this.m_type.equals(otherObject.m_type) && this.m_userName.equals(otherObject.m_userName) && this.m_password.equals(otherObject.m_password) && this.m_connectString.equals(otherObject.m_connectString);
    }

    public Object clone() {
        DefinedConnection newObject = null;
        try {
            newObject = (DefinedConnection)super.clone();
        }
        catch (CloneNotSupportedException e) {
            newObject = new DefinedConnection();
        }
        newObject.m_bLocalDefinition = this.m_bLocalDefinition;
        newObject.m_displayString = this.m_displayString;
        newObject.m_type = this.m_type;
        newObject.m_userName = this.m_userName;
        newObject.m_password = this.m_password;
        newObject.m_connectString = this.m_connectString;
        newObject.m_extraProperties = this.m_extraProperties;
        return newObject;
    }

    public String toString() {
        return this.m_displayString;
    }

    public void dump(Writer output, int index) throws IOException {
        String prefix = "DefinedDataSource" + index;
        output.write("\n");
        output.write(prefix + ".DisplayString.txt=" + QueryUtils.doubleslashes(this.m_displayString));
        output.write("\n");
        output.write(prefix + ".Type=" + QueryUtils.doubleslashes(this.m_type));
        output.write("\n");
        output.write(prefix + ".Username=" + QueryUtils.doubleslashes(this.m_userName));
        output.write("\n");
        output.write(prefix + ".Password=" + QueryUtils.doubleslashes(this.m_password));
        output.write("\n");
        output.write(prefix + ".ConnectString=" + QueryUtils.doubleslashes(this.m_connectString));
        output.write("\n");
        if (this.m_extraProperties != null) {
            Enumeration<Object> keys = this.m_extraProperties.keys();
            while (keys.hasMoreElements()) {
                String strKey = (String)keys.nextElement();
                String strValue = (String)this.m_extraProperties.get(strKey);
                output.write(prefix + "." + strKey + "=" + QueryUtils.doubleslashes(strValue));
                output.write("\n");
            }
        }
    }

    public boolean isLocalDefinition() {
        return this.m_bLocalDefinition;
    }

    public String getDisplayString() {
        return this.m_displayString;
    }

    public String getType() {
        return this.m_type;
    }

    public String getUserName() {
        return this.m_userName;
    }

    public String getPassword() {
        return this.m_password;
    }

    public String getConnectString() {
        return this.m_connectString;
    }

    public Properties getConnectionProperties() {
        return this.m_extraProperties;
    }

    public void setIsLocalDefinition(boolean value) {
        this.m_bLocalDefinition = value;
    }

    public void setDisplayString(String value) {
        this.m_displayString = value;
    }

    public void setType(String value) {
        this.m_type = value;
    }

    public void setUserName(String value) {
        this.m_userName = value;
    }

    public void setPassword(String value) {
        this.m_password = value;
    }

    public void setConnectString(String value) {
        this.m_connectString = value;
    }

    public void setConnectionProperties(Properties value) {
        this.m_extraProperties = value;
    }
}

