/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.models;

import com.sas.collection.OrderedCollection;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.models.Node;
import com.sas.models.NodeInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.models.TreeInterface;
import com.sas.query.QueryException;
import com.sas.query.datasources.DataSourceColumnList;
import com.sas.query.datasources.DataSourceTable;
import com.sas.query.models.DataSourceTreeColumn;
import com.sas.query.visuals.QueryResource;
import java.io.Serializable;

public class DataSourceTreeTable
implements TreeInterface,
NodeInterface,
Serializable {
    protected DataSourceTable m_tableDataSource;
    protected String m_tableName;
    protected String m_tableLabel;
    protected OrderedCollection m_columnCollection;
    protected boolean m_bColumnsReadYet = false;
    protected boolean m_bDisplayColumns = false;
    protected static QueryResource bundle = new QueryResource(DataSourceTreeTable.class);

    public DataSourceTreeTable(DataSourceTable dataSource, boolean bDisplayColumns) {
        this.m_tableDataSource = dataSource;
        this.m_tableName = dataSource.getName();
        this.m_bDisplayColumns = bDisplayColumns;
    }

    public OrderedCollection getColumnCollection() {
        if (!this.m_bColumnsReadYet) {
            this._readColumnInfo();
        }
        return this.m_columnCollection;
    }

    protected void _readColumnInfo() {
        this.m_bColumnsReadYet = true;
        this.m_columnCollection = new OrderedCollection();
        int cColumns = this.m_tableDataSource.getColumnCount();
        DataSourceColumnList columnList = this.m_tableDataSource.getColumns();
        for (int columnIndex = 0; columnIndex < cColumns; ++columnIndex) {
            DataSourceTreeColumn column = new DataSourceTreeColumn(this, columnList.elementAt(columnIndex));
            this.m_columnCollection.add((Object)column);
        }
    }

    public DataSourceTable getDataSourceTable() {
        return this.m_tableDataSource;
    }

    public int getColumnIndexByName(String columnName) throws QueryException {
        for (int index = 0; index < this.getColumnCollection().count(); ++index) {
            DataSourceTreeColumn column = (DataSourceTreeColumn)this.getColumnCollection().get(index);
            if (!columnName.equals(column.getText())) continue;
            return index;
        }
        throw new QueryException(bundle.messageString("Exception.Metadata.Table.UnknownColumn.fmt.txt", columnName, this.getText()));
    }

    public DataSourceTreeColumn getColumnByName(String columnName) throws QueryException {
        for (int index = 0; index < this.getColumnCollection().count(); ++index) {
            DataSourceTreeColumn column = (DataSourceTreeColumn)this.getColumnCollection().get(index);
            if (!columnName.equals(column.getText())) continue;
            return column;
        }
        throw new QueryException(bundle.messageString("Exception.Metadata.Table.UnknownColumn.fmt.txt", columnName, this.getText()));
    }

    public synchronized NodeInterface getRoot() {
        Node rootN = new Node(bundle.getString("metadata.Tree.Title.txt"), "MetadataTreeModel");
        rootN.setNodeChildren((StaticOrderedCollectionInterface)this.getColumnCollection());
        return rootN;
    }

    public String getNodeExpandedText() {
        return this.m_tableName;
    }

    public String getNodeType() {
        return "DataSet";
    }

    public String getNodeText() {
        return this.m_tableName;
    }

    public int countNodeChildren(int maximumChildCount) {
        if (this.m_bDisplayColumns) {
            if (this.getColumnCollection().count() > maximumChildCount) {
                return maximumChildCount;
            }
            if (this.getColumnCollection().count() == maximumChildCount) {
                return -maximumChildCount;
            }
            return this.getColumnCollection().count();
        }
        return 0;
    }

    public int getNodeChildCount() {
        if (this.m_bDisplayColumns) {
            return this.getColumnCollection().count();
        }
        return 0;
    }

    public boolean isLeafNode() {
        return !this.m_bDisplayColumns;
    }

    public SimpleNodeInterface getNodeChild(int index) {
        if (this.m_bDisplayColumns) {
            return (SimpleNodeInterface)this.getColumnCollection().get(index);
        }
        return null;
    }

    public SimpleNodeInterface[] getNodeChildren(int startIndex, int count) {
        OrderedCollection oc;
        Object[] array;
        if (this.m_bDisplayColumns && (array = (oc = this.getChildren()).toArray()) != null) {
            NodeInterface[] sni = new NodeInterface[array.length];
            for (int i = 0; i < array.length; ++i) {
                if (!(array[i] instanceof NodeInterface)) continue;
                sni[i] = (NodeInterface)array[i];
            }
            return sni;
        }
        return null;
    }

    public OrderedCollection getChildren() {
        return this.getColumnCollection();
    }

    public String getExpandedText() {
        return this.m_tableName;
    }

    public String getText() {
        return this.m_tableName;
    }

    public boolean hasChildren() {
        return this.m_bDisplayColumns;
    }

    public void setExpandedText(String expandedText) {
    }

    public void setNodeType(String type) {
    }

    public void setText(String text) {
    }
}

