/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.models;

import com.sas.Component;
import com.sas.collection.OrderedCollection;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.models.Node;
import com.sas.models.NodeInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.models.TreeInterface;
import com.sas.query.datasources.DataSource;
import com.sas.query.datasources.DataSourceContainerList;
import com.sas.query.datasources.DataSourceTable;
import com.sas.query.models.DataSourceTreeTable;
import com.sas.query.models.ModelChangeEvent;
import com.sas.query.models.ModelChangeListener;
import com.sas.query.models.StandardModel;
import com.sas.query.visuals.QueryResource;

public class DataSourceTree
extends Component
implements ModelChangeListener,
TreeInterface,
NodeInterface {
    public static final String RootPropertyChange = "root";
    protected DataSource m_dataSource;
    protected OrderedCollection m_tableCollection;
    protected boolean m_bDisplayColumns = false;
    protected static QueryResource bundle = new QueryResource(DataSourceTree.class);
    protected String m_name = bundle.getString("dataSourceTree.Title.txt");

    public DataSourceTree(StandardModel source, DataSource dataSource, boolean bDisplayColumns) {
        this.m_dataSource = dataSource;
        this.m_bDisplayColumns = bDisplayColumns;
        if (this.m_bDisplayColumns) {
            this.m_name = bundle.getString("dataSourceTree.WithColumns.Title.txt");
        }
        source.addPropertyListener(this);
        this.refresh();
    }

    public NodeInterface getRoot() {
        Node rootN = new Node(this.m_name, "SASSystem");
        rootN.setNodeChildren((StaticOrderedCollectionInterface)this.m_tableCollection);
        return rootN;
    }

    public DataSourceTreeTable getTableByName(String tableName) {
        for (int index = 0; index < this.m_tableCollection.count(); ++index) {
            DataSourceTreeTable table = (DataSourceTreeTable)this.m_tableCollection.get(index);
            if (!tableName.equals(table.getText())) continue;
            return table;
        }
        return null;
    }

    public void refresh() {
        int cTables = this.m_dataSource.getItemCount();
        this.m_tableCollection = new OrderedCollection();
        DataSourceContainerList containerList = this.m_dataSource.getItems();
        for (int tableIndex = 0; tableIndex < cTables; ++tableIndex) {
            if (!(containerList.elementAt(tableIndex) instanceof DataSourceTable)) continue;
            DataSourceTreeTable table = new DataSourceTreeTable((DataSourceTable)containerList.elementAt(tableIndex), this.m_bDisplayColumns);
            this.m_tableCollection.add((Object)table);
        }
        this.firePropertyChange(RootPropertyChange, null, null);
    }

    public String getNodeType() {
        return "DataSource";
    }

    public String getNodeExpandedText() {
        return this.getText();
    }

    public String getNodeText() {
        return this.getText();
    }

    public int getNodeChildCount() {
        return this.m_tableCollection.count();
    }

    public OrderedCollection getChildren() {
        return this.m_tableCollection;
    }

    public String getExpandedText() {
        return this.m_name;
    }

    public String getText() {
        return this.m_name;
    }

    public boolean hasChildren() {
        return this.m_tableCollection.count() > 0;
    }

    public void setExpandedText(String expandedText) {
    }

    public void setNodeType(String type) {
    }

    public void setText(String text) {
    }

    public boolean isLeafNode() {
        return false;
    }

    public SimpleNodeInterface getNodeChild(int index) {
        return (SimpleNodeInterface)this.m_tableCollection.get(index);
    }

    public SimpleNodeInterface[] getNodeChildren(int startIndex, int count) {
        OrderedCollection oc = this.getChildren();
        Object[] array = oc.toArray();
        if (array != null) {
            NodeInterface[] sni = new NodeInterface[array.length];
            for (int i = 0; i < array.length; ++i) {
                if (!(array[i] instanceof NodeInterface)) continue;
                sni[i] = (NodeInterface)array[i];
            }
            return sni;
        }
        return null;
    }

    public int countNodeChildren(int maximumChildCount) {
        if (this.m_tableCollection.count() > maximumChildCount) {
            return maximumChildCount;
        }
        if (this.m_tableCollection.count() == maximumChildCount) {
            return -maximumChildCount;
        }
        return this.m_tableCollection.count();
    }

    @Override
    public void modelChangeCallback(ModelChangeEvent event) {
        this.refresh();
        if (event.isStructureChange()) {
            this.firePropertyChange(RootPropertyChange, null, null);
        }
    }
}

