/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.models;

import com.sas.query.Query;
import com.sas.query.datasources.Function;
import com.sas.query.models.ColumnExpression;
import com.sas.query.models.CompoundExpression;
import com.sas.query.models.Expression;
import com.sas.query.models.GroupItem;
import com.sas.query.models.GroupItemList;
import com.sas.query.models.OrderItem;
import com.sas.query.models.ResultItem;
import com.sas.query.models.ResultItemList;
import com.sas.query.models.StandardModel;
import com.sas.query.visuals.QueryResource;

public class DataItem
extends StandardModel {
    protected ResultItem m_resultItem;
    protected OrderItem m_orderItem;
    protected GroupItem m_groupItem;
    protected Expression m_expression;
    protected String m_generatedUniqueAlias;
    public static final String expressionProperty = "expression";
    static QueryResource bundle = new QueryResource(DataItem.class);
    public static final int OC_DEFAULT = 0;
    public static final int OC_ASC = 1;
    public static final int OC_DESC = 2;
    public static final int OC_MISSING = -1;

    public DataItem(Query query, Expression expression) {
        super(query);
        this.m_resultItem = null;
        this.m_orderItem = null;
        this.m_groupItem = null;
        this.m_expression = expression;
    }

    public DataItem(Query query, ResultItem resultItem) {
        super(query);
        this.m_resultItem = resultItem;
        this.m_orderItem = null;
        this.m_groupItem = null;
        this.m_expression = resultItem.getExpression();
    }

    public DataItem(Query query, OrderItem orderItem) {
        super(query);
        this.m_resultItem = null;
        this.m_orderItem = orderItem;
        this.m_groupItem = null;
        this.m_expression = orderItem.getExpression();
    }

    public DataItem(Query query, GroupItem groupItem) {
        super(query);
        this.m_resultItem = null;
        this.m_orderItem = null;
        this.m_groupItem = groupItem;
        this.m_expression = groupItem.getExpression();
    }

    public DataItem(Query query, ResultItem resultItem, OrderItem orderItem, GroupItem groupItem) {
        super(query);
        this.m_resultItem = resultItem;
        this.m_orderItem = orderItem;
        this.m_groupItem = groupItem;
        this.m_expression = resultItem.getExpression();
    }

    public String toString() {
        return this.getDisplayString();
    }

    public String getDisplayString() {
        if (this.m_resultItem != null) {
            return this.m_resultItem.getDisplayString();
        }
        if (this.m_orderItem != null) {
            return this.m_orderItem.getDisplayString();
        }
        if (this.m_groupItem != null) {
            return this.m_groupItem.getDisplayString();
        }
        if (this.m_expression != null) {
            return this.m_expression.getDisplayString();
        }
        return "";
    }

    public void deleteFromQuery() {
        if (this.m_resultItem != null) {
            this.m_query.deleteResultItem(this.m_resultItem);
        }
        if (this.m_orderItem != null) {
            this.m_query.deleteOrderItem(this.m_orderItem);
        }
        if (this.m_groupItem != null) {
            this.m_query.deleteGroupItem(this.m_groupItem);
        }
    }

    public Expression getExpression() {
        return this.m_expression;
    }

    public void setExpression(Expression expression) {
        Expression oldExpression = this.m_expression;
        this.m_expression = expression;
        if (this.m_resultItem != null) {
            this.m_resultItem.setExpression(expression);
            this.queueDataChange(4, expressionProperty, oldExpression);
        } else {
            if (this.m_orderItem != null) {
                this.m_orderItem.setExpression(expression);
                this.queueDataChange(256, expressionProperty, oldExpression);
            }
            if (this.m_groupItem != null) {
                this.m_groupItem.setExpression(expression);
                this.queueDataChange(64, expressionProperty, oldExpression);
            }
        }
    }

    public String getAlias() {
        if (this.m_resultItem != null) {
            return this.m_resultItem.getAlias();
        }
        return null;
    }

    public void setAlias(String strName) {
        if (this.m_resultItem != null) {
            if (strName != null && (strName = strName.trim()).equals("")) {
                strName = null;
            }
            this.m_resultItem.setAlias(strName);
        }
    }

    public String generateUniqueAlias() {
        String returnString = null;
        ResultItem resultItem = this.getResultItem();
        if (resultItem != null && resultItem.getAlias() != null && !this.getAlias().equals(this.m_generatedUniqueAlias)) {
            returnString = resultItem.getAlias();
        } else if (!(this.getExpression() instanceof ColumnExpression)) {
            this.m_generatedUniqueAlias = returnString = this._convertToUniqueIdentifier(this.getExpression().toString());
        }
        return returnString;
    }

    public String getGeneratedUniqueAlias() {
        return this.m_generatedUniqueAlias;
    }

    protected String _convertToUniqueIdentifier(String expressionString) {
        String returnString = "";
        boolean bPreviousWasSpace = true;
        for (int index = 0; index < expressionString.length(); ++index) {
            char tempChar = expressionString.charAt(index);
            if (Character.isLetterOrDigit(tempChar)) {
                if (bPreviousWasSpace) {
                    tempChar = Character.toUpperCase(tempChar);
                }
                returnString = returnString + tempChar;
                bPreviousWasSpace = false;
                continue;
            }
            bPreviousWasSpace = true;
        }
        returnString = returnString.length() == 0 || !Character.isLetter(returnString.charAt(0)) ? bundle.getString("DataItem.Prefix.Exp.txt") + returnString : returnString + bundle.getString("DataItem.Suffix.Exp.txt");
        returnString = this.m_query.getUniqueResultName(returnString);
        return returnString;
    }

    public String getFormat() {
        if (this.m_resultItem != null) {
            return this.m_resultItem.getFormat();
        }
        return null;
    }

    public void setLabel(String strFormat) {
        if (this.m_resultItem != null) {
            this.m_resultItem.setLabel(strFormat);
        }
    }

    public String getLabel() {
        if (this.m_resultItem != null) {
            return this.m_resultItem.getLabel();
        }
        return null;
    }

    public void setFormat(String strFormat) {
        if (this.m_resultItem != null) {
            if (strFormat != null && (strFormat = strFormat.trim()).equals("")) {
                strFormat = null;
            }
            this.m_resultItem.setFormat(strFormat);
        }
    }

    public String getInformat() {
        if (this.m_resultItem != null) {
            return this.m_resultItem.getInformat();
        }
        return null;
    }

    public void setInformat(String strFormat) {
        if (this.m_resultItem != null) {
            if (strFormat != null && (strFormat = strFormat.trim()).equals("")) {
                strFormat = null;
            }
            this.m_resultItem.setInformat(strFormat);
        }
    }

    public ResultItem getResultItem() {
        return this.m_resultItem;
    }

    public void setResultItem(ResultItem resultItem) {
        this.m_resultItem = resultItem;
        if (this.m_resultItem == null && this.m_orderItem != null) {
            try {
                this.m_orderItem.setExpression((Expression)this.m_orderItem.getResultItem().getExpression().clone());
            }
            catch (Exception e) {
                this.m_query.getMessageHandler().addInternalError(bundle.messageString("model.unableCopyRsltExpr.txt"));
            }
        }
    }

    public OrderItem getOrderItem() {
        return this.m_orderItem;
    }

    public void setOrderItem(OrderItem orderItem) {
        this.m_orderItem = orderItem;
    }

    public GroupItem getGroupItem() {
        return this.m_groupItem;
    }

    public void setGroupItem(GroupItem groupItem) {
        this.m_groupItem = groupItem;
    }

    public void group() {
        if (this.m_groupItem == null && this.m_resultItem != null) {
            int resIndex = this.m_query.getResultItems().indexOf(this.m_resultItem);
            int grpIndex = 0;
            int prevgrpIndex = 0;
            if (this.m_query.getGroupItemCount() != 0) {
                GroupItemList groupList = this.m_query.getGroupItems();
                ResultItemList resultItems = this.m_query.getResultItems();
                for (int i = resIndex - 1; i != -1; --i) {
                    ResultItem tmpResultItem = resultItems.elementAt(i);
                    for (prevgrpIndex = groupList.size() - 1; prevgrpIndex >= 0 && tmpResultItem != groupList.elementAt(prevgrpIndex).getResultItem(); --prevgrpIndex) {
                    }
                    if (prevgrpIndex == -1) continue;
                    grpIndex = prevgrpIndex;
                    break;
                }
            }
            this.m_groupItem = new GroupItem(this.m_resultItem);
            this.m_query.addGroupItem(this.m_groupItem, grpIndex);
        } else if (this.m_groupItem == null) {
            this.m_groupItem = new GroupItem(this.m_query, this.m_expression);
            this.m_query.addGroupItem(this.m_groupItem);
        }
    }

    public void group(int pos) {
        if (this.m_groupItem == null) {
            if (this.m_resultItem != null) {
                this.m_groupItem = new GroupItem(this.m_resultItem);
                this.m_query.addGroupItem(this.m_groupItem, pos);
            } else {
                this.m_groupItem = new GroupItem(this.m_query, this.m_expression);
                this.m_query.addGroupItem(this.m_groupItem, pos);
            }
        } else {
            this.m_query.moveGroupItem(this.m_query.getPositionForGroupItem(this.m_groupItem), pos);
        }
    }

    public void deleteGroupItem() {
        if (this.m_groupItem != null) {
            this.m_query.deleteGroupItem(this.m_groupItem);
            this.m_groupItem = null;
        }
    }

    public Function getAggregation() {
        if (this.m_expression.isAggregation()) {
            return ((CompoundExpression)this.m_expression).getCurrentFunction();
        }
        return null;
    }

    public boolean isAggregation() {
        return this.m_expression.isAggregation();
    }

    public void setAggregation(Function newAgg) {
        if (this.m_expression.isAggregation()) {
            this.m_expression = this.m_expression.deleteAggregation();
        }
        if (newAgg != null) {
            this.deleteGroupItem();
            this.m_expression = this.m_expression.addAggregation(newAgg);
            this.setExpression(this.m_expression);
        }
    }

    public void deleteAggregation() {
        if (this.m_expression.isAggregation()) {
            this.m_expression = this.m_expression.deleteAggregation();
        }
        this.setExpression(this.m_expression);
    }

    public void order() {
        if (this.m_orderItem == null) {
            this.m_orderItem = this.m_resultItem != null ? new OrderItem(this.m_resultItem) : new OrderItem(this.m_query, this.m_expression);
            this.m_query.addOrderItem(this.m_orderItem);
        }
    }

    public void order(int dir, int pos) {
        if (this.m_orderItem == null) {
            this.m_orderItem = this.m_resultItem != null ? new OrderItem(this.m_resultItem) : new OrderItem(this.m_query, this.m_expression);
            if (dir != -1) {
                this.m_orderItem.setSortingDirection(dir);
            }
            if (pos != -1) {
                this.m_query.addOrderItem(this.m_orderItem, pos);
            } else {
                this.m_query.addOrderItem(this.m_orderItem);
            }
        } else {
            if (dir != -1) {
                this.m_orderItem.setSortingDirection(dir);
            }
            if (pos != -1) {
                this.m_query.moveOrderItem(this.m_query.getPositionForOrderItem(this.m_orderItem), pos);
            }
        }
    }

    public void deleteOrderItem() {
        if (this.m_orderItem != null) {
            this.m_query.deleteOrderItem(this.m_orderItem);
            this.m_orderItem = null;
        }
    }

    public void result() {
        if (this.m_resultItem == null) {
            this.m_resultItem = new ResultItem(this.m_query, this.m_expression);
            this.m_query.addResultItem(this.m_resultItem, 0);
        } else if (this.m_resultItem.getExpression() != this.m_expression) {
            this.m_resultItem.setExpression(this.m_expression);
        }
    }

    public void result(int pos) {
        if (this.m_resultItem == null) {
            this.m_resultItem = new ResultItem(this.m_query, this.m_expression);
            this.m_query.addResultItem(this.m_resultItem, pos);
        } else {
            this.m_query.moveResultItem(this.m_query.getPositionForResultItem(this.m_resultItem), pos);
        }
    }

    public void deleteResultItem() {
        if (this.m_resultItem != null) {
            this.m_query.deleteResultItem(this.m_resultItem);
            this.m_resultItem = null;
        }
    }
}

