/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.models;

import com.sas.query.datasources.SqlLogic;
import com.sas.query.models.Expression;
import com.sas.query.models.ExpressionList;
import com.sas.query.models.QueryExpression;
import com.sas.query.models.UnparsedExpression;
import com.sas.query.parser.Token;

public class ConcatenatedExpression
extends Expression {
    protected ExpressionList m_expressionList = new ExpressionList();

    public ConcatenatedExpression(Expression expression) {
        this.addExpression(expression);
    }

    public ConcatenatedExpression() {
    }

    public void addExpression(Expression expression) {
        if (expression != null) {
            if (!(expression instanceof UnparsedExpression) || this.m_expressionList.size() == 0 || !(this.m_expressionList.elementAt(this.m_expressionList.size() - 1) instanceof UnparsedExpression)) {
                this.m_expressionList.addElement(expression);
            } else {
                Token newtok;
                Token tok;
                UnparsedExpression previousLast = (UnparsedExpression)this.m_expressionList.elementAt(this.m_expressionList.size() - 1);
                Object userdata = previousLast.getUserData();
                if (userdata != null && (tok = (Token)userdata).isType(22)) {
                    this.m_expressionList.addElement(expression);
                    return;
                }
                UnparsedExpression guyToAppend = (UnparsedExpression)expression;
                Object newuserdata = guyToAppend.getUserData();
                if (newuserdata != null && (newtok = (Token)newuserdata).isType(22)) {
                    this.m_expressionList.addElement(expression);
                    return;
                }
                if (!previousLast.merge(guyToAppend)) {
                    this.m_expressionList.addElement(expression);
                }
            }
        }
    }

    public void addExpression(ConcatenatedExpression expression) {
        if (expression != null) {
            for (int index = 0; index < expression.getExpressionCount(); ++index) {
                this.addExpression(expression.getExpression(index));
            }
        }
    }

    public void replaceExpression(int index, Expression expression) {
        this.m_expressionList.addElementAt(expression, index);
    }

    public Expression getExpression(int index) {
        return this.m_expressionList.elementAt(index);
    }

    public Expression getSimplestExpression() {
        if (this.getExpressionCount() == 0) {
            return null;
        }
        if (this.getExpressionCount() == 1) {
            return this.getExpression(0);
        }
        return this;
    }

    public int getExpressionCount() {
        return this.m_expressionList.size();
    }

    @Override
    public String toString() {
        String returnString = "";
        for (int index = 0; index < this.m_expressionList.size(); ++index) {
            Expression curExp = this.m_expressionList.elementAt(index);
            if (curExp instanceof UnparsedExpression) {
                UnparsedExpression unparsedGuy = (UnparsedExpression)curExp;
                Token tok = null;
                if (unparsedGuy.getUserData() != null) {
                    tok = (Token)unparsedGuy.getUserData();
                }
                if (tok != null && tok.preceededByBlank()) {
                    returnString = returnString + " ";
                }
                returnString = returnString + unparsedGuy.toString();
                continue;
            }
            returnString = returnString + curExp.toString();
        }
        return returnString;
    }

    @Override
    public String generateSQL(SqlLogic sqlLogic, int declareOrReference) {
        String returnString = null;
        if (declareOrReference == 2) {
            returnString = super.getAlias(sqlLogic);
        }
        if (returnString == null) {
            returnString = "";
            for (int index = 0; index < this.m_expressionList.size(); ++index) {
                Expression curExp = this.m_expressionList.elementAt(index);
                if (curExp instanceof QueryExpression) {
                    QueryExpression qe = (QueryExpression)curExp;
                    returnString = returnString + qe.generateSQL(sqlLogic, declareOrReference) + " ";
                    continue;
                }
                if (curExp instanceof UnparsedExpression) {
                    UnparsedExpression unparsedGuy = (UnparsedExpression)curExp;
                    Token tok = null;
                    if (unparsedGuy.getUserData() != null) {
                        tok = (Token)unparsedGuy.getUserData();
                    }
                    if (tok != null && tok.preceededByBlank() && returnString.length() > 0 && returnString.charAt(returnString.length() - 1) != ' ') {
                        returnString = returnString + " ";
                    }
                    returnString = returnString + unparsedGuy.generateSQL(sqlLogic, declareOrReference);
                    if (tok == null || !tok.followedByBlank()) continue;
                    returnString = returnString + " ";
                    continue;
                }
                returnString = returnString + curExp.generateSQL(sqlLogic, declareOrReference);
                returnString = returnString + " ";
            }
        }
        return returnString;
    }
}

