/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.models;

import com.sas.query.Query;
import com.sas.query.datasources.DataSource;
import com.sas.query.datasources.Function;
import com.sas.query.datasources.FunctionList;
import com.sas.query.datasources.SqlLogic;
import com.sas.query.models.ColumnList;
import com.sas.query.models.Expression;
import com.sas.query.models.ExpressionList;
import com.sas.query.models.FilterNodeWrapper;
import com.sas.query.models.MessageHandler;
import com.sas.query.models.RefreshMapTable;
import com.sas.query.models.UnparsedExpression;
import com.sas.query.parser.ParserException;
import com.sas.query.visuals.QueryResource;
import java.util.Vector;

public class CompoundExpression
extends Expression {
    static QueryResource bundle = new QueryResource(CompoundExpression.class);
    protected Function m_function = null;
    protected boolean m_bLogicalNegation = false;
    protected ExpressionList m_parameters = new ExpressionList();

    public CompoundExpression(Function function, ExpressionList parameters) {
        this.m_function = function;
        this.m_parameters = parameters;
    }

    public CompoundExpression(Function function, Expression parm1) {
        this.m_function = function;
        this.m_parameters = new ExpressionList();
        this.m_parameters.addElement(parm1);
    }

    public CompoundExpression(Function function, Expression parm1, Expression parm2) {
        this.m_function = function;
        this.m_parameters = new ExpressionList();
        this.m_parameters.addElement(parm1);
        this.m_parameters.addElement(parm2);
    }

    public CompoundExpression(DataSource dataSource, Expression leftExpression, String strOperator, Expression rightExpression) {
        this.m_parameters = new ExpressionList();
        this.m_parameters.addElement(leftExpression);
        this.m_parameters.addElement(rightExpression);
        FunctionList functionList = dataSource.getProperties().getAllFunctions();
        functionList = functionList.getSubset(strOperator, leftExpression.getDataType(), 32768);
        this.m_function = functionList.elementAt(0);
    }

    public int getStaticDataType() {
        return this.getCurrentFunction().getReturnType();
    }

    @Override
    public int getDataType() {
        int returnType = this.getStaticDataType();
        int bitsSet = 0;
        for (int register = returnType; register != 0; register >>= 1) {
            if ((register & 1) == 0) continue;
            ++bitsSet;
        }
        if (bitsSet < 2) {
            return returnType;
        }
        int priparmindex = this.getCurrentFunction().getPrimaryParameterIndex();
        if (priparmindex < 0 || priparmindex > this.getCurrentNumberOfParms() - 1) {
            return returnType;
        }
        Expression priparm = this.getParameter(priparmindex);
        int priparmtype = priparm.getDataType();
        if ((priparmtype | returnType) != 0) {
            return priparmtype;
        }
        return returnType;
    }

    public CompoundExpression(CompoundExpression guyToCopy) throws CloneNotSupportedException {
        super(guyToCopy);
        this.m_bLogicalNegation = guyToCopy.m_bLogicalNegation;
        if (guyToCopy.getParameters() == null) {
            this.m_parameters = null;
        } else {
            this.m_parameters = new ExpressionList();
            this.m_parameters.addClone(guyToCopy.getParameters());
        }
        this.m_function = guyToCopy.m_function;
    }

    @Override
    public FunctionList getReferencedFunctions() {
        FunctionList functionList = super.getReferencedFunctions();
        if (this.m_function != null) {
            functionList.addElement(this.m_function);
        }
        for (int index = 0; index < this.m_parameters.size(); ++index) {
            Expression temp = this.m_parameters.elementAt(index);
            if (temp == null) continue;
            FunctionList newList = temp.getReferencedFunctions();
            functionList.add(newList);
        }
        return functionList;
    }

    @Override
    public ColumnList getReferencedColumns() {
        ColumnList columnList = new ColumnList();
        for (int index = 0; index < this.m_parameters.size(); ++index) {
            Expression temp = this.m_parameters.elementAt(index);
            if (temp == null) continue;
            ColumnList newList = temp.getReferencedColumns();
            columnList.add(newList);
        }
        return columnList;
    }

    @Override
    public void refresh(DataSource dataSource, RefreshMapTable mapTable) {
        if (this.m_function != null && mapTable.containsKey(this.m_function)) {
            this.m_function = (Function)mapTable.get(this.m_function);
        }
        for (int index = 0; index < this.m_parameters.size(); ++index) {
            Expression temp = this.m_parameters.elementAt(index);
            if (temp == null) continue;
            temp.refresh(dataSource, mapTable);
        }
    }

    @Override
    public void getDefaultRefreshMapping(DataSource dataSource, RefreshMapTable mapTable) {
        if (this.m_function != null) {
            mapTable.put(this.m_function, dataSource.getProperties().getAllFunctions().findFunction(this.m_function.getFunctionType(), this.m_function.getFunctionName(), this.m_function.getPrimaryParameterType(), this.m_function.getReturnType(), this.getCurrentNumberOfParms()));
        }
        for (int index = 0; index < this.m_parameters.size(); ++index) {
            Expression temp = this.m_parameters.elementAt(index);
            if (temp == null) continue;
            temp.getDefaultRefreshMapping(dataSource, mapTable);
        }
    }

    @Override
    public boolean returnsNulls() {
        return false;
    }

    @Override
    public void replaceChildExpression(Expression fromExp, Expression toExp) {
        for (int i = 0; i < this.getCurrentNumberOfParms(); ++i) {
            if (this.getParameter(i) == fromExp) {
                this.m_parameters.setElementAt(toExp, i);
                continue;
            }
            this.getParameter(i).replaceChildExpression(fromExp, toExp);
        }
    }

    public int getCurrentNumberOfParms() {
        return this.m_parameters.size();
    }

    private int getCurrentNumberOfNonNullParms(Query query) {
        int totalSetParms = 0;
        for (int i = 0; i < this.m_parameters.size(); ++i) {
            Expression parm;
            if (this.m_parameters.elementAt(i) == null || (parm = this.m_parameters.elementAt(i)).generateSQL(query.getSqlLogic(), 2).length() <= 0) continue;
            ++totalSetParms;
        }
        return totalSetParms;
    }

    public void addParameter(Expression newParm) {
        this.m_parameters.addElement(newParm);
    }

    public void clearParms() {
        this.m_parameters.removeAllElements();
    }

    public ExpressionList getParameters() {
        return this.m_parameters;
    }

    public Expression getParameter(int i) {
        return this.m_parameters.elementAt(i);
    }

    public void setParameter(Expression exp, int i) {
        this.m_parameters.addElementAt(exp, i);
    }

    public void removeParameter(int i) {
        this.m_parameters.removeElementAt(i);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new CompoundExpression(this);
    }

    @Override
    public boolean isValid(Query query) {
        boolean retValue = false;
        retValue = true;
        if (this.getCurrentNumberOfNonNullParms(query) > this.getCurrentFunction().getMaxParms()) {
            retValue = false;
        }
        if (this.getCurrentNumberOfNonNullParms(query) < this.getCurrentFunction().getMinParms()) {
            retValue = false;
        }
        return retValue;
    }

    public boolean isNOTable() {
        return this.getCurrentFunction().isNOTable();
    }

    public boolean canNullsBeIncluded() {
        if (this.getCurrentFunction().getReturnType() != 32768) {
            return false;
        }
        if (!this.getCurrentFunction().canNullsBeIncluded()) {
            return false;
        }
        if (this.getCurrentNumberOfOperands() <= 0) {
            return true;
        }
        return this.getParameter(0).returnsNulls();
    }

    public boolean isLogicalNegation() {
        return this.m_bLogicalNegation;
    }

    public void setLogicalNegation(boolean notvalue) {
        this.m_bLogicalNegation = notvalue;
    }

    @Override
    public void toggleLogicalNegation(Function andFunction, Function orFunction) throws ParserException {
        if (this.getCurrentFunction().equals(andFunction)) {
            this.setCurrentFunction(orFunction);
            Expression parm1 = this.getParameter(0);
            Expression parm2 = this.getParameter(1);
            if (parm1 == null || parm2 == null) {
                throw new ParserException("unable to distribute logical not");
            }
            parm1.toggleLogicalNegation(andFunction, orFunction);
            parm2.toggleLogicalNegation(andFunction, orFunction);
        } else if (this.getCurrentFunction().equals(orFunction)) {
            this.setCurrentFunction(andFunction);
            Expression parm1 = this.getParameter(0);
            Expression parm2 = this.getParameter(1);
            if (parm1 == null || parm2 == null) {
                throw new ParserException("unable to distribute logical not");
            }
            parm1.toggleLogicalNegation(andFunction, orFunction);
            parm2.toggleLogicalNegation(andFunction, orFunction);
        } else {
            this.m_bLogicalNegation = !this.m_bLogicalNegation;
        }
    }

    public int getMinNumberOfOperands() {
        return this.getCurrentFunction().getMinParms();
    }

    public int getMaxNumberOfOperands() {
        return this.getCurrentFunction().getMaxParms();
    }

    public int getCurrentNumberOfOperands() {
        return this.getParameters().size();
    }

    @Override
    public String generateSQL(SqlLogic sqlLogic, int declareOrReference) {
        String returnSQL = null;
        String alias = null;
        if (declareOrReference == 2) {
            alias = super.getAlias(sqlLogic);
        }
        if (alias == null) {
            returnSQL = this.getCurrentFunction().generateSQL(this, sqlLogic, declareOrReference);
            if (this.isLogicalNegation()) {
                returnSQL = "NOT (" + returnSQL + ")";
            }
        } else {
            String prodname = sqlLogic.getQuery().getDataSource().getDatabaseProductName();
            if (prodname.equals("Sas")) {
                returnSQL = "CALCULATED " + alias;
            }
        }
        return returnSQL;
    }

    @Override
    public String toString() {
        String returnLimit = this.getCurrentFunction().getDisplayString(this);
        if (this.isLogicalNegation()) {
            returnLimit = bundle.messageString("Message.LimitString.NegateExpression.fmt.txt", returnLimit);
        }
        char[] ca = returnLimit.toCharArray();
        returnLimit = "";
        for (int i = 0; i < ca.length; ++i) {
            if (ca[i] == '\n' || ca[i] == '\r') continue;
            returnLimit = returnLimit + new Character(ca[i]);
        }
        return returnLimit;
    }

    public Function getCurrentFunction() {
        return this.m_function;
    }

    public void setCurrentFunction(Function newCurrent) {
        this.m_function = newCurrent;
    }

    @Override
    public boolean isAggregation() {
        if (this.getCurrentFunction() == null) {
            return false;
        }
        return (this.getCurrentFunction().getFunctionType() & 1) != 0;
    }

    @Override
    public String getAggregationType() {
        if (this.getCurrentFunction() == null) {
            return "";
        }
        return this.getCurrentFunction().toString();
    }

    @Override
    public boolean hasAggregation() {
        if (this.isAggregation()) {
            return true;
        }
        for (int i = 0; i < this.getParameters().size(); ++i) {
            if (this.getParameter(i) == null || !this.getParameter(i).hasAggregation()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Expression deleteAggregation() {
        if (this.isAggregation()) {
            if (this.getParameters().size() < 1) {
                return new UnparsedExpression("");
            }
            return this.getParameter(0);
        }
        MessageHandler.addStaticError(bundle.messageString("model.nonAggrExpr.txt"));
        return this;
    }

    public Vector getFormatTokens(int viewType) {
        Vector retTokens = this.m_function.getFormatTokens(viewType);
        return retTokens;
    }

    @Override
    public FilterNodeWrapper generateFilterNodes(Query query, Function andFunction, Function orFunction) {
        if (this.m_function == andFunction) {
            Expression left = this.m_parameters.elementAt(0);
            Expression right = this.m_parameters.elementAt(1);
            return FilterNodeWrapper.AND(left.generateFilterNodes(query, andFunction, orFunction), right.generateFilterNodes(query, andFunction, orFunction));
        }
        if (this.m_function == orFunction) {
            Expression left = this.m_parameters.elementAt(0);
            Expression right = this.m_parameters.elementAt(1);
            return FilterNodeWrapper.OR(left.generateFilterNodes(query, andFunction, orFunction), right.generateFilterNodes(query, andFunction, orFunction));
        }
        return super.generateFilterNodes(query, andFunction, orFunction);
    }
}

