/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.models;

import com.sas.query.QueryConfiguration;
import com.sas.query.datasources.DataSource;
import com.sas.query.datasources.SqlLogic;
import com.sas.query.models.Column;
import com.sas.query.models.ColumnList;
import com.sas.query.models.Expression;
import com.sas.query.models.MessageHandler;
import com.sas.query.models.PhysicalColumn;
import com.sas.query.models.RefreshMapTable;
import com.sas.query.visuals.QueryResource;
import java.util.Vector;

public class ColumnExpression
extends Expression {
    static QueryResource bundle = new QueryResource(ColumnExpression.class);
    protected Column m_baseColumn = null;

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new ColumnExpression(this);
    }

    public ColumnExpression() {
    }

    public ColumnExpression(Column column) {
        this.m_baseColumn = column;
    }

    public ColumnExpression(ColumnExpression guyToCopy) {
        super(guyToCopy);
        this.m_baseColumn = guyToCopy.getColumn();
    }

    @Override
    public void refresh(DataSource dataSource, RefreshMapTable mapTable) {
        if (this.m_baseColumn != null && this.m_baseColumn instanceof PhysicalColumn) {
            ((PhysicalColumn)this.m_baseColumn).refresh(dataSource, mapTable);
        }
    }

    @Override
    public void getDefaultRefreshMapping(DataSource dataSource, RefreshMapTable mapTable) {
        if (this.m_baseColumn != null && this.m_baseColumn instanceof PhysicalColumn) {
            ((PhysicalColumn)this.m_baseColumn).getDefaultRefreshMapping(dataSource, mapTable);
        }
    }

    @Override
    public ColumnList getReferencedColumns() {
        ColumnList list = new ColumnList(1);
        if (this.m_baseColumn != null) {
            list.addElement(this.m_baseColumn);
            return list;
        }
        return null;
    }

    @Override
    public int getDataType() {
        if (this.m_baseColumn == null) {
            return 0;
        }
        return this.m_baseColumn.getDataType();
    }

    @Override
    public boolean returnsNulls() {
        if (this.m_baseColumn == null) {
            MessageHandler.addStaticError(bundle.messageString("model.uninstColExpr.txt"));
            return false;
        }
        return this.m_baseColumn.isNullable();
    }

    @Override
    public String toString() {
        return this.m_baseColumn.getName();
    }

    @Override
    public String generateSQL(SqlLogic sqlLogic, int declareOrReference) {
        String retString = null;
        if (this.m_baseColumn == null) {
            MessageHandler.addStaticError(bundle.messageString("model.bugColExpr.txt"));
            return "BASE COLUMN MISSING!!!";
        }
        if (declareOrReference == 2) {
            retString = super.getAlias(sqlLogic);
        }
        if (retString == null) {
            retString = sqlLogic.genColumnName(this.m_baseColumn);
        }
        return retString;
    }

    public Vector getDistinctValues() {
        if (QueryConfiguration.getConfigurationBoolean("Queries.DistinctValues.MaximumToReturnSpecified.notrans", false)) {
            int maxDistinctValues = QueryConfiguration.getConfigurationInt("Queries.DistinctValues.MaximumReturned.num.notrans", 250);
            return this.getDistinctValues(maxDistinctValues);
        }
        return this.m_baseColumn.getDistinctValues();
    }

    public Vector getDistinctValues(int nSetSize) {
        if (this.m_baseColumn != null) {
            return this.m_baseColumn.getDistinctValueSet(nSetSize);
        }
        return null;
    }

    public boolean supportsDistinctValues() {
        if (this.m_baseColumn != null) {
            return this.m_baseColumn.supportsDistinctValues();
        }
        return false;
    }

    public Vector getNextValueSet(int nSetSize) {
        if (this.m_baseColumn != null) {
            return this.m_baseColumn.getNextValueSet(nSetSize);
        }
        return null;
    }

    public boolean isThereAnotherDistinctValue() {
        if (this.m_baseColumn != null) {
            return this.m_baseColumn.isThereAnotherDistinctValue();
        }
        return false;
    }

    public Column getColumn() {
        return this.m_baseColumn;
    }

    public void setColumn(Column column) {
        this.m_baseColumn = column;
    }
}

