/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.datasources;

import com.sas.query.datasources.DataSource;
import com.sas.query.datasources.Function;
import com.sas.query.datasources.FunctionConstants;
import com.sas.query.datasources.FunctionList;
import com.sas.query.datasources.Operator;
import com.sas.query.models.ExpressionConstants;
import java.util.Vector;

public class SqlProperties
implements FunctionConstants,
ExpressionConstants {
    public static final int TABLES = 1;
    public static final int VIEWS = 2;
    public static final int TABLES_AND_VIEWS = 3;
    public static final int SAS_DATE_STRING_FORMAT = 1;
    public static final int JDBC_DATE_STRING_FORMAT = 2;
    protected int m_dateStringFormat = 1;
    protected transient FunctionList m_allApplicable = null;
    protected transient DataSource m_dataSource = null;

    public SqlProperties(DataSource source) {
        this.m_dataSource = source;
    }

    public SqlProperties() {
    }

    public void setDataSource(DataSource source) {
        this.m_dataSource = source;
    }

    public boolean isValidIdentifier(String name) {
        boolean returnValue = true;
        if (Character.isDigit(name.charAt(0))) {
            returnValue = false;
        }
        for (int index = 0; returnValue && index < name.length(); ++index) {
            char testChar = name.charAt(index);
            if (Character.isLetterOrDigit(testChar) || testChar == '_') continue;
            returnValue = false;
        }
        return returnValue;
    }

    public int getDateStringFormat() {
        return this.m_dateStringFormat;
    }

    public void setDateStringFormat(int format) {
        this.m_dateStringFormat = format;
    }

    public boolean getAlwaysQualifyColumnNames() {
        return false;
    }

    public boolean supportsFlippedGreaterLessThanEqualInput() {
        return true;
    }

    public boolean supports_GT_LT_NE_GE_LE_EQ() {
        return true;
    }

    public String stringConcatenationOperatorName() {
        return "||";
    }

    public String logicalNotEqualsConditionalName() {
        return "<>";
    }

    public boolean supportsBarAndAmpersandForLogicalAND_OR() {
        return true;
    }

    public boolean supportsFormats() {
        return false;
    }

    public boolean supportsExecutingStatements() {
        return true;
    }

    public boolean supportsCreatingTables() {
        return true;
    }

    public boolean supportsCreatingViews() {
        return true;
    }

    public boolean supportsReplacingTables(int type) {
        return true;
    }

    public boolean supportsReplacingViews(int type) {
        return true;
    }

    public boolean supportsGettingViewSql() {
        return false;
    }

    public int getMaxColumnNameLength() {
        return 32;
    }

    public int getMaxTableNameLength() {
        return 32;
    }

    public String getCatalogSeparator() {
        return ".";
    }

    public String getUnquotedNameCharacters() {
        return "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_";
    }

    public String getIdentifierQuoteStart() {
        return "'";
    }

    public String getIdentifierQuoteEnd() {
        return "'";
    }

    public int getMaxBinaryLiteralLength() {
        return 255;
    }

    public int getMaxCharLiteralLength() {
        return 255;
    }

    public int getMaxColumnsInOrderBy() {
        return 32;
    }

    public int getMaxColumnsInGroupBy() {
        return 32;
    }

    public int getMaxStatementLength() {
        return 32000;
    }

    public int getMaxTablesInSelect() {
        return 32;
    }

    public String getSearchStringEscape() {
        return "\\";
    }

    public String getSqlKeywords() {
        return "SELECT,FROM,WHERE,GROUP,ORDER,BY,HAVING,JOIN,INNER,OUTER";
    }

    public String getJoinSideWithTable() {
        return "RIGHT";
    }

    public boolean isCatalogAtStart() {
        return false;
    }

    public boolean nullPlusNonNullIsNull() {
        return true;
    }

    public boolean storesLowerCaseIdentifiers() {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() {
        return true;
    }

    public boolean storesMixedCaseQuotedIdentifiers() {
        return true;
    }

    public boolean storesUpperCaseIdentifiers() {
        return false;
    }

    public boolean storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    public boolean supportsANSI92IntermediateSQL() {
        return false;
    }

    public boolean supportsCatalogsInDataManipulation() {
        return false;
    }

    public boolean supportsColumnAliasing() {
        return true;
    }

    public boolean supportsConvert() {
        return false;
    }

    public boolean supportsCorrelatedSubqueries() {
        return true;
    }

    public boolean supportsCoreSQLGrammar() {
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() {
        return false;
    }

    public boolean supportsExpressionsInOrderBy() {
        return true;
    }

    public boolean supportsExtendedSQLGrammar() {
        return true;
    }

    public boolean supportsFullOuterJoins() {
        return true;
    }

    public boolean supportsGroupBy() {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() {
        return true;
    }

    public boolean supportsGroupByUnrelated() {
        return true;
    }

    public boolean supportsIntegrityEnhancementFacility() {
        return true;
    }

    public boolean supportsLikeEscapeClause() {
        return true;
    }

    public boolean supportsLimitedOuterJoins() {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() {
        return true;
    }

    public boolean supportsMixedCaseIdentifiers() {
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() {
        return true;
    }

    public boolean supportsOrderByUnrelated() {
        return true;
    }

    public boolean supportsOuterJoins() {
        return true;
    }

    public boolean supportsSchemasInDataManipulation() {
        return false;
    }

    public boolean supportsSubqueriesInComparisons() {
        return true;
    }

    public boolean supportsSubqueriesInExists() {
        return true;
    }

    public boolean supportsSubqueriesInIns() {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() {
        return true;
    }

    public boolean supportsTableCorrelationNames() {
        return true;
    }

    public boolean supportsUnion() {
        return true;
    }

    public boolean supportsUnionAll() {
        return true;
    }

    public boolean supportsCStyleBlockCommentsInSQL() {
        return true;
    }

    public String[] getExcludedFunctions() {
        return null;
    }

    public FunctionList getExtendedFunctionDefinitions() {
        return null;
    }

    public FunctionList getAllFunctions() {
        return this.getAllForDataSource();
    }

    public Vector getAllFunctionCategories() {
        FunctionList allFunctionDefs = this.getAllFunctions();
        allFunctionDefs = allFunctionDefs.removeByType(12);
        return this.getAllFunctionCategories(allFunctionDefs);
    }

    public Vector getAllFunctionCategories(FunctionList allFunctionDefsToUse) {
        Vector<Integer> returnValue = new Vector<Integer>();
        for (int index = 0; index < FunctionConstants.FUNCTION_CATEGORIES.length; ++index) {
            int category = FunctionConstants.FUNCTION_CATEGORIES[index];
            if (!allFunctionDefsToUse.containsCategory(category)) continue;
            returnValue.addElement(new Integer(category));
        }
        return returnValue;
    }

    private FunctionList getAllForDataSource() {
        if (this.m_allApplicable == null) {
            this.m_allApplicable = new FunctionList();
            this.m_allApplicable.add(Operator.standardOperatorDefinitions());
            this.m_allApplicable.add(Function.standardFunctionDefinitions());
            this.m_allApplicable.merge(this.getExcludedFunctions(), this.getExtendedFunctionDefinitions());
        }
        return this.m_allApplicable;
    }
}

