/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.datasources;

import com.sas.query.Query;
import com.sas.query.QueryConfiguration;
import com.sas.query.QueryUtils;
import com.sas.query.datasources.SqlLogic;
import com.sas.query.datasources.SqlProperties;
import com.sas.query.datasources.WebAfDataSource;
import com.sas.query.models.Column;
import com.sas.query.models.Expression;
import com.sas.query.models.FilterNode;
import com.sas.query.models.ResultItem;
import com.sas.query.models.Table;
import java.util.Hashtable;

public class SasSqlLogic
extends SqlLogic {
    public SasSqlLogic(Query query, Hashtable passwordList) {
        super(query, passwordList);
    }

    public SasSqlLogic(SqlProperties sqlProperties) {
        super(sqlProperties);
    }

    public SasSqlLogic() {
    }

    @Override
    public void initProperties(SqlProperties sqlProperties) {
        super.initProperties(sqlProperties);
        String sasVersion = sqlProperties.m_dataSource.getDatabaseProductVersion();
        if (!sasVersion.substring(0, 1).equals("6")) {
            sqlProperties.m_dataSource.execute("reset dquote=ansi");
        }
    }

    @Override
    public int getJoinSuitability(Column column) {
        int confidence = super.getJoinSuitability(column);
        if (column.getSqlType() == 8) {
            confidence += JS_INT;
        }
        return confidence;
    }

    @Override
    public String genCreateView(String strQuery, String viewName, String passwordOnViewDefinition) {
        String createViewStr = null;
        strQuery = QueryUtils.formatSql(strQuery, this.m_properties.m_dataSource);
        createViewStr = "create view " + viewName;
        if (passwordOnViewDefinition != null) {
            createViewStr = createViewStr + "(ALTER=" + passwordOnViewDefinition + ")";
        }
        createViewStr = createViewStr + " as " + strQuery;
        String sasVersion = this.m_properties.m_dataSource.getDatabaseProductVersion();
        if (!sasVersion.substring(0, 1).equals("6") && !sasVersion.substring(0, 1).equals("7")) {
            createViewStr = createViewStr + " remembering ( " + WebAfDataSource.encodeQueryForRemember(strQuery, this.getQuery(), passwordOnViewDefinition) + " )";
        }
        return createViewStr;
    }

    @Override
    protected String genSQLForTable(Table table) {
        if (table == null) {
            return "";
        }
        String sqlString = super.genSQLForTable(table);
        String options = table.getDataSourceTable().getTableOptions();
        if (table.getDataSourceTable().isPasswordSet() || options.trim().length() > 0) {
            sqlString = sqlString + " (";
            if (table.getDataSourceTable().isPasswordSet()) {
                String strPassword = (String)this.m_passwordList.get(table.getDataSourceTable());
                sqlString = sqlString + "pw=" + strPassword;
            }
            if (options.trim().length() > 0) {
                sqlString = sqlString + " " + options;
            }
            sqlString = sqlString + ")";
        }
        return sqlString;
    }

    @Override
    protected String genColumnNameInSelectList(ResultItem item) {
        String sqlString = "";
        Expression expression = item.getExpression();
        sqlString = sqlString + expression.generateSQL(this, 1);
        if (item.getLabel() != null) {
            sqlString = sqlString + " LABEL='" + item.getLabel() + "'";
        }
        if (item.getFormat() != null) {
            sqlString = sqlString + " FORMAT=" + item.getFormat();
        }
        if (item.getInformat() != null) {
            sqlString = sqlString + " INFORMAT=" + item.getInformat();
        }
        return sqlString;
    }

    @Override
    public String genQuery(Query query) {
        String retString = super.genQuery(query);
        retString = QueryUtils.formatSql(retString, this.m_properties.m_dataSource);
        return retString;
    }

    @Override
    public String genQuery(Query query, FilterNode finalWhereNode, FilterNode finalHavingNode) {
        String retString = super.genQuery(query, finalWhereNode, finalHavingNode);
        retString = QueryUtils.formatSql(retString, this.m_properties.m_dataSource);
        return retString;
    }

    public String getDefaultLibraryName() {
        return QueryConfiguration.getConfigurationString("SasDefaultLibraryName.txt", "WORK");
    }

    @Override
    public String getQualifiedName(String name) {
        String qualifiedName = name.indexOf(this.getQuery().getDataSource().getProperties().getCatalogSeparator()) != -1 ? name : this.getDefaultLibraryName() + this.getQuery().getDataSource().getProperties().getCatalogSeparator() + name;
        return qualifiedName;
    }
}

