/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.datasources;

import com.sas.query.datasources.SasFormat;
import com.sas.query.models.VectorSort;
import com.sas.query.visuals.QueryResource;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class SasFormatList
implements Serializable {
    static final long serialVersionUID = -714312824608949126L;
    protected Vector m_list;
    protected static QueryResource bundle = new QueryResource(SasFormatList.class);

    public SasFormatList() {
        this.m_list = new Vector();
    }

    public SasFormatList(int initialSize) {
        this.m_list = new Vector(initialSize);
    }

    public int size() {
        return this.m_list.size();
    }

    public void sortByName() {
        VectorSort.sort(this.m_list);
    }

    public synchronized void add(SasFormat[] objArray) {
        for (int i = 0; i < objArray.length; ++i) {
            this.addElement(objArray[i]);
        }
    }

    public synchronized void add(SasFormatList newFList) {
        if (newFList == null) {
            return;
        }
        for (int index = 0; index < newFList.size(); ++index) {
            this.addElement(newFList.elementAt(index));
        }
    }

    public synchronized Enumeration elements() {
        return this.m_list.elements();
    }

    public synchronized SasFormat[] toArray() {
        Object[] returnArray = new SasFormat[this.m_list.size()];
        this.m_list.copyInto(returnArray);
        return returnArray;
    }

    public synchronized void addElement(SasFormat object) {
        this.m_list.addElement(object);
    }

    public synchronized SasFormat elementAt(int index) {
        return (SasFormat)this.m_list.elementAt(index);
    }

    public final int indexOf(SasFormat elem) {
        return this.m_list.indexOf(elem);
    }

    public final synchronized void removeAllElements() {
        this.m_list.removeAllElements();
    }

    public final boolean contains(SasFormat elem) {
        return this.m_list.contains(elem);
    }

    public final synchronized void removeElementAt(int index) {
        this.m_list.removeElementAt(index);
    }

    public final synchronized void insertElementAt(SasFormat fun, int index) {
        this.m_list.insertElementAt(fun, index);
    }

    public final synchronized boolean removeElement(SasFormat obj) {
        return this.m_list.removeElement(obj);
    }

    public synchronized SasFormatList getSubsetByDataType(int dataType) {
        SasFormatList retList = new SasFormatList();
        if (dataType == 0) {
            Enumeration e = this.elements();
            while (e.hasMoreElements()) {
                SasFormat fun = (SasFormat)e.nextElement();
                retList.addElement(fun);
            }
        } else {
            int requestedType = 2;
            if (dataType == 4) {
                requestedType = 1;
            }
            Enumeration e = this.elements();
            while (e.hasMoreElements()) {
                SasFormat fun = (SasFormat)e.nextElement();
                if (fun.getDataType() != requestedType) continue;
                retList.addElement(fun);
            }
        }
        return retList;
    }

    public synchronized SasFormatList getSubset(int category, int dataType) {
        return this.getSubsetByCategory(category).getSubsetByDataType(dataType);
    }

    public synchronized SasFormatList getSubsetByCategory(int category) {
        SasFormatList retList = new SasFormatList();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            SasFormat fun = (SasFormat)e.nextElement();
            if ((fun.getCategories() & category) == 0) continue;
            retList.addElement(fun);
        }
        return retList;
    }
}

