/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.datasources;

import com.sas.query.Query;
import com.sas.query.QueryException;
import com.sas.query.datasources.DataSource;
import com.sas.query.datasources.DataSourceColumn;
import com.sas.query.datasources.DataSourceColumnList;
import com.sas.query.datasources.DataSourceContainer;
import com.sas.query.datasources.DataSourceContainerList;
import com.sas.query.datasources.DataSourceResultSet;
import com.sas.query.datasources.DataSourceTable;
import com.sas.query.datasources.NativeSas;
import com.sas.query.datasources.RelationshipList;
import com.sas.query.datasources.SasSqlLogic;
import com.sas.query.datasources.SasSqlProperties;
import com.sas.query.datasources.SqlLogic;
import com.sas.query.datasources.SqlProperties;
import com.sas.query.models.ExpressionConstants;
import com.sas.query.models.MessageHandler;
import com.sas.query.visuals.QueryResource;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Vector;

public class NativeSasDataSource
extends DataSource
implements ExpressionConstants {
    protected String m_strName;
    protected DataSourceContainerList m_containerList;
    protected transient Hashtable m_typeInfo;
    protected transient NativeSas m_connection;
    protected int m_mapIndex;
    protected static QueryResource bundle = new QueryResource(NativeSasDataSource.class);

    public NativeSasDataSource(int mapIndex, String databaseName, MessageHandler messages) throws QueryException {
        super(messages);
        this.m_mapIndex = mapIndex;
        this.m_connection = new NativeSas();
        this.m_strName = databaseName;
        this.m_databaseProductName = "Sas";
        this.m_databaseProductVersion = "8";
        this._initialize();
    }

    @Override
    public void close() {
        this.m_connection.close(this.m_mapIndex);
    }

    public NativeSas getConnection() {
        return this.m_connection;
    }

    protected String _getDatabaseProductName() {
        this.m_databaseProductName = this.m_connection.getDatabaseProductName(this.m_mapIndex);
        this.m_databaseProductName = this.m_databaseProductName.substring(0, 1).toUpperCase() + this.m_databaseProductName.substring(1).toLowerCase();
        return "Sas";
    }

    protected String _getDatabaseProductVersion() {
        this.m_databaseProductVersion = this.m_connection.getDatabaseProductVersion(this.m_mapIndex);
        return "8";
    }

    protected void _initialize() {
        try {
            String[] libraryArray = this.m_connection.getLibraryNames(this.m_mapIndex);
            this.m_containerList = new DataSourceContainerList(libraryArray.length);
            for (int index = 0; index < libraryArray.length; ++index) {
                this.m_containerList.addElement(new NativeSasDataSourceContainer(libraryArray[index]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void initialize() {
    }

    @Override
    public String getName() {
        return this.m_strName;
    }

    @Override
    public String getQualifiedName() {
        return this.getName();
    }

    @Override
    public DataSourceContainer getParent() {
        return null;
    }

    @Override
    public SqlLogic getSqlLogic(Query query) {
        if (this.m_sqlLogicQuery == null) {
            this.m_sqlLogicQuery = new SasSqlLogic(query, this.m_passwordList);
        }
        this.m_sqlLogicQuery.setQuery(query);
        return this.m_sqlLogicQuery;
    }

    public SqlLogic getSqlLogic(SqlProperties sqlProperties) {
        if (this.m_sqlLogicProp == null) {
            this.m_sqlLogicProp = new SasSqlLogic(sqlProperties);
        }
        return this.m_sqlLogicProp;
    }

    @Override
    public SqlProperties getProperties() {
        if (this.m_properties == null) {
            this.m_properties = new SasSqlProperties(this);
        }
        return this.m_properties;
    }

    @Override
    public void execute(String executeStr) {
        this.m_connection.execute(this.m_mapIndex, executeStr);
    }

    @Override
    public DataSourceResultSet getResultSet(String strSql) {
        return null;
    }

    @Override
    public int getItemCount() {
        return this.m_containerList.size();
    }

    @Override
    public String[] getItemNames() {
        String[] tableList = new String[this.m_containerList.size()];
        for (int index = 0; index < this.m_containerList.size(); ++index) {
            tableList[index] = this.m_containerList.elementAt(index).getName();
        }
        return tableList;
    }

    @Override
    public boolean getHasMultipleLayers() {
        return true;
    }

    @Override
    public DataSourceContainerList getItems() {
        return this.m_containerList;
    }

    public class NativeSasDataSourceContainer
    extends DataSourceContainer {
        protected String m_strName;
        protected boolean m_bDetailInfoReadYet = false;
        protected int m_cTables;
        protected DataSourceContainerList m_tables;

        public NativeSasDataSourceContainer(String strName) {
            this.m_strName = strName;
            this.m_bDetailInfoReadYet = false;
        }

        @Override
        public void initialize() {
            this._readDetailInfo();
        }

        @Override
        public String getName() {
            return this.m_strName;
        }

        @Override
        public String getQualifiedName() {
            return this.getName();
        }

        @Override
        public DataSourceContainer getParent() {
            return NativeSasDataSource.this;
        }

        @Override
        public DataSourceContainerList getItems() {
            if (!this.m_bDetailInfoReadYet) {
                this.initialize();
            }
            return this.m_tables;
        }

        @Override
        public int getItemCount() {
            if (!this.m_bDetailInfoReadYet) {
                this.initialize();
            }
            return this.m_cTables;
        }

        @Override
        public String[] getItemNames() {
            String[] strList = new String[this.m_cTables];
            for (int index = 0; index < this.m_cTables; ++index) {
                strList[index] = this.m_tables.elementAt(index).getName();
            }
            return strList;
        }

        protected void _readDetailInfo() {
            this.m_tables = new DataSourceContainerList();
            this.m_bDetailInfoReadYet = true;
            this.m_tables = new DataSourceContainerList(this.getItemCount());
            try {
                String[] tableArray = NativeSasDataSource.this.m_connection.getTableNames(NativeSasDataSource.this.m_mapIndex, this.getName());
                for (int index = 0; index < tableArray.length; ++index) {
                    this.m_tables.addElement(new NativeSasDataSourceTable(tableArray[index].trim()));
                }
                this.m_cTables = this.m_tables.size();
            }
            catch (Exception ex) {
                NativeSasDataSource.this.m_messages.addInternalError(ex + ": " + ex.getMessage());
                ex.printStackTrace();
            }
        }

        public class NativeSasDataSourceTable
        extends DataSourceTable {
            protected String m_tableName;
            protected boolean m_fColumnInfoReadYet;
            protected int m_cColumns;
            protected DataSourceColumnList m_columns;

            public NativeSasDataSourceTable(String tableName) {
                this.m_tableName = tableName;
                this.m_fColumnInfoReadYet = false;
            }

            @Override
            public void initialize() {
                this._readColumnInfo();
            }

            @Override
            public String getName() {
                return this.m_tableName;
            }

            @Override
            public String getQualifiedName() {
                return this._appendName(NativeSasDataSourceContainer.this.getName(), this.getName());
            }

            @Override
            public DataSourceContainer getParent() {
                return NativeSasDataSourceContainer.this;
            }

            @Override
            public RelationshipList getRelationships() {
                return null;
            }

            protected String _appendName(String strQualifier, String strName) {
                if (strQualifier == null || strQualifier.length() == 0) {
                    return new String(strName);
                }
                return new String(strQualifier + '.' + strName);
            }

            @Override
            public DataSourceColumnList getColumns() {
                if (!this.m_fColumnInfoReadYet) {
                    this._readColumnInfo();
                }
                return this.m_columns;
            }

            @Override
            public int getColumnCount() {
                if (!this.m_fColumnInfoReadYet) {
                    this._readColumnInfo();
                }
                return this.m_cColumns;
            }

            protected void _readColumnInfo() {
                this.m_fColumnInfoReadYet = true;
                String strLibraryName = NativeSasDataSourceContainer.this.getName();
                String strTableName = this.getName();
                if (this.isPasswordSet()) {
                    String password = (String)NativeSasDataSource.this.m_passwordList.get(this);
                    strTableName = strTableName + "(PW=" + password + ")";
                }
                try {
                    String[] nameArray = NativeSasDataSource.this.m_connection.getColumnNames(NativeSasDataSource.this.m_mapIndex, strLibraryName, strTableName);
                    this.m_cColumns = nameArray.length;
                    this.m_columns = new DataSourceColumnList(this.m_cColumns);
                    for (int index = 0; index < this.m_cColumns; ++index) {
                        NativeSasDataSourceColumn returnColumn = new NativeSasDataSourceColumn(nameArray[index], 12, 32, false, false, "", "", "", "");
                        this.m_columns.addElement(returnColumn);
                    }
                }
                catch (Exception ex) {
                    NativeSasDataSource.this.m_messages.addInternalError(ex + ": " + ex.getMessage());
                }
            }

            public DataSourceColumn createColumn(String name, int type, int length, boolean nullable, boolean bIndexed, String remarks, String format, String informat, String label) {
                NativeSasDataSourceColumn returnColumn = new NativeSasDataSourceColumn(name, type, length, nullable, bIndexed, remarks, format, informat, label);
                return returnColumn;
            }

            public DataSourceColumn createColumn(String name) {
                NativeSasDataSourceColumn returnColumn = new NativeSasDataSourceColumn(name, 12, 32, false, false, "", "", "", "");
                return returnColumn;
            }

            public DataSourceColumn createColumn() {
                NativeSasDataSourceColumn returnColumn = new NativeSasDataSourceColumn("test", 12, 32, false, false, "", "", "", "");
                return returnColumn;
            }

            public class NativeSasDataSourceColumn
            extends DataSourceColumn {
                protected transient boolean m_fIsThereAnotherValue = false;
                protected transient Statement m_statement = null;
                protected transient ResultSet m_valueRowSet = null;
                protected transient String m_name;
                protected transient int m_type;
                protected transient int m_length;
                protected transient boolean m_nullable;
                protected transient boolean m_bIndexed;
                protected transient String m_remarks;
                protected transient String m_format;
                protected transient String m_informat;
                protected transient String m_label;

                public NativeSasDataSourceColumn(String name, int type, int length, boolean nullable, boolean bIndexed, String remarks, String format, String informat, String label) {
                    this.m_name = name;
                    this.m_type = type;
                    this.m_length = length;
                    this.m_nullable = nullable;
                    this.m_bIndexed = bIndexed;
                    this.m_format = format;
                    this.m_informat = informat;
                    this.m_label = label;
                    this.m_remarks = remarks != null ? remarks.trim() : remarks;
                }

                @Override
                public String getQualifiedName() {
                    return this.getParent().getQualifiedName() + "." + this.getName();
                }

                @Override
                public DataSourceTable getParent() {
                    return NativeSasDataSourceTable.this;
                }

                @Override
                public boolean isIndexed() {
                    return this.m_bIndexed;
                }

                public void setIndexed(boolean bIndexed) {
                    this.m_bIndexed = bIndexed;
                }

                @Override
                public boolean isNullable() {
                    return this.m_nullable;
                }

                @Override
                public int getLength() {
                    return this.m_length;
                }

                @Override
                public String getFormat() {
                    return this.m_format;
                }

                @Override
                public String getInformat() {
                    return this.m_informat;
                }

                @Override
                public String getName() {
                    return this.m_name;
                }

                @Override
                public String getLabel() {
                    return this.m_label;
                }

                @Override
                public int getSqlType() {
                    return this.m_type;
                }

                public boolean isSearchable() {
                    return true;
                }

                @Override
                public boolean supportsDistinctValues() {
                    return this.m_type != -4 && this.m_type != -1;
                }

                @Override
                public Vector getDistinctValues() {
                    return this.getNextValueSet(NativeSasDataSource.this.getMaximumSetSize());
                }

                @Override
                public Vector getDistinctValueSet(int nSetSize) {
                    this._closeExistingRowSet();
                    return this.getNextValueSet(nSetSize);
                }

                @Override
                public Vector getNextValueSet(int nSetSize) {
                    if (this.m_valueRowSet == null) {
                        this._getDistinctValues();
                    }
                    Vector<String> returnVector = new Vector<String>();
                    for (int index = 0; index < nSetSize && this.isThereAnotherDistinctValue(); ++index) {
                        String temp = this._getNextValue();
                        if (temp == null) continue;
                        returnVector.addElement(temp);
                    }
                    return returnVector;
                }

                public String _getNextValue() {
                    while (this.m_valueRowSet != null && this.m_fIsThereAnotherValue) {
                        try {
                            String temp = this.m_valueRowSet.getString(1);
                            this.m_fIsThereAnotherValue = this.m_valueRowSet.next();
                            if (temp == null) continue;
                            return temp.trim();
                        }
                        catch (NullPointerException e) {
                            this.m_fIsThereAnotherValue = false;
                        }
                        catch (Exception ex) {
                            this.m_fIsThereAnotherValue = false;
                            NativeSasDataSource.this.m_messages.addWarning(ex + ": " + ex.getMessage());
                        }
                    }
                    return null;
                }

                @Override
                public boolean isThereAnotherDistinctValue() {
                    return this.m_fIsThereAnotherValue;
                }

                protected void _getDistinctValues() {
                    String strQuery = "";
                    try {
                        strQuery = "SELECT DISTINCT ";
                        strQuery = strQuery + NativeSasDataSource.this.getSqlLogic(NativeSasDataSource.this.getProperties()).genIdentifier(this.getParent().getName());
                        strQuery = strQuery + ".";
                        strQuery = strQuery + NativeSasDataSource.this.getSqlLogic(NativeSasDataSource.this.getProperties()).genIdentifier(this.getName());
                        strQuery = strQuery + " FROM ";
                        strQuery = strQuery + NativeSasDataSource.this.getSqlLogic(NativeSasDataSource.this.getProperties()).genIdentifier(NativeSasDataSourceContainer.this.getName());
                        strQuery = strQuery + ".";
                        String tableName = this.getParent().getName();
                        if (this.getParent().isPasswordSet()) {
                            String password = (String)NativeSasDataSource.this.m_passwordList.get(this.getParent());
                            tableName = tableName + "(PW=" + password + ")";
                        }
                        strQuery = strQuery + NativeSasDataSource.this.getSqlLogic(NativeSasDataSource.this.getProperties()).genIdentifier(tableName);
                    }
                    catch (Exception ex) {
                        NativeSasDataSource.this.m_messages.addInternalError(bundle.messageString("Message.DataSource.getDistinctVals.txt") + ex.getMessage() + "\n\t" + strQuery);
                    }
                }

                protected void _closeExistingRowSet() {
                    if (this.m_valueRowSet == null) {
                        return;
                    }
                    try {
                        this.m_valueRowSet.close();
                        this.m_valueRowSet = null;
                        this.m_statement.close();
                        this.m_statement = null;
                    }
                    catch (Exception ex) {
                        this.m_valueRowSet = null;
                        this.m_statement = null;
                        NativeSasDataSource.this.m_messages.addWarning(ex + ": " + ex.getMessage());
                    }
                }
            }
        }
    }
}

