/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.datasources;

import com.sas.query.datasources.DataSourceResultSet;
import com.sas.query.datasources.JdbcDataSource;
import com.sas.query.models.MessageHandler;
import com.sas.query.visuals.QueryResource;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class JdbcResultSet
extends DataSourceResultSet {
    protected String m_strSql;
    protected Connection m_connection;
    protected transient Statement m_statement = null;
    protected transient ResultSet m_rowSet = null;
    protected transient ResultSetMetaData m_rowSetMetaData = null;
    protected transient int m_cColumns = 0;
    protected transient int m_cRows = -1;
    protected static QueryResource bundle = new QueryResource(JdbcResultSet.class);

    public JdbcResultSet(String strSql, JdbcDataSource dataSource, MessageHandler messageHandler) {
        super(dataSource, messageHandler);
        this.m_strSql = strSql;
        this.m_connection = dataSource.getConnection();
        if (this.m_messageHandler.failureHasOccurred()) {
            return;
        }
    }

    @Override
    public void close() {
        this.m_cache.clear();
        try {
            if (this.m_rowSet != null) {
                this.m_rowSet.close();
                this.m_rowSet = null;
            }
        }
        catch (Exception e) {
            this.m_messageHandler.addInternalError(bundle.messageString("closingRsltSet.fmt.txt", e.getMessage()));
        }
        try {
            if (this.m_statement != null) {
                this.m_statement.close();
                this.m_statement = null;
            }
        }
        catch (Exception e) {
            this.m_messageHandler.addInternalError(bundle.messageString("closingStmt.fmt.txt", e.getMessage()));
        }
    }

    @Override
    public void initialize() {
        this._prefetchData();
        this._initialize();
    }

    protected void _prefetchData() {
        try {
            this.m_statement = this.m_connection.createStatement();
            this.m_rowSet = this.m_statement.executeQuery(this.m_strSql);
            this.m_rowSetMetaData = this.m_rowSet.getMetaData();
            this.m_cColumns = this.m_rowSetMetaData.getColumnCount();
            this.m_cRows = 0;
            while (this.m_rowSet.next()) {
                Object[] rowArray = new Object[this.m_cColumns];
                for (int index = 0; index < this.m_cColumns; ++index) {
                    rowArray[index] = this.m_rowSet.getObject(index + 1);
                }
                ++this.m_cRows;
                this.m_cache.put(new Integer(this.m_cRows), rowArray);
            }
        }
        catch (SQLException e) {
            this.m_messageHandler.addError(e.getMessage());
        }
        catch (OutOfMemoryError e) {
            this.m_messageHandler.addError(bundle, "JdbcResultSet.Message.memoryError.txt");
        }
        catch (Exception e) {
            this.m_messageHandler.addInternalError(e.getMessage());
        }
        if (this.m_messageHandler.failureHasOccurred()) {
            this.m_cache.clear();
            this.m_cRows = 0;
            this.m_cColumns = 0;
        }
    }

    @Override
    public int countColumns(int maxCount) {
        return this.m_cColumns;
    }

    @Override
    public int countRows(int maxCount) {
        return this.m_cRows == -1 ? 0 : this.m_cRows;
    }

    public Object[][] getCells(int startRowIndex, int startColumnIndex, int rowCount, int columnCount) {
        return null;
    }

    public Class getCellClass(int rowIndex, int columnIndex) {
        return null;
    }

    public Class[][] getCellClasses(int startRowIndex, int startColumnIndex, int rowCount, int columnCount) {
        return null;
    }

    public Object[] getColumn(int index) {
        return null;
    }

    public int getColumnCount() {
        return this.m_cColumns;
    }

    @Override
    public Object[] getRow(int index) {
        return null;
    }

    @Override
    public int getRowCount() {
        return -1;
    }

    @Override
    public boolean isColumnLabelsSupported() {
        return true;
    }

    @Override
    public String getColumnLabel(int index) {
        try {
            return this.m_rowSetMetaData.getColumnLabel(index);
        }
        catch (SQLException e) {
            this.m_messageHandler.addInternalError(e.getMessage());
            return null;
        }
    }

    @Override
    public String getColumnName(int index) {
        try {
            return this.m_rowSetMetaData.getColumnName(index);
        }
        catch (SQLException e) {
            this.m_messageHandler.addInternalError(e.getMessage());
            return null;
        }
    }

    @Override
    public Object[] getColumnLabels(int startIndex, int count) {
        return null;
    }

    public boolean isColumnsLabelSupported() {
        return false;
    }

    protected void _initialize() {
    }

    @Override
    public boolean _getNextRow() {
        ++this.m_rowIndex;
        return this.m_rowIndex < this.m_cRows;
    }
}

