/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.datasources;

import com.sas.query.datasources.FunctionConstants;
import com.sas.query.models.ConstantExpression;
import com.sas.query.models.ExpressionConstants;
import java.io.Serializable;

public class FunctionParameter
implements Cloneable,
Serializable,
FunctionConstants,
ExpressionConstants {
    static final long serialVersionUID = -4544969794546441031L;
    protected String m_strName;
    protected String m_strTooltip;
    protected int m_nType;
    protected boolean m_isOptional;
    protected boolean m_commalist;
    protected int m_restrictions;
    protected String[] m_choiceList;

    public FunctionParameter(String strName, String descript, int nType) {
        this.m_strName = strName;
        this.m_strTooltip = descript;
        this.m_nType = nType;
        this.m_isOptional = false;
        this.m_commalist = false;
        this.m_restrictions = 0;
        this.m_choiceList = null;
    }

    public FunctionParameter(String strName, int nType, String descript) {
        this.m_strName = strName;
        this.m_strTooltip = descript;
        this.m_nType = nType;
        this.m_isOptional = false;
        this.m_commalist = false;
        this.m_restrictions = 0;
        this.m_choiceList = null;
    }

    public FunctionParameter(String strName, int nType, String descript, boolean opt) {
        this.m_strName = strName;
        this.m_strTooltip = descript;
        this.m_nType = nType;
        this.m_isOptional = opt;
        this.m_commalist = false;
        this.m_restrictions = 0;
        this.m_choiceList = null;
    }

    public FunctionParameter(String strName, int nType, String descript, boolean isopt, boolean iscommalist, int nRestrict, String[] choicelist) {
        this.m_strName = strName;
        this.m_strTooltip = descript;
        this.m_nType = nType;
        this.m_isOptional = isopt;
        this.m_commalist = iscommalist;
        this.m_restrictions = nRestrict;
        this.m_choiceList = choicelist;
    }

    public Object clone() throws CloneNotSupportedException {
        Object oNewGuy = super.clone();
        FunctionParameter newguy = (FunctionParameter)oNewGuy;
        newguy.m_strName = this.m_strName;
        newguy.m_strTooltip = this.m_strTooltip;
        newguy.m_nType = this.m_nType;
        newguy.m_isOptional = this.m_isOptional;
        newguy.m_commalist = this.m_commalist;
        newguy.m_restrictions = this.m_restrictions;
        newguy.m_choiceList = (String[])this.m_choiceList.clone();
        return newguy;
    }

    public ConstantExpression generateTemplate() {
        ConstantExpression retValue = null;
        if (this.getType() == 0) {
            retValue = this.isOptional() ? new ConstantExpression("<value>", 0, true) : new ConstantExpression("<optionalValue>", 0, true);
        } else if (this.getType() == 1) {
            retValue = this.isOptional() ? new ConstantExpression("<optionalBitValue>", 1, true) : new ConstantExpression("<bitValue>", 1, true);
        } else if (this.getType() == 2) {
            retValue = this.isOptional() ? new ConstantExpression("<optionalNumValue>", 2, true) : new ConstantExpression("<numValue>", 2, true);
        } else if (this.getType() == 4) {
            retValue = this.isOptional() ? new ConstantExpression("<optionalCharValue>", 4, true) : new ConstantExpression("<charValue>", 4, true);
        } else if (this.getType() == 8) {
            String tempVal = "<{";
            for (int i = 0; i < this.getChoiceList().length; ++i) {
                tempVal = tempVal + this.getChoiceList()[i];
                if (i == this.getChoiceList().length - 1) continue;
                tempVal = tempVal + "|";
            }
            tempVal = tempVal + "}>";
            retValue = new ConstantExpression(tempVal, 8, true);
        } else {
            retValue = this.getType() == 16 ? (this.isOptional() ? new ConstantExpression("<optionalDateValue>", 16, true) : new ConstantExpression("<dateValue>", 16, true)) : (this.getType() == 32 ? (this.isOptional() ? new ConstantExpression("<optionalTimeValue>", 32, true) : new ConstantExpression("<timeValue>", 32, true)) : (this.getType() == 64 ? (this.isOptional() ? new ConstantExpression("<optionalTimestampValue>", 64, true) : new ConstantExpression("<timestampValue>", 64, true)) : (this.getType() == 128 ? (this.isOptional() ? new ConstantExpression("<optionalIntervalValue[ym]>", 128, true) : new ConstantExpression("<intervalValue[ym]>", 128, true)) : (this.getType() == 256 ? (this.isOptional() ? new ConstantExpression("<optionalIntervalValue[dt]>", 256, true) : new ConstantExpression("<intervalValue[dt]>", 256, true)) : (this.getType() == 32768 ? (this.isOptional() ? new ConstantExpression("<optionalBooleanValue>", 32768, true) : new ConstantExpression("<booleanValue>", 32768, true)) : (this.isOptional() ? new ConstantExpression("<optionalVal>", 0) : new ConstantExpression("<val>", 0)))))));
        }
        retValue.setType(0);
        return retValue;
    }

    public int getType() {
        return this.m_nType;
    }

    public boolean isOptional() {
        return this.m_isOptional;
    }

    public boolean isCommaList() {
        return this.m_commalist;
    }

    public String getName() {
        return this.m_strName;
    }

    public String getDescription() {
        return this.m_strTooltip;
    }

    public String[] getChoiceList() {
        return this.m_choiceList;
    }

    public int getRestrictions() {
        return this.m_restrictions;
    }

    public boolean hasRestrictions() {
        return this.m_restrictions == 0;
    }

    public boolean hasChoiceList() {
        return this.getChoiceList() != null;
    }
}

