/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.datasources;

import com.sas.query.datasources.DataSource;
import com.sas.query.models.MessageHandler;
import java.util.Hashtable;

public abstract class DataSourceResultSet {
    protected transient DataSource m_dataSource;
    protected transient boolean m_bEof = false;
    protected transient boolean m_bCanceled = false;
    protected transient int m_rowIndex = 0;
    protected transient Hashtable m_cache = new Hashtable();
    protected transient MessageHandler m_messageHandler;

    public DataSourceResultSet(DataSource dataSource, MessageHandler messageHandler) {
        this.m_dataSource = dataSource;
        this.m_messageHandler = messageHandler;
    }

    public abstract void close();

    public synchronized void cancel() {
        this.m_bCanceled = true;
    }

    public boolean isCanceled() {
        return this.m_bCanceled;
    }

    public void initialize() {
    }

    public int countColumns(int maxCount) {
        return 0;
    }

    public int countRows(int maxCount) {
        return 0;
    }

    public Object getCell(int rowIndex, int columnIndex) {
        while (rowIndex > this.m_rowIndex && !this.m_bEof) {
            this._getNextRow();
        }
        if (rowIndex > this.m_rowIndex) {
            return null;
        }
        Object[] rowArray = (Object[])this.m_cache.get(new Integer(rowIndex));
        return rowArray[columnIndex - 1];
    }

    public Object[] getRow(int index) {
        return null;
    }

    public int getRowCount() {
        return -1;
    }

    public boolean isColumnLabelsSupported() {
        return false;
    }

    public String getColumnLabel(int index) {
        return null;
    }

    public String getColumnName(int index) {
        return null;
    }

    public Object[] getColumnLabels(int startIndex, int count) {
        return null;
    }

    public abstract boolean _getNextRow();
}

