/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.datasources;

import com.sas.query.Query;
import com.sas.query.QueryConfiguration;
import com.sas.query.QueryException;
import com.sas.query.datasources.DataSourceColumn;
import com.sas.query.datasources.DataSourceColumnList;
import com.sas.query.datasources.DataSourceContainer;
import com.sas.query.datasources.DataSourceContainerList;
import com.sas.query.datasources.DataSourceResultSet;
import com.sas.query.datasources.DataSourceTable;
import com.sas.query.datasources.SqlLogic;
import com.sas.query.datasources.SqlProperties;
import com.sas.query.models.FilterNode;
import com.sas.query.models.MessageHandler;
import com.sas.query.visuals.ConnectionPropertiesDefiner;
import com.sas.query.visuals.QueryResource;
import java.awt.Frame;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Hashtable;

public abstract class DataSource
extends DataSourceContainer {
    protected transient MessageHandler m_messages;
    protected transient Hashtable m_passwordList = new Hashtable();
    protected SqlLogic m_sqlLogicProp = null;
    protected SqlLogic m_sqlLogicQuery = null;
    protected SqlProperties m_properties;
    static QueryResource bundle = new QueryResource(DataSource.class);
    protected String m_databaseProductName;
    protected String m_databaseProductVersion;
    protected String m_name;
    protected String m_description;
    protected int m_limits = 0;

    public DataSource() throws QueryException {
        this.m_messages = new MessageHandler();
    }

    public DataSource(MessageHandler messages) throws QueryException {
        this.m_messages = messages;
    }

    public abstract void close();

    public abstract SqlLogic getSqlLogic(Query var1);

    public boolean supportsSingleThreadDataAccessOnly() {
        return false;
    }

    public abstract SqlProperties getProperties();

    public abstract void execute(String var1);

    public boolean isValidSql(Query query) {
        return true;
    }

    public int getMaximumSetSize() {
        int maxSetSize = QueryConfiguration.getConfigurationInt("Queries.SetSize.Maximum.num.notrans", 500000);
        return maxSetSize;
    }

    public void submit(String strQuery) {
        this.submit(strQuery, new OutputStreamWriter(System.out));
    }

    public String getDatabaseProductName() {
        return this.m_databaseProductName;
    }

    public String getDatabaseProductVersion() {
        return this.m_databaseProductVersion;
    }

    public MessageHandler getMessageHandler() {
        return this.m_messages;
    }

    public void setMessageHandler(MessageHandler messages) {
        this.m_messages = messages;
    }

    public void submit(String strQuery, String outFile) {
        try {
            FileWriter outWriter = new FileWriter(outFile);
            this.submit(strQuery, outWriter);
        }
        catch (IOException e) {
            this.m_messages.addError(e, bundle.messageString("Message.OutputFileProblem.Open.fmt.txt", outFile));
        }
    }

    public void submit(String strQuery, Writer outWriter) {
    }

    public DataSourceResultSet getResultSet(String strQuery) {
        return null;
    }

    public DataSourceResultSet getFormattedResultSet(Query query, FilterNode finalWhereNode, FilterNode finalHavingNode) {
        return this.getResultSet(query.getSql(finalWhereNode, finalHavingNode));
    }

    public void createTable(String strQuery, String tableName) {
        String createTabStr = this.m_sqlLogicQuery.genCreateTable(strQuery, tableName);
        this.execute(createTabStr);
    }

    public void createView(String strQuery, String viewName, String passwordOnViewDef) {
        if (this.getProperties().supportsCreatingViews()) {
            String createViewStr = this.m_sqlLogicQuery.genCreateView(strQuery, viewName, passwordOnViewDef);
            this.execute(createViewStr);
        } else {
            this.m_messages.addError(bundle.messageString("Message.DataSource.noViewCreate.fmt.txt", new String(this.m_databaseProductName)));
        }
    }

    public String getViewSql(Frame parentFrame, boolean promptForPasswords, String qualifiedViewName, Query query) {
        return this.getViewSql(parentFrame, promptForPasswords, qualifiedViewName, query, null);
    }

    public String getViewSql(Frame parentFrame, boolean promptForPasswords, String qualifiedViewName, Query query, String password) {
        return null;
    }

    public boolean getHasMultipleLayers() {
        return false;
    }

    public DataSourceTable getTable(String strQualifiedTableName) {
        int pos = strQualifiedTableName.lastIndexOf(".");
        if (pos == -1) {
            DataSourceContainerList children = this.getItems();
            for (int index = 0; index < children.size(); ++index) {
                DataSourceContainer child = children.elementAt(index);
                if (!(child instanceof DataSourceTable) || !child.getName().equalsIgnoreCase(strQualifiedTableName)) continue;
                return (DataSourceTable)child;
            }
            return null;
        }
        try {
            DataSourceContainerList children = this.getItems();
            for (int index = 0; index < children.size(); ++index) {
                DataSourceContainer child = children.elementAt(index);
                if (!child.getName().equalsIgnoreCase(strQualifiedTableName.substring(0, pos))) continue;
                DataSourceContainerList tableList = child.getItems();
                for (int tableIndex = 0; tableIndex < tableList.size(); ++tableIndex) {
                    DataSourceContainer table = tableList.elementAt(tableIndex);
                    if (!(table instanceof DataSourceTable) || !table.getName().equalsIgnoreCase(strQualifiedTableName.substring(pos + 1))) continue;
                    return (DataSourceTable)table;
                }
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public DataSourceColumn getColumn(String strQualifiedColumnName) {
        String separatorString = this.getProperties().getCatalogSeparator();
        int pos = strQualifiedColumnName.lastIndexOf(separatorString);
        if (pos == -1) {
            return null;
        }
        try {
            DataSourceTable table = this.getTable(strQualifiedColumnName.substring(0, pos));
            if (table == null) {
                return null;
            }
            String strColumnName = strQualifiedColumnName.substring(pos + 1);
            DataSourceColumnList columnList = table.getColumns();
            for (int index = 0; index < columnList.size(); ++index) {
                DataSourceColumn column = columnList.elementAt(index);
                if (!column.getName().equals(strColumnName)) continue;
                return column;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void setLimits(int limits) {
        this.m_limits = limits;
    }

    public int getLimits() {
        return this.m_limits;
    }

    public void addPassword(String strQualifiedTableName, String strPassword) {
        this.addPassword(this.getTable(strQualifiedTableName), strPassword);
    }

    public void addPassword(DataSourceTable table, String strPassword) {
        this.m_passwordList.put(table, strPassword);
    }

    public boolean isPasswordSet(DataSourceTable table) {
        return this.m_passwordList.containsKey(table);
    }

    public void clearPassword(DataSourceTable table) {
        this.m_passwordList.remove(table);
    }

    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public String getDescription() {
        return this.m_description;
    }

    public ConnectionPropertiesDefiner getConnectionPropertiesDefiner() {
        return null;
    }

    @Override
    public void refresh() {
    }
}

