/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.datasources;

import com.sas.query.datasources.CustomDataSourceTable;
import com.sas.query.datasources.DataSourceColumn;
import com.sas.query.datasources.DataSourceTable;
import java.io.Serializable;

class CustomDataSourceColumn
extends DataSourceColumn
implements Serializable {
    protected CustomDataSourceTable m_parent;
    protected int m_length;
    protected String m_name;
    protected String m_label;
    protected int m_type;
    protected String m_format;
    protected boolean m_nullable;

    private CustomDataSourceColumn() {
    }

    public CustomDataSourceColumn(CustomDataSourceTable parent, String name, String label, int type, int length, String format, boolean nullable) {
        this.m_parent = parent;
        this.m_length = length;
        this.m_name = name;
        this.m_label = label;
        this.m_type = type;
        this.m_format = format;
        this.m_nullable = nullable;
    }

    @Override
    public String getQualifiedName() {
        return this.getParent().getQualifiedName() + "." + this.getName();
    }

    @Override
    public DataSourceTable getParent() {
        return this.m_parent;
    }

    @Override
    public int getLength() {
        return this.m_length;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public int getSqlType() {
        return this.m_type;
    }

    @Override
    public String getLabel() {
        return this.m_label;
    }

    @Override
    public String getFormat() {
        return this.m_format;
    }

    @Override
    public boolean isNullable() {
        return this.m_nullable;
    }

    protected static int _mapStringToSqlType(String strType) {
        int retType = 0;
        retType = strType.equalsIgnoreCase("bit") ? -7 : (strType.equalsIgnoreCase("char") ? 1 : (strType.equalsIgnoreCase("longvarchar") ? -1 : (strType.equalsIgnoreCase("varchar") ? 12 : (strType.equalsIgnoreCase("date") ? 91 : (strType.equalsIgnoreCase("bigint") ? -5 : (strType.equalsIgnoreCase("binary") ? -2 : (strType.equalsIgnoreCase("decimal") ? 3 : (strType.equalsIgnoreCase("double") ? 8 : (strType.equalsIgnoreCase("float") ? 6 : (strType.equalsIgnoreCase("integer") ? 4 : (strType.equalsIgnoreCase("longvarbinary") ? -4 : (strType.equalsIgnoreCase("tinyint") ? -6 : (strType.equalsIgnoreCase("varbinary") ? -3 : (strType.equalsIgnoreCase("numeric") ? 2 : (strType.equalsIgnoreCase("real") ? 7 : (strType.equalsIgnoreCase("smallint") ? 5 : (strType.equalsIgnoreCase("time") ? 92 : (strType.equalsIgnoreCase("timestamp") ? 93 : 1111))))))))))))))))));
        return retType;
    }

    protected static String _mapSqlTypeToString(int sqlType) {
        String retType = null;
        switch (sqlType) {
            case -7: {
                retType = "bit";
                break;
            }
            case 1: {
                retType = "char";
                break;
            }
            case -1: {
                retType = "longvarchar";
                break;
            }
            case 12: {
                retType = "varchar";
                break;
            }
            case 91: {
                retType = "date";
                break;
            }
            case -5: {
                retType = "bigint";
                break;
            }
            case -2: {
                retType = "binary";
                break;
            }
            case 3: {
                retType = "decimal";
                break;
            }
            case 8: {
                retType = "double";
                break;
            }
            case 6: {
                retType = "float";
                break;
            }
            case 4: {
                retType = "integer";
                break;
            }
            case -4: {
                retType = "longvarbinary";
                break;
            }
            case -6: {
                retType = "tinyint";
                break;
            }
            case -3: {
                retType = "varbinary";
                break;
            }
            case 2: {
                retType = "numeric";
                break;
            }
            case 7: {
                retType = "real";
                break;
            }
            case 5: {
                retType = "smallint";
                break;
            }
            case 92: {
                retType = "time";
                break;
            }
            case 93: {
                retType = "timestamp";
                break;
            }
            default: {
                retType = "unknown";
            }
        }
        return retType;
    }
}

