/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.datasources;

import com.sas.query.Query;
import com.sas.query.QueryException;
import com.sas.query.datasources.CustomDataSourceTable;
import com.sas.query.datasources.CustomSqlProperties;
import com.sas.query.datasources.DataSource;
import com.sas.query.datasources.DataSourceColumn;
import com.sas.query.datasources.DataSourceColumnList;
import com.sas.query.datasources.DataSourceContainer;
import com.sas.query.datasources.DataSourceContainerList;
import com.sas.query.datasources.DataSourceTable;
import com.sas.query.datasources.DataSourceTableList;
import com.sas.query.datasources.FunctionList;
import com.sas.query.datasources.SqlLogic;
import com.sas.query.datasources.SqlProperties;
import com.sas.query.models.Column;
import com.sas.query.models.ColumnList;
import com.sas.query.models.ExpressionList;
import com.sas.query.models.MessageHandler;
import com.sas.query.models.PhysicalColumn;
import com.sas.query.visuals.QueryResource;
import java.io.Serializable;

public class CustomDataSource
extends DataSource
implements Serializable {
    static final long serialVersionUID = 8910352929448790660L;
    protected DataSourceContainerList m_tables = new DataSourceContainerList();
    protected transient SqlProperties m_properties;
    protected static QueryResource bundle = new QueryResource(CustomDataSource.class);

    public CustomDataSource() throws QueryException {
        super(new MessageHandler());
        this.m_properties = new SqlProperties(this);
    }

    public CustomDataSource(Query query, DataSource dso, MessageHandler messages) throws QueryException {
        super(messages);
        this.m_messages = messages;
        DataSourceTableList tableList = query.getDataSourceTables();
        for (int index = 0; index < tableList.size(); ++index) {
            DataSourceTable table = tableList.elementAt(index);
            this.addTable(table.getName(), table.getQualifiedName());
        }
        CustomSqlProperties properties = new CustomSqlProperties(this);
        this.m_properties = properties;
        ExpressionList expressionList = query.getExpressions();
        for (int index = 0; index < expressionList.size(); ++index) {
            FunctionList functionList = expressionList.elementAt(index).getReferencedFunctions();
            properties.addFunctions(functionList);
            ColumnList columnList = expressionList.elementAt(index).getReferencedColumns();
            for (int columnIndex = 0; columnList != null && columnIndex < columnList.size(); ++columnIndex) {
                Column logicalColumn = columnList.elementAt(columnIndex);
                DataSourceColumn column = ((PhysicalColumn)logicalColumn).getDataSourceColumn();
                this.addColumn(column.getParent().getQualifiedName(), column.getName(), column.getLabel(), column.getSqlType(), column.getLength(), column.getFormat(), column.isNullable());
            }
        }
    }

    @Override
    public void close() {
        this.m_tables = null;
        this.m_properties = null;
    }

    @Override
    public void initialize() {
    }

    @Override
    public String getQualifiedName() {
        return this.getName();
    }

    @Override
    public DataSourceContainer getParent() {
        return null;
    }

    @Override
    public String getName() {
        return "Custom DataSource";
    }

    @Override
    public SqlLogic getSqlLogic(Query query) {
        return new SqlLogic(query, this.m_passwordList);
    }

    @Override
    public SqlProperties getProperties() {
        return this.m_properties;
    }

    @Override
    public void execute(String executeStr) {
    }

    @Override
    public DataSourceTable getTable(String strQualifiedTableName) {
        DataSourceContainerList tableList = this.getItems();
        for (int index = 0; index < tableList.size(); ++index) {
            DataSourceTable table = (DataSourceTable)tableList.elementAt(index);
            if (!table.getQualifiedName().equals(strQualifiedTableName)) continue;
            return table;
        }
        return null;
    }

    @Override
    public DataSourceColumn getColumn(String strQualifiedColumnName) {
        String separatorString = this.getProperties().getCatalogSeparator();
        int pos = strQualifiedColumnName.lastIndexOf(separatorString);
        if (pos == -1) {
            return null;
        }
        DataSourceTable table = this.getTable(strQualifiedColumnName.substring(0, pos));
        if (table == null) {
            return null;
        }
        String strColumnName = strQualifiedColumnName.substring(pos + 1);
        DataSourceColumnList columnList = table.getColumns();
        for (int index = 0; index < columnList.size(); ++index) {
            DataSourceColumn column = columnList.elementAt(index);
            if (!column.getName().equals(strColumnName)) continue;
            return column;
        }
        return null;
    }

    @Override
    public int getItemCount() {
        return this.m_tables.size();
    }

    @Override
    public String[] getItemNames() {
        String[] names = new String[this.m_tables.size()];
        for (int index = 0; index < this.m_tables.size(); ++index) {
            CustomDataSourceTable table = (CustomDataSourceTable)this.m_tables.elementAt(index);
            names[index] = table.getName();
        }
        return names;
    }

    @Override
    public DataSourceContainerList getItems() {
        return this.m_tables;
    }

    public void addTable(String name, String qualifiedName) {
        CustomDataSourceTable table = this._tableForName(qualifiedName);
        if (table != null) {
            this.m_messages.addError(bundle.messageString("Message.DataSource.tableExists.fmt.txt", name));
            return;
        }
        this.m_tables.addElement(new CustomDataSourceTable(this, name, qualifiedName));
    }

    public void addColumn(String qualifiedTableName, String name, String label, int type, int length, String format, boolean nullable) {
        CustomDataSourceTable table = this._tableForName(qualifiedTableName);
        if (table == null) {
            this.m_messages.addError(bundle.messageString("Message.DataSource.noTable.txt") + qualifiedTableName);
            return;
        }
        table.addColumn(name, label, type, length, format, nullable);
    }

    protected CustomDataSourceTable _tableForName(String qualifiedName) {
        for (int index = 0; index < this.m_tables.size(); ++index) {
            CustomDataSourceTable table = (CustomDataSourceTable)this.m_tables.elementAt(index);
            if (!qualifiedName.equals(table.getQualifiedName())) continue;
            return table;
        }
        return null;
    }
}

