/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.datasources;

import com.sas.query.Query;
import com.sas.query.datasources.SqlLogic;
import com.sas.query.datasources.SqlProperties;
import com.sas.query.models.Join;
import com.sas.query.models.JoinList;
import com.sas.query.models.JoinRelationshipList;
import java.util.Hashtable;

public class AccessSqlLogic
extends SqlLogic {
    public AccessSqlLogic(Query query, Hashtable passwordList) {
        super(query, passwordList);
    }

    public AccessSqlLogic(SqlProperties sqlProperties) {
        super(sqlProperties);
    }

    public AccessSqlLogic() {
    }

    @Override
    public String genCreateTable(String strQuery, String tableName) {
        String selectStr = strQuery.substring(0, strQuery.indexOf(" FROM "));
        String fromStr = strQuery.substring(strQuery.indexOf(" FROM "));
        String createTabStr = selectStr + " INTO " + tableName + fromStr;
        return createTabStr;
    }

    @Override
    protected String genSQLForJoin(JoinList joinList) {
        String sqlString = "";
        String groupString = "";
        for (int i = 0; i < joinList.size(); ++i) {
            Join join = joinList.elementAt(i);
            if (join.getNewJoinGroupValue()) {
                sqlString = sqlString + groupString;
                groupString = "";
                if (i > 0) {
                    sqlString = sqlString + ", ";
                }
                String leftTableString = this.genSQLForTable(join.getTable());
                groupString = groupString + leftTableString;
                if (i != joinList.size() - 1) continue;
                sqlString = sqlString + groupString;
                continue;
            }
            int joinType = join.getJoinType();
            JoinRelationshipList conditions = join.getRelationships();
            if (conditions.size() == 0) {
                groupString = groupString + ", ";
            } else if (joinType == 0) {
                groupString = joinList.elementAt(i - 1).getNewJoinGroupValue() ? " INNER JOIN " + groupString : " INNER JOIN (" + groupString;
            } else if (joinType == 1) {
                groupString = joinList.elementAt(i - 1).getNewJoinGroupValue() ? " RIGHT JOIN " + groupString : " RIGHT JOIN (" + groupString;
            } else if (joinType == 2) {
                groupString = joinList.elementAt(i - 1).getNewJoinGroupValue() ? " LEFT JOIN " + groupString : " LEFT JOIN (" + groupString;
            } else if (joinType == 3) {
                groupString = joinList.elementAt(i - 1).getNewJoinGroupValue() ? " FULL JOIN " + groupString : " FULL JOIN (" + groupString;
            }
            String rightTableString = this.genSQLForTable(join.getTable());
            groupString = rightTableString + groupString;
            for (int j = 0; j < conditions.size(); ++j) {
                groupString = j == 0 ? groupString + " ON " : groupString + " AND ";
                groupString = groupString + conditions.elementAt(j).getComparisonDetails().generateSQL(this, 1);
            }
            if (conditions.size() > 0 && i != joinList.size() - 1 && !joinList.elementAt(i + 1).getNewJoinGroupValue()) {
                groupString = groupString + ") ";
            }
            if (i != joinList.size() - 1) continue;
            sqlString = sqlString + groupString;
        }
        return sqlString;
    }

    @Override
    public String getQualifiedName(String name) {
        return name;
    }
}

