/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.app;

import com.sas.query.Query;
import com.sas.query.models.ModelChangeEvent;
import com.sas.query.models.ModelChangeListener;
import com.sas.query.visuals.QueryResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class WatcherDialog
extends JDialog
implements ModelChangeListener {
    Query m_query;
    protected static QueryResource bundle = new QueryResource(WatcherDialog.class);
    boolean fComponentsAdjusted = false;
    JTextArea eventLogTextArea;
    JButton closeButton;
    JTextArea sqlTextArea;
    JLabel label1;
    JLabel label2;
    JLabel dataSourceLabel;
    JTextField dataSourceTextField;

    public WatcherDialog(Query query, Frame parent, boolean modal) {
        super(parent, modal);
        this.m_query = query;
        query.addPropertyListener(this, 65535);
        this.setLayout(null);
        this.setBounds(565, 320, 430, 408);
        this.setBackground(new Color(0xC0C0C0));
        this.eventLogTextArea = new JTextArea();
        this.eventLogTextArea.setBounds(24, 236, 400, 120);
        this.add(this.eventLogTextArea);
        this.closeButton = new JButton("Close");
        this.closeButton.setBounds(328, 368, 84, 28);
        this.add(this.closeButton);
        this.sqlTextArea = new JTextArea();
        this.sqlTextArea.setBounds(24, 48, 400, 120);
        this.add(this.sqlTextArea);
        this.label1 = new JLabel("Current SQL Representation:");
        this.label1.setBounds(12, 24, 204, 28);
        this.add(this.label1);
        this.label2 = new JLabel("Event Log:");
        this.label2.setBounds(12, 210, 100, 28);
        this.add(this.label2);
        this.dataSourceLabel = new JLabel("DataSource:");
        this.dataSourceLabel.setBounds(12, 180, 84, 28);
        this.add(this.dataSourceLabel);
        this.dataSourceTextField = new JTextField();
        this.dataSourceTextField.setBounds(108, 180, 400, 24);
        this.add(this.dataSourceTextField);
        this.setTitle("Watcher");
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymAction lSymAction = new SymAction();
        this.closeButton.addActionListener(lSymAction);
        this.dataSourceTextField.setText(query.getDataSource().getName());
    }

    @Override
    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        this.setSize(this.getInsets().left + this.getInsets().right + d.width, this.getInsets().top + this.getInsets().bottom + d.height);
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            p.translate(this.getInsets().left, this.getInsets().top);
            components[i].setLocation(p);
        }
        this.fComponentsAdjusted = true;
    }

    public WatcherDialog(Query query, Frame parent, String title, boolean modal) {
        this(query, parent, modal);
        this.setTitle(title);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            Rectangle bounds = this.getParent().getBounds();
            Rectangle abounds = this.getBounds();
            this.setLocation(bounds.x + (bounds.width - abounds.width) / 2, bounds.y + (bounds.height - abounds.height) / 2);
        }
        super.setVisible(b);
    }

    void Dialog1_WindowClosing(WindowEvent event) {
        this.setVisible(false);
    }

    void closeButton_ActionPerformed(ActionEvent event) {
        this.setVisible(false);
    }

    public synchronized void refresh() {
        this.sqlTextArea.setText("");
        this.m_query.validateQuery();
        if (this.m_query.getMessageHandler().failureHasOccurred()) {
            this.sqlTextArea.append(bundle.messageString("missingInfo.txt") + this.m_query.getMessageHandler().getOneBigMessage());
            return;
        }
        this.sqlTextArea.append(this.m_query.getSql());
        if (this.m_query.getMessageHandler().failureHasOccurred()) {
            this.sqlTextArea.append(bundle.messageString("unableGenSQL.txt") + this.m_query.getMessageHandler().getOneBigMessage());
            return;
        }
        this.dataSourceTextField.setText(this.m_query.getDataSource().getName());
    }

    @Override
    public void modelChangeCallback(ModelChangeEvent event) {
        this.refresh();
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == WatcherDialog.this) {
                WatcherDialog.this.Dialog1_WindowClosing(event);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == WatcherDialog.this.closeButton) {
                WatcherDialog.this.closeButton_ActionPerformed(event);
            }
        }
    }
}

