/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.app;

import com.sas.query.app.AppSupport;
import com.sas.query.models.ModelChangeEvent;
import com.sas.query.models.ModelChangeListener;
import com.sas.query.visuals.ImageHandler;
import com.sas.query.visuals.MenuUtil;
import com.sas.query.visuals.MessageUtil;
import com.sas.query.visuals.QueryResource;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.util.MissingResourceException;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

public abstract class StandardAction
extends AbstractAction
implements ModelChangeListener {
    public static final String KEY_NAME = "PropertyKeyName";
    protected transient String m_keyName;
    protected transient String m_name;
    protected transient String m_mneumonic;
    protected transient String m_tooltip;
    protected transient ImageIcon m_icon;
    protected transient AppSupport m_app;
    protected transient boolean m_bListenerAdded = false;
    protected boolean m_changedVetoed;

    public StandardAction(AppSupport app, String name) {
        super(name);
        this.m_app = app;
        this.m_keyName = name;
        this.m_name = this._getResourceString(name + ".Label.txt");
        this.m_mneumonic = this._getResourceString(name + ".Accelerator.txt");
        String strIcon = this._getResourceString(name + "Image");
        if (strIcon != null) {
            QueryResource images = new QueryResource(MenuUtil.class);
            this.m_icon = ImageHandler.getImageIcon(images, strIcon);
        }
        this.m_tooltip = this._getResourceString(name + ".Tooltip.txt");
        this.setEnabled(true);
        this.putValue("LongDescription", this.m_tooltip);
        this.putValue("SmallIcon", this.m_icon);
        this.putValue("ShortDescription", this.m_tooltip);
        this.putValue("Name", this.m_name);
        this.putValue(KEY_NAME, this.m_keyName);
        if (this.m_mneumonic != null) {
            this.putValue("MnemonicKey", new Integer(this.m_mneumonic.charAt(0)));
        }
        this._addListener();
        this._setState();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.m_changedVetoed = false;
        try {
            this.m_app.fireVetoableChange(this.m_name, null, null);
        }
        catch (PropertyVetoException e) {
            this.m_changedVetoed = true;
        }
    }

    public void setApp(AppSupport app) {
        if (this.m_app != null) {
            this._removeListener();
        }
        this.m_app = app;
        this._addListener();
    }

    protected void displayMessages() {
        MessageUtil.displayMessages(this.m_app.getQuery().getMessageHandler());
    }

    @Override
    public void modelChangeCallback(ModelChangeEvent event) {
        this._setState();
    }

    protected void _setState() {
    }

    protected void _addListener() {
        if (!this.m_bListenerAdded && this.m_app.getQuery() != null) {
            this.m_app.getQuery().addPropertyListener(this);
            this.m_bListenerAdded = true;
            this._setState();
        }
    }

    protected void _removeListener() {
        if (this.m_bListenerAdded && this.m_app.getQuery() != null) {
            this.m_app.getQuery().removePropertyListener(this);
            this.m_bListenerAdded = false;
        }
    }

    protected String _getResourceString(String nm) {
        String str;
        try {
            str = AppSupport.bundle.getRawString(nm);
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }
}

