/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.app;

import com.sas.query.Query;
import com.sas.query.QueryDefiner;
import com.sas.query.QueryException;
import com.sas.query.app.WatcherDialog;
import com.sas.query.datasources.DataSource;
import com.sas.query.datasources.JdbcDataSource;
import com.sas.query.models.MessageHandler;
import com.sas.query.models.Table;
import com.sas.query.visuals.MenuUtil;
import com.sas.query.visuals.MessageUtil;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.ResultDialog;
import com.sas.query.visuals.ResultPanel;
import com.sas.query.visuals.SqlPanel;
import com.sas.query.visuals.StandardView;
import com.sas.query.visuals.SummaryView;
import com.sas.query.visuals.UnionListView;
import com.sas.query.visuals.WindowUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;

class QueryTestApp2
extends StandardView {
    QueryResource bundle = new QueryResource(QueryTestApp2.class);
    DataSource m_dataSource;
    QueryDefiner m_queryDefiner;
    protected Component m_panel;
    protected JPanel m_mainPanel;
    protected JTabbedPane m_unionPane;
    protected ResultPanel m_unionResultPanel;
    protected SqlPanel m_unionSqlPanel;
    protected Hashtable m_menuItems;
    protected JMenuBar m_menubar;
    protected JToolBar m_toolbar;
    protected Vector m_viewList = new Vector();
    private Hashtable m_commands;
    public static final String viewSqlAction = "viewSql";
    public static final String viewWatchAction = "viewWatch";
    public static final String makeUnionAction = "makeUnion";
    private Action[] m_defaultActions = new Action[]{new ViewSqlAction(), new MakeUnionAction()};

    QueryTestApp2() {
        super((Query)null);
        JdbcDataSource dataSource;
        MessageHandler messages = new MessageHandler();
        System.out.println("null constructor");
        Properties properties = new Properties();
        try {
            dataSource = new JdbcDataSource("sun.jdbc.odbc.JdbcOdbcDriver", "jdbc:odbc:NorthWind", properties, messages);
        }
        catch (QueryException e) {
            dataSource = null;
            messages.addError(e.getMessage());
        }
        MessageUtil.displayAndExitOnError(messages);
        this.m_query = new Query((DataSource)dataSource, messages);
        this.commonInit();
        Table logicalTable = this.m_query.addTable("Employees");
        this.m_query.addResultItems(logicalTable);
        this.displayMessages();
    }

    QueryTestApp2(Query query) {
        super(query);
        this.commonInit();
    }

    public void commonInit() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exc) {
            System.out.println("Error loading L&F: " + exc);
        }
        this.setLayout(new BorderLayout());
        this.setBackground(Color.lightGray);
        this.m_commands = new Hashtable();
        Action[] actions = this.m_defaultActions;
        for (int i = 0; i < actions.length; ++i) {
            Action a = actions[i];
            this.m_commands.put(a.getValue("Name"), a);
        }
        this.m_menuItems = new Hashtable();
        this.m_menubar = MenuUtil.createMenubar(this.bundle, "menubar", this.m_menuItems, this.m_commands);
        try {
            this.m_queryDefiner = new QueryDefiner(this.m_query, 65, 0);
            this.displayAndExitOnError();
            this.m_dataSource = this.m_query.getDataSource();
            this.m_query.addPropertyListener(this, 512);
            SummaryView summary = new SummaryView(this.m_query, 39);
            this.add("North", summary);
            this.m_panel = new QueryTabView(this.m_query);
            this.m_viewList.addElement(this.m_panel);
            this.m_mainPanel = new JPanel();
            this.m_mainPanel.setLayout(new BorderLayout());
            this.m_mainPanel.add("Center", this.m_panel);
            this.add("Center", this.m_mainPanel);
        }
        catch (Throwable t) {
            System.out.println("uncaught exception: " + t);
            t.printStackTrace();
        }
    }

    @Override
    public void closing() {
    }

    public static void main(String[] args) {
        MessageHandler m_messages = new MessageHandler();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exc) {
            System.out.println("Error loading L&F: " + exc);
        }
        try {
            JFrame frame = new JFrame();
            Properties properties = new Properties();
            JdbcDataSource dataSource = new JdbcDataSource("sun.jdbc.odbc.JdbcOdbcDriver", "jdbc:odbc:NorthWind", properties, m_messages);
            MessageUtil.displayAndExitOnError(m_messages);
            Query query = new Query((DataSource)dataSource, m_messages);
            QueryTestApp2 queryTest = new QueryTestApp2(query);
            frame.setBackground(Color.lightGray);
            frame.getContentPane().add("Center", queryTest);
            frame.pack();
            frame.setSize(800, 610);
            frame.setTitle("Query Test Two");
            frame.addWindowListener(new AppCloser());
            frame.show();
        }
        catch (Throwable t) {
            System.out.println("uncaught exception: " + t);
            t.printStackTrace();
        }
    }

    public void refreshUnions() {
        if (this.m_unionPane == null) {
            return;
        }
        for (Query query = this.m_query; query != null; query = query.getUnion()) {
            boolean bExists = false;
            for (int index = 0; index < this.m_viewList.size(); ++index) {
                if (((QueryTabView)this.m_viewList.elementAt(index)).getQuery() != query) continue;
                bExists = true;
                break;
            }
            if (bExists) continue;
            int tabCount = this.m_unionPane.getTabCount();
            this.m_unionPane.removeTabAt(tabCount - 1);
            this.m_unionPane.removeTabAt(tabCount - 2);
            QueryTabView view = new QueryTabView(query);
            this.m_unionPane.addTab("Select " + this.m_unionPane.getTabCount(), view);
            this.m_viewList.addElement(view);
            query.addPropertyListener(this, 512);
            this.m_unionPane.addTab("Results", this.m_unionResultPanel);
            this.m_unionPane.addTab("SQL", this.m_unionSqlPanel);
        }
    }

    class ViewSqlAction
    extends AbstractAction {
        ViewSqlAction() {
            super(QueryTestApp2.viewSqlAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ResultDialog resultDialog = new ResultDialog(QueryTestApp2.this.getQuery(), WindowUtil.getParentFrame(QueryTestApp2.this), false);
            resultDialog.show();
        }
    }

    class MakeUnionAction
    extends AbstractAction {
        MakeUnionAction() {
            super(QueryTestApp2.makeUnionAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (QueryTestApp2.this.getQuery().getUnion() != null) {
                return;
            }
            QueryTestApp2.this.m_mainPanel.remove(QueryTestApp2.this.m_panel);
            Query newQuery = new Query(QueryTestApp2.this.m_dataSource, QueryTestApp2.this.getQuery().getMessageHandler());
            newQuery.addPropertyListener(QueryTestApp2.this, 512);
            QueryTestApp2.this.getQuery().addUnion(newQuery, 0);
            QueryTestApp2.this.m_unionPane = new JTabbedPane();
            QueryTestApp2.this.m_unionPane.addTab("Union", new UnionListView(QueryTestApp2.this.getQuery(), null, QueryTestApp2.this.m_unionPane));
            QueryTestApp2.this.m_unionPane.addTab("Select 1", QueryTestApp2.this.m_panel);
            QueryTabView view = new QueryTabView(newQuery);
            QueryTestApp2.this.m_viewList.addElement(view);
            QueryTestApp2.this.m_unionPane.addTab("Select 2", view);
            QueryTestApp2.this.m_unionResultPanel = new ResultPanel(QueryTestApp2.this.getQuery());
            QueryTestApp2.this.m_unionPane.addTab("Results", QueryTestApp2.this.m_unionResultPanel);
            QueryTestApp2.this.m_unionSqlPanel = new SqlPanel(QueryTestApp2.this.getQuery());
            QueryTestApp2.this.m_unionPane.addTab("SQL", QueryTestApp2.this.m_unionSqlPanel);
            JPanel spacerPanel = new JPanel();
            spacerPanel.setLayout(new BorderLayout());
            spacerPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
            spacerPanel.add("Center", QueryTestApp2.this.m_unionPane);
            QueryTestApp2.this.m_mainPanel.add("Center", spacerPanel);
            QueryTestApp2.this.m_mainPanel.validate();
        }
    }

    class QueryTabView
    extends JPanel {
        protected Query m_query;
        protected JTabbedPane m_tabbedPane;
        protected ResultPanel m_resultPanel;
        protected SqlPanel m_sqlPanel;

        public QueryTabView(Query query) {
            this.m_query = query;
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
            this.m_tabbedPane = new JTabbedPane();
            try {
                this.m_tabbedPane.addTab("Tables & Joins", new QueryDefiner(query, 34, 0));
                this.m_tabbedPane.addTab("Data Items", new QueryDefiner(query, 320, 0));
                this.m_tabbedPane.addTab("Data Filters", new QueryDefiner(query, 65, 0));
                this.m_tabbedPane.addTab("Group Filters", new JLabel("Not implemented"));
                this.m_tabbedPane.setEnabledAt(3, false);
                this.m_resultPanel = new ResultPanel(query);
                this.m_tabbedPane.addTab("Results", this.m_resultPanel);
                this.m_sqlPanel = new SqlPanel(query);
                this.m_tabbedPane.addTab("SQL", this.m_sqlPanel);
            }
            catch (Throwable t) {
                System.out.println("uncaught exception: " + t);
                t.printStackTrace();
            }
            this.add(this.m_tabbedPane);
        }

        public Query getQuery() {
            return this.m_query;
        }
    }

    protected static final class AppCloser
    extends WindowAdapter {
        protected AppCloser() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }
    }

    class ViewWatchAction
    extends AbstractAction {
        ViewWatchAction() {
            super(QueryTestApp2.viewWatchAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WatcherDialog watchDialog = new WatcherDialog(QueryTestApp2.this.getQuery(), WindowUtil.getParentFrame(QueryTestApp2.this), false);
            watchDialog.show();
        }
    }
}

