/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.app;

import com.sas.query.Query;
import com.sas.query.QueryDefiner;
import com.sas.query.QueryException;
import com.sas.query.app.QueryFrame;
import com.sas.query.datasources.DataSource;
import com.sas.query.datasources.DataSourceList;
import com.sas.query.datasources.DummyDataSource;
import com.sas.query.datasources.JdbcDataSource;
import com.sas.query.models.ConstantExpression;
import com.sas.query.models.MessageHandler;
import com.sas.query.models.RefreshMapTable;
import com.sas.query.models.ResultItem;
import com.sas.query.visuals.AddTableDialog;
import com.sas.query.visuals.MessageUtil;
import com.sas.query.visuals.QueryComponentDialog;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.ResultItemPropertyView;
import com.sas.query.visuals.WindowUtil;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Properties;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;

class QueryTestApp
extends JPanel
implements PropertyChangeListener {
    private static QueryResource resources = new QueryResource(QueryTestApp.class);
    protected Frame m_frame;
    protected DataSourceList m_dataSourceList = new DataSourceList();
    protected MessageHandler m_messages = new MessageHandler();
    protected int m_nCurrentDataSource;
    protected Query m_query;
    protected JDesktopPane m_layeredPane;
    protected FileDialog m_fileDialog = null;

    QueryTestApp(Frame frame) {
        this.m_frame = frame;
        this.setLayout(new BorderLayout());
        try {
            DataSource dso = new DummyDataSource("", "");
            Properties properties = new Properties();
            dso = new JdbcDataSource("sun.jdbc.odbc.JdbcOdbcDriver", "jdbc:odbc:NorthWind", properties, this.m_messages);
            if (this.m_messages.failureHasOccurred()) {
                System.exit(0);
            }
            this.m_dataSourceList.addElement(dso);
            this.setCurrentDataSource(dso);
            this.m_layeredPane = new JDesktopPane();
            this.add(this.m_layeredPane);
            this.showNewQuery(new Query(this.getCurrentDataSource(), this.m_messages));
        }
        catch (Throwable t) {
            System.out.println("uncaught exception: " + t);
            t.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exc) {
            System.out.println("Error loading L&F: " + exc);
        }
        try {
            JFrame frame = new JFrame();
            QueryTestApp queryTest = new QueryTestApp(frame);
            frame.setBackground(Color.lightGray);
            frame.getContentPane().add("Center", queryTest);
            frame.pack();
            frame.setSize(880, 550);
            frame.setTitle("Query Test One");
            frame.setDefaultCloseOperation(0);
            frame.addWindowListener(new AppCloser());
            frame.show();
            JInternalFrame[] frames = queryTest.m_layeredPane.getAllFrames();
            queryTest.m_layeredPane.getDesktopManager().maximizeFrame(frames[0]);
        }
        catch (Throwable t) {
            System.out.println("uncaught exception: " + t);
            t.printStackTrace();
        }
    }

    public Frame getFrame() {
        return this.m_frame;
    }

    public Query getCurrentQuery() {
        return this.m_query;
    }

    public void setCurrentQuery(Query query) {
        this.m_query = query;
    }

    public DataSourceList getDataSources() {
        return this.m_dataSourceList;
    }

    public DataSource getCurrentDataSource() {
        return this.m_dataSourceList.elementAt(this.m_nCurrentDataSource);
    }

    public void setCurrentDataSource(DataSource dso) {
        this.m_nCurrentDataSource = this.m_dataSourceList.indexOf(dso);
    }

    public void insertTable() {
        AddTableDialog dialog = new AddTableDialog(this.m_query, this.m_frame);
        dialog.show();
    }

    public void insertResultItem() {
        ResultItem item = new ResultItem(this.m_query, new ConstantExpression());
        ResultItemPropertyView propertyPanel = new ResultItemPropertyView(this.m_query, item);
        QueryComponentDialog editDialog = new QueryComponentDialog(WindowUtil.getParentFrame(this), this.m_query, propertyPanel, "BUG - need Prefix");
        editDialog.setModal(true);
        editDialog.pack();
        editDialog.setVisible(true);
        if (editDialog.getReturnValue() == 1) {
            this.m_query.addResultItem(item);
        }
        propertyPanel.closing();
    }

    public void showSqlDialog() {
    }

    protected void showNewQuery(Query newQuery) {
        try {
            QueryFrame queryFrame;
            if (newQuery == null) {
                newQuery = new Query(this.getCurrentDataSource(), this.m_messages);
                queryFrame = new QueryFrame(this, newQuery);
            } else {
                queryFrame = new QueryFrame(this, newQuery);
            }
            queryFrame.addPropertyChangeListener(this);
            this.m_layeredPane.add((Component)queryFrame, 5);
            queryFrame.setTitle("Query Test One");
        }
        catch (Throwable t) {
            System.out.println("uncaught exception: " + t);
            t.printStackTrace();
        }
    }

    public void readQueryFromFile() {
        if (this.m_fileDialog == null) {
            this.m_fileDialog = new FileDialog(this.m_frame);
        }
        this.m_fileDialog.setMode(0);
        this.m_fileDialog.show();
        String file = this.m_fileDialog.getFile();
        if (file == null) {
            return;
        }
        String directory = this.m_fileDialog.getDirectory();
        File requestedFile = new File(directory, file);
        if (requestedFile.exists()) {
            try {
                FileInputStream in = new FileInputStream(requestedFile);
                ObjectInputStream s2 = new ObjectInputStream(in);
                Query newQuery = (Query)s2.readObject();
                JdbcDataSource dataSource = new JdbcDataSource("Northwind", null, this.m_messages);
                RefreshMapTable mapTable = newQuery.getDefaultRefreshMapping(dataSource);
                newQuery.setDataSource(dataSource, mapTable);
                this.showNewQuery(newQuery);
            }
            catch (ClassNotFoundException exception) {
                System.err.println("ClassNotFoundException.\n" + exception.getMessage());
                return;
            }
            catch (IOException exception) {
                System.err.println("IOException.\n" + exception.getMessage());
                return;
            }
            catch (QueryException e) {
                System.err.println("QueryException.\n" + e.getMessage());
            }
        }
    }

    public void saveQueryToFile(Query query) {
        if (this.m_fileDialog == null) {
            this.m_fileDialog = new FileDialog(this.m_frame);
        }
        this.m_fileDialog.setMode(0);
        this.m_fileDialog.show();
        String file = this.m_fileDialog.getFile();
        if (file == null) {
            return;
        }
        String directory = this.m_fileDialog.getDirectory();
        File requestedFile = new File(directory, file);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(requestedFile);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(query);
            objectOutputStream.flush();
        }
        catch (IOException exception) {
            System.err.println("IOException.\n" + exception.getMessage());
            return;
        }
    }

    public void shutdown() {
        int nChoice = JOptionPane.showConfirmDialog(null, "Save changes to ...?", "Exit QueryTestApp", 1, 2);
        if (nChoice == 0) {
            this.saveQueryToFile(this.getCurrentQuery());
        } else if (nChoice == 2 || nChoice == -1) {
            return;
        }
        System.exit(0);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if (propertyName == null) {
            return;
        }
        if (propertyName.equals("selected") && ((Boolean)e.getNewValue()).booleanValue()) {
            this.setCurrentQuery(((QueryFrame)e.getSource()).getQuery());
        }
    }

    protected static final class AppCloser
    extends WindowAdapter {
        protected AppCloser() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }
    }

    protected class CloneHandler
    implements ActionListener {
        QueryDefiner m_queryDefiner;

        CloneHandler(QueryDefiner queryDefiner) {
            this.m_queryDefiner = queryDefiner;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            QueryDefiner cloneDefiner = null;
            try {
                cloneDefiner = (QueryDefiner)this.m_queryDefiner.clone();
                this.showClone(cloneDefiner);
            }
            catch (CloneNotSupportedException e) {
                System.err.println("Clone not supported.\n" + e.getMessage());
                return;
            }
        }

        protected void showClone(QueryDefiner cloneDefiner) {
            try {
                String vers = System.getProperty("java.version");
                if (vers.compareTo("1.1.3") < 0) {
                    System.out.println("!!!WARNING: Must be run with a 1.1.3 or higher version VM!!!");
                }
                Frame frame = new Frame();
                frame.setBackground(Color.lightGray);
                Panel panel = new Panel();
                panel.setLayout(new BorderLayout());
                panel.add("Center", cloneDefiner);
                Button showSQLButton = new Button("Show SQL");
                panel.add("South", showSQLButton);
                showSQLButton.addActionListener(new SQLButtonHandler(cloneDefiner));
                Button cloneButton = new Button("Clone");
                panel.add("North", cloneButton);
                cloneButton.addActionListener(new CloneHandler(cloneDefiner));
                frame.add("Center", panel);
                frame.pack();
                frame.setTitle("Query Test One - clone");
                frame.addWindowListener(new AppCloser());
                frame.show();
            }
            catch (Throwable t) {
                System.out.println("uncaught exception: " + t);
                t.printStackTrace();
            }
        }
    }

    protected class SQLButtonHandler
    implements ActionListener {
        QueryDefiner m_queryDefiner;

        SQLButtonHandler(QueryDefiner queryDefiner) {
            this.m_queryDefiner = queryDefiner;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.m_queryDefiner.validateQuery();
            if (MessageUtil.displayMessagesAndCheckForErrors(QueryTestApp.this.m_messages)) {
                return;
            }
            if (this.m_queryDefiner != null) {
                JOptionPane.showMessageDialog(null, "SQL was defined to be \n\t" + this.m_queryDefiner.getSql());
            }
            if (MessageUtil.displayMessagesAndCheckForErrors(QueryTestApp.this.m_messages)) {
                return;
            }
        }
    }
}

