/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.app;

import com.sas.query.Query;
import com.sas.query.QueryException;
import com.sas.query.datasources.CustomDataSource;
import com.sas.query.models.MessageHandler;
import com.sas.query.visuals.ImageHandler;
import com.sas.query.visuals.MessageUtil;
import com.sas.query.visuals.OpenQueryDialog;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.QueryTabView;
import java.awt.BorderLayout;
import java.awt.Color;
import javax.swing.JApplet;
import javax.swing.UIManager;

public class QueryApplet
extends JApplet {
    CustomDataSource m_dataSource;
    Query m_query;
    MessageHandler m_messages = new MessageHandler();
    ImageHandler m_images = new ImageHandler(this, this.m_messages);
    protected static QueryResource bundle = new QueryResource(QueryApplet.class);

    public QueryApplet() {
        try {
            this.m_dataSource = new CustomDataSource();
        }
        catch (QueryException e) {
            System.out.println("Error constructing datasource: " + e.getMessage());
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exc) {
            System.out.println("Error loading L&F: " + exc);
        }
    }

    @Override
    public void init() {
        super.init();
    }

    public static Query promptForQuery(MessageHandler messages) {
        OpenQueryDialog dialog = new OpenQueryDialog(null, messages, bundle.getString("QueryApplet.helpSetLocation.txt"));
        dialog.show();
        if (dialog.getDataSource() == null) {
            return null;
        }
        if (dialog.getQuery() == null) {
            return new Query(dialog.getDataSource(), messages);
        }
        return dialog.getQuery();
    }

    @Override
    public void start() {
        super.start();
        this.configureApplet();
    }

    protected void configureApplet() {
        this.m_query = QueryApplet.promptForQuery(this.m_messages);
        if (this.m_query == null) {
            this.m_messages.addError("Cannot continue without an open datasource.");
        }
        MessageUtil.displayAndExitOnError(this.m_messages);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().setBackground(Color.lightGray);
        try {
            this.getContentPane().add("Center", new QueryTabView(this.m_query));
        }
        catch (Throwable t) {
            System.out.println("uncaught exception: " + t);
            t.printStackTrace();
        }
    }
}

