/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.app;

import com.sas.query.Query;
import com.sas.query.QueryDefiner;
import com.sas.query.app.SplashThread;
import com.sas.query.datasources.DataSource;
import com.sas.query.datasources.NativeSasDataSource;
import com.sas.query.models.MessageHandler;
import com.sas.query.visuals.MenuUtil;
import com.sas.query.visuals.MessageUtil;
import com.sas.query.visuals.OpenQueryDialog;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.ResultDialog;
import com.sas.query.visuals.ResultPanel;
import com.sas.query.visuals.SqlPanel;
import com.sas.query.visuals.StandardView;
import com.sas.query.visuals.SummaryView;
import com.sas.query.visuals.UnionListView;
import com.sas.query.visuals.WindowUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;

public class NativeSasApp
extends StandardView {
    protected static QueryResource bundle = new QueryResource(NativeSasApp.class);
    DataSource m_dataSource;
    protected MessageHandler m_messages;
    protected Component m_panel;
    protected JPanel m_mainPanel;
    protected JTabbedPane m_unionPane;
    protected ResultPanel m_unionResultPanel;
    protected SqlPanel m_unionSqlPanel;
    protected Hashtable m_menuItems;
    protected JMenuBar m_menubar;
    protected JToolBar m_toolbar;
    protected Vector m_viewList = new Vector();
    private Hashtable m_commands;
    public static final String viewSqlAction = "viewSql";
    public static final String viewResultsAction = "viewResults";
    public static final String makeUnionAction = "makeUnion";
    private Action[] m_defaultActions = new Action[]{new ViewResultsAction(), new ViewSqlAction(), new MakeUnionAction()};

    public static Query promptForQuery(MessageHandler messages) {
        OpenQueryDialog dialog = new OpenQueryDialog(null, messages, bundle.getString("NativeSasApp.helpSetLocation.txt"));
        dialog.show();
        if (dialog.getDataSource() == null) {
            return null;
        }
        if (dialog.getQuery() == null) {
            return new Query(dialog.getDataSource(), messages);
        }
        return dialog.getQuery();
    }

    public NativeSasApp(Query query, DataSource dataSource, MessageHandler messages) {
        super(query);
        this.m_dataSource = dataSource;
        this.m_messages = messages;
        query.addPropertyListener(this, 512);
        this.setLayout(new BorderLayout());
        this.setBackground(Color.lightGray);
        this.m_commands = new Hashtable();
        Action[] actions = this.m_defaultActions;
        for (int i = 0; i < actions.length; ++i) {
            Action a = actions[i];
            this.m_commands.put(a.getValue("Name"), a);
        }
        this.m_menuItems = new Hashtable();
        this.m_menubar = MenuUtil.createMenubar(bundle, "menubar", this.m_menuItems, this.m_commands);
        try {
            this.m_panel = new QueryTabView(this.m_query);
            this.m_viewList.addElement(this.m_panel);
            this.m_mainPanel = new JPanel();
            this.m_mainPanel.setLayout(new BorderLayout());
            this.m_mainPanel.add("Center", this.m_panel);
            this.add("Center", this.m_mainPanel);
            JPanel menuPanel = new JPanel();
            menuPanel.setLayout(new BorderLayout());
            menuPanel.add("North", this.m_menubar);
            menuPanel.add("Center", this.m_toolbar);
            this.add("North", menuPanel);
        }
        catch (Throwable t) {
            this.m_query.getMessageHandler().addInternalError(t);
        }
    }

    @Override
    public void closing() {
    }

    public static void runFromSas(int mapIndex) {
        MessageHandler m_messages = new MessageHandler();
        SplashThread m_splashThread = null;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exc) {
            MessageHandler.addStaticError(exc);
            MessageHandler.addStaticError("Error loading L&F");
        }
        try {
            m_splashThread = new SplashThread();
            m_splashThread.start();
            JFrame frame = new JFrame();
            frame.setDefaultCloseOperation(2);
            DataSource m_dataSource = null;
            try {
                m_dataSource = new NativeSasDataSource(mapIndex, "NativeSas", m_messages);
            }
            catch (Exception e) {
                m_messages.addError(e, "Creating datasource failed ");
                MessageUtil.displayAndExitOnError(m_messages);
                return;
            }
            Query m_query = new Query(m_dataSource);
            if (m_query == null) {
                m_messages.addError("Cannot continue without an open datasource.");
            }
            if (MessageUtil.displayMessagesAndCheckForErrors(m_messages)) {
                return;
            }
            m_dataSource = m_query.getDataSource();
            NativeSasApp queryTest = new NativeSasApp(m_query, m_dataSource, m_messages);
            frame.setBackground(SystemColor.control);
            frame.getContentPane().add("Center", queryTest);
            frame.pack();
            frame.setSize(800, 530);
            frame.setTitle("SAS Query");
            frame.addWindowListener(new AppCloser(frame, m_dataSource));
            WindowUtil.center(frame);
            frame.show();
            frame.toFront();
        }
        catch (Throwable t) {
            MessageHandler.addStaticError(t);
        }
        if (m_splashThread != null) {
            m_splashThread.interrupt();
            m_splashThread = null;
        }
    }

    public void refreshUnions() {
        if (this.m_unionPane == null) {
            return;
        }
        for (Query query = this.m_query; query != null; query = query.getUnion()) {
            boolean bExists = false;
            for (int index = 0; index < this.m_viewList.size(); ++index) {
                if (((QueryTabView)this.m_viewList.elementAt(index)).getQuery() != query) continue;
                bExists = true;
                break;
            }
            if (bExists) continue;
            int tabCount = this.m_unionPane.getTabCount();
            this.m_unionPane.removeTabAt(tabCount - 1);
            this.m_unionPane.removeTabAt(tabCount - 2);
            QueryTabView view = new QueryTabView(query);
            this.m_unionPane.addTab("Select " + this.m_unionPane.getTabCount(), view);
            this.m_viewList.addElement(view);
            query.addPropertyListener(this, 512);
            this.m_unionPane.addTab("Results", this.m_unionResultPanel);
            this.m_unionPane.addTab("SQL", this.m_unionSqlPanel);
        }
    }

    static void println(String text, int indent) {
        for (int index = 0; index < indent; ++index) {
            System.out.print(" ");
        }
        System.out.print(text);
        System.out.println();
    }

    class ViewResultsAction
    extends AbstractAction {
        ViewResultsAction() {
            super(NativeSasApp.viewResultsAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String strSql = NativeSasApp.this.getQuery().getSql();
            NativeSasApp.this.m_dataSource.execute(strSql);
        }
    }

    class ViewSqlAction
    extends AbstractAction {
        ViewSqlAction() {
            super(NativeSasApp.viewSqlAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ResultDialog resultDialog = new ResultDialog(NativeSasApp.this.getQuery(), WindowUtil.getParentFrame(NativeSasApp.this), false);
            resultDialog.show();
        }
    }

    class MakeUnionAction
    extends AbstractAction {
        MakeUnionAction() {
            super(NativeSasApp.makeUnionAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (NativeSasApp.this.getQuery().getUnion() != null) {
                return;
            }
            NativeSasApp.this.m_mainPanel.remove(NativeSasApp.this.m_panel);
            Query newQuery = new Query(NativeSasApp.this.m_dataSource, NativeSasApp.this.m_messages);
            newQuery.addPropertyListener(NativeSasApp.this, 512);
            NativeSasApp.this.getQuery().addUnion(newQuery, 0);
            NativeSasApp.this.m_unionPane = new JTabbedPane();
            NativeSasApp.this.m_unionPane.addTab("Union", new UnionListView(NativeSasApp.this.getQuery(), null, NativeSasApp.this.m_unionPane));
            NativeSasApp.this.m_unionPane.addTab("Select 1", NativeSasApp.this.m_panel);
            QueryTabView view = new QueryTabView(newQuery);
            NativeSasApp.this.m_viewList.addElement(view);
            NativeSasApp.this.m_unionPane.addTab("Select 2", view);
            NativeSasApp.this.m_unionResultPanel = new ResultPanel(NativeSasApp.this.getQuery());
            NativeSasApp.this.m_unionPane.addTab("Results", NativeSasApp.this.m_unionResultPanel);
            NativeSasApp.this.m_unionSqlPanel = new SqlPanel(NativeSasApp.this.getQuery());
            NativeSasApp.this.m_unionPane.addTab("SQL", NativeSasApp.this.m_unionSqlPanel);
            JPanel spacerPanel = new JPanel();
            spacerPanel.setLayout(new BorderLayout());
            spacerPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
            spacerPanel.add("Center", NativeSasApp.this.m_unionPane);
            NativeSasApp.this.m_mainPanel.add("Center", spacerPanel);
            NativeSasApp.this.m_mainPanel.validate();
        }
    }

    public class QueryTabView
    extends JPanel {
        protected Query m_query;
        protected JTabbedPane m_tabbedPane;
        protected ResultPanel m_resultPanel;
        protected SqlPanel m_sqlPanel;

        public QueryTabView(Query query) {
            this.m_query = query;
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
            this.m_tabbedPane = new JTabbedPane();
            try {
                this.m_tabbedPane.addTab("Query", new QueryDefiner(query, 290, 0));
                QueryDefiner dataFilters = new QueryDefiner(query, 65, 0);
                JPanel bigDataFilter = new JPanel();
                bigDataFilter.setLayout(new BorderLayout());
                bigDataFilter.add(dataFilters);
                bigDataFilter.add("South", new SummaryView(query, 4));
                this.m_tabbedPane.addTab("Data Filters", bigDataFilter);
                QueryDefiner recordFilters = new QueryDefiner(query, 576, 0);
                JPanel bigRecordFilter = new JPanel();
                bigRecordFilter.setLayout(new BorderLayout());
                bigRecordFilter.add(recordFilters);
                bigRecordFilter.add("South", new SummaryView(query, 16));
                this.m_tabbedPane.addTab("Group Filters", bigRecordFilter);
                this.m_sqlPanel = new SqlPanel(query);
                this.m_tabbedPane.addTab("SQL", this.m_sqlPanel);
            }
            catch (Throwable t) {
                this.m_query.getMessageHandler().addInternalError(t);
            }
            this.add(this.m_tabbedPane);
        }

        public Query getQuery() {
            return this.m_query;
        }
    }

    protected static final class AppCloser
    extends WindowAdapter {
        DataSource m_dataSource;
        Frame m_frame;

        public AppCloser(Frame frame, DataSource dataSource) {
            this.m_frame = frame;
            this.m_dataSource = dataSource;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.m_frame.dispose();
            if (this.m_dataSource instanceof NativeSasDataSource) {
                ((NativeSasDataSource)this.m_dataSource).close();
            }
        }
    }
}

