/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.app;

import com.sas.query.Query;
import com.sas.query.QueryConfiguration;
import com.sas.query.app.StandardAction;
import com.sas.query.datasources.DataSource;
import com.sas.query.models.DataItem;
import com.sas.query.models.DataItemList;
import com.sas.query.models.GroupItem;
import com.sas.query.models.MessageHandler;
import com.sas.query.models.ModelChangeEvent;
import com.sas.query.models.ModelChangeListener;
import com.sas.query.models.UnparsedExpression;
import com.sas.query.visuals.AddTableDialog;
import com.sas.query.visuals.AdvancedJoinPropertyView;
import com.sas.query.visuals.CrossJoinWarningDialog;
import com.sas.query.visuals.DataFlowWarningView;
import com.sas.query.visuals.DataItemPropertyView;
import com.sas.query.visuals.FilterTreeView;
import com.sas.query.visuals.ImageHandler;
import com.sas.query.visuals.MenuUtil;
import com.sas.query.visuals.MessageUtil;
import com.sas.query.visuals.OpenQueryDialog;
import com.sas.query.visuals.QueryComponentDialog;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.QueryTabView;
import com.sas.query.visuals.ResultDialog;
import com.sas.query.visuals.ViewDialog;
import com.sas.query.visuals.WindowUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AppSupport
implements ModelChangeListener,
VetoableChangeListener {
    static QueryResource bundle = new QueryResource(AppSupport.class);
    protected transient Query m_query;
    protected transient JFrame m_frame;
    protected transient MessageHandler m_messages;
    protected FileDialog m_fileDialog = null;
    protected ViewDialog m_viewDialog = null;
    protected ViewDialog m_tableDialog = null;
    protected transient PropertyChangeSupport m_pChanges;
    protected transient Vector m_vetoListeners;
    protected transient boolean m_bIsApplet = false;
    protected transient boolean m_bExitOnClose = true;
    protected transient boolean m_bNeedToSaveQuery = false;
    protected transient boolean m_isAdvancedJoinsAllowed = true;
    protected transient boolean m_isFileSaveAllowed = true;
    protected transient boolean m_isViewSaveAllowed = true;
    protected transient boolean m_isTableSaveAllowed = true;
    protected transient boolean m_isFileReadAllowed = true;
    protected transient boolean m_isViewReadAllowed = true;
    protected transient boolean m_showLabels = false;
    protected String m_strQuery = null;
    protected transient Vector m_viewList = new Vector();
    protected transient QueryTabView m_tabbedView;
    protected transient Hashtable m_commands;
    protected Hashtable m_menuItems;
    protected JMenuBar m_menubar;
    protected JToolBar m_toolbar;
    public static final String fileNewAction = "fileNew";
    public static final String fileNewConnectionAction = "fileNewConnection";
    public static final String fileOpenAction = "fileOpen";
    public static final String fileOpenFromViewAction = "fileOpenFromView";
    public static final String fileSaveAction = "fileSave";
    public static final String fileSaveAsViewAction = "fileSaveAsView";
    public static final String fileCreateTableAction = "fileCreateTable";
    public static final String fileExitAction = "fileExit";
    public static final String viewSqlAction = "viewSql";
    public static final String viewResultsAction = "viewResults";
    public static final String advancedJoinsAction = "advancedJoins";
    public static final String makeUnionAction = "makeUnion";
    public static final String insertResultItemAction = "insertResultItem";
    public static final String insertTableAction = "insertTable";
    public static final String dataFlowAnalysisAction = "dataFlowAnalysis";
    public static final String helpAppHelpAction = "helpAppHelp";
    public static final String aboutTheAppAction = "aboutTheApp";
    private Action[] m_defaultActions;

    public AppSupport(Query query, JFrame frame) {
        this.m_query = query;
        if (frame == null) {
            frame = new JFrame();
            this.m_bIsApplet = true;
        }
        this.m_frame = frame;
        this.m_frame.addWindowListener(new AppCloser(this.m_frame, this));
        this.m_frame.setDefaultCloseOperation(0);
        QueryResource iconBundle = new QueryResource(ImageHandler.class);
        ImageIcon qIcon = ImageHandler.getImageIcon(iconBundle, "qIcon");
        this.m_frame.setIconImage(qIcon.getImage());
        if (this.m_query != null) {
            this.m_strQuery = this.m_query.getSql();
            query.addPropertyListener(this, 65535);
        }
        this.getActions(this);
        this.m_pChanges = new PropertyChangeSupport(this);
        this.m_vetoListeners = new Vector();
        this.addVetoableChangeListener(this);
    }

    public void setExitOnClose(boolean flag) {
        this.m_bExitOnClose = flag;
    }

    public boolean isExitOnClose() {
        return this.m_bExitOnClose;
    }

    public boolean isAdvancedJoinsAllowed() {
        return this.m_isAdvancedJoinsAllowed;
    }

    public void setAdvancedJoinsAllowed(boolean allow) {
        this.m_isAdvancedJoinsAllowed = allow;
    }

    public boolean isFileSaveAllowed() {
        return this.m_isFileSaveAllowed;
    }

    public void setFileSaveAllowed(boolean allow) {
        this.m_isFileSaveAllowed = allow && this.securityIsFileWriteAllowed();
        for (int index = 0; index < this.m_defaultActions.length; ++index) {
            if (!(this.m_defaultActions[index] instanceof FileSaveAction)) continue;
            ((FileSaveAction)this.m_defaultActions[index])._setState();
            break;
        }
    }

    public boolean isViewSaveAllowed() {
        return this.m_isViewSaveAllowed;
    }

    public void setViewSaveAllowed(boolean allow) {
        this.m_isViewSaveAllowed = allow;
        for (int index = 0; index < this.m_defaultActions.length; ++index) {
            if (!(this.m_defaultActions[index] instanceof FileSaveAsViewAction)) continue;
            ((FileSaveAsViewAction)this.m_defaultActions[index])._setState();
            break;
        }
    }

    public boolean isTableSaveAllowed() {
        return this.m_isTableSaveAllowed;
    }

    public void setTableSaveAllowed(boolean allow) {
        this.m_isTableSaveAllowed = allow;
        for (int index = 0; index < this.m_defaultActions.length; ++index) {
            if (!(this.m_defaultActions[index] instanceof FileCreateTableAction)) continue;
            ((FileCreateTableAction)this.m_defaultActions[index])._setState();
            break;
        }
    }

    public boolean isViewReadAllowed() {
        return this.m_isViewReadAllowed;
    }

    public void setViewReadAllowed(boolean allow) {
        this.m_isViewReadAllowed = allow;
        for (int index = 0; index < this.m_defaultActions.length; ++index) {
            if (!(this.m_defaultActions[index] instanceof FileOpenFromViewAction)) continue;
            ((FileOpenFromViewAction)this.m_defaultActions[index])._setState();
            break;
        }
    }

    public boolean isFileReadAllowed() {
        return this.m_isFileReadAllowed;
    }

    public void setFileReadAllowed(boolean allow) {
        this.m_isFileReadAllowed = allow && this.securityIsFileReadAllowed();
        for (int index = 0; index < this.m_defaultActions.length; ++index) {
            if (!(this.m_defaultActions[index] instanceof FileOpenAction)) continue;
            ((FileOpenAction)this.m_defaultActions[index])._setState();
            break;
        }
    }

    public void setShowLabels(boolean doShow) {
        this.m_showLabels = doShow;
        if (this.m_query != null) {
            this.getQuery().setShowLabels(doShow);
        }
    }

    public boolean isShowLabels() {
        boolean retVal = false;
        if (this.m_query != null) {
            retVal = this.getQuery().isShowLabels();
        }
        return retVal;
    }

    public JPanel getMenuPanel(String strMenubar, String strToolbar) {
        Action[] actions = this.m_defaultActions;
        this.m_commands = this.getCommands(actions);
        this.m_menuItems = new Hashtable();
        if (this.m_bIsApplet) {
            String str = bundle.getString("appletString");
            strMenubar = str + strMenubar;
            strToolbar = str + strToolbar;
        }
        this.m_menubar = MenuUtil.createMenubar(bundle, strMenubar, this.m_menuItems, this.m_commands);
        this.m_toolbar = MenuUtil.createToolbar(bundle, strToolbar, this.m_commands);
        JPanel menuPanel = new JPanel();
        menuPanel.setLayout(new BorderLayout());
        menuPanel.add("North", this.m_menubar);
        menuPanel.add("South", this.m_toolbar);
        return menuPanel;
    }

    public void setTabbedView(QueryTabView tabbedView) {
        this.m_tabbedView = tabbedView;
        this.m_tabbedView.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                for (int index = 0; index < AppSupport.this.m_defaultActions.length; ++index) {
                    if (!(AppSupport.this.m_defaultActions[index] instanceof StandardAction)) continue;
                    ((StandardAction)AppSupport.this.m_defaultActions[index])._setState();
                }
            }
        });
    }

    public Query getQuery() {
        return this.m_query;
    }

    public JFrame getFrame() {
        return this.m_frame;
    }

    public MessageHandler getMessages() {
        return this.m_query.getMessageHandler();
    }

    public void firePropertyChanges() {
        this.getMessages().firePropertyChanges();
    }

    public Action[] setActions(Action[] actions) {
        Action[] oldActionSet = this.m_defaultActions;
        this.m_defaultActions = actions;
        return oldActionSet;
    }

    public Action[] getActions(AppSupport queryGetter) {
        if (this.m_defaultActions == null) {
            this.m_defaultActions = this.getDefaultActions(queryGetter);
        }
        return this.m_defaultActions;
    }

    public Action[] getDefaultActions(AppSupport queryGetter) {
        Action[] actions = new Action[]{new FileNewAction(queryGetter), new FileNewConnectionAction(queryGetter), new FileOpenAction(queryGetter), new FileOpenFromViewAction(queryGetter), new FileSaveAction(queryGetter), new FileSaveAsViewAction(queryGetter), new FileCreateTableAction(queryGetter), new FileExitAction(queryGetter), new ViewResultsAction(queryGetter), new ViewSqlAction(queryGetter), new AdvancedJoinsAction(queryGetter), new InsertTableAction(queryGetter), new InsertResultItemAction(queryGetter), new DataFlowAnalysisAction(queryGetter), new HelpAppHelpAction(queryGetter), new AboutTheAppAction(queryGetter)};
        return actions;
    }

    public Hashtable getCommands(Action[] actionArray) {
        Hashtable<Object, Action> commands = new Hashtable<Object, Action>();
        for (int i = 0; i < actionArray.length; ++i) {
            Action action = actionArray[i];
            commands.put(action.getValue("Name"), action);
        }
        return commands;
    }

    @Override
    public void modelChangeCallback(ModelChangeEvent event) {
        if (event.isStructureChange() && !event.didOnlyThisStructureTypeChange(8) && !event.didOnlyThisStructureAreaChange(1024)) {
            this.m_bNeedToSaveQuery = true;
        }
        if (event.isDataChange() && !event.didOnlyThisDataAreaChange(1024)) {
            this.m_bNeedToSaveQuery = true;
        }
    }

    private boolean securityIsFileReadAllowed() {
        boolean readAllowed = true;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            try {
                security.checkRead("tempname.txt");
            }
            catch (SecurityException se) {
                readAllowed = false;
            }
        }
        return readAllowed;
    }

    private boolean securityIsFileWriteAllowed() {
        boolean writeAllowed = true;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            try {
                security.checkWrite("tempname.txt");
            }
            catch (SecurityException se) {
                writeAllowed = false;
            }
        }
        return writeAllowed;
    }

    protected int _saveOnClose(boolean bCanBeCanceled) {
        int nChoice = 0;
        if (this.isFileSaveAllowed() || this.isViewSaveAllowed()) {
            Object[] options;
            Object[] optionsBoth = new Object[]{bundle.getString("AppSupport.SaveMessageButtons.SaveAsFile.txt"), bundle.getString("AppSupport.SaveMessageButtons.SaveAsView.txt"), bundle.getString("AppSupport.SaveMessageButtons.NoSave.txt"), bundle.getString("AppSupport.SaveMessageButtons.Cancel.txt")};
            Object[] optionsViewOnly = new Object[]{bundle.getString("AppSupport.SaveMessageButtons.SaveAsView.txt"), bundle.getString("AppSupport.SaveMessageButtons.NoSave.txt"), bundle.getString("AppSupport.SaveMessageButtons.Cancel.txt")};
            Object[] optionsFileOnly = new Object[]{bundle.getString("AppSupport.SaveMessageButtons.SaveAsFile.txt"), bundle.getString("AppSupport.SaveMessageButtons.NoSave.txt"), bundle.getString("AppSupport.SaveMessageButtons.Cancel.txt")};
            int saveFileOption = -99;
            int saveViewOption = -99;
            int noSaveOption = -99;
            if (this.isFileSaveAllowed() && this.isViewSaveAllowed()) {
                options = optionsBoth;
                saveFileOption = 0;
                saveViewOption = 1;
                noSaveOption = 2;
            } else if (this.isFileSaveAllowed()) {
                options = optionsFileOnly;
                saveFileOption = 0;
                noSaveOption = 1;
            } else {
                options = optionsViewOnly;
                saveViewOption = 0;
                noSaveOption = 1;
            }
            nChoice = JOptionPane.showOptionDialog(null, bundle.messageString("AppSupport.Message.SaveChangesToQuery.txt"), bundle.messageString("AppSupport.Title.Save.txt"), -1, 3, null, options, options[0]);
            if (nChoice == saveFileOption) {
                if (!this.saveQueryToFile(this.getQuery())) {
                    nChoice = 2;
                    MessageUtil.displayMessages(this.getMessages());
                }
            } else if (nChoice == saveViewOption) {
                if (!this.saveQueryToView(this.getQuery())) {
                    nChoice = 2;
                    MessageUtil.displayMessages(this.getMessages());
                }
            } else {
                nChoice = nChoice == noSaveOption ? 0 : 2;
            }
        }
        return nChoice;
    }

    public void readQueryFromFile(JFrame frame) {
        if (this.m_fileDialog == null) {
            this.m_fileDialog = new FileDialog(frame);
        }
        this.m_fileDialog.setFile("*." + QueryConfiguration.getConfigurationString("FileSave.DefaultExtension.txt", "txt"));
        this.m_fileDialog.setMode(0);
        WindowUtil.center(this.m_fileDialog);
        this.m_fileDialog.show();
        String file = this.m_fileDialog.getFile();
        if (file == null) {
            return;
        }
        String directory = this.m_fileDialog.getDirectory();
        WindowUtil.busyOn(frame);
        this.m_query.openQueryFromFile(directory + System.getProperty("file.separator") + file);
        WindowUtil.busyOff(frame);
        if (!this.getMessages().failureHasOccurred()) {
            this.m_bNeedToSaveQuery = false;
        }
        MessageUtil.displayMessages(this.getMessages());
        this.firePropertyChanges();
    }

    public void readQueryFromView(JFrame frame) {
        if (this.m_viewDialog == null) {
            this.getQuery().getSqlProperties();
            this.m_viewDialog = new ViewDialog(this.m_query, (Frame)frame, 2);
        }
        this.m_viewDialog.selectNodeinTree(this.m_viewDialog.getViewName());
        this.m_viewDialog.setMode(1);
        this.m_viewDialog.setTitle(bundle.messageString("AppSupport.Title.OpenView.txt"));
        this.m_viewDialog.setPasswordPrompting(this.shouldViewPasswordPromptBeShown());
        WindowUtil.center(this.m_viewDialog);
        this.m_viewDialog.show();
        if (this.m_viewDialog.isCancelPressed()) {
            return;
        }
        String viewName = this.m_viewDialog.getViewName();
        if (viewName == null) {
            return;
        }
        WindowUtil.busyOn(frame);
        viewName = this.m_query.getSqlLogic().getQualifiedName(viewName);
        this.m_viewDialog.setViewName(viewName);
        String pwd = this.m_viewDialog.getPassword();
        this.m_query.openQueryFromView(this.m_frame, true, viewName, pwd);
        if (!this.getMessages().failureHasOccurred()) {
            this.m_bNeedToSaveQuery = false;
        }
        WindowUtil.busyOff(frame);
        MessageUtil.displayMessages(this.getMessages());
        this.firePropertyChanges();
    }

    private boolean shouldViewPasswordPromptBeShown() {
        String productName = this.m_query.getDataSource().getDatabaseProductName();
        String sasVersion = this.m_query.getDataSource().getDatabaseProductVersion();
        boolean promptForViewPassword = false;
        if (productName.equalsIgnoreCase("SAS")) {
            int indexOfDot = sasVersion.indexOf(".");
            if (indexOfDot > -1) {
                String mainVersion = sasVersion.substring(0, indexOfDot);
                String minorVersion = sasVersion.substring(indexOfDot + 1);
                Integer mainValue = Integer.valueOf(mainVersion);
                Integer minorValue = Integer.valueOf(minorVersion);
                int main = mainValue;
                int minor = minorValue;
                promptForViewPassword = main < 8 ? false : (main > 8 ? true : minor >= 2);
            } else {
                int versionNumber = Integer.valueOf(sasVersion);
                promptForViewPassword = versionNumber > 8;
            }
        }
        return promptForViewPassword;
    }

    public boolean saveQueryToFile(Query query) {
        if (this.m_fileDialog == null) {
            this.m_fileDialog = new FileDialog(this.m_frame);
            this.m_fileDialog.setFile("*." + QueryConfiguration.getConfigurationString("FileSave.DefaultExtension.txt", "txt"));
        }
        this.m_fileDialog.setMode(1);
        WindowUtil.center(this.m_fileDialog);
        this.m_fileDialog.show();
        String file = this.m_fileDialog.getFile();
        if (file == null) {
            return false;
        }
        WindowUtil.busyOn(this.m_frame);
        String directory = this.m_fileDialog.getDirectory();
        if (file.indexOf(46) < 0) {
            file = file + '.' + QueryConfiguration.getConfigurationString("FileSave.DefaultExtension.txt", "txt");
        }
        String strPath = directory + System.getProperty("file.separator") + file;
        query.saveQueryToFile(strPath);
        boolean success = false;
        if (!this.getMessages().failureHasOccurred()) {
            this.m_bNeedToSaveQuery = false;
            success = true;
        }
        WindowUtil.busyOff(this.m_frame);
        this.getMessages().firePropertyChanges();
        this.firePropertyChange(fileSaveAction, null, strPath);
        return success;
    }

    public boolean saveQueryToView(Query query) {
        boolean success = false;
        this.m_viewDialog = null;
        if (this.m_viewDialog == null) {
            this.getQuery().getSqlProperties();
            this.m_viewDialog = new ViewDialog(query, (Frame)this.m_frame, 2);
        }
        this.m_viewDialog.selectNodeinTree(this.m_viewDialog.getViewName());
        this.m_viewDialog.setMode(2);
        this.m_viewDialog.setTitle(bundle.getString("AppSupport.Title.SaveAsView.txt"));
        this.m_viewDialog.setPasswordPrompting(this.shouldViewPasswordPromptBeShown());
        WindowUtil.center(this.m_viewDialog);
        this.m_viewDialog.show();
        if (this.m_viewDialog.isCancelPressed()) {
            return success;
        }
        String viewName = this.m_viewDialog.getViewName();
        if (viewName == null) {
            return success;
        }
        WindowUtil.busyOn(this.m_frame);
        viewName = this.m_query.getSqlLogic().getQualifiedName(viewName);
        this.m_viewDialog.setViewName(viewName);
        String passwordForViewDefinition = this.m_viewDialog.getPassword();
        query.saveQueryToView(viewName, passwordForViewDefinition);
        if (!this.getMessages().failureHasOccurred()) {
            String strMessage = this.m_viewDialog.overwriteHasOccurred() ? bundle.messageString("AppSupport.Message.ReplacedView.fmt.txt", viewName) : bundle.messageString("AppSupport.Message.CreatedView.fmt.txt", viewName);
            JOptionPane.showMessageDialog(null, strMessage, bundle.messageString("AppSupport.Title.Success.txt"), 1);
            this.m_bNeedToSaveQuery = false;
            success = true;
        }
        WindowUtil.busyOff(this.m_frame);
        this.getMessages().firePropertyChanges();
        this.firePropertyChange(fileSaveAsViewAction, null, viewName);
        return success;
    }

    public void saveQueryToTable(Query query) {
        if (this.m_tableDialog == null) {
            this.getQuery().getSqlProperties();
            this.m_tableDialog = new ViewDialog(query, (Frame)this.m_frame, 1);
        }
        this.m_tableDialog.selectNodeinTree(this.m_tableDialog.getViewName());
        this.m_tableDialog.setMode(3);
        this.m_tableDialog.setTitle(bundle.messageString("AppSupport.Title.CreateDataset.txt"));
        this.m_tableDialog.setPasswordPrompting(false);
        WindowUtil.center(this.m_tableDialog);
        this.m_tableDialog.show();
        if (this.m_tableDialog.isCancelPressed()) {
            return;
        }
        String tableName = this.m_tableDialog.getViewName();
        if (tableName == null) {
            return;
        }
        WindowUtil.busyOn(this.m_frame);
        tableName = this.m_query.getSqlLogic().getQualifiedName(tableName);
        this.m_tableDialog.setViewName(tableName);
        query.saveQueryToTable(tableName);
        if (!this.getMessages().failureHasOccurred()) {
            String strMessage = this.m_tableDialog.overwriteHasOccurred() ? bundle.messageString("AppSupport.Message.ReplacedTable.fmt.txt", tableName) : bundle.messageString("AppSupport.Message.CreatedTable.fmt.txt", tableName);
            JOptionPane.showMessageDialog(null, strMessage, bundle.messageString("AppSupport.Title.Success.txt"), 1);
        }
        WindowUtil.busyOff(this.m_frame);
        this.getMessages().firePropertyChanges();
    }

    protected boolean isPreviousSqlEqualCurrentSql() {
        return this.m_strQuery.equalsIgnoreCase(this.m_query.getSql());
    }

    protected boolean isSqlVoid() {
        boolean sqlVoid = false;
        if (this.m_query.isParsable()) {
            if (this.m_query.getResultItemCount() == 0 && this.m_query.getTableCount() == 0 && this.m_query.getWhereFilterTree().getRoot() == null && this.m_query.getHavingFilterTree().getRoot() == null && this.m_query.getGroupItemCount() == 0 && this.m_query.getOrderItemCount() == 0) {
                sqlVoid = true;
            }
        } else {
            sqlVoid = false;
        }
        return sqlVoid;
    }

    protected boolean shutdown() {
        if (this.m_bNeedToSaveQuery && !this.isPreviousSqlEqualCurrentSql() && !this.isSqlVoid() && this._saveOnClose(true) == 2) {
            return false;
        }
        if (this.m_bExitOnClose) {
            try {
                if (this.m_query.getDataSource() != null) {
                    this.m_query.getDataSource().close();
                }
                System.exit(0);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return true;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_pChanges.addPropertyChangeListener(listener);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if ((oldValue == null && newValue == null || oldValue != newValue && (oldValue == null || !oldValue.equals(newValue))) && this.m_pChanges != null) {
            this.m_pChanges.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_pChanges.removePropertyChangeListener(listener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener listener) {
        if (this.m_vetoListeners == null) {
            this.m_vetoListeners = new Vector();
        }
        this.m_vetoListeners.addElement(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireVetoableChange(String propertyName, Object oldValue, Object newValue) throws PropertyVetoException {
        if (this.m_vetoListeners == null) {
            return;
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        Vector targets = null;
        AppSupport appSupport = this;
        synchronized (appSupport) {
            if (this.m_vetoListeners != null) {
                targets = (Vector)this.m_vetoListeners.clone();
            }
        }
        if (this.m_vetoListeners != null) {
            for (int i = 0; i < targets.size(); ++i) {
                VetoableChangeListener target = (VetoableChangeListener)targets.elementAt(i);
                target.vetoableChange(evt);
            }
        }
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (this.m_vetoListeners == null) {
            return;
        }
        this.m_vetoListeners.removeElement(listener);
    }

    @Override
    public void vetoableChange(PropertyChangeEvent event) throws PropertyVetoException {
        if (event.getSource() == this && this.m_tabbedView.hasPendingChanges()) {
            Object[] warningOptions = new Object[]{bundle.getString("Common.Discard.txt"), bundle.getString("Common.Cancel.txt")};
            int warningChoice = JOptionPane.showOptionDialog(this.m_frame, bundle.getString("AppSupport.DiscardUnappliedMessage.txt"), bundle.getString("AppSupport.DiscardUnappliedTitle.txt"), 2, 2, null, warningOptions, warningOptions[0]);
            if (warningChoice != 0) {
                throw new PropertyVetoException("", event);
            }
            this.m_tabbedView.discardPendingChanges();
        }
    }

    protected static final class AppCloser
    extends WindowAdapter {
        AppSupport m_app;
        Query m_query;
        DataSource m_dataSource;
        Frame m_frame;

        public AppCloser(Frame frame, AppSupport queryApp) {
            this.m_frame = frame;
            this.m_app = queryApp;
            this.m_query = queryApp.getQuery();
            if (this.m_query != null) {
                this.m_dataSource = this.m_query.getDataSource();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (this.m_app.shutdown()) {
                this.m_frame.dispose();
            }
        }
    }

    class FileSaveAction
    extends StandardAction {
        FileSaveAction(AppSupport app) {
            this(app, AppSupport.fileSaveAction);
        }

        FileSaveAction(AppSupport app, String name) {
            super(app, name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            if (!this.m_changedVetoed) {
                AppSupport.this.saveQueryToFile(AppSupport.this.getQuery());
                this.displayMessages();
            }
        }

        @Override
        protected void _setState() {
            if (this.m_app.getQuery() == null) {
                this.setEnabled(false);
            } else {
                boolean bEnabled;
                boolean bl = bEnabled = !this.m_app.isSqlVoid() && this.m_app.m_isFileSaveAllowed;
                if (bEnabled != this.isEnabled()) {
                    this.setEnabled(bEnabled);
                }
            }
        }
    }

    class FileSaveAsViewAction
    extends StandardAction {
        FileSaveAsViewAction(AppSupport app) {
            super(app, AppSupport.fileSaveAsViewAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            if (!this.m_changedVetoed) {
                this.m_app.saveQueryToView(this.m_app.getQuery());
                this.displayMessages();
            }
        }

        @Override
        protected void _setState() {
            if (this.m_app.getQuery() == null) {
                this.setEnabled(false);
            } else {
                boolean bEnabled;
                boolean bl = bEnabled = this.m_app.getQuery().canResultsBeGotten() && this.m_app.m_isViewSaveAllowed;
                if (bEnabled != this.isEnabled()) {
                    this.setEnabled(bEnabled);
                }
            }
        }
    }

    class FileCreateTableAction
    extends StandardAction {
        FileCreateTableAction(AppSupport app) {
            super(app, AppSupport.fileCreateTableAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            if (!this.m_changedVetoed) {
                this.m_app.saveQueryToTable(this.m_app.getQuery());
                this.displayMessages();
                AppSupport.this.firePropertyChange(this.m_keyName, null, null);
            }
        }

        @Override
        protected void _setState() {
            if (this.m_app.getQuery() == null) {
                this.setEnabled(false);
            } else {
                boolean bEnabled;
                boolean bl = bEnabled = this.m_app.getQuery().canResultsBeGotten() && this.m_app.m_isTableSaveAllowed;
                if (bEnabled != this.isEnabled()) {
                    this.setEnabled(bEnabled);
                }
            }
        }
    }

    class FileOpenFromViewAction
    extends StandardAction {
        FileOpenFromViewAction(AppSupport app) {
            super(app, AppSupport.fileOpenFromViewAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            if (!this.m_changedVetoed) {
                if (AppSupport.this.m_bNeedToSaveQuery && !AppSupport.this.isPreviousSqlEqualCurrentSql() && !AppSupport.this.isSqlVoid() && AppSupport.this._saveOnClose(true) == 2) {
                    return;
                }
                this.m_app.readQueryFromView(this.m_app.getFrame());
                this.displayMessages();
                AppSupport.this.m_strQuery = AppSupport.this.m_query.getSql();
                AppSupport.this.firePropertyChange(this.m_keyName, null, null);
            }
        }

        @Override
        protected void _setState() {
            this.setEnabled(this.m_app.m_isViewReadAllowed);
        }
    }

    class FileOpenAction
    extends StandardAction {
        FileOpenAction(AppSupport app) {
            super(app, AppSupport.fileOpenAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            if (!this.m_changedVetoed) {
                if (AppSupport.this.m_bNeedToSaveQuery && !AppSupport.this.isPreviousSqlEqualCurrentSql() && !AppSupport.this.isSqlVoid() && AppSupport.this._saveOnClose(true) == 2) {
                    return;
                }
                this.m_app.readQueryFromFile(this.m_app.getFrame());
                this.displayMessages();
                AppSupport.this.m_strQuery = AppSupport.this.m_query.getSql();
                AppSupport.this.firePropertyChange(this.m_keyName, null, null);
            }
        }

        @Override
        protected void _setState() {
            this.setEnabled(this.m_app.m_isFileReadAllowed);
        }
    }

    class FileNewAction
    extends StandardAction {
        FileNewAction(AppSupport app) {
            super(app, AppSupport.fileNewAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            if (!this.m_changedVetoed) {
                if (AppSupport.this.m_bNeedToSaveQuery && !AppSupport.this.isPreviousSqlEqualCurrentSql() && !AppSupport.this.isSqlVoid() && AppSupport.this._saveOnClose(true) == 2) {
                    return;
                }
                this.m_app.getQuery().clear();
                this.m_app.firePropertyChanges();
                AppSupport.this.m_bNeedToSaveQuery = false;
                AppSupport.this.m_strQuery = AppSupport.this.m_query.getSql();
                AppSupport.this.firePropertyChange(this.m_keyName, null, null);
            }
        }
    }

    class FileNewConnectionAction
    extends StandardAction {
        FileNewConnectionAction(AppSupport app) {
            super(app, AppSupport.fileNewConnectionAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            if (!this.m_changedVetoed) {
                if (AppSupport.this.m_bNeedToSaveQuery && !AppSupport.this.isPreviousSqlEqualCurrentSql() && !AppSupport.this.isSqlVoid() && AppSupport.this._saveOnClose(true) == 2) {
                    return;
                }
                this.m_app.getQuery().clear();
                this.m_app.firePropertyChanges();
                OpenQueryDialog dialog = new OpenQueryDialog(null, this.m_app.getQuery().getMessageHandler(), bundle.getString("AppSupport.helpSetLocation.txt"));
                dialog.show();
                if (dialog.getDataSource() != null) {
                    this.m_app.getQuery().getDataSource().close();
                    this.m_app.getQuery().setDataSource(dialog.getDataSource());
                    String strSql = dialog.getSql();
                    if (strSql != null) {
                        this.m_app.getQuery().setSQL(strSql);
                    }
                    AppSupport.this.m_viewDialog = null;
                }
                this.m_app.firePropertyChanges();
                AppSupport.this.m_bNeedToSaveQuery = false;
                AppSupport.this.m_strQuery = AppSupport.this.m_query.getSql();
                this.firePropertyChange(this.m_name, null, null);
            }
        }
    }

    class FileExitAction
    extends StandardAction {
        FileExitAction(AppSupport app) {
            super(app, AppSupport.fileExitAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            if (!this.m_changedVetoed) {
                if (AppSupport.this.shutdown()) {
                    new DisposeLater();
                }
                AppSupport.this.firePropertyChange(this.m_keyName, null, null);
            }
        }
    }

    class ViewResultsAction
    extends StandardAction {
        ViewResultsAction(AppSupport app) {
            super(app, AppSupport.viewResultsAction);
            this.m_app = app;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            if (!this.m_changedVetoed) {
                ResultDialog sqlDialog = new ResultDialog(this.m_app.getQuery(), this.m_app.getFrame(), false);
                sqlDialog.show();
                AppSupport.this.firePropertyChange(this.m_keyName, null, null);
            }
        }

        @Override
        protected void _setState() {
            if (this.m_app.getQuery() != null) {
                this.setEnabled(this.m_app.getQuery().canResultsBeGotten());
            }
        }
    }

    class ViewSqlAction
    extends StandardAction {
        ViewSqlAction(AppSupport app) {
            super(app, AppSupport.viewSqlAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            if (!this.m_changedVetoed) {
                ResultDialog resultDialog = new ResultDialog(this.m_app.getQuery(), this.m_app.getFrame(), false);
                resultDialog.show();
                AppSupport.this.firePropertyChange(this.m_keyName, null, null);
            }
        }
    }

    class AdvancedJoinsAction
    extends StandardAction {
        AdvancedJoinsAction(AppSupport app) {
            super(app, AppSupport.advancedJoinsAction);
            this.m_app = app;
            if (this.m_app.getQuery() != null) {
                this.m_app.getQuery().addPropertyListener(this, 16);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            if (!this.m_changedVetoed) {
                QueryComponentDialog joinDialog = new QueryComponentDialog((Frame)this.m_app.getFrame(), this.m_app.getQuery(), new AdvancedJoinPropertyView(this.m_app.getQuery()), "Join.Title.txt");
                joinDialog.pack();
                WindowUtil.center(joinDialog);
                joinDialog.setVisible(true);
                AppSupport.this.firePropertyChanges();
                this.displayMessages();
                AppSupport.this.firePropertyChange(this.m_keyName, null, null);
            }
        }

        @Override
        protected void _setState() {
            if (this.m_app.getQuery() == null) {
                this.setEnabled(false);
            } else {
                boolean bEnabled;
                boolean bl = bEnabled = this.m_app.getQuery().getTableCount() > 1 && this.m_app.m_isAdvancedJoinsAllowed;
                if (bEnabled != this.isEnabled()) {
                    this.setEnabled(bEnabled);
                }
            }
        }
    }

    class InsertTableAction
    extends StandardAction {
        InsertTableAction(AppSupport app) {
            super(app, AppSupport.insertTableAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            if (!this.m_changedVetoed) {
                AddTableDialog dialog = new AddTableDialog(this.m_app.getQuery(), this.m_app.getFrame());
                WindowUtil.center(dialog);
                dialog.setVisible(true);
                AppSupport.this.firePropertyChange(this.m_keyName, null, null);
            }
        }
    }

    class InsertResultItemAction
    extends StandardAction {
        InsertResultItemAction(AppSupport app) {
            super(app, AppSupport.insertResultItemAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            if (!this.m_changedVetoed) {
                try {
                    UnparsedExpression expression = new UnparsedExpression("<uninitialized>");
                    DataItem item = new DataItem(this.m_app.m_query, expression);
                    if (this.m_app.m_query.hasAggregatedRI()) {
                        item.setGroupItem(new GroupItem(this.m_app.m_query, expression));
                    }
                    DataItemList tempList = new DataItemList();
                    tempList.addElement(item);
                    DataItemPropertyView propertyPanel = new DataItemPropertyView(this.m_app.m_query, tempList, item);
                    QueryComponentDialog editDialog = new QueryComponentDialog((Frame)this.m_app.m_frame, this.m_app.m_query, propertyPanel, "DataItem.Title.txt");
                    propertyPanel.setReturnState(true);
                    editDialog.setModal(true);
                    editDialog.pack();
                    WindowUtil.centerOverWindow(editDialog, this.m_app.m_frame);
                    editDialog.setVisible(true);
                    propertyPanel.closing();
                }
                catch (Throwable t) {
                    this.m_app.m_query.getMessageHandler().addInternalError(t);
                }
                AppSupport.this.firePropertyChange(this.m_keyName, null, null);
            }
        }
    }

    class DataFlowAnalysisAction
    extends StandardAction {
        DataFlowWarningView warningView;

        DataFlowAnalysisAction(AppSupport app) {
            super(app, AppSupport.dataFlowAnalysisAction);
            this.warningView = new DataFlowWarningView();
            if (AppSupport.this.m_tabbedView == null) {
                this.setEnabled(false);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            if (!this.m_changedVetoed) {
                CrossJoinWarningDialog warningDialog = new CrossJoinWarningDialog((Frame)AppSupport.this.m_frame, AppSupport.this.getQuery());
                if (warningDialog.isProcessCrossJoinCancelled()) {
                    return;
                }
                FilterTreeView filterView = null;
                filterView = this.getFilterView(AppSupport.this.m_tabbedView.getActiveTab());
                if (this.warningView.getWarningState()) {
                    if (!this.isContinuePressed()) {
                        this.warningView.setWarningState(true);
                        return;
                    }
                    filterView.setDataFlowAnalysisEnable(true);
                } else {
                    filterView.setDataFlowAnalysisEnable(true);
                }
                AppSupport.this.firePropertyChange(this.m_keyName, null, null);
            }
        }

        protected FilterTreeView getFilterView(Component comp) {
            if (comp instanceof FilterTreeView) {
                return (FilterTreeView)comp;
            }
            if (comp instanceof Container) {
                Container container = (Container)comp;
                Component[] compArray = container.getComponents();
                for (int index = 0; index < compArray.length; ++index) {
                    FilterTreeView possibleTree = this.getFilterView(compArray[index]);
                    if (possibleTree == null) continue;
                    return possibleTree;
                }
            }
            return null;
        }

        protected boolean isContinuePressed() {
            Object[] warningOptions = new Object[]{"Continue", "Cancel"};
            int warningChoice = JOptionPane.showOptionDialog(AppSupport.this.m_frame, this.warningView.getMessageView(), "Data Flow Analysis", 2, 2, null, warningOptions, warningOptions[0]);
            return warningChoice == 0;
        }

        @Override
        protected void _setState() {
            if (AppSupport.this == null || AppSupport.this.m_tabbedView == null) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(this.getFilterView(AppSupport.this.m_tabbedView.getActiveTab()) != null);
        }
    }

    class HelpAppHelpAction
    extends StandardAction {
        HelpAppHelpAction(AppSupport app) {
            super(app, AppSupport.helpAppHelpAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            if (!this.m_changedVetoed) {
                AppSupport.this.firePropertyChange(this.m_keyName, null, null);
            }
        }
    }

    class AboutTheAppAction
    extends StandardAction {
        AboutTheAppAction(AppSupport app) {
            super(app, AppSupport.aboutTheAppAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            if (!this.m_changedVetoed) {
                JDialog aboutDialog = new JDialog((Frame)this.m_app.m_frame, true);
                aboutDialog.setTitle(bundle.getString("AppSupport.AboutTitle.txt"));
                QueryResource iconBundle = new QueryResource(ImageHandler.class);
                ImageIcon image = ImageHandler.getImageIcon(iconBundle, "splashIcon");
                GridBagLayout gridBagLayout = new GridBagLayout();
                aboutDialog.getContentPane().setLayout(gridBagLayout);
                JLabel coolImage = new JLabel(image);
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.gridwidth = 3;
                gbc.anchor = 18;
                gbc.fill = 0;
                gbc.insets = new Insets(0, 0, 0, 0);
                gridBagLayout.setConstraints(coolImage, gbc);
                aboutDialog.getContentPane().add(coolImage);
                JLabel text1 = new JLabel(bundle.messageString("AppSupport.AboutText1.fmt.txt", "1.0"));
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 1;
                gbc.anchor = 18;
                gbc.fill = 0;
                gbc.insets = new Insets(5, 5, 0, 5);
                gridBagLayout.setConstraints(text1, gbc);
                aboutDialog.getContentPane().add(text1);
                JLabel text2 = new JLabel(bundle.getString("AppSupport.AboutText2.txt"));
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 2;
                gbc.anchor = 18;
                gbc.fill = 0;
                gbc.insets = new Insets(0, 5, 0, 5);
                gridBagLayout.setConstraints(text2, gbc);
                aboutDialog.getContentPane().add(text2);
                JLabel text3 = new JLabel(bundle.getString("AppSupport.AboutText3.txt"));
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 3;
                gbc.anchor = 18;
                gbc.fill = 0;
                gbc.insets = new Insets(0, 5, 0, 5);
                gridBagLayout.setConstraints(text3, gbc);
                aboutDialog.getContentPane().add(text3);
                JLabel text4 = new JLabel(bundle.getString("AppSupport.AboutText4Legal.txt"));
                text4.setForeground(SystemColor.red);
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 4;
                gbc.anchor = 18;
                gbc.fill = 0;
                gbc.insets = new Insets(15, 5, 5, 5);
                gridBagLayout.setConstraints(text4, gbc);
                aboutDialog.getContentPane().add(text4);
                JLabel eater1 = new JLabel("");
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 1;
                gbc.gridheight = 3;
                gbc.anchor = 18;
                gbc.fill = 2;
                gbc.weightx = 1.0;
                gbc.insets = new Insets(0, 0, 0, 0);
                gridBagLayout.setConstraints(eater1, gbc);
                aboutDialog.getContentPane().add(eater1);
                JLabel eater2 = new JLabel("");
                gbc = new GridBagConstraints();
                gbc.gridx = 2;
                gbc.gridy = 1;
                gbc.gridheight = 3;
                gbc.anchor = 18;
                gbc.fill = 2;
                gbc.weightx = 1.0;
                gbc.insets = new Insets(0, 0, 0, 0);
                gridBagLayout.setConstraints(eater2, gbc);
                aboutDialog.getContentPane().add(eater2);
                JPanel buttonSection = new JPanel();
                GridLayout grid = new GridLayout(1, 3);
                buttonSection.setLayout(grid);
                JButton okButton = new JButton(bundle.getString("AppSupport.AboutDismissButtonText.txt"));
                okButton.addActionListener(new AboutListener(aboutDialog));
                JLabel eater3 = new JLabel("");
                JLabel eater4 = new JLabel("");
                buttonSection.add(eater3);
                buttonSection.add(okButton);
                buttonSection.add(eater4);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 5;
                gbc.gridwidth = 3;
                gbc.anchor = 18;
                gbc.fill = 2;
                gbc.weightx = 1.0;
                gbc.insets = new Insets(0, 0, 0, 0);
                gridBagLayout.setConstraints(buttonSection, gbc);
                aboutDialog.getContentPane().add(buttonSection);
                aboutDialog.pack();
                WindowUtil.centerOverWindow(aboutDialog, this.m_app.m_frame);
                aboutDialog.setVisible(true);
                AppSupport.this.firePropertyChange(this.m_keyName, null, null);
            }
        }

        class AboutListener
        implements ActionListener {
            private JDialog mydialog;

            public AboutListener(JDialog d) {
                this.mydialog = d;
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                this.mydialog.hide();
            }
        }
    }

    class DisposeLater
    implements Runnable {
        public DisposeLater() {
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void run() {
            AppSupport.this.m_frame.dispose();
        }
    }
}

